<?php
    if ( ! class_exists( 'Redux' ) ) {
        return;
    }
    // This is your option name where all the Redux data is stored.
    $opt_name = "manh_themeoptions";
    $theme = wp_get_theme(); // For use with some settings. Not necessary.
    $args = array(
        // TYPICAL -> Change these values as you need/desire
        'opt_name'             => $opt_name,
        // This is where your data is stored in the database and also becomes your global variable name.
        'display_name'         => $theme->get( 'Name' ),
        // Name that appears at the top of your panel
        'display_version'      => $theme->get( 'Version' ),
        // Version that appears at the top of your panel
        'menu_type'            => 'menu',
        //Specify if the admin menu should appear or not. Options: menu or submenu (Under appearance only)
        'allow_sub_menu'       => true,
        // Show the sections below the admin menu item or not
        'menu_title'            => esc_html__( 'M.Anh', 'manh' ),
        'page_title'            => esc_html__( 'M.Anh', 'manh' ),
        
        'dev_mode'             => false,
        'show_options_object'   => false,
        // If dev_mode is enabled, will notify developer of updated versions available in the GitHub Repo
        'customizer'           => true,
        // Enable basic customizer support
        // OPTIONAL -> Give you extra features
        'page_priority'        => 50,
        // HINTS
        'hints'                => array(
            'icon'          => 'el el-question-sign',
            'icon_position' => 'right',
            'icon_color'    => 'lightgray',
            'icon_size'     => 'normal',
            'tip_style'     => array(
                'color'   => 'red',
                'shadow'  => true,
                'rounded' => false,
                'style'   => '',
            ),
            'tip_position'  => array(
                'my' => 'top left',
                'at' => 'bottom right',
            ),
            'tip_effect'    => array(
                'show' => array(
                    'effect'   => 'slide',
                    'duration' => '500',
                    'event'    => 'mouseover',
                ),
                'hide' => array(
                    'effect'   => 'slide',
                    'duration' => '500',
                    'event'    => 'click mouseleave',
                ),
            ),
        )
    );

    Redux::setArgs( $opt_name, $args );

    $tabs = array(
        array(
            'id'      => 'redux-help-tab-1',
            'title'   => __( 'Theme Information 1', 'manh' ),
            'content' => __( '<p>This is the tab content, HTML is allowed.</p>', 'manh' )
        ),
        array(
            'id'      => 'redux-help-tab-2',
            'title'   => __( 'Theme Information 2', 'manh' ),
            'content' => __( '<p>This is the tab content, HTML is allowed.</p>', 'manh' )
        )
    );
    Redux::setHelpTab( $opt_name, $tabs );

    // Set the help sidebar
    $content = __( '<p>This is the sidebar content, HTML is allowed.</p>', 'manh' );
    Redux::setHelpSidebar( $opt_name, $content );

    // Import Demo Content
    $desc = ''; 
    if ( !function_exists('wordpress_importer_init') || !defined('WP_LOAD_IMPORTERS') ) {
        $subtitle = '
            <p><label><i class="fa fa-exclamation-circle"></i>  Please follow the check list bellow to enable import function:</label></p>
            <ul class="i_message">';
        if ( !function_exists('wordpress_importer_init') ) {
            $subtitle .= '<li><i class="fa fa-angle-double-right"></i> Need install and active plugin <a href="'.esc_url("https://wordpress.org/plugins/wordpress-importer/").'" target="_blank">Wordpress Importer</a></li>';
        }
        if( !defined('WP_LOAD_IMPORTERS') ){
            $subtitle .= "<li><i class='fa fa-angle-double-right'></i> Need add <code>define('WP_LOAD_IMPORTERS', true);</code> to file wp-config.php</li>";
        }
        $subtitle .= '</ul>';
    }else{
        $subtitle = '<div class=\'button\' id=\'btn_sampledata\'>Import</div>';
        $subtitle .= '
            <div class=\'sns-importprocess\'>
                <div  class=\'sns-importprocess-width\'></div>
            </div>
            <span id=\'sns-importmsg\'><span class=\'status\'></span></span>
            <div id="sns-import-tablecontent">
                <label>List contents will import:</label>
                <ul>
                  <li class="theme-cfg"><i class="fa fa-hand-pointer-o"></i>Theme config</li>
                  <li class="revslider-cfg"><i class="fa fa-hand-pointer-o"></i>Revolution Slider config</li>
                  <li class="all-content"><i class="fa fa-hand-pointer-o"></i>All contents</li>
                  <li class="widget-cfg"><i class="fa fa-hand-pointer-o"></i>Widget config</li>
                </ul>
            </div>
        ';
    }
    Redux::setSection( $opt_name, array(
        'icon' => 'el-icon-briefcase',
        'title' => esc_html__('Demo content', 'manh'),
        'fields' => array(
            array(
                'title' => '',
                'subtitle' => $subtitle,
                'desc'  => $desc,
                'id' => 'theme_data',
                'icon' => true,
                'type' => 'image_select',
                'default' => 'manh',
                'options' => array(
                    'sns_logo' => get_template_directory_uri().'/assets/img/logo.png',
                ),
            )
        )
    ) );
    // General
    Redux::setSection( $opt_name, array(
        'title'     => esc_html__( 'General', 'manh' ),
        'icon'      => 'el-icon-cog',
        'id'               => 'general',
        'customizer_width' => '400px'
    ) );
    Redux::setSection( $opt_name, array(
        'title'            => __( 'Color, Layout', 'manh' ),
        'id'               => 'general-layout',
        'subsection'       => true,
        'customizer_width' => '450px',
        'fields'           => array(
            array(
                'id'       => 'theme_color',
                'type'     => 'color',
                'output'   => array( '.site-title' ),
                'title'    => esc_html__( 'Theme Color', 'manh' ),
                'default'  => '#c17262',
                'transparent'   => false
            ),
            array(
                'id'       => 'body_bg',
                'type'     => 'background',
                'output'   => array( 'body' ),
                'title'    => esc_html__( 'Body Background', 'manh' ),
                'background-image' => false,
                'preview'   => false,
            ),
        )
    ));
    Redux::setSection( $opt_name, array(
        'title'            => __( 'Fonts', 'manh' ),
        'id'               => 'general-font',
        'subsection'       => true,
        'customizer_width' => '450px',
        'fields'           => array(
            array(
                'id'          => 'body_font',
                'type'        => 'typography',
                'title'       => esc_html__( 'Body font', 'manh' ),
                'line-height'   => false,
                'text-align'   => false,
                'color'         => true,
                'all_styles'  => true,
                'units'       => 'px',
                'default'     => array(
                    'font-size'   => '14px',
                    'font-family' => 'K2D',
                    'font-weight' => '400',
                    'color'       => '#626262'
                ),
            ),
            array(
                'id'          => 'headline_font',
                'type'        => 'typography',
                'title'       => esc_html__( 'Second google font', 'manh' ),
                'line-height'   => false,
                'text-align'    => false,
                'color'         => false,
                'font-size'     => false,
                'all_styles'    => true,
                'units'         => 'px',
                'default'     => array(
                    'font-family' => '',
                ),
                'desc'      => esc_html__( 'Normally, it use for some special heading', 'manh' ),
            ),
            array(
                'id'       => 'hfont_target',
                'type'     => 'textarea',
                'title'    => esc_html__( 'Second google font target', 'manh' ),
                'default'  => '.second-font'
            ),
            array(
                'id'          => 'three_font',
                'type'        => 'typography',
                'title'       => esc_html__( 'Three google font', 'manh' ),
                'line-height'   => false,
                'text-align'    => false,
                'color'         => false,
                'font-size'     => false,
                'all_styles'    => true,
                'units'         => 'px',
                'default'     => array(
                    'font-family' => '',
                ),
            ),
            array(
                'id'       => 'threefont_target',
                'type'     => 'textarea',
                'title'    => esc_html__( 'Three google font target', 'manh' ),
                'default'  => '.three-font'
            ),
        )
    ));
    Redux::setSection( $opt_name, array(
        'title'            => __( 'Breadcrumbs', 'manh' ),
        'id'               => 'general-breadcrumb',
        'subsection'       => true,
        'customizer_width' => '450px',
        'fields'           => array(
            array(
                'id'       => 'showbreadcrump',
                'type'     => 'switch',
                'title'    => 'Show Breadcrumbs?',
                'default'  => true,
                'on'       => 'Yes',
                'off'      => 'No',
            ),
            array(
                'id'       => 'breadcrumbbg',
                'type'     => 'media',
                'title'    => esc_html__("Want use Background image for Breadcrumbs?", 'manh'),
                'required' => array( 'showbreadcrump', '=', 1 ), 
            ),
        )
    ));
    Redux::setSection( $opt_name, array(
        'title'     => esc_html__( 'Header', 'manh' ),
        'icon'      => 'el el-brush',
        'fields'    => array(
            array(
                'id'       => 'header_style',
                'type' => 'select',
                'title'    => esc_html__( 'Header Style', 'manh' ),
                'default'  => 'style1',
                'options' => array(
                    'style1'        => esc_html__( 'Style1', 'manh'),
                    'style2'        => esc_html__( 'Style2 - Transparent white text', 'manh'),
                    'style3'        => esc_html__( 'Style3 - Transparent', 'manh'),
                ),
                'desc'      => esc_html__( 'Select Header Style', 'manh' ),
            ),
            array(
                'id'       => 'enable_search_cat',
                'type'     => 'switch',
                'title'    => esc_html__( 'Enable Search Category for Live Ajax Search', 'manh' ),
                'default'  => false,
                'on'       => 'Yes',
                'off'      => 'No',
            ),
            array(
                'id'       => 'search_limit',
                'type'     => 'text',
                'title'    => esc_html__( 'Search limit numner', 'manh' ),
                'default'  => '6',
                'subtitle' => esc_html__( 'The number limit for search results dispplay', 'manh' ),
                'desc'     => esc_html__( 'Note: The value is number, and -1 is unlimit,', 'manh' ),
            ),
            array(
                'id'       => 'search_title_only',
                'type'     => 'switch',
                'title'    => esc_html__( 'Search by Title only', 'manh' ),
                'default'  => true,
                'on'       => 'Yes',
                'off'      => 'No',
            ),
            array(
                'id'        => 'header_logo',
                'type'      => 'media',
                'default'   => '',
                'title'     => esc_html__( 'Logo', 'manh' ),
                'subtitle'  => esc_html__( 'If this is not selected, This theme will be display logo with "theme/manh/img/logo.png"', 'manh' ),
                'desc'      => esc_html__( 'Image that you want to use as logo', 'manh' ),
            ),
            array(
                'id'       => 'use_stickmenu',
                'type'     => 'switch',
                'title'    => esc_html__( 'Enable Sticky Menu', 'manh' ),
                'subtitle' => esc_html__( 'Keep menu on top when scroll down/up', 'manh' ),
                'default'  => false,
                'on'       => 'Yes',
                'off'      => 'No',
            ),
        )
    ));
    Redux::setSection( $opt_name, array(
        'title'     => esc_html__( 'Footer', 'manh' ),
        'icon'      => 'el el-link',
        'fields'    => array(
            array(
                'title' => esc_html__( 'Style', 'manh'),
                'id' => 'footer_layout',
                'type'  => 'select',
                'multiselect' => false,
                'options' => array(
                    '1'      => esc_html__( 'Style 1', 'manh'),
                    '2'      => esc_html__( 'Style 2', 'manh'),
                    '3'      => esc_html__( 'Style 3', 'manh'),
                    'blank'        => esc_html__( 'Blank', 'manh'),
                ),
                'default'  => '1'
            ), 
        )
    ));
    // Blog
    $siderbars = array(
        'blog-sidebar' => esc_html__( 'Blog Sidebar', 'manh' ),
        'woo-sidebar' => esc_html__( 'WooCommerce Sidebar', 'manh' ),
        'woo-sidebar-sticky' => esc_html__( 'WooCommerce Sidebar - Sticky', 'manh' )
    );
    Redux::setSection( $opt_name, array(
        'title'     => esc_html__( 'Blog', 'manh' ),
        'icon'      => 'el el-file-edit',
        'id'               => 'blog',
        'customizer_width' => '400px'
    ) );
    Redux::setSection( $opt_name, array(
        'title'            => __( 'Blog Pages', 'manh' ),
        'id'               => 'blog-page',
        'subsection'       => true,
        'customizer_width' => '450px',
        'fields'           => array(
            array(
                'id'       => 'layouttype',
                'type'     => 'image_select',
                'title'    => esc_html__('Default Blog Layout', 'manh'), 
                'options'  => array(
                    'm'      => array(
                        'alt'   => esc_html__( 'Without Sidebar', 'manh' ), 
                        'img'   => MANH_THEME_URI.'/assets/img/admin/m.jpg'
                    ),
                    'l-m'      => array(
                        'alt'   => esc_html__( 'Use Left Sidebar', 'manh' ), 
                        'img'   => MANH_THEME_URI.'/assets/img/admin/l-m.jpg'
                    ),
                    'm-r'      => array(
                        'alt'  => esc_html__( 'Use Right Sidebar', 'manh' ), 
                        'img'  => MANH_THEME_URI.'/assets/img/admin/m-r.jpg'
                    ),
                ),
                'default' => 'm-r'
            ),
            // Left Sidebar
            array(
                'title'  => esc_html__( 'Left Sidebar', 'manh' ),
                'id'    => "leftsidebar",
                'type'  => 'select',
                'options'   => $siderbars,
                'multiselect'   => false,
                'required' => array( 'layouttype', '=', array( 'l-m', 'l-m-r' ) )
            ),
            // Right Sidebar
            array(
                'title'  => esc_html__( 'Right Sidebar', 'manh' ),
                'id'    => "rightsidebar",
                'type'  => 'select',
                'options'   => $siderbars,
                'multiselect'   => false,
                'required' => array( 'layouttype', '=', array( 'm-r', 'l-m-r' ) )
            ),
            array( 
                'title' => esc_html__( 'Blog Style', 'manh'),
                'id' => 'blog_type',
                'default' => 'layout1',
                'type' => 'select',
                'multiselect' => false ,
                'options' => array(
                    'layout1'       => esc_html__( 'Blog default page', 'manh'),
                    'masonry'       => esc_html__( 'Blog Masonry ', 'manh'),
                )
            ),
            array(
                'id'        => 'pagination',
                'title'     => esc_html__( 'Page Navigation', 'manh'),
                'desc'      => esc_html__('Choose Type of navigation for blog and any listing page.', 'manh'),
                'default'   => 'def',
                'type'      => 'select',
                'multiselect' => false ,
                'options'   => array(
                    'def'   => esc_html__('Default', 'manh'),
                    'ajax'  =>  esc_html__('Ajax click load more', 'manh'),
                    'ajax2'  =>  esc_html__('Ajax auto load more', 'manh'),
                ),
            ),
            array(
                'id'       => 'masonry_numload',
                'type'     => 'text',
                'title'    => esc_html__( 'Number post with each load more', 'manh' ),
                'default'  => '3',
                'required' => array( 'pagination', '=', array( 'ajax', 'ajax2' ) )
            ),
            array(
                'id'       => 'show_categories',
                'type'     => 'switch',
                'title'    => esc_html__( 'Show Categories for Blog Entries Page', 'manh' ),
                'default'  => true,
                'on'       => 'Yes',
                'off'      => 'No',
            ),
            array(
                'id'       => 'show_date',
                'type'     => 'switch',
                'title'    => esc_html__( 'Show Date for Blog Entries Page', 'manh' ),
                'default'  => true,
                'on'       => 'Yes',
                'off'      => 'No',
            ),
            
            array(
                'id'       => 'show_author',
                'type'     => 'switch',
                'title'    => esc_html__( 'Show Author for Blog Entries Page', 'manh' ),
                'default'  => true,
                'on'       => 'Yes',
                'off'      => 'No',
            ),
            array(
                'id'       => 'show_tags',
                'type'     => 'switch',
                'title'    => esc_html__( 'Show Tags for Blog Entries Page', 'manh' ),
                'default'  => true,
                'on'       => 'Yes',
                'off'      => 'No',
            ),
            array(
                'id'       => 'excerpt_length',
                'type'     => 'text',
                'title'    => esc_html__( 'Blog Excerpt Length', 'manh' ),
                'default'  => '25',
            ),
            array(
                'id'       => 'show_morelink',
                'type'     => 'switch',
                'title'    => esc_html__( 'Show more link', 'manh' ),
                'subtitle' => esc_html__( 'Apply when post have Excerpt', 'manh' ),
                'default'  => true,
                'on'       => 'Yes',
                'off'      => 'No',
            ),
        )
    ));

    Redux::setSection( $opt_name, array(
        'title'            => __( 'Single Post', 'manh' ),
        'id'               => 'blog-singlepost',
        'subsection'       => true,
        'customizer_width' => '450px',
        'fields'           => array(
            array(
                'id'       => 'show_postauthor',
                'type'     => 'switch',
                'title'    => esc_html__( 'Enable Author Info on Post Detail', 'manh' ),
                'default'  => false,
                'on'       => 'Yes',
                'off'      => 'No',
            ),
            array(
                'id'       => 'show_postsharebox',
                'type'     => 'switch',
                'title'    => esc_html__( 'Enable Share box', 'manh' ),
                'subtitle' => esc_html__( 'Just work when you install plugin Simple Share Buttons Adder', 'manh' ),
                'default'  => true,
                'on'       => 'Yes',
                'off'      => 'No',
            ),
            array(
                'id'       => 'enalble_related',
                'type'     => 'switch',
                'title'    => esc_html__( 'Enable Related Post', 'manh' ),
                'default'  => false,
                'on'       => 'Yes',
                'off'      => 'No',
            ),
        )
    ));
    // WooCommerce
    Redux::setSection( $opt_name, array(
        'title'     => esc_html__( 'Woo', 'manh' ),
        'icon'      => 'el el-shopping-cart',
        'id'               => 'woo',
        'desc'             => __( 'These are really basic fields!', 'manh' ),
        'customizer_width' => '400px'
    ) );

    Redux::setSection( $opt_name, array(
        'title'            => __( 'Archives Pages', 'manh' ),
        'id'               => 'woo-shoppage',
        'subsection'       => true,
        'customizer_width' => '450px',
        'fields'           => array(
            array(
                'id'       => 'woo_uselazyload',
                'type'     => 'switch',
                'title'    => esc_html__( 'Use lazyload for Product Image', 'manh' ),
                'default'  => false,
                'on'       => 'Yes',
                'off'      => 'No',
            ),
            array(
                'id'       => 'woo_stickypfilter',
                'type'     => 'switch',
                'title'    => esc_html__( 'Sticky product filter in left', 'manh' ),
                'subtitle'  => esc_html__( 'To use this option you need add Widgets for sidebar Woo Sidebar - Sticky', 'manh' ),
                'default'  => false,
                'on'       => 'Yes',
                'off'      => 'No',
            ),
            array(
                'id'        => 'woo_gridstyle',
                'type'      => 'select',
                'title'     => esc_html__( 'Grid style', 'manh' ),
                'options'  => array(
                    ''  => esc_html__( 'Default', 'manh' ),
                    ''  => esc_html__( 'Style 1', 'manh' ),
                ),
                'default'  => ''
            ),
            array(
                'id'       => 'woo_grid_col',
                'type'     => 'select',
                'title'    => esc_html__( 'Default Grid columns', 'manh' ),
                'subtitle'  => esc_html__( 'We are using grid bootstap - 12 cols layout', 'manh' ),
                'default'  => '3',
                'options'  => array(
                    '1' => '1',
                    '2' => '2',
                    '3' => '3',
                    '4' => '4',
                    '5' => '5',
                    '6' => '6',
                ),
            ),
            array(
                'id'       => 'woo_value_number_cols',
                'type'     => 'text',
                'title'    => esc_html__( 'The numbers value columns', 'manh' ),
                'default'  => '2/3/4',
                'subtitle'  => esc_html__( 'The numbers value to set product columns per row. Ex: 2/3/4/5', 'manh' ),
            ),
            array(
                'id'       => 'woo_number_perpage',
                'type'     => 'text',
                'title'    => esc_html__( 'Number products per listing page', 'manh' ),
                'default'  => '9',
            ),
        )
    ));
    Redux::setSection( $opt_name, array(
        'title'            => __( 'Single Product', 'manh' ),
        'id'               => 'woo-singleproduct',
        'subsection'       => true,
        'customizer_width' => '450px',
        'fields'           => array(
            array(
                'id'       => 'woo_gallery_type',
                'type'     => 'select',  
                'title'    => esc_html__( 'Gallery Thumbnail Type', 'manh' ),
                'default'  => 'h',
                'options'  => array(
                    'h'     => esc_html__( 'Horizontal', 'manh' ),
                    'v'      => esc_html__( 'Vertical', 'manh' ),
                    'n1'      => esc_html__( 'None - Use scrolling layout', 'manh' ),
                ),
            ),
            array(
                'id'       => 'woo_thumb_num',
                'type'     => 'text',
                'title'    => esc_html__( 'Number Thumbnail to display', 'manh' ),
                'default'  => '4',
            ),
            array(
                'id'       => 'single_product_sidebar',
                'type'     => 'switch',
                'title'    => esc_html__( 'Use Sidebar in Single Product Page', 'manh' ),
                'default'  => false,
                'on'       => 'Yes',
                'off'      => 'No',
            ),
            array(
                'id'       => 'woo_designvariations',
                'type'     => 'switch',
                'title'    => esc_html__( 'Re-design Variations Form', 'manh' ),
                'default'  => true,
                'on'       => 'Yes',
                'off'      => 'No',
            ),
            array(
                'id'       => 'woo_sharebox',
                'type'     => 'switch',
                'title'    => esc_html__( 'Enable Share box', 'manh' ),
                'subtitle' => esc_html__( 'Just work when you install plugin Simple Share Buttons Adder', 'manh' ),
                'default'  => true,
                'on'       => 'Yes',
                'off'      => 'No',
            ),
            array(
                'id'       => 'woo_upsells',
                'type'     => 'switch',
                'title'    => esc_html__( 'Enable Upsells Products', 'manh' ),
                'default'  => true,
                'on'       => 'Yes',
                'off'      => 'No',
            ),
            array(
                'id'       => 'woo_upsells_num',
                'type'     => 'text',
                'title'    => esc_html__( 'Number limit of Upsells Products', 'manh' ),
                'required' => array( 'woo_upsells', '=', '1' ),
                'default'  => '6',
            ),
            array(
                'id'       => 'woo_related',
                'type'     => 'switch',
                'title'    => esc_html__( 'Enable Related Products', 'manh' ),
                'default'  => true,
                'on'       => 'Yes',
                'off'      => 'No',
            ),
            array(
                'id'       => 'woo_related_num',
                'type'     => 'text',
                'title'    => esc_html__( 'Number limit of Related Products', 'manh' ),
                'required' => array( 'woo_related', '=', '1' ),
                'default'  => '6',
            ),
        )
    ));
    // Not Found
    Redux::setSection( $opt_name, array(
        'title'     => esc_html__( 'Page Not Found', 'manh' ),
        'icon'      => 'el el-warning-sign',
        'customizer_width' => '450px',
        'fields'           => array(
            array(
                'id'       => 'bg_404',
                'type'     => 'media',
                'title'    => esc_html__("Image for 404 not found page", 'manh'),
            ),
            array(
                'id'       => 'notfound_title',
                'type'     => 'text',
                'title'    => esc_html__( 'Title', 'manh' ),
                'default'  => esc_html__('Opps !', 'manh'),
            ),
            array(
                'id'       => 'notfound_content',
                'type'     => 'textarea',
                'title'    => esc_html__( 'Message Content', 'manh' ),
                'default'  => esc_html__('We can’t seem to find the page you’re looking for.', 'manh'),
            ),
        )
    ));
    // Advance
    Redux::setSection( $opt_name, array(
        'title'     => esc_html__( 'Advance', 'manh' ),
        'icon'      => 'el el-wrench',
        'fields'    => array(
            array(
                'id'       => 'advance_tooltip',
                'type'     => 'switch',
                'title'    => esc_html__( 'Enable Tooltip', 'manh' ),
                'default'  => true,
                'on'       => 'Yes',
                'off'      => 'No',
            ),
            array(
                'id'       => 'advance_cpanel',
                'type'     => 'switch',
                'title'    => esc_html__( 'Enable Cpanel', 'manh' ),
                'default'  => false,
                'on'       => 'Yes',
                'off'      => 'No',
            ),
            array(
                'id'       => 'tf_p_link',
                'type'     => 'text',
                'title'    => esc_html__( 'Link to purchase theme', 'manh' ),
                'default'  => esc_html__('#', 'manh'),
                'required' => array( 'advance_cpanel', '=', '1' )
            ),
            array(
                'id'       => 'advance_scrolltotop',
                'type'     => 'switch',
                'title'    => esc_html__( 'Enable Button Scroll To Top', 'manh' ),
                'default'  => true,
                'on'       => 'Yes',
                'off'      => 'No',
            ),
            array(
                'id'        => 'advance_scss_compile',
                'type'      => 'select',
                'title'     => esc_html__( 'SCSS Compile', 'manh' ),
                'options'  => array(
                    '1' => esc_html__( 'Only compile when don\'t have the css file', 'manh' ),
                    '2' => esc_html__( 'Alway compile', 'manh' ),
                ),
                'default'  => '1'
            ),
            array(
                'id'        => 'advance_scss_format',
                'type'      => 'select',
                'title'     => esc_html__( 'CSS Format', 'manh' ),
                'options'  => array(
                    'scss_formatter' => esc_html__( 'scss_formatter', 'manh' ),
                    'scss_formatter_nested' => esc_html__( 'scss_formatter_nested', 'manh' ),
                    'scss_formatter_compressed' => esc_html__( 'scss_formatter_compressed', 'manh' ),
                ),
                'default'  => 'scss_formatter'
            ),
        )
    ));


