<?php
/**
 * Registering meta boxes
 *
 * All the definitions of meta boxes are listed below with comments.
 * Please read them CAREFULLY.
 *
 * You also should read the changelog to know what has been changed before updating.
 *
 * For more information, please visit:
 * @link http://metabox.io/docs/registering-meta-boxes/
 */
add_filter( 'rwmb_meta_boxes', 'manh_register_meta_boxes' );
/**
 * Register meta boxes
 *
 * Remember to change "your_prefix" to actual prefix in your project
 *
 * @param array $meta_boxes List of meta boxes
 *
 * @return array
 */
function manh_register_meta_boxes( $meta_boxes ){
	/**
	 * prefix of meta keys (optional)
	 * Use underscore (_) at the beginning to make keys hidden
	 * Alt.: You also can make prefix empty to disable it
	 */
	// Better has an underscore as last sign
	$prefix = 'manh_';
	global $wpdb, $manh_opt;
	$revsliders =array();
	$revsliders[0] = esc_html__("Don't use", "manh");
	if ( class_exists('RevSlider') ) {
		$query = $wpdb->prepare("
			SELECT * 
			FROM {$wpdb->prefix}revslider_sliders 
			ORDER BY %s"
			, "ASC");
	    $get_sliders = $wpdb->get_results($query);
	    if($get_sliders) {
		    foreach($get_sliders as $slider) {
			   $revsliders[$slider->alias] = $slider->title;
		   }
	    }
	}
	$default_layout = 'm-r';
	if ( isset($manh_opt['blog_layout']) ) $default_layout = $manh_opt['blog_layout'];
	$siderbars = array();
	foreach ($GLOBALS['wp_registered_sidebars'] as $sidebars) {
		$siderbars[ $sidebars['id']] = $sidebars['name'];
	}
	// Layout config
	$meta_boxes[] = array(
		// Meta box id, UNIQUE per meta box. Optional since 4.1.5
		'id'         => 'sns_productcfg',
		// Meta box title - Will appear at the drag and drop handle bar. Required.
		'title'      => esc_html__( 'Product Config', 'manh' ),
		// Post types, accept custom post types as well - DEFAULT is 'post'. Can be array (multiple post types) or string (1 post type). Optional.
		'post_types' => array( 'product' ),
		// Where the meta box appear: normal (default), advanced, side. Optional.
		'context'    => 'normal',
		// Order of meta box: high (default), low. Optional.
		'priority'   => 'high',
		// Auto save: true, false (default). Optional.
		// 'autosave'   => true,
		// List of meta fields

		'fields'     => array(
            array(
                'id'       => "{$prefix}breadcrumbbg",
                'type'     => 'image_advanced',
                'name'     => esc_html__("Background image for Breadcrumb", 'manh'),
                'desc'	   => esc_html__('Just apply when Show Product Title in the Breadcrumb', 'manh'),
            ),
			array(
				'name'    => esc_html__( 'Gallery Thumbnail Type', 'manh' ),
				'id'       => "{$prefix}woo_gallery_type",
				'type'     => 'select',
				'std'  => '',
				'options'  => array(
					''  => esc_html__( 'Default', 'manh' ),
					'h'  => esc_html__( 'Horizontal', 'manh' ),
					'v'  => esc_html__( 'Vertical', 'manh' ),
					'n1'      => esc_html__( 'None - Use scrolling layout', 'manh' ),
					'n2'      => esc_html__( 'None - Use top slider layout', 'manh' ),
				)
			),
			array(
				'id'    => "{$prefix}product_video",
				'name'  => esc_html__( 'Product Video', 'manh' ),
				'type'  => 'oembed',
				// Allow to clone? Default is false
				'clone' => false,
				'desc'		  => esc_html__( 'Enter your video iframw url(youtube, video), ex: https://www.youtube.com/embed/jjwA6gc3nEY', 'manh' ),
				// Input size
				'size'  => 50,
			),
			array(
				'name'    => esc_html__( 'Use Variation Thumbnail for Variable product', 'manh' ),
				'id'       => "{$prefix}use_variation_thumb",
				'type'     => 'select',
				'std'  => 0,
				'options'  => array(
					0  => esc_html__( 'No', 'manh' ),
					1  => esc_html__( 'Yes', 'manh' ),
				),
				'desc'		=> esc_html__('Just applies for Variable Product', 'manh'),
			),
			array(
				'name'    	=> esc_html__( 'Want to show Extra info?', 'manh' ),
				'id'       	=> "{$prefix}extra_info",
				'type'     	=> 'text',
				'std'  		=> '',
				'desc'		=> esc_html__('Enter the value is slug of Post WCode, On Post WCode you can build any info.', 'manh'),
			),
		)
	);
	// Layout config
	$meta_boxes[] = array(
		// Meta box id, UNIQUE per meta box. Optional since 4.1.5
		'id'         => 'sns_layout',
		// Meta box title - Will appear at the drag and drop handle bar. Required.
		'title'      => esc_html__( 'Layout Config', 'manh' ),
		// Post types, accept custom post types as well - DEFAULT is 'post'. Can be array (multiple post types) or string (1 post type). Optional.
		'post_types' => array( 'page' ),
		// Where the meta box appear: normal (default), advanced, side. Optional.
		'context'    => 'normal',
		// Order of meta box: high (default), low. Optional.
		'priority'   => 'high',
		// Auto save: true, false (default). Optional.
		// 'autosave'   => true,
		// List of meta fields

		'fields'     => array(
			// Layout Type
			array(
				'name'        => esc_html__( 'Layout Type', 'manh' ),
				'id'          => "{$prefix}layouttype",
				'type'        => 'layouttype',
				// Array of 'value' => 'Label' pairs for select box
				'options'     => array(
					'm' => esc_html__( 'Without Sidebar', 'manh' ),
					'l-m' => esc_html__( 'Use Left Sidebar', 'manh' ),
					'm-r' => esc_html__( 'Use Right Sidebar', 'manh' ),
				),
				// Select multiple values, optional. Default is false.
				'multiple'    => false,
				'std'         => $default_layout,
				'placeholder' => esc_html__( '--- Select a layout type ---', 'manh' ),
			),
			// Left Sidebar
			array(
				'name'  => esc_html__( 'Left Sidebar', 'manh' ),
				'id'    => "{$prefix}leftsidebar",
				'type'  => 'select',
				'options'	=> $siderbars,
				'multiple'	=> false,
				'std'		=> 'left-sidebar',
				'placeholder' => esc_html__( '--- Select a sidebar ---', 'manh' ),
			),
			// Right Sidebar
			array(
				'name'  => esc_html__( 'Right Sidebar', 'manh' ),
				'id'    => "{$prefix}rightsidebar",
				'type'  => 'select',
				'options'	=> $siderbars,
				'multiple'	=> false,
				'std'		=> 'right-sidebar',
				'placeholder' => esc_html__( '--- Select a sidebar ---', 'manh' ),
			),
			
		)
	);
	
	$menus = get_terms('nav_menu', array( 'hide_empty' => false ));
	$menu_options[''] = __('Default Menu...', 'manh');
	foreach ( $menus as $menu ){
		$menu_options[$menu->term_id] = $menu->name;
	}
	
	// Page config
	$meta_boxes[] = array(
		// Meta box id, UNIQUE per meta box. Optional since 4.1.5
		'id'         => 'sns_pageconfig',
		// Meta box title - Will appear at the drag and drop handle bar. Required.
		'title'      => esc_html__( 'Page Config', 'manh' ),
		// Post types, accept custom post types as well - DEFAULT is 'post'. Can be array (multiple post types) or string (1 post type). Optional.
		'post_types' => array( 'page' ),
		// Where the meta box appear: normal (default), advanced, side. Optional.
		'context'    => 'normal',
		// Order of meta box: high (default), low. Optional.
		'priority'   => 'high',
		// Auto save: true, false (default). Optional.
		// 'autosave'   => true,
		// List of meta fields

		'fields'     => array(
			array(
				'name'    => esc_html__( 'Want use custom logo?', 'manh' ),
				'id'      => "{$prefix}header_logo",
				'type'    => 'image_advanced',
				'desc'		=> esc_html__('It priority more than Logon in theme option', 'manh'),
			),
			array(
				'name'    => esc_html__( 'Header Style', 'manh' ),
				'id'       => "{$prefix}header_style",
				'type'     => 'select',
				'std'  => '',
				'options'  => array(
					''   	  => esc_html__( 'Default', 'manh' ),
					'style1'  => esc_html__( 'Style1', 'manh' ),
					'style2'  => esc_html__( 'Style2 - Transparent white text', 'manh' ),
					'style3'  => esc_html__( 'Style3 - Transparent', 'manh' ),
				),
				'desc'		=> esc_html__('Select Header style. ', 'manh'),
			),
			array(
				'name'    => esc_html__( 'Want to use extra width for header?', 'manh' ),
				'id'      => "{$prefix}header_extrawidth",
				'type'    => 'select',
				'options' => array(
					'2' => esc_html__( 'No', 'manh' ),
					'1' => esc_html__( 'Yes', 'manh' ),
				),
				'multiple'	=> false,
				'std'         => '2',
			),
			array(
				'name'    => esc_html__( 'Enable Sticky Menu', 'manh' ),
				'id'       => "{$prefix}use_stickmenu",
				'type'     => 'select',
				'std'  => '',
				'options'  => array(
					''   	  => esc_html__( 'Default', 'manh' ),
					true  => esc_html__( 'Yes', 'manh' ),
					false  => esc_html__( 'No', 'manh' ),
				),
			),
			array(
				'name'    => esc_html__( 'Enable Search Category for Live Ajax Search', 'manh' ),
				'id'       => "{$prefix}enable_search_cat",
				'type'     => 'select',
				'std'  => '',
				'options'  => array(
					''   	  => esc_html__( 'Default', 'manh' ),
					true  => esc_html__( 'Yes', 'manh' ),
					false  => esc_html__( 'No', 'manh' ),
				),
			),
			array(
				'name'    => esc_html__( 'Use Slideshow', 'manh' ),
				'id'      => "{$prefix}useslideshow",
				'type'    => 'radio',
				'options' => array(
					'1' => esc_html__( 'Yes', 'manh' ),
					'2' => esc_html__( 'No', 'manh' ),
				),
				'std'         => '2',
			),
			array(
				'name'    => esc_html__( 'Select Slideshow', 'manh' ),
				'id'      => "{$prefix}revolutionslider",
				'type'    => 'select',
				'options' =>  $revsliders ,
				'std'         => '',
			),
			array(
				'name'    => esc_html__( 'Show Title', 'manh' ),
				'id'      => "{$prefix}showtitle",
				'type'    => 'radio',
				'options' => array(
					'1' => esc_html__( 'Yes', 'manh' ),
					'2' => esc_html__( 'No', 'manh' ),
				),
				'std'         => '1',
			),
			array(
				'name'    => esc_html__( 'Show Breadcrumbs?', 'manh' ),
				'id'      => "{$prefix}showbreadcrump",
				'type'    => 'select',
				'options' => array(
					'' => esc_html__( 'Default', 'manh' ),
					'1' => esc_html__( 'Yes', 'manh' ),
					'2' => esc_html__( 'No', 'manh' ),
				),
				'multiple'	=> false,
				'std'         => '',
				'desc' => esc_html__( 'Dont apply for Front page.', 'manh' ),
			),
			array(
				'name'    => esc_html__( 'Want use Background image for Breadcrumbs?', 'manh' ),
				'id'      => "{$prefix}breadcrumbbg",
				'type'    => 'image_advanced',
			),
			array(
				'name'    => esc_html__( 'Want to use extra width for main content?', 'manh' ),
				'id'      => "{$prefix}content_extrawidth",
				'type'    => 'select',
				'options' => array(
					'2' => esc_html__( 'No', 'manh' ),
					'1' => esc_html__( 'Yes', 'manh' ),
				),
				'multiple'	=> false,
				'std'         => '2',
			),
			array(
				'name'    => esc_html__( 'Footer Style', 'manh' ),
				'id'       => "{$prefix}footer_layout",
				'type'     => 'select',
				'std'  => '',
				'options'  => array(
					''  => esc_html__( 'Default', 'manh' ),
					'1'  => esc_html__( 'Style 1', 'manh' ),
					'2'  => esc_html__( 'Style 2', 'manh' ),
					'3'  => esc_html__( 'Style 3', 'manh' ),
					'blank'  => esc_html__( 'Blank', 'manh'),
				),
				'desc'		=> esc_html__('Select Footer layout. "Default" to use in Theme Options.', 'manh'),
			),
			array(
				'name'    => esc_html__( 'Config Theme Color for this page?', 'manh' ),
				'id'      => "{$prefix}page_themecolor",
				'type'    => 'radio',
				'options' => array(
					'1' => esc_html__( 'Yes', 'manh' ),
					'2' => esc_html__( 'No', 'manh' ),
				),
				'std'         => '2',
			),
			array(
				'name' => esc_html__( 'Sellect Theme Color', 'manh' ),
				'id'   => "{$prefix}theme_color",
				'type' => 'color',
				'desc' => esc_html__( 'It will priority than Theme Color in Theme Option panel', 'manh' ),
			),
			array(
				'name'    	=> esc_html__( 'Want to use page class?', 'manh' ),
				'id'       	=> "{$prefix}page_class",
				'type'     	=> 'text',
				'std'  		=> '',
				'desc'		=> esc_html__('It is a class css to add some special style, and just for this page', 'manh'),
			),
		)
	);
	// Post format - Gallery
	$meta_boxes[] = array(
	    	'id' => 'sns-post-gallery',
		    'title' =>  esc_html__('Gallery Settings','manh'),
	    	'description' => '',
    		'pages'      => array( 'post' ), // Post type
	    	'context'    => 'normal',
		    'priority'   => 'high',
	    	'fields' => array(
			     array(
			        'name'		=> 'Gallery Images',
			        'desc'	    => 'Upload Images for post Gallery ( Limit is 15 Images ).',
			        'type'      => 'image_advanced',
			        'id'	    => "{$prefix}post_gallery",
	         		'max_file_uploads' => 15 
	        	)
			)
	);
	// Post format - Video
    $meta_boxes[] = array(
		'id' => 'sns-post-video',
		'title' => esc_html__('Featured Video','manh'),
		'description' => '',
		'pages'      => array( 'post' ), // Post type
		'context'    => 'normal',
		'priority'   => 'high',
		'fields' => array( 
		    array(
				'id'    => "{$prefix}post_video",
				'name'  => esc_html__( 'Video', 'manh' ),
				'type'  => 'oembed',
				// Allow to clone? Default is false
				'clone' => false,
				// Input size
				'size'  => 50,
			)
		)
	);
	// Post format - Audio
    $meta_boxes[] = array(
		'id' => 'sns-post-audio',
		'title' => esc_html__('Featured Audio','manh'),
		'description' => '',
		'pages'      => array( 'post' ), // Post type
		'context'    => 'normal',
		'priority'   => 'high',
		'fields' => array( 
		    array(
				'id'    => "{$prefix}post_audio",
				'name'  => esc_html__( 'Audio', 'manh' ),
				'type'  => 'oembed',
				// Allow to clone? Default is false
				'clone' => false,
				// Input size
				'size'  => 50,
			)
		)
	);
	// Post format - quote
    $meta_boxes[] = array(
		'id' => 'sns-post-quote',
		'title' => esc_html__('Featured Quote','manh'),
		'description' => '',
		'pages'      => array( 'post' ), // Post type
		'context'    => 'normal',
		'priority'   => 'high',
		'fields' => array( 
		    array(
				'id'    => "{$prefix}post_quotecontent",
				'name'  => esc_html__( 'Quote Content', 'manh' ),
				'type'  => 'textarea',
				// Allow to clone? Default is false
				'clone' => false,
			),
			array(
				'id'      => "{$prefix}post_quoteauthor",
				'name'    => esc_html__( 'Quote author', 'manh' ),
				'type'    => 'text',
				'clone' => false,
			),
		)
	);
	// Post format - Link
    $meta_boxes[] = array(
		'id' => 'sns-post-link',
		'title' => esc_html__('Link Settings','manh'),
		'description' => '',
		'pages'      => array( 'post' ), // Post type
		'context'    => 'normal',
		'priority'   => 'high',
		'fields' => array( 
		    array(
				'id'    => "{$prefix}post_linkurl",
				'name'  => esc_html__( 'Link URL', 'manh' ),
				'type'  => 'text',
				// Allow to clone? Default is false
				'clone' => false,
			),
			array(
				'id'      => "{$prefix}post_linktitle",
				'name'    => esc_html__( 'Link Title', 'manh' ),
				'type'    => 'text',
				'clone' => false,
			),
		)
	);

	return $meta_boxes;
}


if ( class_exists( 'RWMB_Field' ) ) {
	class RWMB_Layouttype_Field extends RWMB_Select_Field {
		static function admin_enqueue_scripts(){
			wp_enqueue_style( 'manh-imgselect', MANH_THEME_URI . '/framework/meta-box/img-select.css' );
		}
	}
	// Js for metabox fields action
	add_action( 'admin_print_scripts', 'manh_metabox_adminjs');
    function manh_metabox_adminjs(){
		wp_enqueue_script('manh-imgselect', MANH_THEME_URI . '/framework/meta-box/sns-metabox.js', array('jquery'), '', true);
	}
}
