(function ($) {
	"use strict";
	$(document).ready(function() {
		// lazyload for woo product
		if( $('body').hasClass('use_lazyload') ){
			$('.product_list').each(function(){
				if( $(this).length > 0 ){
					$(this).find('img.lazy').lazyload();
				}
			});
		}
		// OWL click next/prev show lazyload
	    $('.owl-carousel .owl-nav div').each(function(){
			$(this).on('click', function(){ 
				if( $('body').hasClass('use_lazyload') ){
					var parent_owl = $(this).parents('.owl-carousel');
					var timeout = setTimeout(function() {
				        parent_owl.find("img.lazy:not(.loaded)").trigger("appear");
				    }, 1000);
				}
			});
		});
		if ( typeof $.fn.inputSpinner == 'function' && $('.quantity input.qty').length && $('.quantity input.qty').attr('type') !== 'hidden' ) {
			if ( $('.quantity input.qty').attr("step").indexOf(".") >= 0 ) { 
				$('.quantity input.qty').attr('data-decimals', '1');
			}
			$('.quantity input.qty').inputSpinner();
		}
		// Js for shortcode
		SnsShortcodesJs.init();
		// Js for product view
		SnsJsProductView.init();
		// Js for category view
		SnsToolCategoryView.init();
		
		// Product image, gallery, zoom
		SnsSinglePrdN1.movePositionGalleryTrigger();
		SnsSinglePrdN1.addPopupVideo();
		if( $('body.single-product .product.type-product > .gallery_type_h').length ){
			SnsSinglePrdIHG.init('.gallery_type_h');
		}
		if( $('body.single-product .product.type-product > .gallery_type_v').length ){
			SnsSinglePrdIVG.init('.gallery_type_v');
		}
		if( $('body.single-product .product.type-product > .gallery_type_n1').length ){
			SnsSinglePrdN1.reCreateGalleryImages('.gallery_type_n1');
			var tops = 30;
			if ( $('body').hasClass('admin-bar') ) {
				tops = tops + $('body #wpadminbar').height();
			}
			var sidebar_sticky = new StickySidebar('body.single-product .product.type-product > .gallery_type_n1 .entry-summary .summary-inner', {
		        containerSelector: 'body.single-product .product.type-product > .gallery_type_n1',
		        innerWrapperSelector: 'body.single-product .product.type-product > .gallery_type_n1 .entry-summary .summary-inner .inner',
		        topSpacing: tops,
		        bottomSpacing: 30
		    });
		}
		if( $('body.single-product .product.type-product > .gallery_type_n2').length ){
			SnsSinglePrdN2.init('.gallery_type_n2');
		}
		// Variations for Variable Product
		SnsVariationForm.reDesignVariationForm();
		//
		$('.variations-product-wrap').each(function(){
			if ( !$(this).length ) return;
			var $_img_src = '';
			var $_product_image = $(this).parents('.type-product').find('a.product-image img');
			if ( $_product_image.hasClass('lazy') ) {
				$_img_src = $_product_image.data('original');
			}else{
				$_img_src = $_product_image.attr('src');
			}
			$(this).find('.variable-item a.option').each(function(){
				if ( $_img_src == $(this).attr('data-image-src') ) {
					$(this).addClass('active');
				}
			});
		});
		$('body').on('click', '.product .variations-product-wrap a.option', function(e) {
			e.preventDefault();
			if ( $(this).hasClass('active') ) return false;
			var $img_src = '';
			var $prd = $(this).parents('.type-product');
			var $prd_image = $prd.find('.product-image img');
			if ( $prd_image.hasClass('lazy') ) {
				$img_src = $prd_image.data('original');
			}else{
				$img_src = $prd_image.attr('src');
			}
			$prd.find('.variations-product-wrap a.option').removeClass('active'); 
			$(this).addClass('active');
			var $data_src = $(this).attr('data-image-src');
			if( $data_src != '' ){
				$prd_image.attr('src', $data_src);
				$prd_image.attr('srcset', '');
				$prd_image.attr('sizes', '');
			}
			return false;
		});
		// Rating
		$('.star-rating .value').each(function(){
			if( typeof $(this).attr('data-width') !== typeof undefined ){
				$(this).css('width', $(this).attr('data-width'));
			}
		})
		// Rating
		$('.the-bar > span').each(function(){
			if( typeof $(this).attr('data-width') !== typeof undefined ){
				$(this).css('width', $(this).attr('data-width'));
			}
		})
        // Accordion for category
		$('.widget_product_categories .product-categories').SnsAccordion({

		});
		if ( $('body').hasClass('use-tooltip') ) {
			// Add to quick view
			$('.block-product-inner a.yith-wcqv-button').each(function(){
				if ( $(this).attr('data-original-title') != '' ) {
					$(this).attr('data-toggle', 'tooltip').attr('data-placement', 'left').attr('data-original-title', $(this).text().trim());
					if ( $(this).parents('.s-products.product_list').hasClass('list') ) $(this).attr('data-placement', 'right');
				}
			});
			// Add to Wishlist
			$('.block-product-inner .yith-wcwl-add-to-wishlist a.add_to_wishlist').each(function(){
				if ( $(this).attr('data-original-title') != '' ) $(this).attr('data-toggle', 'tooltip').attr('data-placement', 'left').attr('data-original-title', $(this).text().trim());
			});
			$('.block-product-inner .yith-wcwl-wishlistaddedbrowse a, .block-product-inner .yith-wcwl-wishlistexistsbrowse a').each(function(){
				if ( $(this).attr('data-original-title') != '' ) $(this).attr('data-toggle', 'tooltip').attr('data-placement', 'left').attr('data-original-title', $(this).text().trim());
			});
			// Add to compare
			$('.block-product-inner .compare').each(function(){
				if ( $(this).attr('data-original-title') != '' ) $(this).attr('data-toggle', 'tooltip').attr('data-placement', 'left').attr('data-original-title', $(this).text().trim());
			});
			// Add to cart
			$('.block-product-inner .cart-wrap a.button').each(function(){
				if ( $(this).attr('data-original-title') != '' ) $(this).parent('.cart-wrap').attr('data-toggle', 'tooltip').attr('data-placement', 'left').attr('data-original-title', $(this).text().trim());
			});
		}
		// Update mini cart number
		if ( $('.sns-cart-number').length && $('.sns-ajaxcart .tongle .number').length ) {
			$('.sns-ajaxcart .tongle .number').html($('.sns-cart-number').html().trim());
		}
		// Ajax complete
		jQuery(document).ajaxComplete(function(e, xhr, settings) {
			if ( settings.dataType == 'script' ) { return; }
			// Qty btn
			if ( typeof settings.data != 'undefined' && ( settings.data.match(/yith_load_product_quick_view/i) 
				|| settings.url.match(/wc-ajax=add_to_cart/i)
				|| settings.url.match(/wc-ajax=get_refreshed_fragments/i)
				|| settings.data.match(/update_cart/i) ) ) {
				// do something
				if ( typeof $.fn.inputSpinner == 'function' && $('.quantity > input.qty').length && $('.quantity > input.qty').attr('type') !== 'hidden' ) {
					$('.quantity').each(function(){
						if ( $(this).find(' > .input-group').length <= 0) {
							if ( typeof $(this).find('input.qty').attr("step") !== 'undefined' && $(this).find('input.qty').attr("step").indexOf(".") >= 0 ) { 
								$(this).find('input.qty').attr('data-decimals', '1');
							}
							$(this).find('input.qty').inputSpinner();
						}
					});
				}
			}
			// Update mini wishlist number
			if ( typeof settings.data != 'undefined' && settings.data.match(/remove_from_wishlist/i) ) {
				if ( $('.mini-wishlist .tongle .number').length ) {
					var num_wl = parseInt($('.mini-wishlist .tongle .number').html()) - 1;
					if ( num_wl < 0 ) num_wl = 0;
					$('.mini-wishlist .tongle .number').html(num_wl);
				}
			}
			if ( typeof settings.data != 'undefined' && settings.data.match(/add_to_wishlist/i) ) {
				if ( $('.mini-wishlist .tongle .number').length ) {
					var num_wl = parseInt($('.mini-wishlist .tongle .number').html()) + 1;
					$('.mini-wishlist .tongle .number').html(num_wl);
				}
			}
			// For plugin additional variation
			if ( typeof settings.url != 'undefined' && settings.url.match(/wc-ajax=wc_additional_variation_images_get_images/i) ) {
				var rv_timeout = setTimeout(function() {
			        if( $('body.single-product .product.type-product > .gallery_type_h').length ){
						SnsSinglePrdIHG.init('.gallery_type_h');
					}
					if( $('body.single-product .product.type-product > .gallery_type_v').length ){
						SnsSinglePrdIVG.init('.gallery_type_v');
					}
			    }, 1000);
			}
			// Rating
			$('.star-rating .value').each(function(){
				if( typeof $(this).attr('data-width') !== typeof undefined ){
					$(this).css('width', $(this).attr('data-width'));
				}
			})
			// Update mini cart number & push messgae
			if ( typeof settings.data != 'undefined' && settings.url.match(/wc-ajax=add_to_cart/i) ) {
				if ( $('#sns-ajaxcart-popup-message').length ) {
					$('#sns-ajaxcart-popup-message').fadeIn(200);
					clearTimeout(ajax_popup_timeout);
					var ajax_popup_timeout = setTimeout(function() {
						$('#sns-ajaxcart-popup-message').fadeOut(200);
					}, 3200);
				}
			}
			if ( typeof settings.data != 'undefined' && ( settings.url.match(/wc-ajax=add_to_cart/i) || settings.url.match(/wc-ajax=get_refreshed_fragments/i) ) ) {
				if ( $('.sns-cart-number').length ) {
					$('.sns-ajaxcart .tongle .number').html($('.sns-cart-number').html().trim());
				}
			}
			// Set loaded for image lazy in .sns-main
			if( $('body').hasClass('use_lazyload') ){
				clearTimeout(timeout);
				var timeout = setTimeout(function() {
					$(".sns-main img.lazy:not(.loaded)").lazyload();
				}, 1000);
			}
			if ( $('body').hasClass('use-tooltip') ) {
				if ( typeof settings.data != 'undefined' && ( settings.data.match(/add_to_wishlist/i) 
					|| settings.url.match(/wc-ajax=add_to_cart/i)
					|| settings.url.match(/yith-woocompare-add-product/i)
					|| settings.data.match(/yith_load_product_quick_view/i) ) ) {
						$('.tooltip.fade').each(function(){
							if ( $(this).length && $(this).attr('role') == 'tooltip' ) {
								$(this).remove();
							}
						});
				}
				// Add to quick view
				$('.block-product-inner a.yith-wcqv-button').each(function(){
					if ( $(this).attr('data-original-title') != '' ) {
						$(this).attr('data-toggle', 'tooltip').attr('data-placement', 'left').attr('data-original-title', $(this).text().trim());
						if ( $(this).parents('.s-products.product_list').hasClass('list') ) $(this).attr('data-placement', 'right');
					}
				});
				// Add to Wishlist
				$('.block-product-inner .yith-wcwl-add-to-wishlist a.add_to_wishlist').each(function(){
					if ( $(this).attr('data-original-title') != '' ) $(this).attr('data-toggle', 'tooltip').attr('data-placement', 'left').attr('data-original-title', $(this).text().trim());
				});
				$('.block-product-inner .yith-wcwl-wishlistaddedbrowse a, .block-product-inner .yith-wcwl-wishlistexistsbrowse a').each(function(){
					if ( $(this).attr('data-original-title') != '' ) $(this).attr('data-toggle', 'tooltip').attr('data-placement', 'left').attr('data-original-title', $(this).text().trim());
				});
				// Add to compare
				$('.block-product-inner .compare').each(function(){
					if ( $(this).attr('data-original-title') != '' ) $(this).attr('data-toggle', 'tooltip').attr('data-placement', 'left').attr('data-original-title', $(this).text().trim());
				});
				// Add to cart
				$('.block-product-inner .cart-wrap a.button').each(function(){
					if ( $(this).attr('data-original-title') != '' ) $(this).parent('.cart-wrap').attr('data-toggle', 'tooltip').attr('data-placement', 'left').attr('data-original-title', $(this).text().trim());
				});
				// Added to Wishlist
				$('.block-product-inner .yith-wcwl-wishlistaddedbrowse a, .block-product-inner .yith-wcwl-wishlistexistsbrowse a').each(function(){
					$(this).attr('data-toggle', 'tooltip').attr('data-placement', 'left').attr('data-original-title', $(this).text().trim());
				});
				// Added to cart
				$('.block-product-inner .added_to_cart').each(function(){
					if( $(this).text().trim() != '') $(this).parent('.cart-wrap').attr('data-placement', 'left').attr('data-toggle', 'tooltip').attr('data-original-title', $(this).text().trim());
				});
			}
			//
			$('.variations-product-wrap').each(function(){
				if ( !$(this).length ) return;
				var $_img_src = '';
				var $_product_image = $(this).parents('.type-product').find('a.product-image img');
				if ( $_product_image.hasClass('lazy') ) {
					$_img_src = $_product_image.data('original');
				}else{
					$_img_src = $_product_image.attr('src');
				}
				$(this).find('.variable-item a.option').each(function(){
					if ( $_img_src == $(this).attr('data-image-src') ) {
						$(this).addClass('active');
					}
				});
			});
			if ( typeof settings.data == 'undefined' ) {
				clearTimeout(sorttimeout);
				var sorttimeout = setTimeout(function() {
			        SnsToolCategoryView.sortGridLayout();
			    }, 800);
			}

		});
	});
	$(window).on('load', function(){
    	// Js for OWL
		SnsJsOWL.init();
		// mode View & Layout grid
		SnsToolCategoryView.sortGridLayout();
		SnsToolCategoryView.setNumberCols();
    });
    var SnsJsOWL = {
    	init: function() {
    		// Carousel Cross sell Product(cart page)
			if ( $('.cross-sells .products.product_list').length ) {
				$('.cross-sells .products.product_list').addClass('owl-carousel');
				$('.cross-sells .products.product_list').owlCarousel({
	                loop: ( $('.cross-sells .products.product_list').find('> *').length > 3 ) ? true : false, 
	                autoplay : false, dots: false, nav: true, items : 2,
	                responsive : {
	                    0 : { items: 2},
	                    480 : { items: 2 },
	                    768 : { items: 2 },
	                    992 : { items: 2 },
	                    1200 : { items: 3 },
	                    1800 : { items: 3 }
	                },
	            });
			}
    		// Carousel Related Product
			if ( $('.related.products .product_list').length ) {
				var number_lg = 4;
				if ( !$('body').hasClass('layout-type-m') ){
					number_lg = 3;
				}
				$('.related.products .product_list').owlCarousel({
	                loop: ( $('.related.products .product_list').find('> *').length > number_lg ) ? true : false, 
	                autoplay : false, dots: false, nav: true,items : number_lg,
	                responsive : {
	                    0 : { items: 2},
	                    480 : { items: 3 },
	                    768 : { items: 3 },
	                    992 : { items: number_lg },
	                    1200 : { items: number_lg },
	                    1800 : { items: number_lg }
	                },
	            });
			}
			// Carousel Upsell Product
			if ( $('.sns-main .upsells.products .product_list').length ) {
				var number_lg = 4;
				if ( !$('body').hasClass('layout-type-m') ){
					number_lg = 3;
				}
				$('.sns-main .upsells.products .product_list').owlCarousel({
	                loop: ( $('.sns-main .upsells.products .product_list').find('> *').length > 4 ) ? true : false, 
	                autoplay : false, dots: false, nav: true, items : 6,
	                responsive : {
	                    0 : { items: 2},
	                    480 : { items: 3 },
	                    768 : { items: 3 },
	                    992 : { items: number_lg },
	                    1200 : { items: number_lg },
	                    1800 : { items: number_lg }
	                },
	            });
			}
			// Shortcode: SNS Products
			$('.sns-products').each(function(){
				if ( $(this).length > 0 && $(this).find('div.product_list.owl-carousel').find('> *').length > 0 ){
					var wrapc = $(this).find('div.product_list.owl-carousel');
					wrapc.owlCarousel({
						loop: ( $(this).find('div.product_list.owl-carousel').find('> *').length > $(this).data('desktop')) ? true : false,
						dots: ( $(this).data('usepaging')=='1' )? true : false,
						nav: ( $(this).data('usenav')=='1' )? true : false,
						autoplay: ( $(this).data('autoplay')=='1' )? true : false,
		                items : $(this).data('desktop'),
		                responsive : {
		                    0 : { items: $(this).data('mobilep') },
		                    480 : { items: $(this).data('mobilel') },
		                    768 : { items: $(this).data('tabletp') },
		                    992 : { items: $(this).data('tabletl') },
		                    1200 : { items: $(this).data('laptop') },
		                    1800 : { items: $(this).data('desktop') }
		                },
					});
				}
			});
			// Shortcode hot deal
			$('.sns-hot-deals').each(function(){
				if ( $(this).length > 0 && $(this).find('.owl-carousel').find('> *').length > 0 ){
					var wrapc = $(this).find('.owl-carousel');
					wrapc.owlCarousel({
						dots:  false,
						nav: true,
		                items : 1,
		                autoplay: true,
		                responsive : {
		                    0 : { items: $(this).data('mobilep') },
		                    480 : { items: $(this).data('mobilel') },
		                    768 : { items: $(this).data('tabletp') },
		                    992 : { items: $(this).data('tabletl') },
		                    1200 : { items: $(this).data('laptop') },
		                    1800 : { items: $(this).data('desktop') }
		                },
					});
				}
			});
    	}
    }
    // Js for product view
    var SnsJsProductView = {
    	init: function() {
			// Tab information
		    if ( $('#sns_tab_informations').length ) {
			    if (window.location.href.indexOf('#comments') > 0 ) {
					$('#sns_tab_informations .nav-tabs').find("li.reviews_tab").addClass("active");
		    		$('#sns_tab_informations .tab-content').find("#tab-reviews").addClass("active in");
				}else{
		    		$('#sns_tab_informations .nav-tabs').find("li").first().addClass("active");
		    		$('#sns_tab_informations .tab-content').find(".tab-pane").first().addClass("active in");
		    	}
		    	$('#sns_tab_informations .nav-tabs').tabdrop();
		    	$( 'body.single-product a.woocommerce-review-link' ).off('click').on( 'click', function(e) {
		    		e.preventDefault();
					$( '.reviews_tab a' ).click(); 
					$('body, html').animate({
					    scrollTop: $("#sns_tab_informations").offset().top
					}, 800);
					return true;
				} )
		    }
		    // Move Compare & Wishlist in form cart
			if ( $('body.single-product .entry-summary form.variations_form').length || $('body.single-product .entry-summary form.cart table.group_table').length ) {
				var wl_c_el = 'body.single-product .entry-summary .yith-wcwl-add-to-wishlist, body.single-product .entry-summary .compare';
				$(wl_c_el).each(function(){
					if ( $(this).length ) {
						$('body.single-product .entry-summary form.cart').append($(this).clone());
						$(this).remove();
					}
				});
			}
			// Out of stock
			if ( $('.product.type-product .entry-summary .stock.out-of-stock').length ) {
				$('<div class="clear"></div>').insertAfter('.product.type-product .entry-summary .stock.out-of-stock');
			}
    	}
    }
    // Tool for catgory view
    var SnsToolCategoryView = {
    	init: function() {
    		if( typeof $.fn.select2 == 'function' && $('form.woocommerce-ordering .orderby').length > 0 ){
				$('form.woocommerce-ordering .orderby').select2({
					minimumResultsForSearch: Infinity
				});
			}
    		if ( $('.sticky-filter-btn').length ) {
    			$('body').addClass('use-sticky-filter');
	    		$('.sticky-filter-btn, .sticky-product-filter .overlay').on('click', function(e){
					e.preventDefault();
					if($('.sticky-product-filter').hasClass('active')){
						$('.sticky-product-filter .overlay').fadeOut(250);
						$('.sticky-product-filter').removeClass('active'); 
					} else {
						$('.sticky-product-filter .overlay').fadeIn(250);
						$('.sticky-product-filter').addClass('active');
					}
				});
	    	}
	    	if ( typeof yith_wcan != 'undefined' ) {
		        // YITH Filter
		        if ( typeof $(yith_wcan.scroll_top).offset() != 'undefined' ) {
			        $(document).off('click', '.yith-wcan a').on('click', '.yith-wcan a', function (e) {
			        	e.preventDefault();
			        	$('html, body').stop().animate({
			                scrollTop: $(yith_wcan.scroll_top).offset().top - 20
			            }, 600);
			            $(this).yith_wcan_ajax_filters(e, this);
			        });
			    }
			    $('.yith-wcan-color li a').each(function(){
			    	if ( $(this).attr('style') !== '' ){
			    		$(this).prepend("<span class='attr-color'></span>");
			    		$(this).find('.attr-color').attr('style', $(this).attr('style'));
			    		$(this).attr('style', '');
			    	}
			    });
			}
    	},
    	sortGridLayout: function(bool) { 
    		if ( $('.prdlist-content #sns_woo_list').length ) {
    			if ( typeof bool == 'undefined') var bool = false;
    			if ( bool == true ) {
    				$('.prdlist-content #sns_woo_list').isotope('destroy');
    			}
    			$('.prdlist-content #sns_woo_list').isotope({
				  	itemSelector: '.product',
				  	layoutMode: 'fitRows'
				});

    		}
    	},
    	setNumberCols: function(){
    		if ( $('.prdlist-content #sns_woo_list').length ) {
    			$('.set-cols-number .btn-col').each(function(){
    				var gridnum = $('.prdlist-content #sns_woo_list').attr( 'data-grid' );
    				if ( $(this).attr('data-number') == gridnum ) $(this).addClass('active');
    				$(this).off('click').on('click', function(e) {
		                e.preventDefault();
						if( !$(this).hasClass('active') ){
				            $('.set-cols-number .btn-col').removeClass('active'); 
							$(this).addClass('active');
							$('.prdlist-content #sns_woo_list').attr( 'data-grid', $(this).attr('data-number') );
							$.ajax({
				                url: ajaxurl,
				                data:{
				                	action : 'sns_setgridcols',
				                	gridcols : $(this).attr('data-number')
				                },
				                type: 'POST'
				            });
				            SnsToolCategoryView.sortGridLayout();
				            
				        }
					});
				});
    		}
    	}
    }
    var SnsShortcodesJs = {
    	init: function() {
			$('.sns-360-degree-product').each(function(){ 
				if ( !$(this).length ) return;
				var sns360degree = $(this).find('.content-360').ThreeSixty({
    				totalFrames: $(this).data('total_frame'),
					endFrame: $(this).data('total_frame'),
					currentFrame: 1,
					imgList: '.images',
					progress: '.spinner',
					imagePath: $(this).data('image_path'),
					filePrefix: $(this).data('file_prefix'),
					ext: $(this).data('file_ext'),
					responsive: true,
					height: 512,
					width: 512,
					navigation: $(this).data('navigation'),
					disableSpin: true,
					onReady: function() {
				        setTimeout(function() {
				          sns360degree.play(); sns360degree.$el.find('.nav_bar_play').attr('class', 'nav_bar_stop');
				        }, 2000);
				    }
				});
			});
    	}
    }
	// Begin Class: SnsVariationForm
	var SnsVariationForm = {
        reDesignVariationForm: function( $wrap ) {
        	if ( typeof $wrap == 'undefined') var $wrap = '';
        	if ( $wrap != '' ) {
	    		$wrap = $wrap+' .type-product.product-type-variable';
	    	}else{
	    		$wrap = '.type-product.product-type-variable';
	    	}
			if ( $($wrap).length  && typeof sns_arr_attr !== 'undefined' ) { 
				$($wrap).find('.variations select').each(function(){
					var select = $(this), select_div, var_attr = sns_arr_attr[select.attr('name')];
					if ( typeof var_attr == 'undefined' ) { return false; } 
					select_div = $('<div />', {
				                	'class': 'sellect-wrap'
				            	}).insertAfter(select);
					$($wrap).find('.variations').addClass('re-designed'); select.hide();
					select.find( 'option' ).each(function (){
						var option_old = $(this), option;

						if ( option_old.attr('value')!='' ) { 
							var inner_opt, class_sellect, val_opt = var_attr.key_val[option_old.attr('value')];

			   				if (val_opt.indexOf("http:") == 0 || val_opt.indexOf("https:") == 0) {
								inner_opt = $('<span/>', {
											'html':'<img src="' + val_opt + '">'
										});
								class_sellect = ' image';
							}else if(val_opt.indexOf("#") == 0){
			                    inner_opt = $('<span/>', {
												'style':'background:' + val_opt
											});
								class_sellect = ' color';
							}else {
			                    inner_opt = $('<span/>', {
												'html': val_opt
											});
								class_sellect = ' text';
			                }
			                option = $('<div/>', {
				                        'class': 'option'+class_sellect,
				                        'data-toggle':'tooltip',
				                        'data-original-title':option_old.text(),
				                        'data-value': option_old.attr('value')
				                    }).appendTo(select_div);
		                    inner_opt.appendTo(option);
							if ( option_old.val() == select.val() ){
								option.addClass('selected');
							}
		                    option.on('click', function () {
		                    	// Update variation values
		                        if ( $(this).hasClass('selected') ) {
		                            select.val('').change();
		                        } else {
		                            select.val( option_old.val() ).change();
		                        }
		                        SnsVariationForm.setSelectedOpt( $(this) );
		                    });
		                }
					});
				});
				$( document ).on( 'click', '.variations_form .reset_variations', function(event) {
					$('.variations_form .sellect-wrap .option').removeClass('selected');
				});
			}
		},
		setSelectedOpt: function( option ) {
	        option.toggleClass('selected');
	        option.siblings().removeClass('selected');
	    },
    }
    // End Class: SnsVariationForm
    // Begin Class: SnsSinglePrdIHG
	var SnsSinglePrdIHG = {
		init: function( $wrap ) {
			if ( $( $wrap + ' .flex-control-thumbs' ).length ) {
				$( $wrap + ' .flex-control-thumbs' ).addClass('ready-to-slide');
				$( $wrap + ' .flex-control-thumbs.ready-to-slide' ).slick({
					focusOnSelect: true,
					infinite: false,
					arrows: true,
					slidesToScroll: 1,
					slidesToShow: 4,
					responsive: [
					    {
					      breakpoint: 1200,
					      settings: {
					        slidesToShow: 4,
					      }
					    },
					    {
					      breakpoint: 778,
					      settings: {
					        slidesToShow: 3,
					      }
					    }
					 ]
				});
			}
	    },
	};
	// End Class: SnsSinglePrdIHG
	// Begin Class: SnsSinglePrdIVG
	var SnsSinglePrdIVG = {
		init: function( $wrap ) {
			if ( $( $wrap + ' .flex-control-thumbs' ).length ) {
				$( $wrap + ' .flex-control-thumbs' ).addClass('ready-to-slide');
				$( $wrap + ' .flex-control-thumbs.ready-to-slide' ).slick({
					vertical: true, verticalSwiping: true,
					focusOnSelect: true,
					infinite: false,
					arrows: true,
					slidesToScroll: 1,
					slidesToShow: 4,
					responsive: [
					    {
					      breakpoint: 1200,
					      settings: {
					        slidesToShow: 4,
					      }
					    },
					    {
					      breakpoint: 820,
					      settings: {
					        slidesToShow: 3,
					      }
					    }
					 ]
				});
			}
	    }
	};
	// End Class: SnsSinglePrdIVG
	// Begin Class: SnsSinglePrdN1
    var SnsSinglePrdN1 = {
    	addPopupVideo: function () {
    		if ( typeof wc_single_product_params != 'undefined' && wc_single_product_params.sns_product_video ) {
    			$('.woocommerce-product-gallery__trigger').before('<a href="' + wc_single_product_params.sns_product_video + '" class="sns-product-popvideo added-by-snsjs">Product Video</a>');
    			$( document ).on( 'click', '.woocommerce-product-gallery .sns-product-popvideo', function(e) {
					e.preventDefault();
					var pswpElement = $( '.pswp' )[0],
						items   = [];
					if ( $('.woocommerce-product-gallery .sns-product-popvideo').length && $('.woocommerce-product-gallery .sns-product-popvideo').attr('href') ) {
						var item_video = { html: ' <iframe class="sns-prdpopvideo" width="960" height="541" frameborder="0" src="'+ $('.woocommerce-product-gallery .sns-product-popvideo').attr('href') +'"></iframe>' }
						items.push( item_video );
					}
					var options = $.extend( {
						index: 0,
						addCaptionHTMLFn: function( item, captionEl ) {
							if ( ! item.title ) {
								captionEl.children[0].textContent = '';
								return false;
							}
							captionEl.children[0].textContent = item.title;
							return true;
						}
					}, wc_single_product_params.photoswipe_options );
					// Initializes and opens PhotoSwipe.
					var photoswipe_video = new PhotoSwipe( pswpElement, PhotoSwipeUI_Default, items, options );
					photoswipe_video.init();
					return false;
				});
    		}
    	},
		reCreateGalleryImages: function( $wrap ) {
			SnsSinglePrdN1.flexDestroy( $wrap + ' .woocommerce-product-gallery');
			SnsSinglePrdN1.initPhotoswipe();
			SnsSinglePrdN1.initZoom( $wrap );
			if ( $('form.variations_form').length > 0 ) { SnsSinglePrdN1.forVariableProduct($wrap); }
	    },
	    forVariableProduct: function($wrap) {
	    	$( document ).on( 'click', '.variations_form .reset_variations', function(event) {
	    		SnsSinglePrdN1.initZoom( $wrap );
	    	});
	    	$( document ).on( 'found_variation', '.variations_form', function(event, variation) {
	    		SnsSinglePrdN1.initZoom( $wrap );
	    	});
	    },
	    flexDestroy: function ($wrap) {
			var el = $($wrap);
			var elClean = el.clone();

			elClean.find('.flex-viewport').children().unwrap();
			elClean
				.removeClass('flexslider')
				.find('.clone, .flex-direction-nav, .flex-control-nav')
				.remove()
				.end()
				.find('*').removeAttr('style').removeClass (function (index, css) {
					return (css.match (/\bflex\S+/g) || []).join(' ');
				});

			elClean.insertBefore(el).css( 'opacity', 1 );
			elClean.next().remove();
		},
		initZoom: function ( $wrap ){
			if ( typeof wc_single_product_params != 'undefined' && !wc_single_product_params.zoom_enabled ) return;
			$( $wrap + ' .woocommerce-product-gallery__wrapper .woocommerce-product-gallery__image').each(function(){
				var zoom_options = $.extend( {
					touch: false
				}, wc_single_product_params.zoom_options );

				if ( 'ontouchstart' in document.documentElement ) {
					zoom_options.on = 'click';
				}

				$(this).trigger( 'zoom.destroy' );
				$(this).zoom( zoom_options );

				setTimeout( function() {
					if ( $(this).find(':hover').length ) {
						$(this).trigger( 'mouseover' );
					}
				}, 100 );
			});
		},
		getGalleryItems: function() {
			var $slides = $('.woocommerce-product-gallery__wrapper .woocommerce-product-gallery__image'),
				items   = [];

			if ( $slides.length > 0 ) {
				$slides.each( function( i, el ) {
					var img = $( el ).find( 'img' );

					if ( img.length ) {
						var large_image_src = img.attr( 'data-large_image' ),
							large_image_w   = img.attr( 'data-large_image_width' ),
							large_image_h   = img.attr( 'data-large_image_height' ),
							item            = {
								src  : large_image_src,
								w    : large_image_w,
								h    : large_image_h,
								title: img.attr( 'data-caption' ) ? img.attr( 'data-caption' ) : img.attr( 'title' )
							};
						items.push( item );
					}
				} );
			}
			
			return items;
		},
		movePositionGalleryTrigger: function() {
			if ( typeof PhotoSwipe !== 'undefined' && $('.woocommerce-product-gallery .woocommerce-product-gallery__trigger').length ) {
				$('.woocommerce-product-gallery .woocommerce-product-gallery__trigger').appendTo('.woocommerce-product-gallery .flex-viewport');
			}
		},
		initPhotoswipe: function() {
			if ( typeof PhotoSwipe !== 'undefined' && $('.woocommerce-product-gallery .woocommerce-product-gallery__trigger').length ) {
				$('.woocommerce-product-gallery .woocommerce-product-gallery__trigger').on('click', function(e){
					e.preventDefault();
					SnsSinglePrdN1.openNewPhotoswipe();
					return;
				});
			}
		},
		openNewPhotoswipe: function(){
			if ( typeof wc_single_product_params == 'undefined' ) return;
			var pswpElement = $( '.pswp' )[0],
				items       = SnsSinglePrdN1.getGalleryItems(),
				clicked;
			var options = $.extend( {
				index: 0,
				addCaptionHTMLFn: function( item, captionEl ) {
					if ( ! item.title ) {
						captionEl.children[0].textContent = '';
						return false;
					}
					captionEl.children[0].textContent = item.title;
					return true;
				}
			}, wc_single_product_params.photoswipe_options );
			// Initializes and opens PhotoSwipe.
			var photoswipe = new PhotoSwipe( pswpElement, PhotoSwipeUI_Default, items, options );
			photoswipe.init();
		}

	};
    // End Class: SnsSinglePrdN1
    // Begin Class: SnsSinglePrdN2
	var SnsSinglePrdN2 = { 
	    init: function( $wrap ) {
			SnsSinglePrdN1.reCreateGalleryImages( $wrap );
			$( $wrap + ' .woocommerce-product-gallery__wrapper').slick({
				focusOnSelect: true,
				infinite: false,
				arrows: true,
				slidesToScroll: 1,
				slidesToShow: 3,
				responsive: [
				    {
				      breakpoint: 1200,
				      settings: {
				        slidesToShow: 3,
				      }
				    },
				    {
				      breakpoint: 778,
				      settings: {
				        slidesToShow: 2,
				      }
				    },
				    {
				      breakpoint: 460,
				      settings: {
				        slidesToShow: 1,
				      }
				    }
				 ]
			});
	    },
	    reCalWidth: function( $wrap ){
	    	if ( $($wrap).width() > 1024 ){
	    		$($wrap).attr('style', '');
		    	$($wrap).css({
					'left' : -( $('body').innerWidth() - $($wrap).width() ) / 2,
					'width' : $('body').innerWidth(),
					'position' : 'relative',

				});
		    }else{
		    	$($wrap).attr('style', '');
		    }
	    }
	};
	// End Class: SnsSinglePrdN2
})(jQuery);