<?php
function arrow_get_all_plugins_require( $plugins ) {
	/*
	* Array of plugin arrays. Required keys are name and slug.
	* If the source is NOT from the .org repo, then source is also required.
	*/
	$plugins = array(
		array(
			'name'     => esc_html__( 'Elementor', 'lusion' ),
			'slug'     => 'elementor',
			'required' => true,
			'icon'     => 'https://ps.w.org/elementor/assets/icon-256x256.gif',
		),
		array(
			'name'     => esc_html__( 'Classic Widgets', 'lusion' ),
			'slug'     => 'classic-widgets',
			'required' => false,
			'icon'     => 'https://s.w.org/plugins/geopattern-icon/classic-widgets.svg',
		),

		array(
			'name'     => esc_html__( 'Revolution Slider ', 'lusion' ),
			'slug'     => 'revslider',
			'required' => true,
			'icon'     => 'https://arrowtheme.github.io/demo-data/icon-plugins/revslider.png',
			'premium'  => true,
		),

		array(
			'name'     => esc_html__( 'Woocommerce', 'lusion' ),
			'slug'     => 'woocommerce',
			'required' => true,
			'icon'     => 'https://ps.w.org/woocommerce/assets/icon.svg',
		),
		array(
			'name'     => esc_html__( 'WOOCS - WooCommerce Currency Switcher', 'lusion' ),
			'slug'     => 'woocommerce-currency-switcher',
			'required' => false,
		),
		array(
			'name'    => 'Woo Booster Toolkit',
			'slug'    => 'woo-booster-toolkit',
			'premium' => true,
			//          'required' => true,
			'icon'    => 'https://updates.thimpress.com/wp-content/uploads/2023/12/woo-boot-sale.png',
		),

		array(
			'name'     => esc_html__( 'Yith Woocommerce Brands Add-on', 'lusion' ),
			'slug'     => 'yith-woocommerce-brands-add-on',
			'required' => false,
			'icon'     => 'https://ps.w.org/yith-woocommerce-brands-add-on/assets/icon-128x128.jpg',

		),
		array(
			'name'     => esc_html__( 'MailChimp for WordPress', 'lusion' ),
			'slug'     => 'mailchimp-for-wp',
			'required' => false,
		),
		array(
			'name'     => esc_html__( 'Contact Form 7', 'lusion' ),
			'slug'     => 'contact-form-7',
			'required' => false,
		),
		array(
			'name'     => esc_html__( 'Regenerate Thumbnails', 'lusion' ),
			'slug'     => 'regenerate-thumbnails',
			'required' => false,
		),

	);

	return $plugins;
}

add_filter( 'arrowpress_core_get_all_plugins_require', 'arrow_get_all_plugins_require' );

//Add info for Dashboard Admin
if ( ! function_exists( 'arrowpress_lusion_links_guide_user' ) ) {
	function arrowpress_lusion_links_guide_user() {
		return array(
			'docs'      => 'https://docs.arrowtheme.com/lusion-multipurpose-ecommerce-wordpress-theme/',
			'support'   => 'https://help.arrowtheme.com/',
			'knowledge' => 'https://help.arrowtheme.com/',
		);
	}
}
add_filter( 'arrowpress_theme_links_guide_user', 'arrowpress_lusion_links_guide_user' );

/**
 * Link purchase theme.
 */
if ( ! function_exists( 'arrowpress_lusion_link_purchase' ) ) {
	function arrowpress_lusion_link_purchase() {
		return 'https://1.envato.market/9Wv0By';
	}
}
add_filter( 'arrowpress_envato_link_purchase', 'arrowpress_lusion_link_purchase' );

/**
 * Envato id.
 */
if ( ! function_exists( 'arrowpress_lusion_envato_item_id' ) ) {
	function arrowpress_lusion_envato_item_id() {
		return '27657550';
	}
}

add_filter( 'arrowpress_envato_item_id', 'arrowpress_lusion_envato_item_id' );

add_filter(
	'arrowpress_prefix_folder_download_data_demo',
	function () {
		return 'lusion';
	}
);

add_filter( 'arrowpress_importer_basic_settings', 'arrowpress_import_add_basic_settings' );
add_filter( 'arrowpress_importer_page_id_settings', 'arrowpress_import_add_page_id_settings' );
function arrowpress_import_add_basic_settings( $settings ) {
	$settings[] = 'elementor_css_print_method';
	$settings[] = 'elementor_experiment-e_font_icon_svg';
	$settings[] = 'elementor_cpt_support';
	$settings[] = 'elementor_scheme_color';
	$settings[] = 'elementor_scheme_typography';
	$settings[] = 'elementor_scheme_color-picker';
	$settings[] = 'elementor_google_font';
	$settings[] = 'permalink_structure';
	$settings[] = 'woocommerce_single_image_width';
	$settings[] = 'woocommerce_thumbnail_image_width';
	$settings[] = 'woocommerce_thumbnail_cropping';
	$settings[] = 'woocommerce_thumbnail_cropping_custom_width';
	$settings[] = 'woocommerce_thumbnail_cropping_custom_height';
	$settings[] = 'yith_woocompare_compare_button_in_product_page';
	$settings[] = 'yith_wcwl_wishlist_page_id';
	$settings[] = 'wcbt_option';
	$settings[] = '_transient_wc_attribute_taxonomies';

	return $settings;
}

function arrowpress_import_add_page_id_settings( $settings ) {
	$settings[] = 'elementor_active_kit';

	return $settings;
}

add_filter(
	'thim_import_wcbt_attribute_type',
	function () {
		return array(
			'pa_color' => 'color',
			'pa_size'  => 'text',
		);
	}
);


add_filter( 'arrowpress_core_list_child_themes', 'arrowpress_list_child_themes' );
function arrowpress_list_child_themes() {
	return array(
		'lusion-child' => array(
			'name'       => 'Lusion Child',
			'slug'       => 'lusion-child',
			'screenshot' => 'https://arrowtheme.github.io/demo-data/lusion/child-themes/screenshot.png',
			'source'     => 'https://arrowtheme.github.io/demo-data/lusion/child-themes/lusion-child.zip',
			'version'    => '1.0.0',
		),
	);
}
