<?php
/**
 * Single Product Up-Sells
 *
 * This template is overriden by WebGeniusLab team for fine customizing.
 *
 * @see 	    https://docs.woocommerce.com/document/template-structure/
 * @package 	WooCommerce/Templates
 * @version     3.0.0
 */

defined('ABSPATH') || exit;

use WGL_Extensions\Includes\WGL_Carousel_Settings;
wp_enqueue_script('swiper', get_template_directory_uri() . '/js/swiper/js/swiper-bundle.min.js', array(), false, false);
wp_enqueue_style('swiper', get_template_directory_uri() . '/js/swiper/css/swiper-bundle.min.css');

$columns = (int) WGL_Framework::get_option('shop_related_columns');
$count = (int) WGL_Framework::get_option('shop_r_products_per_page');

if ( $upsells ) :
	?><section class="up-sells upsells wgl-products-wrapper products columns-<?php echo esc_attr( $columns ); ?>">
        <h4><?php esc_html_e( 'You May Also Like&hellip;', 'lunfest' ); ?></h4><?php

        woocommerce_product_loop_start();

        ob_start();

            foreach ( $upsells as $upsell ) :

					$post_object = get_post( $upsell->get_id() );

					setup_postdata( $GLOBALS['post'] =& $post_object );

                wc_get_template_part( 'content', 'product' );
            endforeach;

            $products_items = ob_get_clean();

            $options = [
                // General
	            'slides_per_row' => $columns,
	            'autoplay' => false,
	            'slide_per_single' => count((array)$upsells) > 5 ? false : true,
	            'slider_infinite' => count((array)$upsells) > 5 ? true : false,
	            // Pagination
	            'use_pagination' => false,
	            'pagination_type' => 'circle',
	            // Responsive
	            'customize_responsive' => true,
	            'desktop_breakpoint' => 993,
	            'desktop_slides' => $count,
	            'tablet_breakpoint' => 481,
	            'tablet_slides' => 2,
	            'mobile_breakpoint' => 280,
	            'mobile_slides' => 1,
	            'responsive_gap' => [
		            'desktop_gap' => ['size' => 30],
		            'tablet_gap'  => ['size' => 30],
		            'mobile_gap'  => ['size' => 30],
	            ],
	            'extra_class' => 'number_of_slides-'.count((array)$upsells),
            ];

            if (class_exists('Lunfest_Core') && class_exists('WGL_Extensions_Core')) {
                echo WGL_Carousel_Settings::init( $options, $products_items );
            }else{
                echo WGL_Framework::render_html($products_items);
            }

	    woocommerce_product_loop_end();

	?></section><?php

endif;

wp_reset_postdata();
