<?php
/**
 * Related Products
 *
 * This template is overridden by WebGeniusLab team.
 *
 * @see         https://docs.woocommerce.com/document/template-structure/
 * @author      WooThemes
 * @package     WooCommerce/Templates
 * @version     3.9.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

use WGL_Extensions\Includes\WGL_Carousel_Settings;
wp_enqueue_script('swiper', get_template_directory_uri() . '/js/swiper/js/swiper-bundle.min.js', array(), false, false);
wp_enqueue_style('swiper', get_template_directory_uri() . '/js/swiper/css/swiper-bundle.min.css');

$columns = (int) WGL_Framework::get_option('shop_related_columns');
$count = (int) WGL_Framework::get_option('shop_r_products_per_page');

if ( $related_products ) :

	?><section class="related products"><?php

		$heading = apply_filters( 'woocommerce_product_related_products_heading', esc_html__( 'Related products', 'lunfest' ) );

		if ( $heading ) :
			?><h4><?php echo esc_html( $heading ); ?></h4><?php
		endif;

        ?><div class="wgl-products-related wgl-products-wrapper columns-<?php echo esc_attr($columns);?>"><?php

			 woocommerce_product_loop_start();

                ob_start();

                    foreach ( $related_products as $related_product ) :

                        $post_object = get_post( $related_product->get_id() );

                        setup_postdata( $GLOBALS['post'] =& $post_object ); // phpcs:ignore WordPress.WP.GlobalVariablesOverride.Prohibited, Squiz.PHP.DisallowMultipleAssignments.Found

                        wc_get_template_part( 'content', 'product' );

                    endforeach;

                $products_items = ob_get_clean();

                $options = [
                    // General
                    'slides_per_row' => $columns,
                    'autoplay' => false,
                    'slide_per_single' => count((array)$related_products) > 5 ? false : true,
	                'slider_infinite' => count((array)$related_products) > 5 ? true : false,
                    // Pagination
                    'use_pagination' => false,
                    'pagination_type' => 'circle',
                    // Responsive
                    'customize_responsive' => true,
	                'desktop_breakpoint' => 993,
	                'desktop_slides' => $count,
	                'tablet_breakpoint' => 481,
	                'tablet_slides' => 2,
	                'mobile_breakpoint' => 280,
	                'mobile_slides' => 1,
                    'responsive_gap' => [
                        'desktop_gap' => ['size' => 30],
                        'tablet_gap'  => ['size' => 30],
                        'mobile_gap'  => ['size' => 30],
                    ],
                    'extra_class' => 'number_of_slides-'.count((array)$related_products),
                ];

                if (class_exists('Lunfest_Core') && class_exists('WGL_Extensions_Core')) {
                    echo WGL_Carousel_Settings::init( $options, $products_items );
                }else{
                    echo WGL_Framework::render_html($products_items);
                }

            woocommerce_product_loop_end();
	    ?></div>
	</section><?php

endif;

wp_reset_postdata();
