<?php
/**
 * Navigation section template.
 *
 *
 * @package lunfest\templates
 * @author WebGeniusLab <webgeniuslab@gmail.com>
 * @since 1.0.0
 */

$prevPost = get_adjacent_post(false, '', true);
$nextPost  = get_adjacent_post(false, '', false);

// KSES Allowed HTML
$allowed_html = [
    'a' => [
        'href' => true, 'title' => true,
        'class' => true, 'style' => true,
        'rel' => true, 'target' => true
    ],
    'br' => ['class' => true, 'style' => true],
    'b' => ['class' => true, 'style' => true],
    'em' => ['class' => true, 'style' => true],
    'strong' => ['class' => true, 'style' => true],
];

$image_size = '140';

if ($nextPost || $prevPost) :

    echo '<section class="lunfest-post-navigation">';
        $icon_arrow = '<i class="link-icon flaticon flaticon-right-arrow"></i>';

        if (is_a($prevPost, 'WP_Post') ) :
            echo '<div class="prev-link_wrapper">',
                '<div class="info_wrapper">',
                    '<a href="', esc_url(get_permalink($prevPost->ID)), '" title="', esc_attr($prevPost->post_title), '">',
                        $icon_arrow,
                        '<div class="prev-link-info_wrapper">',
                            '<div class="prev_title-info">', esc_html__('PREV','lunfest'), '</div>',
                        '</div>',
                    '</a>',
                '</div>',
            '</div>';
        endif;

        if (is_a($nextPost, 'WP_Post') ) :
            echo '<div class="next-link_wrapper">',
                '<div class="info_wrapper">',
                    '<a href="', esc_url(get_permalink($nextPost->ID)), '" title="', esc_attr( $nextPost->post_title ), '">',
                        '<div class="next-link-info_wrapper">',
                            '<div class="next_title-info">', esc_html__('NEXT','lunfest'), '</div>',
                        '</div>',
                        $icon_arrow,
                    '</a>',
                '</div>',
            '</div>';
        endif;

    echo '</section>';

endif;