<?php

$postID = get_the_ID();

$single = Lunfest_Event::getInstance();
$single->set_data();
$single->set_post_views($postID);

$hide_all_meta = WGL_Framework::get_option('event_single_meta');
$use_author_info = WGL_Framework::get_option('event_single_author_info');
$use_tags = WGL_Framework::get_option('event_single_meta_tags');
$use_shares = WGL_Framework::get_option('event_single_share') && function_exists('wgl_extensions_social');
$use_likes = WGL_Framework::get_option('event_single_likes') && function_exists('wgl_simple_likes');
$use_views = WGL_Framework::get_option('event_single_views');

$meta_date_data = $meta_data = [];
if (!$hide_all_meta) {
	$meta_data['comments'] = !WGL_Framework::get_option('event_single_meta_comments');
	$meta_data['category'] = !WGL_Framework::get_option('event_single_meta_categories');
    $meta_data['author'] = !WGL_Framework::get_option('event_single_meta_author');
    $meta_date_data['date'] = !WGL_Framework::get_option('event_single_meta_date');
}

// Render
?><article class="blog-post blog-post-single-item format-standard">
	<div <?php post_class( 'single_meta' ); ?>>
		<div class="item_wrapper">
			<div class="blog-post_content"><?php

			    // Media
                $single->render_featured();

                // Title
				?><h1 class="blog-post_title"><?php echo get_the_title(); ?></h1><?php

				// Meta Data ?>
				<div class="meta_wrapper"><?php

					if (!$hide_all_meta) $single->render_post_meta($meta_data);

					if ( $use_views || $use_likes) { ?>
						<div class="meta-data"><?php

						// Views
						!$use_views ?: $single->get_post_views(get_the_ID());

						// Likes
						if ($use_likes) {
							wgl_simple_likes()->likes_button(get_the_ID(), 0);
						}?>
						</div><?php
					}?>
				</div><?php

			    // Content
			    the_content();

				WGL_Framework::link_pages();

				if ( $use_tags || $use_shares ) { ?>
					<div class="clear"></div>
                    <div class="post_info-divider"></div>
					<div class="single_post_info"><?php
						// Tags
                        if ($use_tags) {
                            WGL_Framework::events_tags();
                        }
						// Socials
						if ($use_shares) {
							echo '<div class="share_post-container">';
								wgl_extensions_social()->render_post_share();
							echo '</div>';
						}?>
					</div><?php
				}?>
                <div class="clear"></div>
			</div><!--blog-post_content-->
		</div><!--item_wrapper-->
	</div>
</article><?php
