<?php
global $wgl_event_atts;

// Default settings for events item
$trim = true;

extract($wgl_event_atts);

global $wgl_query_vars;
if(!empty($wgl_query_vars)){
    $query = $wgl_query_vars;
}

// Allowed HTML render
$allowed_html = array(
    'a' => array(
        'href' => true,
        'title' => true,
    ),
    'br' => array(),
    'b' => array(),
    'em' => array(),
    'strong' => array()
);

$heading_attr = isset($heading_margin_bottom) && $heading_margin_bottom != '' ? ' style="margin-bottom: '.(int) $heading_margin_bottom.'px"' : '';

while ($query->have_posts()) :
    $query->the_post();

    $p_cats = wp_get_post_terms(get_the_id(), 'event-categories');

    $p_cats_class = isset($event_layout) && 'carousel' === $event_layout ? ' swiper-slide' : '';
    for ($i=0; $i<count( $p_cats ); $i++) {
        $p_cat_term = $p_cats[$i];
        $p_cats_class .= ' '.$p_cat_term->slug;
    }

    echo '<div class="wgl_col-'.esc_attr($event_columns ?? '').' item'.esc_attr($p_cats_class).'">';

    $single = Lunfest_Event::getInstance();
    $single->set_data();

    $title = get_the_title();

    $event_item_classes = ' format-'.$single->get_pf();
    $event_item_classes .= !!$hide_media ? ' hide_media' : '';
    $event_item_classes .= is_sticky() ? ' sticky-post' : '';

    $single->set_data_image_hero(true, $wgl_event_atts, $aq_image = true);
    $has_media = $single->render_bg_image;

    if(!!$hide_media){
        $has_media = false;
    }
    
    $event_item_classes .= !$has_media ? ' format-no_featured' : '';

    $read_more_text = !!$read_more_location && !!$single->render_post_location(false) ? $single->render_post_location(false) : $read_more_text;

    $meta_to_show = array(
        'comments' => !$meta_comments,
        'author' => !$meta_author,
        'date' => !$meta_date,
        'location' => !$meta_location,
        'category' => !$meta_categories,
    ); ?>

    <div class="events-post <?php echo esc_attr($event_item_classes); ?>">
        <div class="events-post-hero_wrapper">
            <div class="events-post-hero_content"><?php
                // Events Title
                if ( !$hide_event_title && !empty($title) ) {
                    echo sprintf('<%1$s class="events-post_title"%2$s><a href="%3$s">%4$s</a></%1$s>', esc_html($heading_tag), $heading_attr, esc_url(get_permalink()), wp_kses($title, $allowed_html));
                }

                // render Post Meta
                if ( !$hide_postmeta ) {
                    $single->render_post_meta($meta_to_show);
                }

                // Content Events
                if ( !$hide_content ) $single->render_excerpt($content_letter_count, $trim, !$read_more_hide, $read_more_text);

                // Read more link
                if ( !$read_more_hide && 'mini' !== $event_style ) {
                    ?><div class="read-more-wrap">
                    <a href="<?php echo esc_url(get_permalink()); ?>" class="button-read-more"><?php
                        echo !!$read_more_text ? '<span>' . esc_html($read_more_text) . '</span>' : '';
                        ?><i class="flaticon flaticon-right-arrow read-more-icon"></i>
                    </a>
                    </div><?php
                } ?>
            </div><?php

            $link_feature = true;
            $single->hero_render_bg($link_feature, $wgl_event_atts, $aq_image = true, false, !$hide_media);

            // Read more link
            if ( !$read_more_hide && 'mini' === $event_style ) {
                ?><div class="read-more-wrap">
                <a href="<?php echo esc_url(get_permalink()); ?>" class="button-read-more"><?php
                    echo !!$read_more_text ? '<span>' . esc_html($read_more_text) . '</span>' : '';
                    ?><i class="flaticon flaticon-right-arrow read-more-icon"></i>
                </a>
                </div><?php
            }

        ?></div>
    </div>
    </div><?php

endwhile;
wp_reset_postdata();
