<?php
/**
 * Enent Navigation section template.
 *
 *
 * @package lunfest\templates
 * @author WebGeniusLab <webgeniuslab@gmail.com>
 * @since 1.0.0
 */

$args = array(
	'status' 	=> '1',
	'scope' 	=> 'future', // Only upcoming events.
	'orderby' 	=> 'event_start_date',
	'blog' 		=> 'all', // Only applicable for MultiSite.
);

$icon_arrow = '<i class="link-icon flaticon flaticon-right-arrow"></i>';

$EM_Events 		= EM_Events::get($args, $count = false);
$found_ids 		= array();
foreach( $EM_Events as $EM_Event ) {
    $found_ids[] = $EM_Event->post_id;
}

$current_post	= get_the_ID();
$current_key 	= array_search($current_post, $found_ids);
$next_key 		= $current_key + 1;
$next_post 		= $found_ids[$next_key] ?? null;
$prev_key 		= $current_key - 1;
$prev_post 		= ($prev_key > -1) ? $found_ids[$prev_key] : '';

if ($current_key != 0 || $current_key != (count( (array) $found_ids) -1) && !empty($found_ids)):
    echo '<section class="lunfest-post-navigation">';
        if($current_key != 0){
            echo '<div class="prev-link_wrapper">',
                '<div class="info_wrapper">',
                    '<a href="', esc_url(get_permalink($prev_post)) , '" title="', esc_attr(get_the_title($prev_post)), '">',
                        $icon_arrow,
                        '<div class="prev-link-info_wrapper">',
                            '<div class="prev_title-info">', esc_html__('PREV','lunfest'), '</div>',
                        '</div>',
                    '</a>',
                '</div>',
            '</div>';
        }

        if($current_key != (count( (array) $found_ids) -1) && !empty($found_ids)) {
            echo '<div class="next-link_wrapper">',
                '<div class="info_wrapper">',
                    '<a href="', esc_url(get_permalink($next_post)), '" title="', esc_attr(get_the_title($next_post)), '">',
                        '<div class="next-link-info_wrapper">',
                            '<div class="next_title-info">', esc_html__('NEXT','lunfest'), '</div>',
                        '</div>',
                        $icon_arrow,
                    '</a>',
                '</div>',
            '</div>';
        }
    echo '</section>';
endif;