<?php

defined('ABSPATH') || exit;

/**
 * The default template for single location rendering
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-location
 *
 * @package lunfest
 * @author WebGeniusLab <webgeniuslab@gmail.com>
 * @since 1.0.0
 */

get_header();
the_post();

$post_type = 'location';
$sb = WGL_Framework::get_sidebar_data('location_single');
$container_class = $sb['container_class'] ?? '';
$row_class = $sb['row_class'] ?? '';
$column = $sb['column'] ?? '12';
$layout = $sb['layout'] ?? '';

if ( is_single() ) {
    if (WGL_Framework::get_mb_option('post_layout_conditional') == 'custom'){
        $single_type = WGL_Framework::get_mb_option('post_single_type_layout');
    }else{
        $single_type = WGL_Framework::get_option($post_type.'_single_type_layout');
    }
}else{
    $single_type = 2;
}

$row_class .= ' single_type-' . $single_type;
if ('3' === $single_type) {
    $featured_bg_style = 'background-color: ' . WGL_Framework::get_option('location_single_layout_3_bg_image')['background-color'] . ';'
        .  ' margin-bottom: ' . (int) WGL_Framework::get_mb_option('page_title_margin', 'mb_page_title_switch', 'on')['margin-bottom'] . 'px;';

    echo '<div class="post_featured_bg" style="', esc_attr($featured_bg_style), '">';
        get_template_part('templates/location/single/post', $single_type . '_image');
    echo '</div>';
}?>

<div class="wgl-container<?php echo esc_attr(apply_filters('wgl/container/class', $container_class)); ?>">
    <div class="row<?php echo esc_attr(apply_filters('wgl/row/class', $row_class)); ?>">
        <div id='main-content' class="wgl_col-<?php echo esc_attr(apply_filters('wgl/column/class', $column)); ?>">
            <?php
                get_template_part('templates/location/single/post', $single_type);

                //* Navigation
                get_template_part('templates/post/post-navigation');

                if (comments_open() || get_comments_number()) {?>
                    <div class="row">
                        <div class="wgl_col-12">
                            <?php comments_template(); ?>
                        </div>
                    </div>
                <?php } ?>
        </div>
        <?php
            echo (isset($sb['content']) && !empty($sb['content']) ) ? $sb['content'] : '';
        ?>
    </div>
</div>

<?php
get_footer();
