<?php

defined('ABSPATH') || exit;

use WGL_Extensions\Templates\WGL_Events;

/**
 * The default template for single events rendering
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-event
 *
 * @package lunfest
 * @author WebGeniusLab <webgeniuslab@gmail.com>
 * @since 1.0.0
 */

get_header();
the_post();

// Allowed HTML render
$allowed_html = array(
    'a' => array(
        'href' => true,
        'title' => true,
    ),
    'br' => array(),
    'b' => array(),
    'em' => array(),
    'strong' => array()
);

$id = get_the_ID();
$post_type = get_post_type($id);
$sb = WGL_Framework::get_sidebar_data($post_type.'_single');
$container_class = $sb['container_class'] ?? '';
$row_class = $sb['row_class'] ?? '';
$column = $sb['column'] ?? '12';
$layout = $sb['layout'] ?? '';

if ( is_single() ) {
    if (WGL_Framework::get_mb_option('post_layout_conditional') == 'custom'){
        $single_type = WGL_Framework::get_mb_option('post_single_type_layout');
    }else{
        $single_type = WGL_Framework::get_option($post_type.'_single_type_layout');
    }
}else{
    $single_type = 2;
}

$row_class .= ' single_type-' . $single_type;
if ('3' === $single_type) {
    $featured_bg_style = 'background-color: ' . WGL_Framework::get_option('event_single_layout_3_bg_image')['background-color'] . ';'
        .  ' margin-bottom: ' . (int) WGL_Framework::get_mb_option('page_title_margin', 'mb_page_title_switch', 'on')['margin-bottom'] . 'px;';

    echo '<div class="post_featured_bg" style="', esc_attr($featured_bg_style), '">';
        get_template_part('templates/events/single/post', $single_type . '_image');
    echo '</div>';
}?>

<div class="wgl-container<?php echo esc_attr(apply_filters('wgl/container/class', $container_class)); ?>">
    <div class="row<?php echo esc_attr(apply_filters('wgl/row/class', $row_class)); ?>">
        <div id='main-content' class="wgl_col-<?php echo esc_attr(apply_filters('wgl/column/class', $column)); ?>">
            <?php
                get_template_part('templates/events/single/post', $single_type);

                //* Navigation
                get_template_part('templates/events/event-navigation');

                $show_post_related = WGL_Framework::get_option('event_single_related_posts');

                $mb_event_show_r = 'off';
                if (class_exists( 'RWMB_Loader' )) {
                    $mb_event_show_r = WGL_Framework::get_mb_option('event_show_r');
                    if(!empty($mb_event_show_r) && $mb_event_show_r != 'default' ){
                        $show_post_related = $mb_event_show_r === 'off' ? null : $mb_event_show_r;
                    }
                }

                if (
                    (bool)$show_post_related
                    && class_exists('\WGL_Extensions\Templates\WGL_Events')
                    && class_exists('\Elementor\Plugin')
                ) {

                    $mb_event_carousel_r = WGL_Framework::get_mb_option('event_carousel_r', 'mb_event_show_r', 'custom');
                    $mb_event_title_r = WGL_Framework::get_mb_option('event_title_r', 'mb_event_show_r', 'custom');

                    $mb_event_column_r = WGL_Framework::get_mb_option('event_column_r', 'mb_event_show_r', 'custom');
                    $mb_event_number_r = WGL_Framework::get_mb_option('event_number_r', 'mb_event_show_r', 'custom');
                    $mb_event_scope_r = WGL_Framework::get_mb_option('event_scope_r', 'mb_event_show_r', 'custom');
                    $mb_event_scope_r = 'all_events' !== $mb_event_scope_r ? $mb_event_scope_r : ''; 
                    
                    ?><div class='single related_posts'><?php

                        $mb_event_cat_r = WGL_Framework::get_option('event_cat_r');

                        if (class_exists( 'RWMB_Loader' )) {
                            $related_cats = WGL_Framework::get_mb_option('event_show_r');

                            if('custom' === $related_cats){
                                $mb_event_cat_r = get_post_meta(get_the_id(), 'mb_event_cat_r');
                                $mb_event_cat_r = explode(',', $mb_event_cat_r[0]);
                            }
                        }

                        $cats = get_the_terms( get_the_id(), 'event-categories' );
                        $cats = $cats ?: array();
                        $cat_slugs = array();
                        foreach( $cats as $cat ){
                            $cat_slugs[] = 'event-categories:'.$cat->slug;
                        }

                        if(!empty($mb_event_cat_r)){
                            $cat_slugs = [];
                            $list = get_terms( 'event-categories', array( 'include' => $mb_event_cat_r  ) );

                            foreach ($list as $key => $value) {
                                $cat_slugs[] = 'event-categories:'.$value->slug;
                            }
                        }

                        $mb_event_cat_r = $cat_slugs;

                        echo '<div class="lunfest_module_title"><h3>'.(!empty($mb_event_title_r) ? esc_html($mb_event_title_r) : esc_html__('Related Events', 'lunfest')) .' </h3></div>';

                        $related_event_atts = [
                            'navigation_type' => 'none',
                            'use_navigation' => null,
                            'event_layout' => !empty($mb_event_carousel_r) ? 'carousel' : 'grid',
                            'img_size_string' => '740x440',
                            'img_size_array' => '',
                            'img_aspect_ratio' => '',
                            'hide_share' => true,
                            'hide_content' => true,
                            'hide_likes' => true,
                            'meta_author' => true,
                            'meta_categories' => true,
                            'meta_comments' => true,
                            'meta_location' => false,
                            'read_more_hide' => true,
                            'read_more_text' => esc_html__('Read More', 'lunfest'),
                            'heading_tag' => 'h6',
                            'content_letter_count' => 130,
                            'crop_square_img' => 1,
                            'items_load' => 4,
                            'name_load_more' => esc_html__('Load More', 'lunfest'),
                            'event_columns' => !empty($mb_event_column_r) ? $mb_event_column_r : (($layout == "none") ? "3" : "4"),
                            'autoplay' => null,
                            'autoplay_speed' => 3000,
                            'slider_infinite' => false,
                            'slide_per_single'  => true,
                            'use_pagination' => null,
                            'pag_type' => 'circle',
                            'pag_offset' => '',
                            'customize_responsive' => true,
                            'desktop_breakpoint' => null,
                            'desktop_slides' => null,
                            'tablet_breakpoint' => null,
                            'tablet_slides' => null,
                            'mobile_breakpoint' => '767',
                            'mobile_slides' => '1',
                            'number_of_posts' => (int)$mb_event_number_r,
                            'taxonomies' => $mb_event_cat_r,
                            'events_order_by' => '_event_start',
                            'show_filter' => null,
                            'scope' => $mb_event_scope_r,
                            'exclude_any' => 'yes',
                            'by_posts' => [$post->post_name] //* exclude current post
                        ];
                        (new Wgl_Events())->render($related_event_atts);

                    ?></div><?php
                }

                if (comments_open() || get_comments_number()) {?>
                    <div class="row">
                        <div class="wgl_col-12">
                            <?php comments_template(); ?>
                        </div>
                    </div>
                <?php } ?>
        </div>
        <?php
            echo (isset($sb['content']) && !empty($sb['content']) ) ? $sb['content'] : '';
        ?>
    </div>
</div>

<?php
get_footer();
