<?php

use WGL_Extensions\Includes\WGL_Elementor_Helper;

if ( ! defined( 'ABSPATH' ) ) { exit; }
/**
* Lunfest WP Event
*
*
* @class        Lunfest_Event
* @version      1.0
* @category Class
* @author       WebGeniusLab
*/

if (!class_exists('Lunfest_Event')) {
	class Lunfest_Event{

		/**
	     * @var Lunfest_Event
	     */
	    private static $instance;

	    /**
	     * @var \WP_Post
	     */ 
	    private $post_id;
	    private $post_format;
	    private $show_date_meta = true;
	    private $show_author_meta = true;
	    private $show_comments_meta = true;
	    private $show_category_meta = true;
	    private $show_location_meta = true;

	    /**
	     * @return Lunfest_Event
	     */
	    public static function getInstance () {
	        if (null === static::$instance)
	        {
	            static::$instance = new static();
	        }
	        return static::$instance;
	    }

	    private function __construct () {
	    	$this->post_id = get_the_ID();   
	    }

	    public function set_post_meta ( $args = false ) {
	    	if ( !(bool)$args || empty($args) ) {
	    		$this->show_date_meta = true;
    			$this->show_author_meta = true;
    			$this->show_comments_meta = true;
    			$this->show_category_meta = true;
    			$this->show_location_meta = true;
	    	} else {
	    		$this->show_date_meta = isset($args['date']) ? $args['date'] : "";
    			$this->show_author_meta = isset($args['author']) ? $args['author'] : "";
    			$this->show_comments_meta = isset($args['comments']) ? $args['comments'] : "";
    			$this->show_category_meta = isset($args['category']) ? $args['category'] : "";    			
    			$this->show_location_meta = isset($args['location']) ? $args['location'] : "";    			
	    	}
	    }  

	    public function set_data_image_hero ($link_feature = false, $image_size = 'full', $aq_image = false ) {
	 		$this->render_bg_image = true;
	 		$media = $this->featured_image($link_feature, $image_size, $aq_image);

	 		if(empty($media)){
	 			$this->render_bg_image = false;
	 		} 		
	 		$this->post_format = get_post_format(); 
	    }	  

	    public function set_data ($link_feature = false) {
	   	   	$this->post_id = get_the_ID();
	    	$this->post_format = get_post_format(); 
	    }

	    public function get_pf () {
	    	if(!$this->post_format) {
	    		$featured_image_url = wp_get_attachment_url( get_post_thumbnail_id( $this->post_id ) );
	    		if (has_post_thumbnail() && !empty($featured_image_url)) {
	    			return 'standard-image';
	    		} else {
	    			return 'standard';
	    		}
	    	}

	    	return $this->post_format;
	    }

	    public function render_featured ( $link_feature = false, $image_size = 'full', $aq_image = false, $meta_args = false, $meta_to_show = false ) {
	 		$media = $this->featured_image($link_feature, $image_size, $aq_image);

            if((bool) $meta_args){
                ?><div class="blog-post_meta_info"><?php
                    $this->render_post_meta( $meta_to_show );
                ?></div><?php
            }

	 		if (!empty($media)){
                ?><div class="blog-post_media">
                    <div class="blog-post_media_part"><?php echo WGL_Framework::render_html($media); ?></div>
                </div><?php
	 		}
	    }	   

	   	public function hero_render_bg ( $link_feature = false, $wgl_event_atts = array(), $aq_image = false, $data_animation = null, $show_media = true ) {
			$default_media = '';

			if(has_post_thumbnail()) {

				$image_url = wp_get_attachment_url(get_post_thumbnail_id(get_the_ID()));
				$temp_url = $image_url;
                $img_size_array = $wgl_event_atts['img_size_array'] ?? '';
                $img_size_string = $wgl_event_atts['img_size_string'] ?? '';
                $img_aspect_ratio = $wgl_event_atts['img_aspect_ratio'] ?? '';
				if(!!$aq_image){
                    $dimensions = WGL_Elementor_Helper::get_image_dimensions($img_size_array ?: $img_size_string, $img_aspect_ratio);

					if(function_exists('aq_resize')){
						$image_url = aq_resize($image_url, $dimensions['width'], $dimensions['height'], true, true, true);
					}
				}
				$image_url = !empty($image_url) ? $image_url : $temp_url;
				$default_media .= $image_url;
			}	

	 		$media = $default_media;

            if((bool) $media && (bool) $show_media){
                ?><div class="events-post-hero_thumb"><?php

                    if ($link_feature) echo '<a href="'.esc_url(get_permalink()).'" class="events-post_feature-link">';
                        ?><img src="<?php echo esc_url( $media ); ?>" alt="<?php echo the_title_attribute( [ 'echo' => false ] ); ?>"><?php
                    if ($link_feature) echo '</a>';

                ?></div><?php
            }
	    }

	    public function featured_image ( $link_feature, $wgl_event_atts = array(), $aq_image = false ) {
			$output = $featured_image_replace = '';

            $featured_image = WGL_Framework::get_option('event_featured_image_type');
            if ( rwmb_meta('mb_featured_image_type') && rwmb_meta('mb_featured_image_conditional') == 'custom' ){
                $featured_image = rwmb_meta('mb_featured_image_type');
                if ($featured_image == 'replace') {
                    $featured_image_replace = rwmb_meta('featured_image_replace');
                }
            }else if ($featured_image == 'replace') {
                $featured_image_replace = WGL_Framework::get_option('event_featured_image_replace');
            }

			if ($featured_image != 'off' || !is_single()) {
				if(has_post_thumbnail() || !empty($featured_image_replace)) {

					if (!empty($featured_image_replace) && is_single()) {
						if (rwmb_meta('mb_featured_image_conditional') == 'custom') {
							$image_id = array_values((array)$featured_image_replace);
							$image_id = $image_id[0]['ID'];
						} else{
							$image_id = $featured_image_replace['id'];
						}
					} else{
						$image_id = get_post_thumbnail_id();
					}

					$image_data = wp_get_attachment_metadata($image_id);
					$image_meta = isset($image_data['image_meta']) ? $image_data['image_meta'] : array();

                    $img_size_array = $wgl_event_atts['img_size_array'] ?? '';
                    $img_size_string = $wgl_event_atts['img_size_string'] ?? '';
                    $img_aspect_ratio = $wgl_event_atts['img_aspect_ratio'] ?? '';
					$image_url = wp_get_attachment_image_src( $image_id, 'full', false )[0];
					$temp_url = $image_url;

					if(!!$aq_image){
                        $dimensions = WGL_Elementor_Helper::get_image_dimensions($img_size_array ?: $img_size_string, $img_aspect_ratio);
                        if(function_exists('aq_resize')){
                            $image_url = aq_resize($image_url, $dimensions['width'], $dimensions['height'], true, true, true);
                        }
					}
                    $image_url = !empty($image_url) ? $image_url : $temp_url;

					$image_meta['title'] = isset($image_meta['title']) ? $image_meta['title'] : "";

					if($image_url){
						if ($link_feature) $output .= '<a href="'.esc_url(get_permalink()).'" class="blog-post_feature-link">';

						$output .= "<img src='" . esc_url( $image_url ) . "' alt='" . esc_attr($image_meta['title']) . "' />";

						if ($link_feature) $output .= '</a>';

						$this->post_format = 'standard-image';
					}
				}
			}

	    	return $output;
	    }

	    public function render_post_meta ($args = false) {
	    	$this->set_post_meta($args);
	    	if( $this->show_date_meta || $this->show_author_meta || $this->show_comments_meta || $this->show_category_meta  ){
		    	
		    	?><div class="post_meta-wrap"><div class="meta-data"><?php

                    if($this->show_date_meta) {
                        global $EM_Event;
                        if(function_exists('em_get_event')) {
                            global $post;
                            $event = em_get_event( $post );
                            $date_format = get_option('dbem_date_format') ? get_option('dbem_date_format') : get_option('date_format');
                            ?><span class="post_date"><?php echo esc_html($event->start()->i18n($date_format)); ?></span><?php
                        }
                    }

                    if($this->show_author_meta) {
                        ?><span class="post_author"><?php
                            esc_html_e('by ', 'lunfest');
                            ?><a href="<?php echo esc_url(get_author_posts_url(get_the_author_meta('ID'))); ?>"><?php echo esc_html(get_the_author_meta('display_name')); ?></a>
                        </span><?php
                    }

                    if($this->show_comments_meta) {
                        $comments_num = get_comments_number($this->post_id);
                        ?><span class="comments_post">
                            <a href="<?php echo esc_url(get_comments_link()); ?>"><?php
                                echo esc_html($comments_num) . ' ' . esc_html(_n('Comment', 'Comments', $comments_num, 'lunfest'));
                            ?></a>
                        </span><?php
                    }

                    if($this->show_location_meta) {
                        $this->render_post_location();
                    }

                    if($this->show_category_meta) {
                        $this->render_post_cats();
                    }

                ?></div></div><?php
            }
	    }	    

	    public function render_post_location ($echo = true) {
	    	global $EM_Event;
	    	if(function_exists('em_get_event')){
				global $post;
				$event = em_get_event( $post );	 
		    	if( get_option('dbem_locations_enabled') ){
		    		
		    		$content = $event->output("#_LOCATION");
		    		
		    		if(!empty($content)){
		    		    if ($echo){
                            ?><span class='post_location'>
                                <span><?php echo WGL_Framework::render_html($content); ?></span>
                            </span><?php
                        }else{
		    		        return WGL_Framework::render_html($content);
                        }
		    		}
                }
	    	}
	    }	    

	    public function render_post_cats () {
            $post_cats = wp_get_post_terms(get_the_id(), 'event-categories');
            if(!empty($post_cats)){
	            $post_cats_str = '';
	            $post_cats_class = '';
	            $post_cats_links = '<span class="post_categories">';
	            for ($i=0; $i<count( $post_cats ); $i++) {
	                $post_cat_term = $post_cats[$i];
	                $post_cat_name = $post_cat_term->name;
	                $post_cats_str .= ' '.$post_cat_name;
	                $post_cats_class .= ' '.$post_cat_term->slug;
	                $post_cats_link = get_category_link( $post_cat_term->term_id );
	                $post_cats_links .= '<span>';
	                $post_cats_links .= '<a href='.esc_html($post_cats_link).' class="event-category">'.esc_html($post_cat_name).'</a>';
	                $post_cats_links .= '</span>';
	            }
	            $post_cats_links .= '</span>';
	            echo WGL_Framework::render_html($post_cats_links);
            }
	    }	    

	    public function get_excerpt(){
	    	ob_start();
			if (has_excerpt()) {
				the_excerpt();
			} 
			return ob_get_clean();
	    }
	    
	    public function render_excerpt ($symbol_count = false, $shortcode = false, $read_more = false, $read_more_text = false) {


			if(!(bool)$symbol_count) {
				$symbol_count = '400';
			}

	    	global $EM_Event;
	    	if(function_exists('em_get_event')){
	    		if ( $shortcode) {
                    $event = em_get_event( get_the_id(), 'post_id' );
                    $post_content = $event->output("#_EVENTEXCERPT");

					if(!empty($post_content)){
                        if('internal' === get_option( 'elementor_css_print_method' )){
                            $post_content = preg_replace('#<style id="elementor-post-'.get_the_ID().'">(.*?)</style>#is', '', $post_content);
                        }
                        $content_strip_tags = strip_tags($post_content);
                        $post_content = WGL_Framework::modifier_character($content_strip_tags, $symbol_count, '...');

			    		echo '<div class="events-post_text">'.$post_content.'</div>';
			    	}
		    	}   		
	    	}
	    }

	    public function get_post_views($postID){
		    $count_key = 'post_views_count';
		    $count = get_post_meta($postID, $count_key, true);
			
			echo '<div class="post_views wgl-views">';
		    if($count==''){
		        delete_post_meta($postID, $count_key);
		        add_post_meta($postID, $count_key, '0');
		        echo '<span class="counts">'. esc_html(0). '</span>';
		    	echo '<span class="counts_text">'. esc_html__(' View', 'lunfest'). '</span>';
		    }else{
				echo '<span class="counts">'. esc_html($count). '</span>';
		    	echo '<span class="counts_text">'. esc_html__(' Views', 'lunfest'). '</span>';
		    }
			echo '</div>';
		}
 
		public function set_post_views($postID) {
			if( !current_user_can('administrator') ) {
		        $user_ip = function_exists('wgl_get_ip') ? wgl_get_ip() : '0.0.0.0';
		        $key = $user_ip . 'x' . $postID; 
		        $value = array($user_ip, $postID); 
		        $visited = get_transient($key); 

		        //check to see if the Post ID/IP ($key) address is currently stored as a transient
		        if ( false === ( $visited ) ) {

		            //store the unique key, Post ID & IP address for 12 hours if it does not exist
		           set_transient( $key, $value, 60*60*12 );

		            $count_key = 'post_views_count';
		            $count = get_post_meta($postID, $count_key, true);
		            if($count==''){
		                $count = 0;
		                delete_post_meta($postID, $count_key);
		                add_post_meta($postID, $count_key, '0');
		            }else{
		                $count++;
		                update_post_meta($postID, $count_key, $count);
		            }
		        }
		    }   
		}


	}
}
