<?php

if (!class_exists('WGL_Extensions_Core')) {
    return;
}

if (!function_exists('wgl_get_redux_icons')) {
    function wgl_get_redux_icons()
    {
        return WGLAdminIcon()->get_icons_name(true);
    }

    add_filter('redux/font-icons', 'wgl_get_redux_icons',99);
}

//* This is theme option name where all the Redux data is stored.
$theme_slug = 'lunfest_set';

/**
 * Set all the possible arguments for Redux
 * For full documentation on arguments, please refer to: https://github.com/ReduxFramework/ReduxFramework/wiki/Arguments
 * */
$theme = wp_get_theme();

Redux::set_args($theme_slug, [
    'opt_name' => $theme_slug, //* This is where your data is stored in the database and also becomes your global variable name.
    'display_name' => $theme->get('Name'), //* Name that appears at the top of your panel
    'display_version' => $theme->get('Version'), //* Version that appears at the top of your panel
    'menu_type' => 'menu', //* Specify if the admin menu should appear or not. Options: menu or submenu (Under appearance only)
    'allow_sub_menu' => true, //* Show the sections below the admin menu item or not
    'menu_title' => esc_html__('Theme Options', 'lunfest'),
    'page_title' => esc_html__('Theme Options', 'lunfest'),
    'google_api_key' => '', //* You will need to generate a Google API key to use this feature. Please visit: https://developers.google.com/fonts/docs/developer_api#Auth
    'google_update_weekly' => false, //* Set it you want google fonts to update weekly. A google_api_key value is required.
    'async_typography' => true, //* Must be defined to add google fonts to the typography module
    'admin_bar' => true, //* Show the panel pages on the admin bar
    'admin_bar_icon' => 'dashicons-admin-generic', //* Choose an icon for the admin bar menu
    'admin_bar_priority' => 50, //* Choose an priority for the admin bar menu
    'global_variable' => '', //* Set a different name for your global variable other than the opt_name
    'dev_mode' => false,
    'update_notice' => true, //* If dev_mode is enabled, will notify developer of updated versions available in the GitHub Repo
    'customizer' => true,
    'page_priority' => 3, //* Order where the menu appears in the admin area. If there is any conflict, something will not show. Warning.
    'page_parent' => 'wgl-dashboard-panel', //* For a full list of options, visit: http://codex.wordpress.org/Function_Reference/add_submenu_page#Parameters
    'page_permissions' => 'manage_options', //* Permissions needed to access the options panel.
    'menu_icon' => 'dashicons-admin-generic', //* Specify a custom URL to an icon
    'last_tab' => '', //* Force your panel to always open to a specific tab (by id)
    'page_icon' => 'icon-themes', //* Icon displayed in the admin panel next to your menu_title
    'page_slug' => 'wgl-theme-options-panel', //* Page slug used to denote the panel, will be based off page title then menu title then opt_name if not provided
    'save_defaults' => true, //* On load save the defaults to DB before user clicks save or not
    'default_show' => false, //* If true, shows the default value next to each field that is not the default value.
    'default_mark' => '', //* What to print by the field's title if the value shown is default. Suggested: *
    'show_import_export' => true, //* Shows the Import/Export panel when not used as a field.
    'transient_time' => 60 * MINUTE_IN_SECONDS, //* Show the time the page took to load, etc
    'output' => true, //* Global shut-off for dynamic CSS output by the framework. Will also disable google fonts output
    'output_tag' => true, //* FUTURE -> Not in use yet, but reserved or partially implemented. Use at your own risk.
    'database' => '', //* possible: options, theme_mods, theme_mods_expanded, transient. Not fully functional, warning!
    'use_cdn' => true,
]);

Redux::set_section(
    $theme_slug,
    [
        'id' => 'general',
        'title' => esc_html__('General', 'lunfest'),
        'icon' => 'el el-screen',
        'fields' => [
            [
                'id' => 'use_minified',
                'title' => esc_html__('Use minified css/js files', 'lunfest'),
                'type' => 'switch',
                'desc' => esc_html__('Speed up your site load.', 'lunfest'),
                'on' => esc_html__('Yes', 'lunfest'),
                'off' => esc_html__('No', 'lunfest'),
            ],
            [
                'id' => 'preloader-start',
                'title' => esc_html__('Preloader', 'lunfest'),
                'type' => 'section',
                'indent' => true,
            ],
            [
                'id' => 'preloader',
                'title' => esc_html__('Preloader', 'lunfest'),
                'type' => 'switch',
                'on' => esc_html__('Use', 'lunfest'),
                'off' => esc_html__('Hide', 'lunfest'),
                'default' => false,
            ],
            [
                'id' => 'preloader_background',
                'title' => esc_html__('Preloader Background', 'lunfest'),
                'type' => 'color',
                'required' => ['preloader', '=', '1'],
                'transparent' => false,
                'default' => '#ffffff',
            ],
            [
                'id' => 'preloader_color',
                'title' => esc_html__('Preloader Color', 'lunfest'),
                'type' => 'color',
                'required' => ['preloader', '=', '1'],
                'transparent' => false,
                'default' => '#9d99f2',
            ],
            [
                'id' => 'preloader-end',
                'type' => 'section',
                'indent' => false,
            ],
            [
                'id' => 'search_settings',
                'type' => 'section',
                'title' => esc_html__('Search', 'lunfest'),
                'indent' => true,
            ],
            [
                'id' => 'search_style',
                'title' => esc_html__('Choose search style', 'lunfest'),
                'type' => 'button_set',
                'options' => [
                    'standard' => esc_html__('Standard', 'lunfest'),
                    'standard_fw' => esc_html__('Full Header Width', 'lunfest'),
                    'alt' => esc_html__('Full Page Width', 'lunfest'),
                ],
                'default' => 'standard_fw',
            ],
            [
                'id' => 'search_post_type',
                'title' => esc_html__('Search Post Types', 'lunfest'),
                'type' => 'multi_text',
                'validate' => 'no_html',
                'add_text' => esc_html__('Add Post Type', 'lunfest'),
                'default' => [],
            ],
            [
                'id' => 'search_settings-end',
                'type' => 'section',
                'indent' => false,
            ],
            [
                'id' => 'cursor_settings',
                'type' => 'section',
                'title' => esc_html__('Cursor Pointer', 'lunfest'),
                'indent' => true,
            ],
            [
                'id' => 'cursor_switch',
                'title' => esc_html__('Cursor Pointer', 'lunfest'),
                'type' => 'switch',
                'on' => esc_html__('On', 'lunfest'),
                'off' => esc_html__('Off', 'lunfest'),
                'default' => true,
            ],
            [
                'id' => 'cursor_color',
                'title' => esc_html__('Point Color', 'lunfest'),
                'type' => 'color_rgba',
                'required' => ['cursor_switch', '=', '1'],
                'transparent' => false,
                'default' => [
                    'alpha' => '0',
                    'rgba' => 'rgba(60,133,153,0)',
                    'color' => '#9d99f2',
                ],
            ],
            [
                'id' => 'cursor_settings-end',
                'type' => 'section',
                'indent' => false,
            ],
            [
                'id' => 'scroll_up_settings',
                'title' => esc_html__('Back to Top', 'lunfest'),
                'type' => 'section',
                'indent' => true,
            ],
            [
                'id' => 'scroll_up',
                'title' => esc_html__('Button', 'lunfest'),
                'type' => 'switch',
                'on' => esc_html__('Use', 'lunfest'),
                'off' => esc_html__('Disable', 'lunfest'),
                'default' => true,
            ],
            [
                'id' => 'scroll_up_appearance',
                'title' => esc_html__('Appearance', 'lunfest'),
                'type' => 'switch',
                'required' => ['scroll_up', '=', true],
                'on' => esc_html__('Text', 'lunfest'),
                'off' => esc_html__('Icon', 'lunfest'),
            ],
            [
                'id' => 'scroll_up_text',
                'title' => esc_html__('Button Text', 'lunfest'),
                'type' => 'text',
                'required' => ['scroll_up_appearance', '=', true],
                'default' => esc_html__('BACK TO TOP', 'lunfest'),
            ],
            [
                'id' => 'scroll_up_arrow_color',
                'title' => esc_html__('Text/Icon Color', 'lunfest'),
                'type' => 'color',
                'required' => ['scroll_up', '=', true],
                'transparent' => false,
                'default' => '#ffffff',
            ],
            [
                'id' => 'scroll_up_arrow_color_bg',
                'title' => esc_html__('Text/Icon Background Color', 'lunfest'),
                'type' => 'color',
                'required' => ['scroll_up', '=', true],
                'transparent' => false,
                'default' => '#2e2e2e',
            ],
            [
                'id' => 'scroll_up_settings-end',
                'type' => 'section',
                'indent' => false,
            ],
        ],
    ]
);

Redux::set_section(
    $theme_slug,
    [
        'id' => 'editors-option',
        'title' => esc_html__('Custom JS', 'lunfest'),
        'subsection' => true,
        'fields' => [
            [
                'id' => 'custom_js',
                'title' => esc_html__('Custom JS', 'lunfest'),
                'type' => 'ace_editor',
                'subtitle' => esc_html__('Paste your JS code here.', 'lunfest'),
                'mode' => 'javascript',
                'theme' => 'chrome',
                'default' => ''
            ],
            [
                'id' => 'header_custom_js',
                'title' => esc_html__('Custom JS', 'lunfest'),
                'type' => 'ace_editor',
                'subtitle' => esc_html__('Code to be added inside HEAD tag', 'lunfest'),
                'mode' => 'html',
                'theme' => 'chrome',
                'default' => ''
            ],
        ],
    ]
);

Redux::set_section(
    $theme_slug,
    [
        'id' => 'header_section',
        'title' => esc_html__('Header', 'lunfest'),
        'icon' => 'fas fa-window-maximize',
    ]
);

$header_builder_items = [
    'default' => [
        'html1' => ['title' => esc_html__('HTML 1', 'lunfest'), 'settings' => true],
        'html2' => ['title' => esc_html__('HTML 2', 'lunfest'), 'settings' => true],
        'html3' => ['title' => esc_html__('HTML 3', 'lunfest'), 'settings' => true],
        'html4' => ['title' => esc_html__('HTML 4', 'lunfest'), 'settings' => true],
        'html5' => ['title' => esc_html__('HTML 5', 'lunfest'), 'settings' => true],
        'html6' => ['title' => esc_html__('HTML 6', 'lunfest'), 'settings' => true],
        'html7' => ['title' => esc_html__('HTML 7', 'lunfest'), 'settings' => true],
        'html8' => ['title' => esc_html__('HTML 8', 'lunfest'), 'settings' => true],
        'delimiter1' => ['title' => esc_html__('|', 'lunfest'), 'settings' => true],
        'delimiter2' => ['title' => esc_html__('|', 'lunfest'), 'settings' => true],
        'delimiter3' => ['title' => esc_html__('|', 'lunfest'), 'settings' => true],
        'delimiter4' => ['title' => esc_html__('|', 'lunfest'), 'settings' => true],
        'delimiter5' => ['title' => esc_html__('|', 'lunfest'), 'settings' => true],
        'delimiter6' => ['title' => esc_html__('|', 'lunfest'), 'settings' => true],
        'spacer3' => ['title' => esc_html__('Spacer 3', 'lunfest'), 'settings' => true],
        'spacer4' => ['title' => esc_html__('Spacer 4', 'lunfest'), 'settings' => true],
        'spacer5' => ['title' => esc_html__('Spacer 5', 'lunfest'), 'settings' => true],
        'spacer6' => ['title' => esc_html__('Spacer 6', 'lunfest'), 'settings' => true],
        'spacer7' => ['title' => esc_html__('Spacer 7', 'lunfest'), 'settings' => true],
        'spacer8' => ['title' => esc_html__('Spacer 8', 'lunfest'), 'settings' => true],
        'button1' => ['title' => esc_html__('Button', 'lunfest'), 'settings' => true],
        'button2' => ['title' => esc_html__('Button', 'lunfest'), 'settings' => true],
        'wpml' => ['title' => esc_html__('WPML', 'lunfest'), 'settings' => false],
        'cart' => ['title' => esc_html__('Cart', 'lunfest'), 'settings' => true],
        'login' => ['title' => esc_html__('WC Login', 'lunfest'), 'settings' => false],
        'side_panel' => ['title' => esc_html__('Side Panel', 'lunfest'), 'settings' => true],
    ],
    'mobile' => [
        'html1' => esc_html__('HTML 1', 'lunfest'),
        'html2' => esc_html__('HTML 2', 'lunfest'),
        'html3' => esc_html__('HTML 3', 'lunfest'),
        'html4' => esc_html__('HTML 4', 'lunfest'),
        'html5' => esc_html__('HTML 5', 'lunfest'),
        'html6' => esc_html__('HTML 6', 'lunfest'),
        'spacer1' => esc_html__('Spacer 1', 'lunfest'),
        'spacer2' => esc_html__('Spacer 2', 'lunfest'),
        'spacer3' => esc_html__('Spacer 3', 'lunfest'),
        'spacer4' => esc_html__('Spacer 4', 'lunfest'),
        'spacer5' => esc_html__('Spacer 5', 'lunfest'),
        'spacer6' => esc_html__('Spacer 6', 'lunfest'),
        'side_panel' => esc_html__('Side Panel', 'lunfest'),
        'wpml' => esc_html__('WPML', 'lunfest'),
        'cart' => esc_html__('Cart', 'lunfest'),
        'login' => esc_html__('WC Login', 'lunfest'),
    ],
    'mobile_drawer' => [
        'html1' => esc_html__('HTML 1', 'lunfest'),
        'html2' => esc_html__('HTML 2', 'lunfest'),
        'html3' => esc_html__('HTML 3', 'lunfest'),
        'html4' => esc_html__('HTML 4', 'lunfest'),
        'html5' => esc_html__('HTML 5', 'lunfest'),
        'html6' => esc_html__('HTML 6', 'lunfest'),
        'wpml' => esc_html__('WPML', 'lunfest'),
        'spacer1' => esc_html__('Spacer 1', 'lunfest'),
        'spacer2' => esc_html__('Spacer 2', 'lunfest'),
        'spacer3' => esc_html__('Spacer 3', 'lunfest'),
        'spacer4' => esc_html__('Spacer 4', 'lunfest'),
        'spacer5' => esc_html__('Spacer 5', 'lunfest'),
        'spacer6' => esc_html__('Spacer 6', 'lunfest'),
    ],
];

Redux::set_section(
    $theme_slug,
    [
        'title' => esc_html__('Header Builder', 'lunfest'),
        'id' => 'header-customize',
        'subsection' => true,
        'fields' => [
            [
                'id' => 'header_switch',
                'title' => esc_html__('Header', 'lunfest'),
                'type' => 'switch',
                'on' => esc_html__('Use', 'lunfest'),
                'off' => esc_html__('Disable', 'lunfest'),
                'default' => true,
            ],
            [
                'id' => 'header_building_tool',
                'title' => esc_html__('Layout Building Tool', 'lunfest'),
                'type' => 'select',
                'required' => ['header_switch', '=', '1'],
                'options' => [
                    'default' => esc_html__('Default Builder', 'lunfest'),
                    'elementor' => esc_html__('Elementor (recommended)', 'lunfest')
                ],
                'default' => 'default',
            ],
            [
                'id' => 'header_page_select',
                'type' => 'select',
                'title' => esc_html__('Header Template', 'lunfest'),
                'required' => ['header_building_tool', '=', 'elementor'],
                'desc' => wp_kses(
                    sprintf(
                        '%s <a href="%s" target="_blank">%s</a> %s<br> %s',
                        __('Selected Template will be used for all pages by default. You can edit/create Header Template in the', 'lunfest'),
                        admin_url('edit.php?post_type=header'),
                        __('Header Templates', 'lunfest'),
                        __('dashboard tab.', 'lunfest'),
                        lunfest_quick_tip(
                            sprintf(
                                __('Note: fine tuning is available through the Elementor\'s <code>Post Settings</code> tab, which is located <a href="%s" target="_blank">here</a>', 'lunfest'),
                                get_template_directory_uri() . '/core/admin/img/dashboard/quick_tip__header_extra_options.png'
                            )
                        )
                    ),
                    ['a' => ['href' => true, 'target' => true], 'br' => [], 'span' => ['class' => true], 'i' => ['class' => true], 'code' => []]
                ),
                'data' => 'posts',
                'args' => [
                    'post_type' => 'header',
                    'posts_per_page' => -1,
                    'orderby' => 'title',
                    'order' => 'ASC',
                ],
            ],
            [
                'id' => 'bottom_header_layout',
                'type' => 'custom_header_builder',
                'title' => esc_html__('Header Builder', 'lunfest'),
                'required' => ['header_building_tool', '=', 'default'],
                'compiler' => 'true',
                'full_width' => true,
                'default' => [
                    'items' => $header_builder_items['default'],
                    'Top Left area' => [],
                    'Top Center area' => [],
                    'Top Right area' => [],
                    'Middle Left area' => [
                        'spacer1' => ['title' => esc_html__('Spacer 1', 'lunfest'), 'settings' => false],
                        'logo' => ['title' => esc_html__('Logo', 'lunfest'), 'settings' => false],
                    ],
                    'Middle Center area' => [
                        'menu' => ['title' => esc_html__('Menu', 'lunfest'), 'settings' => false],
                    ],
                    'Middle Right area' => [
                        'item_search' => ['title' => esc_html__('Search', 'lunfest'), 'settings' => true],
                        'spacer2' => ['title' => esc_html__('Spacer 2', 'lunfest'), 'settings' => false],
                    ],
                    'Bottom Left area' => [],
                    'Bottom Center area' => [],
                    'Bottom Right area' => [],
                ],
            ],
            [
                'id' => 'bottom_header_spacer1',
                'title' => esc_html__('Header Spacer 1 Width', 'lunfest'),
                'type' => 'dimensions',
                'required' => ['header_building_tool', '=', 'default'],
                'width' => true,
                'height' => false,
                'default' => ['width' => 40],
            ],
            [
                'id' => 'bottom_header_spacer2',
                'title' => esc_html__('Header Spacer 2 Width', 'lunfest'),
                'type' => 'dimensions',
                'required' => ['header_building_tool', '=', 'default'],
                'width' => true,
                'height' => false,
                'default' => ['width' => 40],
            ],
            [
                'id' => 'bottom_header_spacer3',
                'title' => esc_html__('Header Spacer 3 Width', 'lunfest'),
                'type' => 'dimensions',
                'required' => ['header_building_tool', '=', 'default'],
                'width' => true,
                'height' => false,
                'default' => ['width' => 25],
            ],
            [
                'id' => 'bottom_header_spacer4',
                'title' => esc_html__('Header Spacer 4 Width', 'lunfest'),
                'type' => 'dimensions',
                'required' => ['header_building_tool', '=', 'default'],
                'width' => true,
                'height' => false,
                'default' => ['width' => 25],
            ],
            [
                'id' => 'bottom_header_spacer5',
                'title' => esc_html__('Header Spacer 5 Width', 'lunfest'),
                'type' => 'dimensions',
                'required' => ['header_building_tool', '=', 'default'],
                'height' => false,
                'width' => true,
                'default' => ['width' => 25],
            ],
            [
                'id' => 'bottom_header_spacer6',
                'title' => esc_html__('Header Spacer 6 Width', 'lunfest'),
                'type' => 'dimensions',
                'required' => ['header_building_tool', '=', 'default'],
                'height' => false,
                'width' => true,
                'default' => ['width' => 25],
            ],
            [
                'id' => 'bottom_header_spacer7',
                'title' => esc_html__('Header Spacer 7 Width', 'lunfest'),
                'type' => 'dimensions',
                'required' => ['header_building_tool', '=', 'default'],
                'width' => true,
                'height' => false,
                'default' => ['width' => 25],
            ],
            [
                'id' => 'bottom_header_spacer8',
                'title' => esc_html__('Header Spacer 8 Width', 'lunfest'),
                'type' => 'dimensions',
                'required' => ['header_building_tool', '=', 'default'],
                'width' => true,
                'height' => false,
                'default' => ['width' => 25],
            ],
            [
                'id' => 'bottom_header_item_search_custom',
                'title' => esc_html__('Customize Search', 'lunfest'),
                'type' => 'switch',
                'required' => ['header_building_tool', '=', 'default'],
                'default' => false,
            ],
            [
                'id' => 'bottom_header_item_search_color_txt',
                'title' => esc_html__('Icon Color', 'lunfest'),
                'type' => 'color_rgba',
                'required' => ['bottom_header_item_search_custom', '=', '1'],
                'mode' => 'background',
                'default' => [
                    'alpha' => '1',
                    'rgba' => 'rgba(35,35,35,1)',
                    'color' => '#232323',
                ],
            ],
            [
                'id' => 'bottom_header_item_search_hover_color_txt',
                'title' => esc_html__('Hover Icon Color', 'lunfest'),
                'type' => 'color_rgba',
                'required' => ['bottom_header_item_search_custom', '=', '1'],
                'mode' => 'background',
                'default' => [
                    'alpha' => '1',
                    'rgba' => 'rgba(35,35,35,1)',
                    'color' => '#232323',
                ],
            ],
            [
                'id' => 'bottom_header_cart_custom',
                'title' => esc_html__('Customize cart', 'lunfest'),
                'type' => 'switch',
                'required' => ['header_building_tool', '=', 'default'],
                'default' => false,
            ],
            [
                'id' => 'bottom_header_cart_color_txt',
                'title' => esc_html__('Icon Color', 'lunfest'),
                'type' => 'color_rgba',
                'required' => ['bottom_header_cart_custom', '=', '1'],
                'mode' => 'background',
                'default' => [
                    'alpha' => '1',
                    'rgba' => 'rgba(35,35,35,1)',
                    'color' => '#232323',
                ],
            ],
            [
                'id' => 'bottom_header_cart_hover_color_txt',
                'title' => esc_html__('Hover Icon Color', 'lunfest'),
                'type' => 'color_rgba',
                'required' => ['bottom_header_cart_custom', '=', '1'],
                'mode' => 'background',
                'default' => [
                    'alpha' => '1',
                    'rgba' => 'rgba(35,35,35,1)',
                    'color' => '#232323',
                ],
            ],
            [
                'id' => 'bottom_header_delimiter1_height',
                'title' => esc_html__('Delimiter Height', 'lunfest'),
                'type' => 'dimensions',
                'required' => ['header_building_tool', '=', 'default'],
                'width' => false,
                'height' => true,
                'default' => ['height' => 50],
            ],
            [
                'id' => 'bottom_header_delimiter1_width',
                'title' => esc_html__('Delimiter Width', 'lunfest'),
                'type' => 'dimensions',
                'required' => ['header_building_tool', '=', 'default'],
                'width' => true,
                'height' => false,
                'default' => ['width' => 1],
            ],
            [
                'id' => 'bottom_header_delimiter1_bg',
                'title' => esc_html__('Delimiter Background', 'lunfest'),
                'type' => 'color_rgba',
                'required' => ['header_building_tool', '=', 'default'],
                'mode' => 'background',
                'default' => [
                    'color' => '#000000',
                    'alpha' => '0.1',
                    'rgba' => 'rgba(0, 0, 0, 0.1)'
                ],
            ],
            [
                'id' => 'bottom_header_delimiter1_margin',
                'title' => esc_html__('Delimiter Spacing', 'lunfest'),
                'type' => 'spacing',
                'required' => ['header_building_tool', '=', 'default'],
                'mode' => 'margin',
                'all' => false,
                'bottom' => false,
                'top' => false,
                'left' => true,
                'right' => true,
                'default' => [
                    'margin-left' => '20',
                    'margin-right' => '30',
                ],
            ],
            [
                'id' => 'bottom_header_delimiter2_height',
                'title' => esc_html__('Delimiter Height', 'lunfest'),
                'type' => 'dimensions',
                'required' => ['header_building_tool', '=', 'default'],
                'height' => true,
                'width' => false,
                'default' => ['height' => 100],
            ],
            [
                'id' => 'bottom_header_delimiter2_width',
                'title' => esc_html__('Delimiter Width', 'lunfest'),
                'type' => 'dimensions',
                'required' => ['header_building_tool', '=', 'default'],
                'height' => false,
                'width' => true,
                'default' => ['width' => 1],
            ],
            [
                'id' => 'bottom_header_delimiter2_bg',
                'title' => esc_html__('Delimiter Background', 'lunfest'),
                'type' => 'color_rgba',
                'required' => ['header_building_tool', '=', 'default'],
                'mode' => 'background',
                'default' => [
                    'color' => '#ffffff',
                    'alpha' => '.9',
                    'rgba' => 'rgba(255,255,255,0.9)'
                ],
            ],
            [
                'id' => 'bottom_header_delimiter2_margin',
                'title' => esc_html__('Delimiter Spacing', 'lunfest'),
                'type' => 'spacing',
                'required' => ['header_building_tool', '=', 'default'],
                'mode' => 'margin',
                'all' => false,
                'bottom' => false,
                'top' => false,
                'left' => true,
                'right' => true,
                'default' => [
                    'margin-left' => '30',
                    'margin-right' => '30',
                ],
            ],
            [
                'id' => 'bottom_header_delimiter3_height',
                'title' => esc_html__('Delimiter Height', 'lunfest'),
                'type' => 'dimensions',
                'required' => ['header_building_tool', '=', 'default'],
                'width' => false,
                'height' => true,
                'default' => ['height' => 100],
            ],
            [
                'id' => 'bottom_header_delimiter3_width',
                'title' => esc_html__('Delimiter Width', 'lunfest'),
                'type' => 'dimensions',
                'required' => ['header_building_tool', '=', 'default'],
                'width' => true,
                'height' => false,
                'default' => ['width' => 1],
            ],
            [
                'id' => 'bottom_header_delimiter3_bg',
                'title' => esc_html__('Delimiter Background', 'lunfest'),
                'type' => 'color_rgba',
                'required' => ['header_building_tool', '=', 'default'],
                'mode' => 'background',
                'default' => [
                    'color' => '#ffffff',
                    'alpha' => '.9',
                    'rgba' => 'rgba(255,255,255,0.9)'
                ],
            ],
            [
                'id' => 'bottom_header_delimiter3_margin',
                'title' => esc_html__('Delimiter Spacing', 'lunfest'),
                'type' => 'spacing',
                'required' => ['header_building_tool', '=', 'default'],
                'mode' => 'margin',
                'all' => false,
                'bottom' => false,
                'top' => false,
                'left' => true,
                'right' => true,
                'default' => [
                    'margin-left' => '30',
                    'margin-right' => '30',
                ],
            ],
            [
                'id' => 'bottom_header_delimiter4_height',
                'title' => esc_html__('Delimiter Height', 'lunfest'),
                'type' => 'dimensions',
                'required' => ['header_building_tool', '=', 'default'],
                'width' => false,
                'height' => true,
                'default' => ['height' => 100],
            ],
            [
                'id' => 'bottom_header_delimiter4_width',
                'title' => esc_html__('Delimiter Width', 'lunfest'),
                'type' => 'dimensions',
                'required' => ['header_building_tool', '=', 'default'],
                'height' => false,
                'width' => true,
                'default' => ['width' => 1],
            ],
            [
                'id' => 'bottom_header_delimiter4_bg',
                'title' => esc_html__('Delimiter Background', 'lunfest'),
                'type' => 'color_rgba',
                'required' => ['header_building_tool', '=', 'default'],
                'mode' => 'background',
                'default' => [
                    'color' => '#ffffff',
                    'alpha' => '.9',
                    'rgba' => 'rgba(255,255,255,0.9)'
                ],
            ],
            [
                'id' => 'bottom_header_delimiter4_margin',
                'title' => esc_html__('Delimiter Spacing', 'lunfest'),
                'type' => 'spacing',
                'required' => ['header_building_tool', '=', 'default'],
                'mode' => 'margin',
                'all' => false,
                'bottom' => false,
                'top' => false,
                'left' => true,
                'right' => true,
                'default' => [
                    'margin-left' => '30',
                    'margin-right' => '30',
                ],
            ],
            [
                'id' => 'bottom_header_delimiter5_height',
                'title' => esc_html__('Delimiter Height', 'lunfest'),
                'type' => 'dimensions',
                'required' => ['header_building_tool', '=', 'default'],
                'width' => false,
                'height' => true,
                'default' => ['height' => 100],
            ],
            [
                'id' => 'bottom_header_delimiter5_width',
                'title' => esc_html__('Delimiter Width', 'lunfest'),
                'type' => 'dimensions',
                'required' => ['header_building_tool', '=', 'default'],
                'height' => false,
                'width' => true,
                'default' => ['width' => 1],
            ],
            [
                'id' => 'bottom_header_delimiter5_bg',
                'title' => esc_html__('Delimiter Background', 'lunfest'),
                'type' => 'color_rgba',
                'required' => ['header_building_tool', '=', 'default'],
                'mode' => 'background',
                'default' => [
                    'color' => '#ffffff',
                    'alpha' => '.9',
                    'rgba' => 'rgba(255,255,255,0.9)'
                ],
            ],
            [
                'id' => 'bottom_header_delimiter5_margin',
                'title' => esc_html__('Delimiter Spacing', 'lunfest'),
                'type' => 'spacing',
                'required' => ['header_building_tool', '=', 'default'],
                'mode' => 'margin',
                'all' => false,
                'bottom' => false,
                'top' => false,
                'left' => true,
                'right' => true,
                'default' => [
                    'margin-left' => '30',
                    'margin-right' => '30',
                ],
            ],
            [
                'id' => 'bottom_header_delimiter6_height',
                'title' => esc_html__('Delimiter Height', 'lunfest'),
                'type' => 'dimensions',
                'required' => ['header_building_tool', '=', 'default'],
                'height' => true,
                'width' => false,
                'default' => ['height' => 100],
            ],
            [
                'id' => 'bottom_header_delimiter6_width',
                'title' => esc_html__('Delimiter Width', 'lunfest'),
                'type' => 'dimensions',
                'required' => ['header_building_tool', '=', 'default'],
                'width' => true,
                'height' => false,
                'default' => ['width' => 1],
            ],
            [
                'id' => 'bottom_header_delimiter6_bg',
                'title' => esc_html__('Delimiter Background', 'lunfest'),
                'type' => 'color_rgba',
                'required' => ['header_building_tool', '=', 'default'],
                'mode' => 'background',
                'default' => [
                    'color' => '#ffffff',
                    'alpha' => '.9',
                    'rgba' => 'rgba(255,255,255,0.9)'
                ],
            ],
            [
                'id' => 'bottom_header_delimiter6_margin',
                'title' => esc_html__('Delimiter Spacing', 'lunfest'),
                'type' => 'spacing',
                'required' => ['header_building_tool', '=', 'default'],
                'mode' => 'margin',
                'all' => false,
                'bottom' => false,
                'top' => false,
                'left' => true,
                'right' => true,
                'default' => [
                    'margin-left' => '30',
                    'margin-right' => '30',
                ],
            ],
            [
                'id' => 'bottom_header_button1_title',
                'title' => esc_html__('Button Text', 'lunfest'),
                'type' => 'text',
                'required' => ['header_building_tool', '=', 'default'],
                'default' => esc_html__('Contact Us', 'lunfest'),
            ],
            [
                'id' => 'bottom_header_button1_link',
                'title' => esc_html__('Link', 'lunfest'),
                'type' => 'text',
                'required' => ['header_building_tool', '=', 'default'],
                'default' => '#',
            ],
            [
                'id' => 'bottom_header_button1_target',
                'title' => esc_html__('Open link in a new tab', 'lunfest'),
                'type' => 'switch',
                'required' => ['header_building_tool', '=', 'default'],
                'default' => true,
            ],
            [
                'id' => 'bottom_header_button1_size',
                'title' => esc_html__('Button Size', 'lunfest'),
                'type' => 'select',
                'required' => ['header_building_tool', '=', 'default'],
                'options' => [
                    'sm' => esc_html__('Small', 'lunfest'),
                    'md' => esc_html__('Medium', 'lunfest'),
                    'lg' => esc_html__('Large', 'lunfest'),
                    'xl' => esc_html__('Extra Large', 'lunfest'),
                ],
                'default' => 'md',
            ],
            [
                'id' => 'bottom_header_button1_radius',
                'title' => esc_html__('Button Border Radius', 'lunfest'),
                'type' => 'text',
                'required' => ['header_building_tool', '=', 'default'],
                'desc' => esc_html__('Value in pixels.', 'lunfest'),
            ],
            [
                'id' => 'bottom_header_button1_custom',
                'title' => esc_html__('Customize Button', 'lunfest'),
                'type' => 'switch',
                'required' => ['header_building_tool', '=', 'default'],
                'default' => false,
            ],
            [
                'id' => 'bottom_header_button1_color_txt',
                'title' => esc_html__('Text Color Idle', 'lunfest'),
                'type' => 'color_rgba',
                'required' => ['bottom_header_button1_custom', '=', '1'],
                'mode' => 'background',
                'default' => [
                    'color' => '#ffffff',
                    'alpha' => '1',
                    'rgba' => 'rgba(255,255,255,1)'
                ],
            ],
            [
                'id' => 'bottom_header_button1_hover_color_txt',
                'title' => esc_html__('Text Color Hover', 'lunfest'),
                'type' => 'color_rgba',
                'required' => ['bottom_header_button1_custom', '=', '1'],
                'mode' => 'background',
                'default' => [
                    'color' => '#232323',
                    'alpha' => '1',
                    'rgba' => 'rgba(35,35,35,1)'
                ],
            ],
            [
                'id' => 'bottom_header_button1_bg',
                'title' => esc_html__('Background Color', 'lunfest'),
                'type' => 'color_rgba',
                'required' => ['bottom_header_button1_custom', '=', '1'],
                'mode' => 'background',
                'default' => [
                    'color' => '#232323',
                    'alpha' => '1',
                    'rgba' => 'rgba(35,35,35,1)'
                ],
            ],
            [
                'id' => 'bottom_header_button1_hover_bg',
                'title' => esc_html__('Hover Background Color', 'lunfest'),
                'type' => 'color_rgba',
                'required' => ['bottom_header_button1_custom', '=', '1'],
                'mode' => 'background',
                'default' => [
                    'color' => '#ffffff',
                    'alpha' => '1',
                    'rgba' => 'rgba(255,255,255,1)'
                ],
            ],
            [
                'id' => 'bottom_header_button1_border',
                'title' => esc_html__('Border Color', 'lunfest'),
                'type' => 'color_rgba',
                'required' => ['bottom_header_button1_custom', '=', '1'],
                'mode' => 'background',
                'default' => [
                    'color' => '#232323',
                    'alpha' => '1',
                    'rgba' => 'rgba(35,35,35,1)'
                ],
            ],
            [
                'id' => 'bottom_header_button1_hover_border',
                'title' => esc_html__('Hover Border Color', 'lunfest'),
                'type' => 'color_rgba',
                'required' => ['bottom_header_button1_custom', '=', '1'],
                'mode' => 'background',
                'default' => [
                    'color' => '#232323',
                    'alpha' => '1',
                    'rgba' => 'rgba(35,35,35,1)'
                ],
            ],
            [
                'id' => 'bottom_header_button2_title',
                'title' => esc_html__('Button Text', 'lunfest'),
                'type' => 'text',
                'required' => ['header_building_tool', '=', 'default'],
                'default' => esc_html__('Contact Us', 'lunfest'),
            ],
            [
                'id' => 'bottom_header_button2_link',
                'title' => esc_html__('Link', 'lunfest'),
                'type' => 'text',
                'required' => ['header_building_tool', '=', 'default'],
            ],
            [
                'id' => 'bottom_header_button2_target',
                'title' => esc_html__('Open link in a new tab', 'lunfest'),
                'type' => 'switch',
                'required' => ['header_building_tool', '=', 'default'],
                'default' => true,
            ],
            [
                'id' => 'bottom_header_button2_size',
                'title' => esc_html__('Button Size', 'lunfest'),
                'type' => 'select',
                'required' => ['header_building_tool', '=', 'default'],
                'options' => [
                    'sm' => esc_html__('Small', 'lunfest'),
                    'md' => esc_html__('Medium', 'lunfest'),
                    'lg' => esc_html__('Large', 'lunfest'),
                    'xl' => esc_html__('Extra Large', 'lunfest'),
                ],
                'default' => 'md',
            ],
            [
                'id' => 'bottom_header_button2_radius',
                'title' => esc_html__('Button Border Radius', 'lunfest'),
                'type' => 'text',
                'required' => ['header_building_tool', '=', 'default'],
                'desc' => esc_html__('Value in pixels.', 'lunfest'),
            ],
            [
                'id' => 'bottom_header_button2_custom',
                'title' => esc_html__('Customize Button', 'lunfest'),
                'type' => 'switch',
                'required' => ['header_building_tool', '=', 'default'],
                'default' => false,
            ],
            [
                'id' => 'bottom_header_button2_color_txt',
                'title' => esc_html__('Text Color Idle', 'lunfest'),
                'type' => 'color_rgba',
                'required' => ['bottom_header_button2_custom', '=', '1'],
                'mode' => 'background',
                'default' => [
                    'alpha' => '1',
                    'rgba' => 'rgba(255,255,255,1)',
                    'color' => '#ffffff',
                ],
            ],
            [
                'id' => 'bottom_header_button2_hover_color_txt',
                'title' => esc_html__('Text Color Hover', 'lunfest'),
                'type' => 'color_rgba',
                'required' => ['bottom_header_button2_custom', '=', '1'],
                'mode' => 'background',
                'default' => [
                    'alpha' => '1',
                    'rgba' => 'rgba(35,35,35,1)',
                    'color' => '#232323',
                ],
            ],
            [
                'id' => 'bottom_header_button2_bg',
                'title' => esc_html__('Background Color', 'lunfest'),
                'type' => 'color_rgba',
                'required' => ['bottom_header_button2_custom', '=', '1'],
                'mode' => 'background',
                'default' => [
                    'alpha' => '1',
                    'rgba' => 'rgba(35,35,35,1)',
                    'color' => '#232323',
                ],
            ],
            [
                'id' => 'bottom_header_button2_hover_bg',
                'title' => esc_html__('Hover Background Color', 'lunfest'),
                'type' => 'color_rgba',
                'required' => ['bottom_header_button2_custom', '=', '1'],
                'mode' => 'background',
                'default' => [
                    'alpha' => '1',
                    'rgba' => 'rgba(255,255,255,1)',
                    'color' => '#ffffff',
                ],
            ],
            [
                'id' => 'bottom_header_button2_border',
                'title' => esc_html__('Border Color', 'lunfest'),
                'type' => 'color_rgba',
                'required' => ['bottom_header_button2_custom', '=', '1'],
                'mode' => 'background',
                'default' => [
                    'alpha' => '1',
                    'rgba' => 'rgba(35,35,35,1)',
                    'color' => '#232323',
                ],
            ],
            [
                'id' => 'bottom_header_button2_hover_border',
                'title' => esc_html__('Hover Border Color', 'lunfest'),
                'type' => 'color_rgba',
                'required' => ['bottom_header_button2_custom', '=', '1'],
                'mode' => 'background',
                'default' => [
                    'alpha' => '1',
                    'rgba' => 'rgba(35,35,35,1)',
                    'color' => '#232323',
                ],
            ],
            [
                'id' => 'bottom_header_bar_html1_editor',
                'title' => esc_html__('HTML Element 1 Editor', 'lunfest'),
                'type' => 'ace_editor',
                'required' => ['header_building_tool', '=', 'default'],
                'mode' => 'html',
            ],
            [
                'id' => 'bottom_header_bar_html2_editor',
                'title' => esc_html__('HTML Element 2 Editor', 'lunfest'),
                'type' => 'ace_editor',
                'required' => ['header_building_tool', '=', 'default'],
                'mode' => 'html',
            ],
            [
                'id' => 'bottom_header_bar_html3_editor',
                'title' => esc_html__('HTML Element 3 Editor', 'lunfest'),
                'type' => 'ace_editor',
                'required' => ['header_building_tool', '=', 'default'],
                'mode' => 'html',
            ],
            [
                'id' => 'bottom_header_bar_html4_editor',
                'title' => esc_html__('HTML Element 4 Editor', 'lunfest'),
                'type' => 'ace_editor',
                'required' => ['header_building_tool', '=', 'default'],
                'mode' => 'html',
            ],
            [
                'id' => 'bottom_header_bar_html5_editor',
                'title' => esc_html__('HTML Element 5 Editor', 'lunfest'),
                'type' => 'ace_editor',
                'required' => ['header_building_tool', '=', 'default'],
                'mode' => 'html',
            ],
            [
                'id' => 'bottom_header_bar_html6_editor',
                'title' => esc_html__('HTML Element 6 Editor', 'lunfest'),
                'type' => 'ace_editor',
                'required' => ['header_building_tool', '=', 'default'],
                'mode' => 'html',
            ],
            [
                'id' => 'bottom_header_bar_html7_editor',
                'title' => esc_html__('HTML Element 7 Editor', 'lunfest'),
                'type' => 'ace_editor',
                'required' => ['header_building_tool', '=', 'default'],
                'mode' => 'html',
            ],
            [
                'id' => 'bottom_header_bar_html8_editor',
                'title' => esc_html__('HTML Element 8 Editor', 'lunfest'),
                'type' => 'ace_editor',
                'required' => ['header_building_tool', '=', 'default'],
                'mode' => 'html',
            ],
            [
                'id' => 'bottom_header_side_panel_color',
                'title' => esc_html__('Icon Color', 'lunfest'),
                'type' => 'color_rgba',
                'required' => ['header_building_tool', '=', 'default'],
                'mode' => 'background',
                'default' => [
                    'alpha' => '1',
                    'rgba' => 'rgba(38,38,38,1)',
                    'color' => '#252525',
                ],
            ],
            [
                'id' => 'bottom_header_side_panel_background',
                'title' => esc_html__('Background Icon', 'lunfest'),
                'type' => 'color_rgba',
                'required' => ['header_building_tool', '=', 'default'],
                'mode' => 'background',
                'default' => [
                    'alpha' => '0',
                    'rgba' => 'rgba(255,255,255,0)',
                    'color' => '#ffffff',
                ],
            ],
            [
                'id' => 'header_top-start',
                'title' => esc_html__('Header Top Options', 'lunfest'),
                'type' => 'section',
                'required' => ['header_building_tool', '=', 'default'],
                'indent' => true,
            ],
            [
                'id' => 'header_top_full_width',
                'title' => esc_html__('Full Width Header', 'lunfest'),
                'type' => 'switch',
                'subtitle' => esc_html__('Set header content in full width', 'lunfest'),
                'default' => false,
            ],
            [
                'id' => 'header_top_max_width_custom',
                'title' => esc_html__('Limit the Max Width of Container', 'lunfest'),
                'type' => 'switch',
                'default' => false,
            ],
            [
                'id' => 'header_top_max_width',
                'title' => esc_html__('Max Width', 'lunfest'),
                'type' => 'dimensions',
                'required' => ['header_top_max_width_custom', '=', '1'],
                'width' => true,
                'height' => false,
                'default' => ['width' => 1290],
            ],
            [
                'id' => 'header_top_height',
                'title' => esc_html__('Header Top Height', 'lunfest'),
                'type' => 'dimensions',
                'width' => false,
                'height' => true,
                'default' => ['height' => 49],
            ],
            [
                'id' => 'header_top_background_image',
                'title' => esc_html__('Header Top Background Image', 'lunfest'),
                'type' => 'media',
            ],
            [
                'id' => 'header_top_background',
                'title' => esc_html__('Header Top Background', 'lunfest'),
                'type' => 'color_rgba',
                'mode' => 'background',
                'default' => [
                    'alpha' => '1',
                    'rgba' => 'rgba(255,255,255,1)',
                    'color' => '#ffffff',
                ],
            ],
            [
                'id' => 'header_top_color',
                'title' => esc_html__('Header Top Text Color', 'lunfest'),
                'type' => 'color',
                'transparent' => false,
                'default' => '#a2a2a2',
            ],
            [
                'id' => 'header_top_bottom_border',
                'type' => 'switch',
                'title' => esc_html__('Set Header Top Bottom Border', 'lunfest'),
                'default' => true,
            ],
            [
                'id' => 'header_top_border_height',
                'title' => esc_html__('Header Top Border Width', 'lunfest'),
                'type' => 'dimensions',
                'required' => ['header_top_bottom_border', '=', '1'],
                'width' => false,
                'height' => true,
                'default' => ['height' => '1'],
            ],
            [
                'id' => 'header_top_bottom_border_color',
                'title' => esc_html__('Header Top Border Color', 'lunfest'),
                'type' => 'color_rgba',
                'required' => ['header_top_bottom_border', '=', '1'],
                'mode' => 'background',
                'default' => [
                    'alpha' => '.2',
                    'rgba' => 'rgba(162,162,162,0.2)',
                    'color' => '#a2a2a2',
                ],
            ],
            [
                'id' => 'header_top-end',
                'type' => 'section',
                'indent' => false,
            ],
            [
                'id' => 'header_middle-start',
                'title' => esc_html__('Header Middle Options', 'lunfest'),
                'type' => 'section',
                'required' => ['header_building_tool', '=', 'default'],
                'indent' => true,
            ],
            [
                'id' => 'header_middle_full_width',
                'type' => 'switch',
                'title' => esc_html__('Full Width Middle Header', 'lunfest'),
                'subtitle' => esc_html__('Set header content in full width', 'lunfest'),
	            'default' => true,
            ],
            [
                'id' => 'header_middle_max_width_custom',
                'title' => esc_html__('Limit the Max Width of Container', 'lunfest'),
                'type' => 'switch',
                'default' => false,
            ],
            [
                'id' => 'header_middle_max_width',
                'title' => esc_html__('Max Width', 'lunfest'),
                'type' => 'dimensions',
                'required' => ['header_middle_max_width_custom', '=', '1'],
                'width' => true,
                'height' => false,
                'default' => ['width' => 1290],
            ],
            [
                'id' => 'header_middle_height',
                'title' => esc_html__('Header Middle Height', 'lunfest'),
                'type' => 'dimensions',
                'width' => false,
                'height' => true,
                'default' => ['height' => 100],
            ],
            [
                'id' => 'header_middle_background_image',
                'title' => esc_html__('Header Middle Background Image', 'lunfest'),
                'type' => 'media',
            ],
            [
                'id' => 'header_middle_background',
                'title' => esc_html__('Header Middle Background', 'lunfest'),
                'type' => 'color_rgba',
                'mode' => 'background',
                'default' => [
                    'alpha' => '1',
                    'rgba' => 'rgba(255,255,255,1)',
                    'color' => '#ffffff',
                ],
            ],
            [
                'id' => 'header_middle_color',
                'title' => esc_html__('Header Middle Text Color', 'lunfest'),
                'type' => 'color',
                'transparent' => false,
                'default' => '#252525',
            ],
            [
                'id' => 'header_middle_bottom_border',
                'title' => esc_html__('Set Header Middle Bottom Border', 'lunfest'),
                'type' => 'switch',
                'default' => false,
            ],
            [
                'id' => 'header_middle_border_height',
                'title' => esc_html__('Header Middle Border Width', 'lunfest'),
                'type' => 'dimensions',
                'required' => ['header_middle_bottom_border', '=', '1'],
                'height' => true,
                'width' => false,
                'default' => ['height' => '1'],
            ],
            [
                'id' => 'header_middle_bottom_border_color',
                'title' => esc_html__('Header Middle Border Color', 'lunfest'),
                'type' => 'color_rgba',
                'required' => ['header_middle_bottom_border', '=', '1'],
                'mode' => 'background',
                'default' => [
                    'alpha' => '1',
                    'rgba' => 'rgba(245,245,245,1)',
                    'color' => '#f5f5f5',
                ],
            ],
            [
                'id' => 'header_middle-end',
                'type' => 'section',
                'indent' => false,
            ],
            [
                'id' => 'header_bottom-start',
                'title' => esc_html__('Header Bottom Options', 'lunfest'),
                'type' => 'section',
                'required' => ['header_building_tool', '=', 'default'],
                'indent' => true,
            ],
            [
                'id' => 'header_bottom_full_width',
                'title' => esc_html__('Full Width Bottom Header', 'lunfest'),
                'type' => 'switch',
                'subtitle' => esc_html__('Set header content in full width', 'lunfest'),
                'default' => false,
            ],
            [
                'id' => 'header_bottom_max_width_custom',
                'title' => esc_html__('Limit the Max Width of Container', 'lunfest'),
                'type' => 'switch',
                'default' => false,
            ],
            [
                'id' => 'header_bottom_max_width',
                'title' => esc_html__('Max Width', 'lunfest'),
                'type' => 'dimensions',
                'required' => ['header_bottom_max_width_custom', '=', '1'],
                'width' => true,
                'height' => false,
                'default' => ['width' => 1290],
            ],
            [
                'id' => 'header_bottom_height',
                'title' => esc_html__('Header Bottom Height', 'lunfest'),
                'type' => 'dimensions',
                'width' => false,
                'height' => true,
                'default' => ['height' => 100],
            ],
            [
                'id' => 'header_bottom_background_image',
                'title' => esc_html__('Header Bottom Background Image', 'lunfest'),
                'type' => 'media',
            ],
            [
                'id' => 'header_bottom_background',
                'title' => esc_html__('Header Bottom Background', 'lunfest'),
                'type' => 'color_rgba',
                'mode' => 'background',
                'default' => [
                    'color' => '#ffffff',
                    'alpha' => '.9',
                    'rgba' => 'rgba(255,255,255,0.9)'
                ],
            ],
            [
                'id' => 'header_bottom_color',
                'title' => esc_html__('Header Bottom Text Color', 'lunfest'),
                'type' => 'color',
                'transparent' => false,
                'default' => '#fefefe',
            ],
            [
                'id' => 'header_bottom_bottom_border',
                'title' => esc_html__('Set Header Bottom Border', 'lunfest'),
                'type' => 'switch',
                'default' => true,
            ],
            [
                'id' => 'header_bottom_border_height',
                'title' => esc_html__('Header Bottom Border Width', 'lunfest'),
                'type' => 'dimensions',
                'required' => ['header_bottom_bottom_border', '=', '1'],
                'width' => false,
                'height' => true,
                'default' => ['height' => '1'],
            ],
            [
                'id' => 'header_bottom_bottom_border_color',
                'title' => esc_html__('Header Bottom Border Color', 'lunfest'),
                'type' => 'color_rgba',
                'required' => ['header_bottom_bottom_border', '=', '1'],
                'mode' => 'background',
                'default' => [
                    'color' => '#ffffff',
                    'alpha' => '1',
                    'rgba' => 'rgba(255,255,255,0.2)'
                ],
            ],
            [
                'id' => 'header_bottom-end',
                'type' => 'section',
                'indent' => false,
            ],
            [
                'id' => 'header_column-top-left-start',
                'title' => esc_html__('Top Left Column Options', 'lunfest'),
                'type' => 'section',
                'required' => ['header_building_tool', '=', 'default'],
                'indent' => true,
            ],
            [
                'id' => 'header_column_top_left_horz',
                'type' => 'button_set',
                'title' => esc_html__('Horizontal Align', 'lunfest'),
                'options' => [
                    'left' => esc_html__('Left', 'lunfest'),
                    'center' => esc_html__('Center', 'lunfest'),
                    'right' => esc_html__('Right', 'lunfest'),
                ],
                'default' => 'left'
            ],
            [
                'id' => 'header_column_top_left_vert',
                'type' => 'button_set',
                'title' => esc_html__('Vertical Align', 'lunfest'),
                'options' => [
                    'top' => esc_html__('Top', 'lunfest'),
                    'middle' => esc_html__('Middle', 'lunfest'),
                    'bottom' => esc_html__('Bottom', 'lunfest'),
                ],
                'default' => 'middle'
            ],
            [
                'id' => 'header_column_top_left_display',
                'type' => 'button_set',
                'title' => esc_html__('Display', 'lunfest'),
                'options' => [
                    'normal' => esc_html__('Normal', 'lunfest'),
                    'grow' => esc_html__('Grow', 'lunfest'),
                ],
                'default' => 'normal'
            ],
            [
                'id' => 'header_column-top-left-end',
                'type' => 'section',
                'indent' => false,
            ],
            [
                'id' => 'header_column-top-center-start',
                'title' => esc_html__('Top Center Column Options', 'lunfest'),
                'type' => 'section',
                'required' => ['header_building_tool', '=', 'default'],
                'indent' => true,
            ],
            [
                'id' => 'header_column_top_center_horz',
                'title' => esc_html__('Horizontal Align', 'lunfest'),
                'type' => 'button_set',
                'options' => [
                    'left' => esc_html__('Left', 'lunfest'),
                    'center' => esc_html__('Center', 'lunfest'),
                    'right' => esc_html__('Right', 'lunfest'),
                ],
                'default' => 'left'
            ],
            [
                'id' => 'header_column_top_center_vert',
                'title' => esc_html__('Vertical Align', 'lunfest'),
                'type' => 'button_set',
                'options' => [
                    'top' => esc_html__('Top', 'lunfest'),
                    'middle' => esc_html__('Middle', 'lunfest'),
                    'bottom' => esc_html__('Bottom', 'lunfest'),
                ],
                'default' => 'middle'
            ],
            [
                'id' => 'header_column_top_center_display',
                'title' => esc_html__('Display', 'lunfest'),
                'type' => 'button_set',
                'options' => [
                    'normal' => esc_html__('Normal', 'lunfest'),
                    'grow' => esc_html__('Grow', 'lunfest'),
                ],
                'default' => 'normal'
            ],
            [
                'id' => 'header_column-top-center-end',
                'type' => 'section',
                'indent' => false,
            ],
            [
                'id' => 'header_column-top-center-start',
                'title' => esc_html__('Top Center Column Options', 'lunfest'),
                'type' => 'section',
                'required' => ['header_building_tool', '=', 'default'],
                'indent' => true,
            ],
            [
                'id' => 'header_column_top_center_horz',
                'title' => esc_html__('Horizontal Align', 'lunfest'),
                'type' => 'button_set',
                'options' => [
                    'left' => esc_html__('Left', 'lunfest'),
                    'center' => esc_html__('Center', 'lunfest'),
                    'right' => esc_html__('Right', 'lunfest'),
                ],
                'default' => 'left'
            ],
            [
                'id' => 'header_column_top_center_vert',
                'title' => esc_html__('Vertical Align', 'lunfest'),
                'type' => 'button_set',
                'options' => [
                    'top' => esc_html__('Top', 'lunfest'),
                    'middle' => esc_html__('Middle', 'lunfest'),
                    'bottom' => esc_html__('Bottom', 'lunfest'),
                ],
                'default' => 'middle'
            ],
            [
                'id' => 'header_column_top_center_display',
                'title' => esc_html__('Display', 'lunfest'),
                'type' => 'button_set',
                'options' => [
                    'normal' => esc_html__('Normal', 'lunfest'),
                    'grow' => esc_html__('Grow', 'lunfest'),
                ],
                'default' => 'normal'
            ],
            [
                'id' => 'header_column-top-center-end',
                'type' => 'section',
                'indent' => false,
            ],
            [
                'id' => 'header_column-top-right-start',
                'title' => esc_html__('Top Right Column Options', 'lunfest'),
                'type' => 'section',
                'required' => ['header_building_tool', '=', 'default'],
                'indent' => true,
            ],
            [
                'id' => 'header_column_top_right_horz',
                'title' => esc_html__('Horizontal Align', 'lunfest'),
                'type' => 'button_set',
                'options' => [
                    'left' => esc_html__('Left', 'lunfest'),
                    'center' => esc_html__('Center', 'lunfest'),
                    'right' => esc_html__('Right', 'lunfest'),
                ],
                'default' => 'right'
            ],
            [
                'id' => 'header_column_top_right_vert',
                'title' => esc_html__('Vertical Align', 'lunfest'),
                'type' => 'button_set',
                'options' => [
                    'top' => esc_html__('Top', 'lunfest'),
                    'middle' => esc_html__('Middle', 'lunfest'),
                    'bottom' => esc_html__('Bottom', 'lunfest'),
                ],
                'default' => 'middle'
            ],
            [
                'id' => 'header_column_top_right_display',
                'title' => esc_html__('Display', 'lunfest'),
                'type' => 'button_set',
                'options' => [
                    'normal' => esc_html__('Normal', 'lunfest'),
                    'grow' => esc_html__('Grow', 'lunfest'),
                ],
                'default' => 'normal'
            ],
            [
                'id' => 'header_column-top-right-end',
                'type' => 'section',
                'indent' => false,
            ],
            [
                'id' => 'header_column-middle-left-start',
                'title' => esc_html__('Middle Left Column Options', 'lunfest'),
                'type' => 'section',
                'required' => ['header_building_tool', '=', 'default'],
                'indent' => true,
            ],
            [
                'id' => 'header_column_middle_left_horz',
                'title' => esc_html__('Horizontal Align', 'lunfest'),
                'type' => 'button_set',
                'options' => [
                    'left' => esc_html__('Left', 'lunfest'),
                    'center' => esc_html__('Center', 'lunfest'),
                    'right' => esc_html__('Right', 'lunfest'),
                ],
                'default' => 'left'
            ],
            [
                'id' => 'header_column_middle_left_vert',
                'title' => esc_html__('Vertical Align', 'lunfest'),
                'type' => 'button_set',
                'options' => [
                    'top' => esc_html__('Top', 'lunfest'),
                    'middle' => esc_html__('Middle', 'lunfest'),
                    'bottom' => esc_html__('Bottom', 'lunfest'),
                ],
                'default' => 'middle'
            ],
            [
                'id' => 'header_column_middle_left_display',
                'title' => esc_html__('Display', 'lunfest'),
                'type' => 'button_set',
                'options' => [
                    'normal' => esc_html__('Normal', 'lunfest'),
                    'grow' => esc_html__('Grow', 'lunfest'),
                ],
                'default' => 'normal'
            ],
            [
                'id' => 'header_column-middle-left-end',
                'type' => 'section',
                'indent' => false,
            ],
            [
                'id' => 'header_column-middle-center-start',
                'title' => esc_html__('Middle Center Column Options', 'lunfest'),
                'type' => 'section',
                'required' => ['header_building_tool', '=', 'default'],
                'indent' => true,
            ],
            [
                'id' => 'header_column_middle_center_horz',
                'type' => 'button_set',
                'title' => esc_html__('Horizontal Align', 'lunfest'),
                'options' => [
                    'left' => esc_html__('Left', 'lunfest'),
                    'center' => esc_html__('Center', 'lunfest'),
                    'right' => esc_html__('Right', 'lunfest'),
                ],
                'default' => 'center',
            ],
            [
                'id' => 'header_column_middle_center_vert',
                'type' => 'button_set',
                'title' => esc_html__('Vertical Align', 'lunfest'),
                'options' => [
                    'top' => esc_html__('Top', 'lunfest'),
                    'middle' => esc_html__('Middle', 'lunfest'),
                    'bottom' => esc_html__('Bottom', 'lunfest'),
                ],
                'default' => 'middle'
            ],
            [
                'id' => 'header_column_middle_center_display',
                'title' => esc_html__('Display', 'lunfest'),
                'type' => 'button_set',
                'options' => [
                    'normal' => esc_html__('Normal', 'lunfest'),
                    'grow' => esc_html__('Grow', 'lunfest'),
                ],
                'default' => 'normal'
            ],
            [
                'id' => 'header_column-middle-center-end',
                'type' => 'section',
                'indent' => false,
            ],
            [
                'id' => 'header_column-middle-right-start',
                'title' => esc_html__('Middle Right Column Options', 'lunfest'),
                'type' => 'section',
                'required' => ['header_building_tool', '=', 'default'],
                'indent' => true,
            ],
            [
                'id' => 'header_column_middle_right_horz',
                'title' => esc_html__('Horizontal Align', 'lunfest'),
                'type' => 'button_set',
                'options' => [
                    'left' => esc_html__('Left', 'lunfest'),
                    'center' => esc_html__('Center', 'lunfest'),
                    'right' => esc_html__('Right', 'lunfest'),
                ],
                'default' => 'right',
            ],
            [
                'id' => 'header_column_middle_right_vert',
                'title' => esc_html__('Vertical Align', 'lunfest'),
                'type' => 'button_set',
                'options' => [
                    'top' => esc_html__('Top', 'lunfest'),
                    'middle' => esc_html__('Middle', 'lunfest'),
                    'bottom' => esc_html__('Bottom', 'lunfest'),
                ],
                'default' => 'middle',
            ],
            [
                'id' => 'header_column_middle_right_display',
                'type' => 'button_set',
                'title' => esc_html__('Display', 'lunfest'),
                'options' => [
                    'normal' => esc_html__('Normal', 'lunfest'),
                    'grow' => esc_html__('Grow', 'lunfest'),
                ],
                'default' => 'normal',
            ],
            [
                'id' => 'header_column-middle-right-end',
                'type' => 'section',
                'indent' => false,
            ],
            [
                'id' => 'header_column-bottom-left-start',
                'title' => esc_html__('Bottom Left Column Options', 'lunfest'),
                'type' => 'section',
                'required' => ['header_building_tool', '=', 'default'],
                'indent' => true,
            ],
            [
                'id' => 'header_column_bottom_left_horz',
                'title' => esc_html__('Horizontal Align', 'lunfest'),
                'type' => 'button_set',
                'options' => [
                    'left' => esc_html__('Left', 'lunfest'),
                    'center' => esc_html__('Center', 'lunfest'),
                    'right' => esc_html__('Right', 'lunfest'),
                ],
                'default' => 'left'
            ],
            [
                'id' => 'header_column_bottom_left_vert',
                'title' => esc_html__('Vertical Align', 'lunfest'),
                'type' => 'button_set',
                'options' => [
                    'top' => esc_html__('Top', 'lunfest'),
                    'middle' => esc_html__('Middle', 'lunfest'),
                    'bottom' => esc_html__('Bottom', 'lunfest'),
                ],
                'default' => 'middle'
            ],
            [
                'id' => 'header_column_bottom_left_display',
                'title' => esc_html__('Display', 'lunfest'),
                'type' => 'button_set',
                'options' => [
                    'normal' => esc_html__('Normal', 'lunfest'),
                    'grow' => esc_html__('Grow', 'lunfest'),
                ],
                'default' => 'normal'
            ],
            [
                'id' => 'header_column-bottom-left-end',
                'type' => 'section',
                'indent' => false,
            ],
            [
                'id' => 'header_column-bottom-center-start',
                'type' => 'section',
                'title' => esc_html__('Bottom Center Column Options', 'lunfest'),
                'indent' => true,
                'required' => ['header_building_tool', '=', 'default'],
            ],
            [
                'id' => 'header_column_bottom_center_horz',
                'title' => esc_html__('Horizontal Align', 'lunfest'),
                'type' => 'button_set',
                'options' => [
                    'left' => esc_html__('Left', 'lunfest'),
                    'center' => esc_html__('Center', 'lunfest'),
                    'right' => esc_html__('Right', 'lunfest'),
                ],
                'default' => 'left'
            ],
            [
                'id' => 'header_column_bottom_center_vert',
                'title' => esc_html__('Vertical Align', 'lunfest'),
                'type' => 'button_set',
                'options' => [
                    'top' => esc_html__('Top', 'lunfest'),
                    'middle' => esc_html__('Middle', 'lunfest'),
                    'bottom' => esc_html__('Bottom', 'lunfest'),
                ],
                'default' => 'middle'
            ],
            [
                'id' => 'header_column_bottom_center_display',
                'type' => 'button_set',
                'title' => esc_html__('Display', 'lunfest'),
                'options' => [
                    'normal' => esc_html__('Normal', 'lunfest'),
                    'grow' => esc_html__('Grow', 'lunfest'),
                ],
                'default' => 'normal'
            ],
            [
                'id' => 'header_column-bottom-center-end',
                'type' => 'section',
                'indent' => false,
            ],
            [
                'id' => 'header_column-bottom-right-start',
                'title' => esc_html__('Bottom Right Column Options', 'lunfest'),
                'type' => 'section',
                'required' => ['header_building_tool', '=', 'default'],
                'indent' => true,
            ],
            [
                'id' => 'header_column_bottom_right_horz',
                'title' => esc_html__('Horizontal Align', 'lunfest'),
                'type' => 'button_set',
                'options' => [
                    'left' => esc_html__('Left', 'lunfest'),
                    'center' => esc_html__('Center', 'lunfest'),
                    'right' => esc_html__('Right', 'lunfest'),
                ],
                'default' => 'right'
            ],
            [
                'id' => 'header_column_bottom_right_vert',
                'title' => esc_html__('Vertical Align', 'lunfest'),
                'type' => 'button_set',
                'options' => [
                    'top' => esc_html__('Top', 'lunfest'),
                    'middle' => esc_html__('Middle', 'lunfest'),
                    'bottom' => esc_html__('Bottom', 'lunfest'),
                ],
                'default' => 'middle'
            ],
            [
                'id' => 'header_column_bottom_right_display',
                'title' => esc_html__('Display', 'lunfest'),
                'type' => 'button_set',
                'options' => [
                    'normal' => esc_html__('Normal', 'lunfest'),
                    'grow' => esc_html__('Grow', 'lunfest'),
                ],
                'default' => 'normal'
            ],
            [
                'id' => 'header_column-bottom-right-end',
                'type' => 'section',
                'indent' => false,
            ],
            [
                'id' => 'header_row_settings-start',
                'title' => esc_html__('Header Settings', 'lunfest'),
                'type' => 'section',
                'required' => ['header_building_tool', '=', 'default'],
                'indent' => true,
            ],
            [
                'id' => 'header_shadow',
                'title' => esc_html__('Header Bottom Shadow', 'lunfest'),
                'type' => 'switch',
                'default' => false,
            ],
            [
                'id' => 'header_on_bg',
                'title' => esc_html__('Over content', 'lunfest'),
                'type' => 'switch',
                'subtitle' => esc_html__('Display header template over the content.', 'lunfest'),
                'on' => esc_html__('Yes', 'lunfest'),
                'off' => esc_html__('No', 'lunfest'),
                'default' => false,
            ],
            [
                'id' => 'lavalamp_active',
                'type' => 'switch',
                'title' => esc_html__('Lavalamp Marker', 'lunfest'),
                'on' => esc_html__('Use', 'lunfest'),
                'off' => esc_html__('Hide', 'lunfest'),
                'default' => false,
            ],
            [
                'id' => 'sub_menu_background',
                'type' => 'color_rgba',
                'title' => esc_html__('Sub Menu Background', 'lunfest'),
                'mode' => 'background',
                'default' => [
                    'alpha' => '1',
                    'rgba' => 'rgba(22,26,29,1)',
                    'color' => '#161a1d',
                ],
            ],
            [
                'id' => 'sub_menu_color',
                'title' => esc_html__('Sub Menu Text Color', 'lunfest'),
                'type' => 'color',
                'transparent' => false,
                'default' => '#ffffff',
            ],
            [
                'id' => 'header_sub_menu_bottom_border',
                'title' => esc_html__('Sub Menu Bottom Border', 'lunfest'),
                'type' => 'switch',
                'default' => false,
            ],
            [
                'id' => 'header_sub_menu_border_height',
                'title' => esc_html__('Sub Menu Border Width', 'lunfest'),
                'type' => 'dimensions',
                'required' => ['header_sub_menu_bottom_border', '=', '1'],
                'width' => false,
                'height' => true,
                'default' => ['height' => '1'],
            ],
            [
                'id' => 'header_sub_menu_bottom_border_color',
                'title' => esc_html__('Sub Menu Border Color', 'lunfest'),
                'type' => 'color_rgba',
                'required' => ['header_sub_menu_bottom_border', '=', '1'],
                'mode' => 'background',
                'default' => [
                    'alpha' => '1',
                    'rgba' => 'rgba(0, 0, 0, 0.08)',
                    'color' => '#ffffff',
                ],
            ],
            [
                'id' => 'header_mobile_queris',
                'title' => esc_html__('Mobile Header Switch Breakpoint', 'lunfest'),
                'type' => 'slider',
                'display_value' => 'text',
                'min' => 400,
                'max' => 1920,
                'default' => 1200,
            ],
            [
                'id' => 'header_row_settings-end',
                'type' => 'section',
                'indent' => false,
            ],
        ]
    ]
);

Redux::set_section(
    $theme_slug,
    [
        'title' => esc_html__('Header Sticky', 'lunfest'),
        'id' => 'header_builder_sticky',
        'subsection' => true,
        'fields' => [
            [
                'id' => 'header_sticky',
                'title' => esc_html__('Header Sticky', 'lunfest'),
                'type' => 'switch',
                'default' => true,
            ],
            [
                'id' => 'header_sticky-start',
                'title' => esc_html__('Sticky Settings', 'lunfest'),
                'type' => 'section',
                'required' => ['header_sticky', '=', '1'],
                'indent' => true,
            ],
            [
                'id' => 'header_sticky_page_select',
                'title' => esc_html__('Header Sticky Template', 'lunfest'),
                'type' => 'select',
                'required' => ['header_sticky', '=', '1'],
                'desc' => sprintf(
                    '%s <a href="%s" target="_blank">%s</a> %s',
                    esc_html__('Selected Template will be used for all pages by default. You can edit/create Header Template in the', 'lunfest'),
                    admin_url('edit.php?post_type=header'),
                    esc_html__('Header Templates', 'lunfest'),
                    esc_html__('dashboard tab.', 'lunfest')
                ),
                'data' => 'posts',
                'args' => [
                    'post_type' => 'header',
                    'posts_per_page' => -1,
                    'orderby' => 'title',
                    'order' => 'ASC',
                ],
            ],
            [
                'id' => 'header_sticky_style',
                'type' => 'select',
                'title' => esc_html__('Appearance', 'lunfest'),
                'options' => [
                    'standard' => esc_html__('Always Visible', 'lunfest'),
                    'scroll_up' => esc_html__('Visible while scrolling upwards', 'lunfest'),
                ],
                'default' => 'scroll_up'
            ],
            [
                'id' => 'header_sticky-end',
                'type' => 'section',
                'indent' => false,
            ],
        ]
    ]
);

Redux::set_section(
    $theme_slug,
    [
        'title' => esc_html__('Header Mobile', 'lunfest'),
        'id' => 'header_builder_mobile',
        'subsection' => true,
        'fields' => [
            [
                'id' => 'mobile_header',
                'title' => esc_html__('Mobile Header', 'lunfest'),
                'type' => 'switch',
                'on' => esc_html__('Custom', 'lunfest'),
                'off' => esc_html__('Default', 'lunfest'),
                'default' => false,
            ],
            [
                'id' => 'header_mobile_appearance-start',
                'title' => esc_html__('Appearance', 'lunfest'),
                'type' => 'section',
                'required' => ['mobile_header', '=', '1'],
                'indent' => true,
            ],
            [
                'id' => 'header_mobile_height',
                'title' => esc_html__('Header Height', 'lunfest'),
                'type' => 'dimensions',
                'width' => false,
                'height' => true,
                'default' => ['height' => '60'],
            ],
            [
                'id' => 'header_mobile_full_width',
                'title' => esc_html__('Full Width Header', 'lunfest'),
                'type' => 'switch',
                'default' => false,
            ],
            [
                'id' => 'mobile_sticky',
                'title' => esc_html__('Mobile Sticky Header', 'lunfest'),
                'type' => 'switch',
                'default' => false,
            ],
            [
                'id' => 'mobile_over_content',
                'title' => esc_html__('Header Over Content', 'lunfest'),
                'type' => 'switch',
                'default' => false,
            ],
            [
                'id' => 'mobile_background',
                'title' => esc_html__('Header Background', 'lunfest'),
                'type' => 'color_rgba',
                'mode' => 'background',
                'default' => [
                    'alpha' => '1',
                    'rgba' => 'rgba(22,26,29, 1)',
                    'color' => '#161a1d',
                ],
            ],
            [
                'id' => 'mobile_color',
                'title' => esc_html__('Header Text Color', 'lunfest'),
                'type' => 'color',
                'transparent' => false,
                'default' => '#ffffff',
            ],
            [
                'id' => 'header_mobile_appearance-end',
                'type' => 'section',
                'indent' => false,
            ],
            [
                'id' => 'header_mobile_menu-start',
                'title' => esc_html__('Menu', 'lunfest'),
                'type' => 'section',
                'required' => ['mobile_header', '=', '1'],
                'indent' => true,
            ],
            [
                'id' => 'mobile_position',
                'title' => esc_html__('Menu Occurrence', 'lunfest'),
                'type' => 'button_set',
                'options' => [
                    'left' => esc_html__('Left', 'lunfest'),
                    'right' => esc_html__('Right', 'lunfest'),
                ],
                'default' => 'left',
            ],
            [
                'id' => 'custom_mobile_menu',
                'title' => esc_html__('Custom Mobile Menu', 'lunfest'),
                'type' => 'switch',
                'default' => false,
            ],
            [
                'id' => 'mobile_menu',
                'type' => 'select',
                'title' => esc_html__('Mobile Menu', 'lunfest'),
                'required' => ['custom_mobile_menu', '=', '1'],
                'select2' => ['allowClear' => false],
                'options' => $menus = wgl_get_custom_menu(),
                'default' => reset($menus),
            ],
            [
                'id' => 'mobile_sub_menu_color',
                'title' => esc_html__('Menu Text Color', 'lunfest'),
                'type' => 'color',
                'transparent' => false,
                'default' => '#ffffff',
            ],
            [
                'id' => 'mobile_sub_menu_background',
                'title' => esc_html__('Menu Background', 'lunfest'),
                'type' => 'color_rgba',
                'mode' => 'background',
                'default' => [
                    'alpha' => '1',
                    'rgba' => 'rgba(22,26,29,1)',
                    'color' => '#161a1d',
                ],
            ],
            [
                'id' => 'mobile_sub_menu_overlay',
                'title' => esc_html__('Menu Overlay', 'lunfest'),
                'type' => 'color_rgba',
                'mode' => 'background',
                'default' => [
                    'alpha' => '1',
                    'rgba' => 'rgba(22,26,29,0.8)',
                    'color' => '#161a1d',
                ],
            ],
            [
                'id' => 'header_mobile_menu-end',
                'type' => 'section',
                'indent' => false,
            ],
            [
                'id' => 'mobile_header_layout',
                'title' => esc_html__('Mobile Header Order', 'lunfest'),
                'type' => 'sorter',
                'required' => ['mobile_header', '=', '1'],
                'desc' => esc_html__('Organize the layout of the mobile header', 'lunfest'),
                'compiler' => 'true',
                'full_width' => true,
                'options' => [
                    'items' => $header_builder_items['mobile'],
                    'Left align side' => [
                        'menu' => esc_html__('Hamburger Menu', 'lunfest'),
                    ],
                    'Center align side' => [
                        'logo' => esc_html__('Logo', 'lunfest'),
                    ],
                    'Right align side' => [
                        'item_search' => esc_html__('Search', 'lunfest'),
                    ],
                ],
            ],
            [
                'id' => 'mobile_content_header_layout',
                'title' => esc_html__('Mobile Drawer Content', 'lunfest'),
                'type' => 'sorter',
                'required' => ['mobile_header', '=', '1'],
                'desc' => esc_html__('Organize the layout of the mobile header', 'lunfest'),
                'compiler' => 'true',
                'full_width' => true,
                'options' => [
                    'items' => $header_builder_items['mobile_drawer'],
                    'Left align side' => [
                        'logo' => esc_html__('Logo', 'lunfest'),
                        'menu' => esc_html__('Menu', 'lunfest'),
                        'item_search' => esc_html__('Search', 'lunfest'),
                    ],
                ],
                'default' => [
                    'items' => $header_builder_items['mobile_drawer'],
                    'Left align side' => [
                        'logo' => esc_html__('Logo', 'lunfest'),
                        'menu' => esc_html__('Menu', 'lunfest'),
                        'item_search' => esc_html__('Search', 'lunfest'),
                    ],
                ],
            ],
            [
                'id' => 'mobile_header_bar_html1_editor',
                'title' => esc_html__('HTML Element 1 Editor', 'lunfest'),
                'type' => 'ace_editor',
                'required' => ['mobile_header', '=', '1'],
                'mode' => 'html',
                'default' => '',
            ],
            [
                'id' => 'mobile_header_bar_html2_editor',
                'title' => esc_html__('HTML Element 2 Editor', 'lunfest'),
                'type' => 'ace_editor',
                'required' => ['mobile_header', '=', '1'],
                'mode' => 'html',
                'default' => '',
            ],
            [
                'id' => 'mobile_header_bar_html3_editor',
                'title' => esc_html__('HTML Element 3 Editor', 'lunfest'),
                'type' => 'ace_editor',
                'required' => ['mobile_header', '=', '1'],
                'mode' => 'html',
                'default' => '',
            ],
            [
                'id' => 'mobile_header_bar_html4_editor',
                'title' => esc_html__('HTML Element 4 Editor', 'lunfest'),
                'type' => 'ace_editor',
                'required' => ['mobile_header', '=', '1'],
                'mode' => 'html',
                'default' => '',
            ],
            [
                'id' => 'mobile_header_bar_html5_editor',
                'title' => esc_html__('HTML Element 5 Editor', 'lunfest'),
                'type' => 'ace_editor',
                'required' => ['mobile_header', '=', '1'],
                'mode' => 'html',
                'default' => '',
            ],
            [
                'id' => 'mobile_header_bar_html6_editor',
                'title' => esc_html__('HTML Element 6 Editor', 'lunfest'),
                'type' => 'ace_editor',
                'required' => ['mobile_header', '=', '1'],
                'mode' => 'html',
                'default' => '',
            ],
            [
                'id' => 'mobile_header_spacer1',
                'title' => esc_html__('Spacer 1 Width', 'lunfest'),
                'type' => 'dimensions',
                'required' => ['mobile_header', '=', '1'],
                'width' => true,
                'height' => false,
                'default' => ['width' => 25],
            ],
            [
                'id' => 'mobile_header_spacer2',
                'title' => esc_html__('Spacer 2 Width', 'lunfest'),
                'type' => 'dimensions',
                'required' => ['mobile_header', '=', '1'],
                'width' => true,
                'height' => false,
                'default' => ['width' => 25],
            ],
            [
                'id' => 'mobile_header_spacer3',
                'title' => esc_html__('Spacer 3 Width', 'lunfest'),
                'type' => 'dimensions',
                'required' => ['mobile_header', '=', '1'],
                'width' => true,
                'height' => false,
                'default' => ['width' => 25],
            ],
            [
                'id' => 'mobile_header_spacer4',
                'title' => esc_html__('Spacer 4 Width', 'lunfest'),
                'type' => 'dimensions',
                'required' => ['mobile_header', '=', '1'],
                'width' => true,
                'height' => false,
                'default' => ['width' => 25],
            ],
            [
                'id' => 'mobile_header_spacer5',
                'title' => esc_html__('Spacer 5 Width', 'lunfest'),
                'type' => 'dimensions',
                'required' => ['mobile_header', '=', '1'],
                'width' => true,
                'height' => false,
                'default' => ['width' => 25],
            ],
            [
                'id' => 'mobile_header_spacer6',
                'title' => esc_html__('Spacer 6 Width', 'lunfest'),
                'type' => 'dimensions',
                'required' => ['mobile_header', '=', '1'],
                'width' => true,
                'height' => false,
                'default' => ['width' => 25],
            ],
        ]
    ]
);

Redux::set_section(
    $theme_slug,
    [
        'id' => 'logo',
        'title' => esc_html__('Logo', 'lunfest'),
        'subsection' => true,
        'required' => ['header_building_tool', '=', 'elementor'],
        'fields' => [
            [
                'id' => 'header_logo',
                'title' => esc_html__('Default Header Logo', 'lunfest'),
                'type' => 'media',
            ],
            [
                'id' => 'logo_height_custom',
                'title' => esc_html__('Limit Default Logo Height', 'lunfest'),
                'type' => 'switch',
                'required' => ['header_logo', '!=', ''],
                'on' => esc_html__('Yes', 'lunfest'),
                'off' => esc_html__('No', 'lunfest'),
                'default' => false,
            ],
            [
                'id' => 'logo_height',
                'title' => esc_html__('Default Logo Height', 'lunfest'),
                'type' => 'dimensions',
                'required' => ['logo_height_custom', '=', '1'],
                'height' => true,
                'width' => false,
                'default' => ['height' => 90],
            ],
            [
                'id' => 'sticky_header_logo',
                'title' => esc_html__('Sticky Header Logo', 'lunfest'),
                'type' => 'media',
            ],
            [
                'id' => 'sticky_logo_height_custom',
                'title' => esc_html__('Limit Sticky Logo Height', 'lunfest'),
                'type' => 'switch',
                'required' => ['sticky_header_logo', '!=', ''],
                'on' => esc_html__('Yes', 'lunfest'),
                'off' => esc_html__('No', 'lunfest'),
                'default' => false,
            ],
            [
                'id' => 'sticky_logo_height',
                'title' => esc_html__('Sticky Header Logo Height', 'lunfest'),
                'type' => 'dimensions',
                'required' => ['sticky_logo_height_custom', '=', '1'],
                'height' => true,
                'width' => false,
                'default' => ['height' => 90],
            ],
            [
                'id' => 'logo_mobile',
                'title' => esc_html__('Mobile Header Logo', 'lunfest'),
                'type' => 'media',
            ],
            [
                'id' => 'mobile_logo_height_custom',
                'title' => esc_html__('Limit Mobile Logo Height', 'lunfest'),
                'type' => 'switch',
                'required' => ['logo_mobile', '!=', ''],
                'on' => esc_html__('Yes', 'lunfest'),
                'off' => esc_html__('No', 'lunfest'),
                'default' => false,
            ],
            [
                'id' => 'mobile_logo_height',
                'title' => esc_html__('Mobile Logo Height', 'lunfest'),
                'type' => 'dimensions',
                'required' => ['mobile_logo_height_custom', '=', '1'],
                'height' => true,
                'width' => false,
                'default' => ['height' => 60],
            ],
            [
                'id' => 'logo_mobile_menu',
                'title' => esc_html__('Mobile Menu Logo', 'lunfest'),
                'type' => 'media',
            ],
            [
                'id' => 'mobile_logo_menu_height_custom',
                'title' => esc_html__('Limit Mobile Menu Logo Height', 'lunfest'),
                'type' => 'switch',
                'required' => ['logo_mobile_menu', '!=', ''],
                'on' => esc_html__('Yes', 'lunfest'),
                'off' => esc_html__('No', 'lunfest'),
                'default' => false,
            ],
            [
                'id' => 'mobile_logo_menu_height',
                'title' => esc_html__('Mobile Menu Logo Height', 'lunfest'),
                'type' => 'dimensions',
                'required' => ['mobile_logo_menu_height_custom', '=', '1'],
                'height' => true,
                'width' => false,
                'default' => ['height' => 60],
            ],
        ]
    ]
);

Redux::set_section(
    $theme_slug,
    [
        'id' => 'page_title',
        'title' => esc_html__('Page Title', 'lunfest'),
        'icon' => 'el el-home-alt',
    ]
);

Redux::set_section(
    $theme_slug,
    [
        'id' => 'page_title_settings',
        'title' => esc_html__('General', 'lunfest'),
        'subsection' => true,
        'fields' => [
            [
                'id' => 'page_title_switch',
                'title' => esc_html__('Use Page Titles?', 'lunfest'),
                'type' => 'switch',
                'on' => esc_html__('Use', 'lunfest'),
                'off' => esc_html__('Hide', 'lunfest'),
                'default' => true,
            ],
            [
                'id' => 'page_title-start',
                'title' => esc_html__('Appearance', 'lunfest'),
                'type' => 'section',
                'required' => ['page_title_switch', '=', '1'],
                'indent' => true,
            ],
            [
                'id' => 'page_title_bg_switch',
                'title' => esc_html__('Use Background Image/Color?', 'lunfest'),
                'type' => 'switch',
                'on' => esc_html__('Use', 'lunfest'),
                'off' => esc_html__('Hide', 'lunfest'),
                'default' => true,
            ],
            [
                'id' => 'page_title_bg_image',
                'title' => esc_html__('Background Image/Color', 'lunfest'),
                'type' => 'background',
                'required' => ['page_title_bg_switch', '=', true],
                'preview' => false,
                'preview_media' => true,
                'background-color' => true,
                'transparent' => false,
                'default' => [
                    'background-image' => '',
                    'background-repeat' => 'no-repeat',
                    'background-size' => 'cover',
                    'background-attachment' => 'scroll',
                    'background-position' => 'center bottom',
                    'background-color' => '#3a3a3a',
                ],
            ],
            [
                'id' => 'page_title_height',
                'title' => esc_html__('Min Height', 'lunfest'),
                'type' => 'dimensions',
                'required' => ['page_title_bg_switch', '=', true],
                'desc' => esc_html__('Choose `0px` in order to use `min-height: auto;`', 'lunfest'),
                'width' => false,
                'height' => true,
                'default' => ['height' => 400],
            ],
            [
                'id' => 'page_title_padding',
                'title' => esc_html__('Paddings Top/Bottom', 'lunfest'),
                'type' => 'spacing',
                'mode' => 'padding',
                'all' => false,
                'bottom' => true,
                'top' => true,
                'left' => false,
                'right' => false,
                'default' => [
                    'padding-top' => '56',
                    'padding-bottom' => '60',
                ],
            ],
            [
                'id' => 'page_title_margin',
                'title' => esc_html__('Margin Bottom', 'lunfest'),
                'type' => 'spacing',
                'mode' => 'margin',
                'all' => false,
                'bottom' => true,
                'top' => false,
                'left' => false,
                'right' => false,
                'default' => ['margin-bottom' => '50'],
            ],
            [
                'id' => 'page_title_align',
                'title' => esc_html__('Title Alignment', 'lunfest'),
                'type' => 'button_set',
                'options' => [
                    'left' => esc_html__('Left', 'lunfest'),
                    'center' => esc_html__('Center', 'lunfest'),
                    'right' => esc_html__('Right', 'lunfest'),
                ],
                'default' => 'center',
            ],
            [
                'id' => 'page_title_breadcrumbs_switch',
                'title' => esc_html__('Breadcrumbs', 'lunfest'),
                'type' => 'switch',
                'on' => esc_html__('Use', 'lunfest'),
                'off' => esc_html__('Hide', 'lunfest'),
                'default' => true,
            ],
            [
                'id' => 'page_title_breadcrumbs_block_switch',
                'title' => esc_html__('Breadcrumbs Full Width', 'lunfest'),
                'type' => 'switch',
                'required' => ['page_title_breadcrumbs_switch', '=', true],
                'on' => esc_html__('Yes', 'lunfest'),
                'off' => esc_html__('No', 'lunfest'),
                'default' => true,
            ],
            [
                'id' => 'page_title_breadcrumbs_align',
                'title' => esc_html__('Breadcrumbs Alignment', 'lunfest'),
                'type' => 'button_set',
                'required' => ['page_title_breadcrumbs_block_switch', '=', true],
                'options' => [
                    'left' => esc_html__('Left', 'lunfest'),
                    'center' => esc_html__('Center', 'lunfest'),
                    'right' => esc_html__('Right', 'lunfest'),
                ],
                'default' => 'center',
            ],
            [
                'id' => 'page_title_parallax',
                'title' => esc_html__('Parallax Effect', 'lunfest'),
                'type' => 'switch',
                'default' => false,
            ],
            [
                'id' => 'page_title_parallax_speed',
                'title' => esc_html__('Parallax Speed', 'lunfest'),
                'type' => 'spinner',
                'required' => ['page_title_parallax', '=', '1'],
                'min' => '-5',
                'max' => '5',
                'step' => '0.1',
                'default' => '0.3',
            ],
            [
                'id' => 'page_title-end',
                'type' => 'section',
                'indent' => false,
            ],
        ]
    ]
);

Redux::set_section(
    $theme_slug,
    [
        'id' => 'page_title_typography',
        'title' => esc_html__('Typography', 'lunfest'),
        'subsection' => true,
        'fields' => [
            [
                'id' => 'page_title_font',
                'title' => esc_html__('Page Title Font', 'lunfest'),
                'type' => 'custom_typography',
                'font-size' => true,
                'google' => false,
                'font-weight' => false,
                'font-family' => false,
                'font-style' => false,
                'color' => true,
                'line-height' => true,
                'letter-spacing' => true,
                'font-backup' => false,
                'text-align' => false,
                'all_styles' => false,
                'default' => [
                    'font-size' => '70px',
                    'line-height' => '90px',
                    'color' => '#ffffff',
                    'letter-spacing' => '0',
                ],
            ],
            [
                'id' => 'page_title_breadcrumbs_font',
                'title' => esc_html__('Breadcrumbs Font', 'lunfest'),
                'type' => 'custom_typography',
                'font-size' => true,
                'google' => false,
                'font-weight' => false,
                'font-family' => false,
                'font-style' => false,
                'color' => true,
                'line-height' => true,
                'letter-spacing' => true,
                'font-backup' => false,
                'text-align' => false,
                'all_styles' => false,
                'default' => [
                    'font-size' => '14px',
                    'color' => '#ffffff',
                    'line-height' => '34px',
                    'letter-spacing' => '0',
                ],
            ],
        ]
    ]
);

Redux::set_section(
    $theme_slug,
    [
        'title' => esc_html__('Responsive', 'lunfest'),
        'id' => 'page_title_responsive',
        'subsection' => true,
        'fields' => [
            [
                'id' => 'page_title_resp_switch',
                'title' => esc_html__('Responsive Settings', 'lunfest'),
                'type' => 'switch',
                'default' => true,
            ],
            [
                'id' => 'page_title_resp_resolution',
                'title' => esc_html__('Screen breakpoint', 'lunfest'),
                'type' => 'slider',
                'required' => ['page_title_resp_switch', '=', '1'],
                'desc' => esc_html__('Use responsive settings on screens smaller then choosed breakpoint.', 'lunfest'),
                'display_value' => 'text',
                'min' => 1,
                'max' => 1700,
                'step' => 1,
                'default' => 1200,
            ],
            [
                'id' => 'page_title_resp_padding',
                'title' => esc_html__('Page Title Paddings', 'lunfest'),
                'type' => 'spacing',
                'required' => ['page_title_resp_switch', '=', '1'],
                'mode' => 'padding',
                'all' => false,
                'bottom' => true,
                'top' => true,
                'left' => false,
                'right' => false,
                'default' => [
                    'padding-top' => '90',
                    'padding-bottom' => '90',
                ],
            ],
            [
                'id' => 'page_title_resp_font',
                'title' => esc_html__('Page Title Font', 'lunfest'),
                'type' => 'custom_typography',
                'required' => ['page_title_resp_switch', '=', '1'],
                'google' => false,
                'all_styles' => false,
                'font-family' => false,
                'font-style' => false,
                'font-size' => true,
                'font-weight' => false,
                'font-backup' => false,
                'line-height' => true,
                'text-align' => false,
                'color' => true,
                'default' => [
                    'font-size' => '32px',
                    'line-height' => '42px',
                    'color' => '#ffffff',
                ],
            ],
            [
                'id' => 'page_title_resp_breadcrumbs_switch',
                'title' => esc_html__('Breadcrumbs', 'lunfest'),
                'type' => 'switch',
                'required' => ['page_title_resp_switch', '=', '1'],
                'default' => true,
            ],
            [
                'id' => 'page_title_resp_breadcrumbs_font',
                'title' => esc_html__('Breadcrumbs Font', 'lunfest'),
                'type' => 'custom_typography',
                'required' => ['page_title_resp_breadcrumbs_switch', '=', '1'],
                'google' => false,
                'all_styles' => false,
                'font-family' => false,
                'font-style' => false,
                'font-size' => true,
                'font-weight' => false,
                'font-backup' => false,
                'line-height' => true,
                'text-align' => false,
                'color' => true,
                'default' => [
                    'font-size' => '14px',
                    'color' => '#ffffff',
                    'line-height' => '24px',
                ],
            ],
        ]
    ]
);

Redux::set_section(
    $theme_slug,
    [
        'id' => 'footer',
        'title' => esc_html__('Footer', 'lunfest'),
        'icon' => 'fas fa-window-maximize el-rotate-180',
    ]
);

Redux::set_section(
    $theme_slug,
    [
        'id' => 'footer-general',
        'title' => esc_html__('General', 'lunfest'),
        'subsection' => true,
        'fields' => [
            [
                'id' => 'footer_switch',
                'title' => esc_html__('Footer', 'lunfest'),
                'type' => 'switch',
                'on' => esc_html__('Use', 'lunfest'),
                'off' => esc_html__('Disable', 'lunfest'),
                'default' => true,
            ],
            [
                'id' => 'footer-start',
                'title' => esc_html__('Layout', 'lunfest'),
                'type' => 'section',
                'required' => ['footer_switch', '=', '1'],
                'indent' => true,
            ],
            [
                'id' => 'footer_building_tool',
                'title' => esc_html__('Layout Building Tool', 'lunfest'),
                'type' => 'select',
                'options' => [
                    'widgets' => esc_html__('Wordpress Widgets', 'lunfest'),
                    'elementor' => esc_html__('Elementor', 'lunfest'),
                ],
                'default' => 'widgets',
            ],
            [
                'id' => 'footer_page_select',
                'title' => esc_html__('Footer Template', 'lunfest'),
                'type' => 'select',
                'required' => ['footer_building_tool', '=', 'elementor'],
                'data' => 'posts',
                'args' => [
                    'post_type' => 'footer',
                    'posts_per_page' => -1,
                    'orderby' => 'title',
                    'order' => 'ASC',
                ],
            ],
            [
                'id' => 'widget_columns',
                'title' => esc_html__('Columns', 'lunfest'),
                'type' => 'button_set',
                'required' => ['footer_building_tool', '=', 'widgets'],
                'options' => [
                    '1' => esc_html('1'),
                    '2' => esc_html('2'),
                    '3' => esc_html('3'),
                    '4' => esc_html('4'),
                ],
                'default' => '4',
            ],
            [
                'id' => 'widget_columns_2',
                'title' => esc_html__('Columns Layout', 'lunfest'),
                'type' => 'image_select',
                'required' => ['widget_columns', '=', '2'],
                'options' => [
                    '6-6' => [
                        'alt' => '50-50',
                        'img' => get_template_directory_uri() . '/core/admin/img/options/50-50.png'
                    ],
                    '3-9' => [
                        'alt' => '25-75',
                        'img' => get_template_directory_uri() . '/core/admin/img/options/25-75.png'
                    ],
                    '9-3' => [
                        'alt' => '75-25',
                        'img' => get_template_directory_uri() . '/core/admin/img/options/75-25.png'
                    ],
                    '4-8' => [
                        'alt' => '33-66',
                        'img' => get_template_directory_uri() . '/core/admin/img/options/33-66.png'
                    ],
                    '8-4' => [
                        'alt' => '66-33',
                        'img' => get_template_directory_uri() . '/core/admin/img/options/66-33.png'
                    ]
                ],
                'default' => '6-6',
            ],
            [
                'id' => 'widget_columns_3',
                'title' => esc_html__('Columns Layout', 'lunfest'),
                'type' => 'image_select',
                'required' => ['widget_columns', '=', '3'],
                'options' => [
                    '4-4-4' => [
                        'alt' => '33-33-33',
                        'img' => get_template_directory_uri() . '/core/admin/img/options/33-33-33.png'
                    ],
                    '3-3-6' => [
                        'alt' => '25-25-50',
                        'img' => get_template_directory_uri() . '/core/admin/img/options/25-25-50.png'
                    ],
                    '3-6-3' => [
                        'alt' => '25-50-25',
                        'img' => get_template_directory_uri() . '/core/admin/img/options/25-50-25.png'
                    ],
                    '6-3-3' => [
                        'alt' => '50-25-25',
                        'img' => get_template_directory_uri() . '/core/admin/img/options/50-25-25.png'
                    ],
                ],
                'default' => '4-4-4',
            ],
            [
                'id' => 'footer_spacing',
                'title' => esc_html__('Paddings', 'lunfest'),
                'type' => 'spacing',
                'required' => ['footer_building_tool', '=', 'widgets'],
                'output' => ['.wgl-footer'],
                'all' => false,
                'mode' => 'padding',
                'units' => 'px',
                'default' => [
                    'padding-top' => '50px',
                    'padding-right' => '0px',
                    'padding-bottom' => '0px',
                    'padding-left' => '0px'
                ],
            ],
            [
                'id' => 'footer_full_width',
                'title' => esc_html__('Full Width On/Off', 'lunfest'),
                'type' => 'switch',
                'required' => ['footer_building_tool', '=', 'widgets'],
                'default' => false,
            ],
            [
                'id' => 'footer-end',
                'type' => 'section',
                'indent' => false,
            ],
            [
                'id' => 'footer-start-styles',
                'title' => esc_html__('Footer Styling', 'lunfest'),
                'type' => 'section',
                'required' => [
                    ['footer_switch', '=', '1'],
                    ['footer_building_tool', '=', 'widgets'],
                ],
                'indent' => true,
            ],
            [
                'id' => 'footer_bg_image',
                'title' => esc_html__('Background Image', 'lunfest'),
                'type' => 'background',
                'required' => [
                    ['footer_switch', '=', '1'],
                    ['footer_building_tool', '=', 'widgets'],
                ],
                'preview' => false,
                'preview_media' => true,
                'background-color' => false,
                'default' => [
                    'background-repeat' => 'repeat',
                    'background-size' => 'cover',
                    'background-attachment' => 'scroll',
                    'background-position' => 'center center',
                ],
            ],
            [
                'id' => 'footer_align',
                'title' => esc_html__('Content Align', 'lunfest'),
                'type' => 'button_set',
                'required' => [
                    ['footer_switch', '=', '1'],
                    ['footer_building_tool', '=', 'widgets'],
                ],
                'options' => [
                    'left' => esc_html__('Left', 'lunfest'),
                    'center' => esc_html__('Center', 'lunfest'),
                    'right' => esc_html__('Right', 'lunfest'),
                ],
                'default' => 'center',
            ],
            [
                'id' => 'footer_bg_color',
                'title' => esc_html__('Background Color', 'lunfest'),
                'type' => 'color',
                'required' => [
                    ['footer_switch', '=', '1'],
                    ['footer_building_tool', '=', 'widgets'],
                ],
                'transparent' => false,
                'default' => '#252525',
            ],
            [
                'id' => 'footer_heading_color',
                'title' => esc_html__('Headings color', 'lunfest'),
                'type' => 'color',
                'required' => [
                    ['footer_switch', '=', '1'],
                    ['footer_building_tool', '=', 'widgets'],
                ],
                'transparent' => false,
                'default' => '#ffffff',
            ],
            [
                'id' => 'footer_text_color',
                'title' => esc_html__('Content color', 'lunfest'),
                'type' => 'color',
                'required' => [
                    ['footer_switch', '=', '1'],
                    ['footer_building_tool', '=', 'widgets'],
                ],
                'transparent' => false,
                'default' => '#dce0f5',
            ],
            [
                'id' => 'footer_add_border',
                'title' => esc_html__('Add Border Top', 'lunfest'),
                'type' => 'switch',
                'required' => [
                    ['footer_switch', '=', '1'],
                    ['footer_building_tool', '=', 'widgets'],
                ],
                'default' => false,
            ],
            [
                'id' => 'footer_border_color',
                'title' => esc_html__('Border color', 'lunfest'),
                'type' => 'color',
                'required' => ['footer_add_border', '=', '1'],
                'transparent' => false,
                'default' => '#dcdcdc',
            ],
            [
                'id' => 'footer-end-styles',
                'type' => 'section',
                'indent' => false,
            ],
        ]
    ]
);

Redux::set_section(
    $theme_slug,
    [
        'id' => 'footer-copyright',
        'title' => esc_html__('Copyright', 'lunfest'),
        'subsection' => true,
        'fields' => [
            [
                'id' => 'copyright_switch',
                'type' => 'switch',
                'title' => esc_html__('Copyright', 'lunfest'),
                'on' => esc_html__('Use', 'lunfest'),
                'off' => esc_html__('Disable', 'lunfest'),
                'default' => true,
            ],
            [
                'id' => 'copyright-start',
                'type' => 'section',
                'title' => esc_html__('Copyright Settings', 'lunfest'),
                'indent' => true,
                'required' => ['copyright_switch', '=', '1'],
            ],
            [
                'id' => 'copyright_editor',
                'title' => esc_html__('Editor', 'lunfest'),
                'type' => 'editor',
                'required' => ['copyright_switch', '=', '1'],
                'args' => [
                    'wpautop' => false,
                    'media_buttons' => false,
                    'textarea_rows' => 2,
                    'teeny' => false,
                    'quicktags' => true,
                ],
                'default' => '<p>Copyright © 2022 Lunfest by WebGeniusLab. All Rights Reserved</p>',
            ],
            [
                'id' => 'copyright_text_color',
                'title' => esc_html__('Text Color', 'lunfest'),
                'type' => 'color',
                'required' => ['copyright_switch', '=', '1'],
                'transparent' => false,
                'default' => '#d5d5d5',
            ],
            [
                'id' => 'copyright_bg_color',
                'title' => esc_html__('Background Color', 'lunfest'),
                'type' => 'color',
                'required' => ['copyright_switch', '=', '1'],
                'transparent' => false,
                'default' => '#000000',
            ],
            [
                'id' => 'copyright_spacing',
                'type' => 'spacing',
                'title' => esc_html__('Paddings', 'lunfest'),
                'required' => ['copyright_switch', '=', '1'],
                'mode' => 'padding',
                'all' => false,
                'left' => false,
                'right' => false,
                'default' => [
                    'padding-top' => '20',
                    'padding-bottom' => '20',
                ],
            ],
            [
                'id' => 'copyright-end',
                'type' => 'section',
                'indent' => false,
            ],
        ]
    ]
);

Redux::set_section(
    $theme_slug,
    [
        'id' => 'blog-option',
        'title' => esc_html__('Blog', 'lunfest'),
        'icon' => 'el el-bullhorn',
    ]
);

Redux::set_section(
    $theme_slug,
    [
        'id' => 'blog-list-option',
        'title' => esc_html__('Archive', 'lunfest'),
        'subsection' => true,
        'fields' => [
            [
                'id' => 'blog_list_page_title-start',
                'title' => esc_html__('Page Title', 'lunfest'),
                'type' => 'section',
                'required' => ['page_title_switch', '=', '1'],
                'indent' => true,
            ],
            [
                'id' => 'post_archive__page_title_bg_image',
                'title' => esc_html__('Background Image', 'lunfest'),
                'type' => 'background',
                'background-color' => false,
                'preview_media' => true,
                'preview' => false,
                'default' => [
                    'background-repeat' => 'repeat',
                    'background-size' => 'cover',
                    'background-attachment' => 'scroll',
                    'background-position' => 'center center',
                ],
            ],
            [
                'id' => 'blog_list_page_title-end',
                'type' => 'section',
                'indent' => false,
            ],
            [
                'id' => 'blog_list_sidebar-start',
                'title' => esc_html__('Sidebar', 'lunfest'),
                'type' => 'section',
                'indent' => true,
            ],
            [
                'id' => 'blog_list_sidebar_layout',
                'title' => esc_html__('Sidebar Layout', 'lunfest'),
                'type' => 'image_select',
                'options' => [
                    'none' => [
                        'alt' => esc_html__('None', 'lunfest'),
                        'img' => get_template_directory_uri() . '/core/admin/img/options/1col.png'
                    ],
                    'left' => [
                        'alt' => esc_html__('Left', 'lunfest'),
                        'img' => get_template_directory_uri() . '/core/admin/img/options/2cl.png'
                    ],
                    'right' => [
                        'alt' => esc_html__('Right', 'lunfest'),
                        'img' => get_template_directory_uri() . '/core/admin/img/options/2cr.png'
                    ]
                ],
                'default' => 'none'
            ],
            [
                'id' => 'blog_list_sidebar_def',
                'title' => esc_html__('Sidebar Template', 'lunfest'),
                'type' => 'select',
                'required' => ['blog_list_sidebar_layout', '!=', 'none'],
                'data' => 'sidebars',
            ],
            [
                'id' => 'blog_list_sidebar_def_width',
                'title' => esc_html__('Sidebar Width', 'lunfest'),
                'type' => 'button_set',
                'required' => ['blog_list_sidebar_layout', '!=', 'none'],
                'options' => [
                    '9' => esc_html( '25%' ),
                    '8' => esc_html( '33%' ),
                ],
                'default' => '9',
            ],
            [
                'id' => 'blog_list_sidebar_sticky',
                'title' => esc_html__('Sticky Sidebar', 'lunfest'),
                'type' => 'switch',
                'required' => ['blog_list_sidebar_layout', '!=', 'none'],
                'default' => false,
            ],
            [
                'id' => 'blog_list_sidebar_gap',
                'title' => esc_html__( 'Sidebar Side Gap', 'lunfest' ),
                'type' => 'select',
                'required' => [ 'blog_list_sidebar_layout', '!=', 'none' ],
                'options' => [
                    'def' => esc_html__( 'Default', 'lunfest' ),
                    '0' => esc_html( '15' ),
                    '15' => esc_html( '30' ),
                    '20' => esc_html( '35' ),
                    '25' => esc_html( '40' ),
                    '30' => esc_html( '45' ),
                    '35' => esc_html( '50' ),
                    '40' => esc_html( '55' ),
                    '45' => esc_html( '60' ),
                ],
                'default' => 'def',
            ],
            [
                'id' => 'blog_list_sidebar-end',
                'type' => 'section',
                'indent' => false,
            ],
            [
                'id' => 'blog_list_appearance-start',
                'title' => esc_html__('Appearance', 'lunfest'),
                'type' => 'section',
                'indent' => true,
            ],
            [
                'id' => 'blog_list_columns',
                'title' => esc_html__('Columns in Archive', 'lunfest'),
                'type' => 'button_set',
                'options' => [
                    '12' => esc_html__('One', 'lunfest'),
                    '6' => esc_html__('Two', 'lunfest'),
                    '4' => esc_html__('Three', 'lunfest'),
                    '3' => esc_html__('Four', 'lunfest'),
                ],
                'default' => '12',
            ],
            [
                'id' => 'blog_list_likes',
                'title' => esc_html__('Likes', 'lunfest'),
                'type' => 'switch',
                'on' => esc_html__('Use', 'lunfest'),
                'off' => esc_html__('Hide', 'lunfest'),
                'default' => false,
            ],
            [
                'id' => 'blog_list_views',
                'title' => esc_html__('Views', 'lunfest'),
                'type' => 'switch',
                'on' => esc_html__('Use', 'lunfest'),
                'off' => esc_html__('Hide', 'lunfest'),
                'default' => false,
            ],
            [
                'id' => 'blog_list_share',
                'title' => esc_html__('Shares', 'lunfest'),
                'type' => 'switch',
                'on' => esc_html__('Use', 'lunfest'),
                'off' => esc_html__('Hide', 'lunfest'),
                'default' => false,
            ],
            [
                'id' => 'blog_list_hide_media',
                'title' => esc_html__('Hide Media?', 'lunfest'),
                'type' => 'switch',
                'on' => esc_html__('Yes', 'lunfest'),
                'off' => esc_html__('No', 'lunfest'),
                'default' => false,
            ],
            [
                'id' => 'blog_list_hide_title',
                'title' => esc_html__('Hide Title?', 'lunfest'),
                'type' => 'switch',
                'on' => esc_html__('Yes', 'lunfest'),
                'off' => esc_html__('No', 'lunfest'),
                'default' => false,
            ],
            [
                'id' => 'blog_list_hide_content',
                'title' => esc_html__('Hide Content?', 'lunfest'),
                'type' => 'switch',
                'on' => esc_html__('Yes', 'lunfest'),
                'off' => esc_html__('No', 'lunfest'),
                'default' => false,
            ],
            [
                'id' => 'blog_post_listing_content',
                'title' => esc_html__('Limit the characters amount in Content?', 'lunfest'),
                'type' => 'switch',
                'required' => ['blog_list_hide_content', '=', false],
                'on' => esc_html__('Yes', 'lunfest'),
                'off' => esc_html__('No', 'lunfest'),
                'default' => false,
            ],
            [
                'id' => 'blog_list_letter_count',
                'title' => esc_html__('Characters amount to be displayed in Content', 'lunfest'),
                'type' => 'text',
                'required' => ['blog_post_listing_content', '=', true],
                'default' => '85',
            ],
            [
                'id' => 'blog_list_read_more',
                'title' => esc_html__('Hide Read More Button?', 'lunfest'),
                'type' => 'switch',
                'on' => esc_html__('Yes', 'lunfest'),
                'off' => esc_html__('No', 'lunfest'),
                'default' => false,
            ],
            [
                'id' => 'blog_list_meta',
                'title' => esc_html__('Hide all post-meta?', 'lunfest'),
                'type' => 'switch',
                'on' => esc_html__('Yes', 'lunfest'),
                'off' => esc_html__('No', 'lunfest'),
                'default' => false,
            ],
            [
                'id' => 'blog_list_meta_author',
                'title' => esc_html__('Hide post-meta author?', 'lunfest'),
                'type' => 'switch',
                'required' => ['blog_list_meta', '=', false],
                'on' => esc_html__('Yes', 'lunfest'),
                'off' => esc_html__('No', 'lunfest'),
                'default' => false,
            ],
            [
                'id' => 'blog_list_meta_comments',
                'title' => esc_html__('Hide post-meta comments?', 'lunfest'),
                'type' => 'switch',
                'required' => ['blog_list_meta', '=', false],
                'on' => esc_html__('Yes', 'lunfest'),
                'off' => esc_html__('No', 'lunfest'),
                'default' => true,
            ],
            [
                'id' => 'blog_list_meta_categories',
                'title' => esc_html__('Hide post-meta categories?', 'lunfest'),
                'type' => 'switch',
                'required' => ['blog_list_meta', '=', false],
                'on' => esc_html__('Yes', 'lunfest'),
                'off' => esc_html__('No', 'lunfest'),
                'default' => false,
            ],
            [
                'id' => 'blog_list_meta_date',
                'title' => esc_html__('Hide post-meta date?', 'lunfest'),
                'type' => 'switch',
                'required' => ['blog_list_meta', '=', false],
                'on' => esc_html__('Yes', 'lunfest'),
                'off' => esc_html__('No', 'lunfest'),
                'default' => false,
            ],
            [
                'id' => 'blog_list_appearance-end',
                'type' => 'section',
                'indent' => false,
            ],
        ]
    ]
);

Redux::set_section(
    $theme_slug,
    [
        'id' => 'blog-single-option',
        'title' => esc_html__('Single', 'lunfest'),
        'subsection' => true,
        'fields' => [
            [
                'id' => 'post_single_type_layout',
                'title' => esc_html__('Default Post Layout', 'lunfest'),
                'type' => 'button_set',
                'desc' => esc_html__('Note: each Post can be separately customized within its Metaboxes section.', 'lunfest'),
                'options' => [
                    '1' => esc_html__('Title First', 'lunfest'),
                    '2' => esc_html__('Image First', 'lunfest'),
                    '3' => esc_html__('Overlay Image', 'lunfest')
                ],
                'default' => '3',
            ],
            [
                'id' => 'blog_single_page_title-start',
                'title' => esc_html__('Page Title', 'lunfest'),
                'type' => 'section',
                'required' => ['page_title_switch', '=', '1'],
                'indent' => true,
            ],
            [
                'id' => 'blog_title_conditional',
                'title' => esc_html__('Page Title Text', 'lunfest'),
                'type' => 'switch',
                'on' => esc_html__('Post Type Name', 'lunfest'),
                'off' => esc_html__('Post Title', 'lunfest'),
                'default' => true,
            ],
            [
                'id' => 'blog_single__page_title_breadcrumbs_switch',
                'title' => esc_html__('Breadcrumbs', 'lunfest'),
                'type' => 'switch',
                'required' => ['post_single_type_layout', '!=', '3'],
                'on' => esc_html__('Use', 'lunfest'),
                'off' => esc_html__('Hide', 'lunfest'),
                'default' => true,
            ],
            [
                'id' => 'post_single__page_title_bg_switch',
                'title' => esc_html__('Use Background Image/Color?', 'lunfest'),
                'type' => 'switch',
                'required' => ['post_single_type_layout', '!=', '3'],
                'on' => esc_html__('Use', 'lunfest'),
                'off' => esc_html__('Hide', 'lunfest'),
                'default' => true,
            ],
            [
                'id' => 'post_single__page_title_bg_image',
                'title' => esc_html__('Background Image/Color', 'lunfest'),
                'type' => 'background',
                'required' => ['post_single_type_layout', '!=', '3'],
                'preview' => false,
                'preview_media' => true,
                'background-color' => true,
                'transparent' => false,
                'default' => [
                    'background-repeat' => 'repeat',
                    'background-size' => 'cover',
                    'background-attachment' => 'scroll',
                    'background-position' => 'center center',
                ],
            ],
	        [
		        'id' => 'post_single_layout_3_bg_image',
		        'type' => 'background',
                'title' => esc_html__('Default Background', 'lunfest'),
                'required' => ['post_single_type_layout', '=', '3'],
                'desc' => esc_html__('Note: If Featured Image doesn\'t exist.', 'lunfest'),
		        'preview' => false,
		        'preview_media' => true,
		        'background-color' => true,
		        'transparent' => false,
		        'background-repeat' => false,
		        'background-size' => false,
		        'background-attachment' => false,
		        'background-position' => false,
		        'default' => [
			        'background-color' => '#3a3a3a',
		        ],
	        ],
            [
                'id' => 'single_padding_layout_3',
                'type' => 'spacing',
                'title' => esc_html__('Padding Top/Bottom', 'lunfest'),
                'required' => ['post_single_type_layout', '=', '3'],
                'mode' => 'padding',
                'all' => false,
                'top' => true,
                'right' => false,
                'bottom' => true,
                'left' => false,
                'default' => [
                    'padding-top' => '355',
                    'padding-bottom' => '0',
                ],
            ],
            [
                'id' => 'blog_single_page_title-end',
                'type' => 'section',
                'indent' => false,
            ],
            [
                'id' => 'blog_single_sidebar-start',
                'type' => 'section',
                'title' => esc_html__('Sidebar', 'lunfest'),
                'indent' => true,
            ],
            [
                'id' => 'single_sidebar_layout',
                'title' => esc_html__('Sidebar Layout', 'lunfest'),
                'type' => 'image_select',
                'options' => [
                    'none' => [
                        'alt' => esc_html__('None', 'lunfest'),
                        'img' => get_template_directory_uri() . '/core/admin/img/options/1col.png'
                    ],
                    'left' => [
                        'alt' => esc_html__('Left', 'lunfest'),
                        'img' => get_template_directory_uri() . '/core/admin/img/options/2cl.png'
                    ],
                    'right' => [
                        'alt' => esc_html__('Right', 'lunfest'),
                        'img' => get_template_directory_uri() . '/core/admin/img/options/2cr.png'
                    ]
                ],
                'default' => 'right'
            ],
            [
                'id' => 'single_sidebar_def',
                'title' => esc_html__('Sidebar Template', 'lunfest'),
                'type' => 'select',
                'required' => ['single_sidebar_layout', '!=', 'none'],
                'data' => 'sidebars',
                'default' => 'sidebar_main-sidebar',
            ],
            [
                'id' => 'single_sidebar_def_width',
                'title' => esc_html__('Sidebar Width', 'lunfest'),
                'type' => 'button_set',
                'required' => ['single_sidebar_layout', '!=', 'none'],
                'options' => [
                    '9' => esc_html( '25%' ),
                    '8' => esc_html( '33%' ),
                ],
                'default' => '9',
            ],
            [
                'id' => 'single_sidebar_sticky',
                'title' => esc_html__('Sticky Sidebar', 'lunfest'),
                'type' => 'switch',
                'required' => ['single_sidebar_layout', '!=', 'none'],
                'default' => true,
            ],
            [
                'id' => 'single_sidebar_gap',
                'title' => esc_html__( 'Sidebar Side Gap', 'lunfest' ),
                'type' => 'select',
                'required' => [ 'single_sidebar_layout', '!=', 'none' ],
                'options' => [
                    'def' => esc_html__( 'Default', 'lunfest' ),
                    '0' => esc_html( '15' ),
                    '15' => esc_html( '30' ),
                    '20' => esc_html( '35' ),
                    '25' => esc_html( '40' ),
                    '30' => esc_html( '45' ),
                    '35' => esc_html( '50' ),
                    '40' => esc_html( '55' ),
                    '45' => esc_html( '60' ),
                ],
                'default' => 'def',
            ],
            [
                'id' => 'blog_single_sidebar-end',
                'type' => 'section',
                'indent' => false,
            ],
            [
                'id' => 'blog_single_appearance-start',
                'title' => esc_html__('Appearance', 'lunfest'),
                'type' => 'section',
                'indent' => true,
            ],
            [
                'id' => 'featured_image_type',
                'title' => esc_html__('Featured Image', 'lunfest'),
                'type' => 'button_set',
                'options' => [
                    'default' => esc_html__('Default', 'lunfest'),
                    'off' => esc_html__('Off', 'lunfest'),
                    'replace' => esc_html__('Replace', 'lunfest')
                ],
                'default' => 'default',
            ],
            [
                'id' => 'featured_image_replace',
                'title' => esc_html__('Image To Replace On', 'lunfest'),
                'type' => 'media',
                'required' => ['featured_image_type', '=', 'replace'],
            ],
            [
                'id' => 'single_apply_animation',
                'title' => esc_html__('Apply Animation?', 'lunfest'),
                'type' => 'switch',
                'required' => ['post_single_type_layout', '=', '3'],
                'desc' => lunfest_quick_tip(
                    wp_kses(
                        __('Fade out the Post Title during page scrolling. <br>Note: affects only <code>Overlay Image</code> post layouts', 'lunfest'),
                        ['br' => [], 'code' => []]
                    )
                ),
                'on' => esc_html__('Yes', 'lunfest'),
                'off' => esc_html__('No', 'lunfest'),
                'default' => true,
            ],
            [
                'id' => 'single_likes',
                'title' => esc_html__('Likes', 'lunfest'),
                'type' => 'switch',
                'on' => esc_html__('Use', 'lunfest'),
                'off' => esc_html__('Hide', 'lunfest'),
                'default' => false,
            ],
            [
                'id' => 'single_views',
                'title' => esc_html__('Views', 'lunfest'),
                'type' => 'switch',
                'on' => esc_html__('Use', 'lunfest'),
                'off' => esc_html__('Hide', 'lunfest'),
                'default' => false,
            ],
            [
                'id' => 'single_share',
                'title' => esc_html__('Shares', 'lunfest'),
                'type' => 'switch',
                'on' => esc_html__('Use', 'lunfest'),
                'off' => esc_html__('Hide', 'lunfest'),
                'default' => false,
            ],
            [
                'id' => 'single_meta_tags',
                'title' => esc_html__('Tags', 'lunfest'),
                'type' => 'switch',
                'on' => esc_html__('Use', 'lunfest'),
                'off' => esc_html__('Hide', 'lunfest'),
                'default' => true,
            ],
            [
                'id' => 'single_author_info',
                'title' => esc_html__('Author Info', 'lunfest'),
                'type' => 'switch',
                'on' => esc_html__('Use', 'lunfest'),
                'off' => esc_html__('Hide', 'lunfest'),
                'default' => false,
            ],
            [
                'id' => 'single_meta',
                'title' => esc_html__('Hide all post-meta?', 'lunfest'),
                'type' => 'switch',
                'on' => esc_html__('Yes', 'lunfest'),
                'off' => esc_html__('No', 'lunfest'),
                'default' => false,
            ],
            [
                'id' => 'single_meta_author',
                'title' => esc_html__('Hide post-meta author?', 'lunfest'),
                'type' => 'switch',
                'required' => ['single_meta', '=', false],
                'on' => esc_html__('Yes', 'lunfest'),
                'off' => esc_html__('No', 'lunfest'),
                'default' => true,
            ],
            [
                'id' => 'single_meta_comments',
                'title' => esc_html__('Hide post-meta comments?', 'lunfest'),
                'type' => 'switch',
                'required' => ['single_meta', '=', false],
                'on' => esc_html__('Yes', 'lunfest'),
                'off' => esc_html__('No', 'lunfest'),
                'default' => true,
            ],
            [
                'id' => 'single_meta_categories',
                'title' => esc_html__('Hide post-meta categories?', 'lunfest'),
                'type' => 'switch',
                'required' => ['single_meta', '=', false],
                'on' => esc_html__('Yes', 'lunfest'),
                'off' => esc_html__('No', 'lunfest'),
                'default' => false,
            ],
            [
                'id' => 'single_meta_date',
                'title' => esc_html__('Hide post-meta date?', 'lunfest'),
                'type' => 'switch',
                'required' => ['single_meta', '=', false],
                'on' => esc_html__('Yes', 'lunfest'),
                'off' => esc_html__('No', 'lunfest'),
                'default' => false,
            ],
            [
                'id' => 'blog_single_appearance-end',
                'type' => 'section',
                'indent' => false,
            ],
        ]
    ]
);

Redux::set_section(
    $theme_slug,
    [
        'id' => 'blog-single-related-option',
        'title' => esc_html__('Related', 'lunfest'),
        'subsection' => true,
        'fields' => [
            [
                'id' => 'single_related_posts',
                'title' => esc_html__('Related Posts', 'lunfest'),
                'type' => 'switch',
                'default' => true,
            ],
            [
                'id' => 'blog_title_r',
                'title' => esc_html__('Related Section Title', 'lunfest'),
                'type' => 'text',
                'required' => ['single_related_posts', '=', '1'],
                'default' => esc_html__('Related Posts', 'lunfest'),
            ],
            [
                'id' => 'blog_cat_r',
                'title' => esc_html__('Select Categories', 'lunfest'),
                'type' => 'select',
                'required' => ['single_related_posts', '=', '1'],
                'multi' => true,
                'data' => 'categories',
                'width' => '20%',
            ],
            [
                'id' => 'blog_column_r',
                'title' => esc_html__('Columns', 'lunfest'),
                'type' => 'button_set',
                'required' => ['single_related_posts', '=', '1'],
                'options' => [
                    '12' => '1',
                    '6' => '2',
                    '4' => '3',
                    '3' => '4'
                ],
                'default' => '6',
            ],
            [
                'id' => 'blog_number_r',
                'title' => esc_html__('Number of Related Items', 'lunfest'),
                'type' => 'text',
                'required' => ['single_related_posts', '=', '1'],
                'default' => '2',
            ],
            [
                'id' => 'blog_carousel_r',
                'title' => esc_html__('Display items in the carousel', 'lunfest'),
                'type' => 'switch',
                'required' => ['single_related_posts', '=', '1'],
                'default' => true,
            ],
        ]
    ]
);

Redux::set_section(
    $theme_slug,
    [
        'id' => 'portfolio-option',
        'title' => esc_html__('Portfolio', 'lunfest'),
        'icon' => 'el el-picture',
    ]
);

Redux::set_section(
    $theme_slug,
    [
        'id' => 'portfolio-list-option',
        'title' => esc_html__('Archive', 'lunfest'),
        'subsection' => true,
        'fields' => [
            [
                'id' => 'portfolio_slug',
                'title' => esc_html__('Portfolio Slug', 'lunfest'),
                'type' => 'text',
                'default' => 'portfolio',
            ],
            [
                'id' => 'portfolio_archive_page_title-start',
                'title' => esc_html__('Page Title', 'lunfest'),
                'type' => 'section',
                'required' => ['page_title_switch', '=', '1'],
                'indent' => true,
            ],
            [
                'id' => 'portfolio_archive__page_title_bg_image',
                'title' => esc_html__('Page Title Background Image', 'lunfest'),
                'type' => 'background',
                'preview' => false,
                'preview_media' => true,
                'background-color' => false,
                'default' => [
                    'background-repeat' => 'repeat',
                    'background-size' => 'cover',
                    'background-attachment' => 'scroll',
                    'background-position' => 'center center',
                    'background-color' => '',
                ],
            ],
            [
                'id' => 'portfolio_archive_page_title-end',
                'type' => 'section',
                'indent' => false,
            ],
            [
                'id' => 'portfolio_archive_sidebar-start',
                'title' => esc_html__('Sidebar', 'lunfest'),
                'type' => 'section',
                'indent' => true,
            ],
            [
                'id' => 'portfolio_list_sidebar_layout',
                'title' => esc_html__('Sidebar Layout', 'lunfest'),
                'type' => 'image_select',
                'options' => [
                    'none' => [
                        'alt' => esc_html__('None', 'lunfest'),
                        'img' => get_template_directory_uri() . '/core/admin/img/options/1col.png'
                    ],
                    'left' => [
                        'alt' => esc_html__('Left', 'lunfest'),
                        'img' => get_template_directory_uri() . '/core/admin/img/options/2cl.png'
                    ],
                    'right' => [
                        'alt' => esc_html__('Right', 'lunfest'),
                        'img' => get_template_directory_uri() . '/core/admin/img/options/2cr.png'
                    ]
                ],
                'default' => 'none'
            ],
            [
                'id' => 'portfolio_list_sidebar_def',
                'title' => esc_html__('Sidebar Template', 'lunfest'),
                'type' => 'select',
                'required' => ['portfolio_list_sidebar_layout', '!=', 'none'],
                'data' => 'sidebars',
            ],
            [
                'id' => 'portfolio_list_sidebar_def_width',
                'title' => esc_html__('Sidebar Width', 'lunfest'),
                'type' => 'button_set',
                'required' => ['portfolio_list_sidebar_layout', '!=', 'none'],
                'options' => [
                    '9' => esc_html__('25%', 'lunfest'),
                    '8' => esc_html__('33%', 'lunfest'),
                ],
                'default' => '9',
            ],
            [
                'id' => 'portfolio_archive_sidebar-end',
                'type' => 'section',
                'indent' => false,
            ],
            [
                'id' => 'portfolio_list_appearance-start',
                'title' => esc_html__('Appearance', 'lunfest'),
                'type' => 'section',
                'indent' => true,
            ],
            [
                'id' => 'portfolio_list_columns',
                'title' => esc_html__('Columns in Archive', 'lunfest'),
                'type' => 'button_set',
                'options' => [
                    '1' => esc_html__('One', 'lunfest'),
                    '2' => esc_html__('Two', 'lunfest'),
                    '3' => esc_html__('Three', 'lunfest'),
                    '4' => esc_html__('Four', 'lunfest'),
                ],
                'default' => '3',
            ],
            [
                'id' => 'portfolio_list_show_title',
                'title' => esc_html__('Title', 'lunfest'),
                'type' => 'switch',
                'on' => esc_html__('Use', 'lunfest'),
                'off' => esc_html__('Hide', 'lunfest'),
                'default' => true,
            ],
            [
                'id' => 'portfolio_list_show_content',
                'title' => esc_html__('Content', 'lunfest'),
                'type' => 'switch',
                'on' => esc_html__('Use', 'lunfest'),
                'off' => esc_html__('Hide', 'lunfest'),
                'default' => false,
            ],
            [
                'id' => 'portfolio_list_show_cat',
                'title' => esc_html__('Categories', 'lunfest'),
                'type' => 'switch',
                'on' => esc_html__('Use', 'lunfest'),
                'off' => esc_html__('Hide', 'lunfest'),
                'default' => true,
            ],
            [
                'id' => 'portfolio_list_appearance-end',
                'type' => 'section',
                'indent' => false,
            ],
        ]
    ]
);

Redux::set_section(
    $theme_slug,
    [
        'id' => 'portfolio-single-option',
        'title' => esc_html__('Single', 'lunfest'),
        'subsection' => true,
        'fields' => [
            [
                'id' => 'portfolio_single_layout-start',
                'title' => esc_html__('Layout', 'lunfest'),
                'type' => 'section',
                'indent' => true,
            ],
            [
                'id' => 'portfolio_single_type_layout',
                'title' => esc_html__('Portfolio Single Layout', 'lunfest'),
                'type' => 'button_set',
                'options' => [
                    '1' => esc_html__('Default First', 'lunfest'),
                    '2' => esc_html__('Sticky Image', 'lunfest'),
                ],
                'default' => '2',
            ],
            [
                'id' => 'portfolio_single_layout-end',
                'type' => 'section',
                'indent' => false,
            ],
            [
                'id' => 'portfolio_single_page_title-start',
                'title' => esc_html__('Page Title', 'lunfest'),
                'type' => 'section',
                'required' => ['page_title_switch', '=', true],
                'indent' => true,
            ],
            [
                'id' => 'portfolio_title_conditional',
                'title' => esc_html__('Page Title Text', 'lunfest'),
                'type' => 'switch',
                'on' => esc_html__('Post Type Name', 'lunfest'),
                'off' => esc_html__('Post Title', 'lunfest'),
                'default' => true,
            ],
            [
                'id' => 'portfolio_single_title_align',
                'title' => esc_html__('Title Alignment', 'lunfest'),
                'type' => 'button_set',
                'options' => [
                    'left' => esc_html__('Left', 'lunfest'),
                    'center' => esc_html__('Center', 'lunfest'),
                    'right' => esc_html__('Right', 'lunfest'),
                ],
                'default' => 'center',
            ],
            [
                'id' => 'portfolio_single_breadcrumbs_align',
                'title' => esc_html__('Breadcrumbs Alignment', 'lunfest'),
                'type' => 'button_set',
                'options' => [
                    'left' => esc_html__('Left', 'lunfest'),
                    'center' => esc_html__('Center', 'lunfest'),
                    'right' => esc_html__('Right', 'lunfest'),
                ],
                'default' => 'center',
            ],
            [
                'id' => 'portfolio_single_breadcrumbs_block_switch',
                'title' => esc_html__('Breadcrumbs Full Width', 'lunfest'),
                'type' => 'switch',
                'default' => true,
            ],
            [
                'id' => 'portfolio_single__page_title_bg_switch',
                'title' => esc_html__('Use Background Image/Color?', 'lunfest'),
                'type' => 'switch',
                'on' => esc_html__('Use', 'lunfest'),
                'off' => esc_html__('Hide', 'lunfest'),
                'default' => true,
            ],
            [
                'id' => 'portfolio_single__page_title_bg_image',
                'title' => esc_html__('Background Image/Color', 'lunfest'),
                'type' => 'background',
                'required' => ['portfolio_single__page_title_bg_switch', '=', true],
                'preview' => false,
                'preview_media' => true,
                'background-color' => true,
                'transparent' => false,
                'default' => [
                    'background-repeat' => 'repeat',
                    'background-size' => 'cover',
                    'background-attachment' => 'scroll',
                    'background-position' => 'center center',
                    'background-color' => '',
                ],
            ],
            [
                'id' => 'portfolio_single__page_title_height',
                'title' => esc_html__('Min Height', 'lunfest'),
                'type' => 'dimensions',
                'desc' => esc_html__('Choose `0px` in order to use `min-height: auto;`', 'lunfest'),
                'height' => true,
                'width' => false,
            ],
            [
                'id' => 'portfolio_single__page_title_padding',
                'title' => esc_html__('Paddings Top/Bottom', 'lunfest'),
                'type' => 'spacing',
                'mode' => 'padding',
                'all' => false,
                'bottom' => true,
                'top' => true,
                'left' => false,
                'right' => false,
            ],
            [
                'id' => 'portfolio_single__page_title_margin',
                'title' => esc_html__('Margin Bottom', 'lunfest'),
                'type' => 'spacing',
                'mode' => 'margin',
                'all' => false,
                'bottom' => true,
                'top' => false,
                'left' => false,
                'right' => false,
            ],
            [
                'id' => 'portfolio_single_page_title-end',
                'type' => 'section',
                'indent' => false,
            ],
            [
                'id' => 'portfolio_single_sidebar-start',
                'title' => esc_html__('Sidebar', 'lunfest'),
                'type' => 'section',
                'indent' => true,
            ],
            [
                'id' => 'portfolio_single_sidebar_layout',
                'title' => esc_html__('Sidebar Layout', 'lunfest'),
                'type' => 'image_select',
                'options' => [
                    'none' => [
                        'alt' => esc_html__('None', 'lunfest'),
                        'img' => get_template_directory_uri() . '/core/admin/img/options/1col.png'
                    ],
                    'left' => [
                        'alt' => esc_html__('Left', 'lunfest'),
                        'img' => get_template_directory_uri() . '/core/admin/img/options/2cl.png'
                    ],
                    'right' => [
                        'alt' => esc_html__('Right', 'lunfest'),
                        'img' => get_template_directory_uri() . '/core/admin/img/options/2cr.png'
                    ]
                ],
                'default' => 'none'
            ],
            [
                'id' => 'portfolio_single_sidebar_def',
                'title' => esc_html__('Sidebar Template', 'lunfest'),
                'type' => 'select',
                'required' => ['portfolio_single_sidebar_layout', '!=', 'none'],
                'data' => 'sidebars',
            ],
            [
                'id' => 'portfolio_single_sidebar_def_width',
                'title' => esc_html__('Sidebar Width', 'lunfest'),
                'type' => 'button_set',
                'required' => ['portfolio_single_sidebar_layout', '!=', 'none'],
                'options' => [
                    '9' => esc_html( '25%' ),
                    '8' => esc_html( '33%' ),
                ],
                'default' => '8',
            ],
            [
                'id' => 'portfolio_single_sidebar_sticky',
                'title' => esc_html__('Sticky Sidebar', 'lunfest'),
                'type' => 'switch',
                'required' => ['portfolio_single_sidebar_layout', '!=', 'none'],
                'default' => false,
            ],
            [
                'id' => 'portfolio_single_sidebar_gap',
                'title' => esc_html__( 'Sidebar Side Gap', 'lunfest' ),
                'type' => 'select',
                'required' => [ 'portfolio_single_sidebar_layout', '!=', 'none' ],
                'options' => [
                    'def' => esc_html__( 'Default', 'lunfest' ),
	                '0' => esc_html( '15' ),
	                '15' => esc_html( '30' ),
	                '20' => esc_html( '35' ),
	                '25' => esc_html( '40' ),
	                '30' => esc_html( '45' ),
	                '35' => esc_html( '50' ),
	                '40' => esc_html( '55' ),
	                '45' => esc_html( '60' ),
                ],
                'default' => 'def',
            ],
            [
                'id' => 'portfolio_single_sidebar-end',
                'type' => 'section',
                'indent' => false,
            ],
            [
                'id' => 'portfolio_single_appearance-start',
                'title' => esc_html__('Appearance', 'lunfest'),
                'type' => 'section',
                'indent' => true,
            ],
            [
                'id' => 'portfolio_above_content_cats',
                'title' => esc_html__('Tags', 'lunfest'),
                'type' => 'switch',
                'on' => esc_html__('Use', 'lunfest'),
                'off' => esc_html__('Hide', 'lunfest'),
                'default' => false,
            ],
            [
                'id' => 'portfolio_above_content_share',
                'title' => esc_html__('Shares', 'lunfest'),
                'type' => 'switch',
                'on' => esc_html__('Use', 'lunfest'),
                'off' => esc_html__('Hide', 'lunfest'),
                'default' => false,
            ],
            [
                'id' => 'portfolio_single_meta_likes',
                'title' => esc_html__('Likes', 'lunfest'),
                'type' => 'switch',
                'on' => esc_html__('Use', 'lunfest'),
                'off' => esc_html__('Hide', 'lunfest'),
                'default' => false,
            ],
            [
                'id' => 'portfolio_single_meta',
                'title' => esc_html__('Hide all post-meta?', 'lunfest'),
                'type' => 'switch',
                'on' => esc_html__('Yes', 'lunfest'),
                'off' => esc_html__('No', 'lunfest'),
                'default' => false,
            ],
            [
                'id' => 'portfolio_single_meta_author',
                'title' => esc_html__('Post-meta author', 'lunfest'),
                'type' => 'switch',
                'required' => ['portfolio_single_meta', '=', false],
                'on' => esc_html__('Use', 'lunfest'),
                'off' => esc_html__('Hide', 'lunfest'),
                'default' => false,
            ],
            [
                'id' => 'portfolio_single_meta_comments',
                'title' => esc_html__('Post-meta comments', 'lunfest'),
                'type' => 'switch',
                'required' => ['portfolio_single_meta', '=', false],
                'on' => esc_html__('Use', 'lunfest'),
                'off' => esc_html__('Hide', 'lunfest'),
                'default' => false,
            ],
            [
                'id' => 'portfolio_single_meta_categories',
                'title' => esc_html__('Post-meta categories', 'lunfest'),
                'type' => 'switch',
                'required' => ['portfolio_single_meta', '=', false],
                'on' => esc_html__('Use', 'lunfest'),
                'off' => esc_html__('Hide', 'lunfest'),
                'default' => true,
            ],
            [
                'id' => 'portfolio_single_meta_date',
                'title' => esc_html__('Post-meta date', 'lunfest'),
                'type' => 'switch',
                'required' => ['portfolio_single_meta', '=', false],
                'on' => esc_html__('Use', 'lunfest'),
                'off' => esc_html__('Hide', 'lunfest'),
                'default' => false,
            ],
            [
                'id' => 'portfolio_single_appearance-end',
                'type' => 'section',
                'indent' => false,
            ],
        ]
    ]
);

Redux::set_section(
    $theme_slug,
    [
        'id' => 'portfolio-related-option',
        'title' => esc_html__('Related Posts', 'lunfest'),
        'subsection' => true,
        'fields' => [
            [
                'id' => 'portfolio_related_switch',
                'title' => esc_html__('Related Posts', 'lunfest'),
                'type' => 'switch',
                'on' => esc_html__('Use', 'lunfest'),
                'off' => esc_html__('Hide', 'lunfest'),
                'default' => true,
            ],
            [
                'id' => 'portfolio_related_title',
                'title' => esc_html__('Title', 'lunfest'),
                'type' => 'text',
                'required' => ['portfolio_related_switch', '=', '1'],
                'default' => esc_html__('Related Projects', 'lunfest'),
            ],
            [
                'id' => 'pf_carousel_r',
                'title' => esc_html__('Display items within carousel for this post', 'lunfest'),
                'type' => 'switch',
                'required' => ['portfolio_related_switch', '=', '1'],
                'default' => true,
            ],
            [
                'id' => 'pf_column_r',
                'title' => esc_html__('Related Columns', 'lunfest'),
                'type' => 'button_set',
                'required' => ['portfolio_related_switch', '=', '1'],
                'options' => [
                    '2' => esc_html__('Two', 'lunfest'),
                    '3' => esc_html__('Three', 'lunfest'),
                    '4' => esc_html__('Four', 'lunfest'),
                ],
                'default' => '3',
            ],
            [
                'id' => 'pf_number_r',
                'title' => esc_html__('Number of Related Items', 'lunfest'),
                'type' => 'text',
                'required' => ['portfolio_related_switch', '=', '1'],
                'default' => '3',
            ],
        ]
    ]
);

Redux::set_section(
    $theme_slug,
    [
        'id' => 'portfolio-advanced',
        'title' => esc_html__('Advanced', 'lunfest'),
        'subsection' => true,
        'fields' => [
            [
                'id' => 'portfolio_archives',
                'title' => esc_html__('Portfolio Archives', 'lunfest'),
                'type' => 'switch',
                'on' => esc_html__('Enabled', 'lunfest'),
                'off' => esc_html__('Disabled', 'lunfest'),
                'default' => true,
                'desc' => lunfest_quick_tip(sprintf(
                    wp_kses(
                        __('Archive Page lists all the portfolio posts you have created. <br>This option will disable only the Archive Page, while the post\'s Single Pages will still be displayed. <br>Note: you need to refresh your <a href="%s">permalinks</a> after switching this option.', 'lunfest'),
                        ['a' => ['href' => true], 'br' => []]
                    ),
                    esc_url(admin_url('options-permalink.php'))
                )),
            ],
            [
                'id' => 'portfolio_singular',
                'title' => esc_html__('Portfolio Single', 'lunfest'),
                'type' => 'switch',
                'on' => esc_html__('Enabled', 'lunfest'),
                'off' => esc_html__('Disabled', 'lunfest'),
                'default' => true,
                'desc' => lunfest_quick_tip(
                    wp_kses(
                        __('By default, all Portfolio posts have their Single Pages. <br>This creates a specific URL on your website for every post. <br>Selecting "Disabled" will prevent the single view post being publicly displayed.', 'lunfest'),
                        ['br' => []]
                    )
                ),
            ],
        ]
    ]
);

Redux::set_section(
    $theme_slug,
    [
        'id' => 'team-option',
        'title' => esc_html__('Team', 'lunfest'),
        'icon' => 'el el-user',
    ]
);

Redux::set_section(
    $theme_slug,
    [
        'id' => 'team-single-option',
        'title' => esc_html__('Single', 'lunfest'),
        'subsection' => true,
        'fields' => [
            [
                'id' => 'team_single_page_title-start',
                'title' => esc_html__('Page Title', 'lunfest'),
                'type' => 'section',
                'required' => ['page_title_switch', '=', true],
                'indent' => true,
            ],
            [
                'id' => 'team_title_conditional',
                'title' => esc_html__('Page Title Text', 'lunfest'),
                'type' => 'switch',
                'on' => esc_html__('Post Type Name', 'lunfest'),
                'off' => esc_html__('Post Title', 'lunfest'),
                'default' => true,
            ],
            [
                'id' => 'team_single__page_title_bg_switch',
                'title' => esc_html__('Use Background Image/Color?', 'lunfest'),
                'type' => 'switch',
                'on' => esc_html__('Use', 'lunfest'),
                'off' => esc_html__('Hide', 'lunfest'),
                'default' => true,
            ],
            [
                'id' => 'team_single__page_title_bg_image',
                'title' => esc_html__('Background Image/Color', 'lunfest'),
                'type' => 'background',
                'required' => ['team_single__page_title_bg_switch', '=', true],
                'preview' => false,
                'preview_media' => true,
                'background-color' => true,
                'transparent' => false,
                'default' => [
                    'background-repeat' => 'repeat',
                    'background-size' => 'cover',
                    'background-attachment' => 'scroll',
                    'background-position' => 'center center',
                    'background-color' => '',
                ],
            ],
            [
                'id' => 'team_single__page_title_height',
                'title' => esc_html__('Min Height', 'lunfest'),
                'type' => 'dimensions',
                'required' => ['page_title_bg_switch', '=', true],
                'desc' => esc_html__('Choose `0px` in order to use `min-height: auto;`', 'lunfest'),
                'height' => true,
                'width' => false,
            ],
            [
                'id' => 'team_single__page_title_padding',
                'title' => esc_html__('Paddings Top/Bottom', 'lunfest'),
                'type' => 'spacing',
                'mode' => 'padding',
                'all' => false,
                'bottom' => true,
                'top' => true,
                'left' => false,
                'right' => false,
            ],
            [
                'id' => 'team_single__page_title_margin',
                'title' => esc_html__('Margin Bottom', 'lunfest'),
                'type' => 'spacing',
                'mode' => 'margin',
                'all' => false,
                'bottom' => true,
                'top' => false,
                'left' => false,
                'right' => false,
            ],
            [
                'id' => 'team_single_page_title-end',
                'type' => 'section',
                'indent' => false,
            ],
        ]
    ]
);

Redux::set_section(
    $theme_slug,
    [
        'id' => 'team-advanced',
        'title' => esc_html__('Advanced', 'lunfest'),
        'subsection' => true,
        'fields' => [
            [
                'id' => 'team_slug',
                'title' => esc_html__('Team Slug', 'lunfest'),
                'type' => 'text',
                'default' => 'team',
            ],
            [
                'id' => 'team_singular',
                'title' => esc_html__('Team Singles', 'lunfest'),
                'type' => 'switch',
                'on' => esc_html__('Enabled', 'lunfest'),
                'off' => esc_html__('Disabled', 'lunfest'),
                'default' => true,
                'desc' => esc_html__('By default, all team posts have single views enabled. This creates a specific URL on your website for that post. Selecting "Disabled" will prevent the single view post being publicly displayed.', 'lunfest'),
            ],
            [
                'id' => 'team_archives',
                'title' => esc_html__('Team Archive', 'lunfest'),
                'type' => 'switch',
                'on' => esc_html__('Enabled', 'lunfest'),
                'off' => esc_html__('Disabled', 'lunfest'),
                'default' => true,
                'desc' => sprintf(
                    wp_kses(
                        __('Archive Page lists all the Team Members you have created. This option will disable only the member\'s Archive Page. The member\'s Single Pages will still be displayed. Note: you will need to refresh your <a href="%s">permalinks</a> after switching this option.', 'lunfest'),
                        ['a' => ['href' => true, 'target' => true]]
                    ),
                    esc_url(admin_url('options-permalink.php'))
                ),
            ],
        ]
    ]
);

Redux::set_section(
    $theme_slug,
    [
        'title' => esc_html__('Page 404', 'lunfest'),
        'id' => '404-option',
        'icon' => 'el el-error',
        'fields' => [
            [
                'id' => '404_building_tool',
                'title' => esc_html__('Layout Building Tool', 'lunfest'),
                'type' => 'select',
                'options' => [
                    'default' => esc_html__('Default', 'lunfest'),
                    'elementor' => esc_html__('Elementor', 'lunfest'),
                ],
                'default' => 'default',
            ],
            [
                'id' => '404_template_select',
                'type' => 'select',
                'title' => esc_html__('Select Template', 'lunfest'),
                'required' => ['404_building_tool', '=', 'elementor'],
                'data' => 'posts',
                'desc' => sprintf(
                    '%s <br>%s <a href="%s" target="_blank">%s</a> %s',
                    esc_html__('Selected Template will be used for 404 page by default.', 'lunfest'),
                    esc_html__('You can edit/create Template in the', 'lunfest'),
                    admin_url('edit.php?post_type=elementor_library&tabs_group=library'),
                    esc_html__('Saved Templates', 'lunfest'),
                    esc_html__('dashboard tab.', 'lunfest')
                ),
                'args' => [
                    'post_type' => 'elementor_library',
                    'posts_per_page' => -1,
                    'orderby' => 'title',
                    'order' => 'ASC',
                ],
            ],
            [
                'id' => '404_show_header',
                'type' => 'switch',
                'title' => esc_html__('Header Section', 'lunfest'),
                'on' => esc_html__('Use', 'lunfest'),
                'off' => esc_html__('Hide', 'lunfest'),
                'default' => true,
            ],
            [
                'id' => '404_page_title_switcher',
                'title' => esc_html__('Page Title Section', 'lunfest'),
                'type' => 'switch',
                'on' => esc_html__('Use', 'lunfest'),
                'off' => esc_html__('Hide', 'lunfest'),
                'default' => true,
            ],
            [
                'id' => '404_page_title-start',
                'type' => 'section',
                'required' => ['404_page_title_switcher', '=', true],
                'indent' => true,
            ],
            [
                'id' => '404_custom_title_switch',
                'title' => esc_html__('Page Title Text', 'lunfest'),
                'type' => 'switch',
                'required' => ['404_page_title_switcher', '=', true],
                'on' => esc_html__('Custom', 'lunfest'),
                'off' => esc_html__('Default', 'lunfest'),
                'default' => false,
            ],
            [
                'id' => '404_page_title_text',
                'title' => esc_html__('Custom Page Title Text', 'lunfest'),
                'type' => 'text',
                'required' => ['404_custom_title_switch', '=', true],
            ],
            [
                'id' => '404_page__page_title_bg_switch',
                'title' => esc_html__('Use Background Image/Color?', 'lunfest'),
                'type' => 'switch',
                'required' => ['404_page_title_switcher', '=', true],
                'on' => esc_html__('Use', 'lunfest'),
                'off' => esc_html__('Hide', 'lunfest'),
                'default' => true,
            ],
            [
                'id' => '404_page__page_title_bg_image',
                'title' => esc_html__('Background Image/Color', 'lunfest'),
                'type' => 'background',
                'required' => ['404_page__page_title_bg_switch', '=', true],
                'preview' => false,
                'preview_media' => true,
                'background-color' => true,
                'transparent' => false,
                'default' => [
                    'background-repeat' => 'repeat',
                    'background-size' => 'cover',
                    'background-attachment' => 'scroll',
                    'background-position' => 'center center',
                ],
            ],
            [
                'id' => '404_page__page_title_height',
                'title' => esc_html__('Min Height', 'lunfest'),
                'type' => 'dimensions',
                'required' => ['page_title_bg_switch', '=', true],
                'desc' => esc_html__('Choose `0px` in order to use `min-height: auto;`', 'lunfest'),
                'height' => true,
                'width' => false,
            ],
            [
                'id' => '404_page__page_title_padding',
                'title' => esc_html__('Paddings Top/Bottom', 'lunfest'),
                'type' => 'spacing',
                'mode' => 'padding',
                'all' => false,
                'top' => true,
                'bottom' => true,
                'left' => false,
                'right' => false,
            ],
            [
                'id' => '404_page__page_title_margin',
                'title' => esc_html__('Margin Bottom', 'lunfest'),
                'type' => 'spacing',
                'mode' => 'margin',
                'all' => false,
                'top' => false,
                'bottom' => true,
                'left' => false,
                'right' => false,
                'default' => [
                    'margin-bottom' => '0',
                ],
            ],
            [
                'id' => '404_page_title-end',
                'type' => 'section',
                'indent' => false,
            ],
            [
                'id' => '404_page_main-start',
                'type' => 'section',
                'title' => esc_html__('Section Settings', 'lunfest'),
                'required' => ['404_page_title_switcher', '=', true],
                'indent' => true,
            ],
            [
                'id' => '404_page_main_bg_image',
                'title' => esc_html__('Background Image/Color', 'lunfest'),
                'type' => 'background',
                'preview' => false,
                'preview_media' => true,
                'background-color' => false,
                'transparent' => false,
                'default' => [
                    'background-repeat' => 'repeat',
                    'background-size' => 'cover',
                    'background-attachment' => 'scroll',
                    'background-position' => 'center center',
                ],
            ],
            [
                'id' => '404_page_main_padding',
                'title' => esc_html__('Paddings Top/Bottom', 'lunfest'),
                'type' => 'spacing',
                'mode' => 'padding',
                'all' => false,
                'top' => true,
                'bottom' => true,
                'left' => false,
                'right' => false,
            ],
            [
                'id' => '404_page_main-end',
                'type' => 'section',
                'indent' => false,
            ],
            [
                'id' => '404_show_footer',
                'title' => esc_html__('Footer Section', 'lunfest'),
                'type' => 'switch',
                'on' => esc_html__('Use', 'lunfest'),
                'off' => esc_html__('Hide', 'lunfest'),
                'default' => true,
            ],
        ]
    ]
);

Redux::set_section(
    $theme_slug,
    [
        'id' => 'side_panel',
        'title' => esc_html__('Side Panel', 'lunfest'),
        'icon' => 'el el-indent-left',
        'fields' => [
            [
                'id' => 'side_panel_enabled',
                'title' => esc_html__('Side Panel', 'lunfest'),
                'type' => 'switch',
                'on' => esc_html__('Use', 'lunfest'),
                'off' => esc_html__('Disable', 'lunfest'),
                'default' => false,
            ],
            [
                'id' => 'side_panel-start',
                'title' => esc_html__('Layout', 'lunfest'),
                'type' => 'section',
                'required' => ['side_panel_enabled', '=', true],
                'indent' => true,
            ],
            [
                'id' => 'side_panel_building_tool',
                'title' => esc_html__('Layout Building Tool', 'lunfest'),
                'type' => 'select',
                'options' => [
                    'widgets' => esc_html__('Wordpress Widgets', 'lunfest'),
                    'elementor' => esc_html__('Elementor (recommended)', 'lunfest'),
                ],
                'default' => 'elementor',
            ],
            [
                'id' => 'side_panel_page_select',
                'title' => esc_html__('Select Template', 'lunfest'),
                'type' => 'select',
                'required' => ['side_panel_building_tool', '=', 'elementor'],
                'desc' => wp_kses(
                    sprintf(
                        '%s <a href="%s" target="_blank">%s</a> %s<br> %s',
                        __('You can edit/create Side Panel Template in the', 'lunfest'),
                        admin_url('edit.php?post_type=side_panel'),
                        __('Side Panel', 'lunfest'),
                        __('dashboard tab.', 'lunfest'),
                        lunfest_quick_tip(
                            sprintf(
                                __('Note: fine tuning is available through the Elementor\'s <code>Post Settings</code> tab, which is located <a href="%s" target="_blank">here</a>', 'lunfest'),
                                get_template_directory_uri() . '/core/admin/img/dashboard/quick_tip__side_panel_extra_options.png'
                            )
                        )
                    ),
                    ['a' => ['href' => true, 'target' => true], 'br' => [], 'span' => ['class' => true], 'i' => ['class' => true], 'code' => []]
                ),
                'data' => 'posts',
                'args' => [
                    'post_type' => 'side_panel',
                    'posts_per_page' => -1,
                    'orderby' => 'title',
                    'order' => 'ASC',
                ],
            ],
            [
                'id' => 'side_panel_spacing',
                'title' => esc_html__('Margin', 'lunfest'),
                'type' => 'spacing',
                'mode' => 'margin',
                'required' => ['side_panel_building_tool', '=', 'widgets'],
                'units' => 'px',
                'all' => false,
                'default' => [
                    'margin-top' => '50',
                    'margin-right' => '50',
                    'margin-bottom' => '50',
                    'margin-left' => '50',
                ],
            ],
            [
                'id' => 'side_panel_title_color',
                'title' => esc_html__('Title Color', 'lunfest'),
                'type' => 'color',
                'required' => ['side_panel_building_tool', '=', 'widgets'],
                'transparent' => false,
                'default' => '#161a1d',
            ],
            [
                'id' => 'side_panel_text_color',
                'title' => esc_html__('Text Color', 'lunfest'),
                'type' => 'color',
                'required' => ['side_panel_building_tool', '=', 'widgets'],
                'transparent' => false,
                'default' => '#161a1d',
            ],
            [
                'id' => 'side_panel_bg',
                'title' => esc_html__('Background', 'lunfest'),
                'type' => 'color_rgba',
                'required' => ['side_panel_building_tool', '=', 'widgets'],
                'mode' => 'background',
                'default' => [
                    'alpha' => '1',
                    'rgba' => 'rgba(255,255,255,1)',
                    'color' => '#ffffff',
                ],
            ],
            [
                'id' => 'side_panel_text_alignment',
                'title' => esc_html__('Text Align', 'lunfest'),
                'type' => 'button_set',
                'required' => ['side_panel_building_tool', '=', 'widgets'],
                'options' => [
                    'left' => esc_html__('Left', 'lunfest'),
                    'center' => esc_html__('Center', 'lunfest'),
                    'right' => esc_html__('Right', 'lunfest'),
                ],
                'default' => 'left',
            ],
            [
                'id' => 'side_panel_width',
                'title' => esc_html__('Width', 'lunfest'),
                'type' => 'dimensions',
                'required' => ['side_panel_building_tool', '=', 'widgets'],
                'width' => true,
                'height' => false,
                'default' => ['width' => 370],
            ],
            [
                'id' => 'side_panel_position',
                'title' => esc_html__('Position', 'lunfest'),
                'type' => 'button_set',
                'required' => ['side_panel_building_tool', '=', 'widgets'],
                'options' => [
                    'left' => esc_html__('Left', 'lunfest'),
                    'right' => esc_html__('Right', 'lunfest'),
                ],
                'default' => 'right'
            ],
            [
                'id' => 'side_panel-end',
                'type' => 'section',
                'indent' => false,
            ],
        ]
    ]
);

Redux::set_section(
    $theme_slug,
    [
        'id' => 'layout_options',
        'title' => esc_html__('Sidebars', 'lunfest'),
        'icon' => 'el el-braille',
        'fields' => [
            [
                'id' => 'sidebars',
                'title' => esc_html__('Register Sidebars', 'lunfest'),
                'type' => 'multi_text',
                'validate' => 'no_html',
                'add_text' => esc_html__('Add Sidebar', 'lunfest'),
                'default' => ['Main Sidebar'],
            ],
            [
                'id' => 'sidebars-start',
                'title' => esc_html__('Sidebar Settings', 'lunfest'),
                'type' => 'section',
                'indent' => true,
            ],
            [
                'id' => 'page_sidebar_layout',
                'title' => esc_html__('Page Sidebar Layout', 'lunfest'),
                'type' => 'image_select',
                'options' => [
                    'none' => [
                        'alt' => esc_html__('None', 'lunfest'),
                        'img' => get_template_directory_uri() . '/core/admin/img/options/1col.png'
                    ],
                    'left' => [
                        'alt' => esc_html__('Left', 'lunfest'),
                        'img' => get_template_directory_uri() . '/core/admin/img/options/2cl.png'
                    ],
                    'right' => [
                        'alt' => esc_html__('Right', 'lunfest'),
                        'img' => get_template_directory_uri() . '/core/admin/img/options/2cr.png'
                    ]
                ],
                'default' => 'none'
            ],
            [
                'id' => 'page_sidebar_def',
                'title' => esc_html__('Page Sidebar', 'lunfest'),
                'type' => 'select',
                'required' => ['page_sidebar_layout', '!=', 'none'],
                'data' => 'sidebars',
            ],
            [
                'id' => 'page_sidebar_def_width',
                'title' => esc_html__('Page Sidebar Width', 'lunfest'),
                'type' => 'button_set',
                'required' => ['page_sidebar_layout', '!=', 'none'],
                'options' => [
                    '9' => esc_html( '25%' ),
                    '8' => esc_html( '33%' ),
                ],
                'default' => '9',
            ],
            [
                'id' => 'page_sidebar_sticky',
                'title' => esc_html__('Sticky Sidebar', 'lunfest'),
                'type' => 'switch',
                'required' => ['page_sidebar_layout', '!=', 'none'],
                'default' => false,
            ],
            [
                'id' => 'page_sidebar_gap',
                'title' => esc_html__( 'Sidebar Side Gap', 'lunfest' ),
                'type' => 'select',
                'required' => [ 'page_sidebar_layout', '!=', 'none' ],
                'options' => [
                    'def' => esc_html__( 'Default', 'lunfest' ),
                    '0' => esc_html( '15' ),
                    '15' => esc_html( '30' ),
                    '20' => esc_html( '35' ),
                    '25' => esc_html( '40' ),
                    '30' => esc_html( '45' ),
                    '35' => esc_html( '50' ),
                    '40' => esc_html( '55' ),
                    '45' => esc_html( '60' ),
                ],
                'default' => 'def',
            ],
            [
                'id' => 'sidebars-end',
                'type' => 'section',
                'indent' => false,
            ],
        ]
    ]
);

Redux::set_section(
    $theme_slug,
    [
        'id' => 'soc_shares',
        'title' => esc_html__('Social Shares', 'lunfest'),
        'icon' => 'el el-share-alt',
        'fields' => [
            [
                'id' => 'post_shares',
                'title' => esc_html__('Share List', 'lunfest'),
                'type' => 'checkbox',
                'desc' => esc_html__('Note: used only on Blog Single, Blog List and Portfolio Single pages', 'lunfest'),
                'options' => [
                    'telegram' => esc_html__('Telegram', 'lunfest'),
                    'reddit' => esc_html__('Reddit', 'lunfest'),
                    'twitter' => esc_html__('Twitter', 'lunfest'),
                    'whatsapp' => esc_html__('WhatsApp', 'lunfest'),
                    'facebook' => esc_html__('Facebook', 'lunfest'),
                    'pinterest' => esc_html__('Pinterest', 'lunfest'),
                    'linkedin' => esc_html__('Linkedin', 'lunfest'),
                ],
                'default' => [
                    'telegram' => '0',
                    'reddit' => '0',
                    'twitter' => '1',
                    'whatsapp' => '0',
                    'facebook' => '1',
                    'pinterest' => '1',
                    'linkedin' => '1',
                ]
            ],
            [
                'id' => 'page_socials-start',
                'title' => esc_html__('Page Socials', 'lunfest'),
                'type' => 'section',
                'indent' => true,
            ],
            [
                'id' => 'show_soc_icon_page',
                'title' => esc_html__('Page Social Shares', 'lunfest'),
                'type' => 'switch',
                'desc' => esc_html__('Social buttons are to be rendered on a left side of each page.', 'lunfest'),
                'on' => esc_html__('Use', 'lunfest'),
                'off' => esc_html__('Hide', 'lunfest'),
                'default' => false,
            ],
            [
                'id' => 'soc_icon_style',
                'title' => esc_html__('Socials visibility', 'lunfest'),
                'type' => 'button_set',
                'options' => [
                    'standard' => esc_html__('Always', 'lunfest'),
                    'hovered' => esc_html__('On Hover', 'lunfest'),
                ],
                'default' => 'standard',
                'required' => ['show_soc_icon_page', '=', '1'],
            ],
            [
                'id' => 'soc_icon_offset',
                'title' => esc_html__('Offset Top', 'lunfest'),
                'type' => 'spacing',
                'required' => ['show_soc_icon_page', '=', '1'],
                'desc' => esc_html__('If units defined as "%" then socials will be fixed to viewport.', 'lunfest'),
                'mode' => 'margin',
                'units' => ['px', '%'],
                'all' => false,
                'top' => true,
                'bottom' => false,
                'left' => false,
                'right' => false,
                'default' => [
                    'margin-top' => '250',
                    'units' => 'px'
                ],
            ],
            [
                'id' => 'soc_icon_facebook',
                'title' => esc_html__('Facebook Button', 'lunfest'),
                'type' => 'switch',
                'required' => ['show_soc_icon_page', '=', '1'],
                'default' => false,
            ],
            [
                'id' => 'soc_icon_twitter',
                'title' => esc_html__('Twitter Button', 'lunfest'),
                'type' => 'switch',
                'required' => ['show_soc_icon_page', '=', '1'],
                'default' => false,
            ],
            [
                'id' => 'soc_icon_linkedin',
                'title' => esc_html__('Linkedin Button', 'lunfest'),
                'type' => 'switch',
                'required' => ['show_soc_icon_page', '=', '1'],
                'default' => false,
            ],
            [
                'id' => 'soc_icon_pinterest',
                'title' => esc_html__('Pinterest Button', 'lunfest'),
                'type' => 'switch',
                'required' => ['show_soc_icon_page', '=', '1'],
                'default' => false,
            ],
            [
                'id' => 'soc_icon_tumblr',
                'title' => esc_html__('Tumblr Button', 'lunfest'),
                'type' => 'switch',
                'required' => ['show_soc_icon_page', '=', '1'],
                'default' => false,
            ],
            [
                'id' => 'add_custom_share',
                'title' => esc_html__('Need Additional Socials?', 'lunfest'),
                'type' => 'switch',
                'required' => ['show_soc_icon_page', '=', '1'],
                'on' => esc_html__('Yes', 'lunfest'),
                'off' => esc_html__('No', 'lunfest'),
                'default' => false,
            ],
            [
                'id' => 'share_name-1',
                'title' => esc_html__('Social 1 - Name', 'lunfest'),
                'type' => 'text',
                'required' => ['add_custom_share', '=', '1'],
            ],
            [
                'id' => 'share_link-1',
                'title' => esc_html__('Social 1 - Link', 'lunfest'),
                'type' => 'text',
                'required' => ['add_custom_share', '=', '1'],
            ],
            [
                'id' => 'share_icons-1',
                'title' => esc_html__('Social 1 - Icon', 'lunfest'),
                'type' => 'select',
                'required' => ['add_custom_share', '=', '1'],
                'data' => 'elusive-icons',
            ],
            [
                'id' => 'share_name-2',
                'title' => esc_html__('Social 2 - Name', 'lunfest'),
                'type' => 'text',
                'required' => ['add_custom_share', '=', '1'],
            ],
            [
                'id' => 'share_link-2',
                'title' => esc_html__('Social 2 - Link', 'lunfest'),
                'type' => 'text',
                'required' => ['add_custom_share', '=', '1'],
            ],
            [
                'id' => 'share_icons-2',
                'title' => esc_html__('Social 2 - Icon', 'lunfest'),
                'type' => 'select',
                'required' => ['add_custom_share', '=', '1'],
                'data' => 'elusive-icons',
            ],
            [
                'id' => 'share_name-3',
                'title' => esc_html__('Social 3 - Name', 'lunfest'),
                'type' => 'text',
                'required' => ['add_custom_share', '=', '1'],
            ],
            [
                'id' => 'share_link-3',
                'title' => esc_html__('Social 3 - Link', 'lunfest'),
                'type' => 'text',
                'required' => ['add_custom_share', '=', '1'],
            ],
            [
                'id' => 'share_icons-3',
                'title' => esc_html__('Social 3 - Icon', 'lunfest'),
                'type' => 'select',
                'required' => ['add_custom_share', '=', '1'],
                'data' => 'elusive-icons',
            ],
            [
                'id' => 'share_name-4',
                'type' => 'text',
                'title' => esc_html__('Social 4 - Name', 'lunfest'),
                'required' => ['add_custom_share', '=', '1'],
            ],
            [
                'id' => 'share_link-4',
                'title' => esc_html__('Social 4 - Link', 'lunfest'),
                'type' => 'text',
                'required' => ['add_custom_share', '=', '1'],
            ],
            [
                'id' => 'share_icons-4',
                'type' => 'select',
                'title' => esc_html__('Social 4 - Icon', 'lunfest'),
                'required' => ['add_custom_share', '=', '1'],
                'data' => 'elusive-icons',
            ],
            [
                'id' => 'share_name-5',
                'title' => esc_html__('Social 5 - Name', 'lunfest'),
                'type' => 'text',
                'required' => ['add_custom_share', '=', '1'],
            ],
            [
                'id' => 'share_link-5',
                'title' => esc_html__('Social 5 - Link', 'lunfest'),
                'type' => 'text',
                'required' => ['add_custom_share', '=', '1'],
            ],
            [
                'id' => 'share_icons-5',
                'title' => esc_html__('Social 5 - Icon', 'lunfest'),
                'type' => 'select',
                'required' => ['add_custom_share', '=', '1'],
                'data' => 'elusive-icons',
            ],
            [
                'id' => 'share_name-6',
                'title' => esc_html__('Social 6 - Name', 'lunfest'),
                'type' => 'text',
                'required' => ['add_custom_share', '=', '1'],
            ],
            [
                'id' => 'share_link-6',
                'title' => esc_html__('Social 6 - Link', 'lunfest'),
                'type' => 'text',
                'required' => ['add_custom_share', '=', '1'],
            ],
            [
                'id' => 'share_icons-6',
                'title' => esc_html__('Social 6 - Icon', 'lunfest'),
                'type' => 'select',
                'required' => ['add_custom_share', '=', '1'],
                'data' => 'elusive-icons',
            ],
            [
                'id' => 'page_socials-end',
                'type' => 'section',
                'indent' => false,
            ],
        ]
    ]
);

Redux::set_section(
    $theme_slug,
    [
        'id' => 'color_options_color',
        'title' => esc_html__( 'Color Settings', 'lunfest' ),
        'icon' => 'el-icon-tint',
        'fields' => [
            [
                'id' => 'theme_colors-start',
                'title' => esc_html__( 'Theme Colors', 'lunfest' ),
                'type' => 'section',
                'indent' => true,
            ],
            [
                'id' => 'theme-primary-color',
                'title' => esc_html__( 'Primary Theme Color', 'lunfest' ),
                'type' => 'color',
                'validate' => 'color',
                'transparent' => false,
                'default' => '#9d99f2',
            ],
            [
                'id' => 'theme-secondary-color',
                'title' => esc_html__( 'Secondary Theme Color', 'lunfest' ),
                'type' => 'color',
                'validate' => 'color',
                'transparent' => false,
                'default' => '#161a1d',
            ],
            [
                'id' => 'theme-tertiary-color',
                'title' => esc_html__( 'Tertiary Theme Color', 'lunfest' ),
                'type' => 'color',
                'validate' => 'color',
                'transparent' => false,
                'default' => '#fff79a',
            ],
            [
                'id' => 'theme-content-color',
                'title' => esc_html__( 'Content Color', 'lunfest' ),
                'type' => 'color',
                'validate' => 'color',
                'transparent' => false,
                'default' => '#515151',
            ],
            [
                'id' => 'theme-headings-color',
                'title' => esc_html__( 'Headings Color', 'lunfest' ),
                'type' => 'color',
                'validate' => 'color',
                'transparent' => false,
                'default' => '#161a1d',
            ],
            [
                'id' => 'body-background-color',
                'title' => esc_html__( 'Body Background Color', 'lunfest' ),
                'type' => 'color',
                'validate' => 'color',
                'transparent' => false,
                'default' => '#ffffff',
            ],
            [
                'id' => 'theme_colors-end',
                'type' => 'section',
                'indent' => false,
            ],
            [
                'id' => 'button_colors-start',
                'title' => esc_html__( 'Button Colors', 'lunfest' ),
                'type' => 'section',
                'indent' => true,
            ],
            [
                'id' => 'button-color-idle',
                'title' => esc_html__( 'Button Color Idle', 'lunfest' ),
                'type' => 'color',
                'validate' => 'color',
                'transparent' => false,
                'default' => '#ffffff',
            ],
            [
                'id' => 'button-bg-idle',
                'title' => esc_html__( 'Button Background Idle', 'lunfest' ),
                'type' => 'color',
                'validate' => 'color',
                'transparent' => false,
                'default' => '#161a1d',
            ],
            [
                'id' => 'button-color-hover',
                'title' => esc_html__( 'Button Color Hover', 'lunfest' ),
                'type' => 'color',
                'validate' => 'color',
                'transparent' => false,
                'default' => '#161a1d',
            ],
            [
                'id' => 'button-bg-hover',
                'title' => esc_html__( 'Button Background Hover', 'lunfest' ),
                'type' => 'color',
                'validate' => 'color',
                'transparent' => false,
                'default' => '#9d99f2',
            ],
            [
                'id' => 'button_colors-end',
                'type' => 'section',
                'indent' => false,
            ],
        ]
    ]
);

//* ↓ Typography Config
Redux::set_section(
    $theme_slug,
    [
        'id' => 'Typography',
        'title' => esc_html__('Typography', 'lunfest'),
        'icon' => 'el-icon-font',
    ]
);

$main_typography = [
    [
        'id' => 'main-font',
        'title' => esc_html__('Content Font', 'lunfest'),
        'line-height' => true,
        'font-size' => true,
        'subsets' => false,
        'all_styles' => true,
        'font-weight-multi' => true,
        'defs' => [
            'font-family' => 'Prompt',
            'font-size' => '16px',
            'line-height' => '30px',
            'font-weight' => '400',
            'font-weight-multi' => '300,400',
        ],
    ],
    [
        'id' => 'header-font',
        'title' => esc_html__('Headings Font', 'lunfest'),
        'font-size' => false,
        'line-height' => false,
        'subsets' => false,
        'all_styles' => true,
        'font-weight-multi' => true,
        'defs' => [
            'google' => true,
            'font-family' => 'Prompt',
            'font-weight' => '500',
            'font-weight-multi' => '300,400,500,600,700',
        ],
    ],
	[
		'id' => 'additional-font',
		'title' => esc_html__('Additional Font', 'lunfest'),
		'font-size' => false,
		'line-height' => false,
		'subsets' => false,
		'all_styles' => true,
		'font-weight-multi' => false,
		'defs' => [
			'google' => true,
			'font-family' => 'Krona One',
			'font-weight' => '400',
		],
	],
];
$typography = [];
foreach ($main_typography as $key => $value) {
    array_push($typography, [
        'id' => $value['id'],
        'type' => 'custom_typography',
        'title' => $value['title'],
        'color' => $value['color'] ?? '',
        'line-height' => $value['line-height'],
        'font-size' => $value['font-size'],
        'subsets' => $value['subsets'],
        'all_styles' => $value['all_styles'],
        'font-weight-multi' => $value['font-weight-multi'] ?? '',
        'subtitle' => $value['subtitle'] ?? '',
        'letter-spacing' => $value['letter-spacing'] ?? '',
        'google' => true,
        'font-style' => true,
        'font-backup' => false,
        'text-align' => false,
        'default' => $value['defs'],
    ]);
}

Redux::set_section(
    $theme_slug,
    [
        'id' => 'main_typography',
        'title' => esc_html__('Main Content', 'lunfest'),
        'subsection' => true,
        'fields' => $typography,
    ]
);

//* ↓ Menu Typography
$menu_typography = [
    [
        'id' => 'menu-font',
        'title' => esc_html__('Menu Font', 'lunfest'),
        'color' => false,
        'line-height' => true,
        'font-size' => true,
        'subsets' => true,
        'letter-spacing' => true,
        'defs' => [
            'google' => true,
            'font-family' => 'Krona One',
            'font-size' => '14px',
            'font-weight' => '400',
            'line-height' => '30px',
            'letter-spacing' => '0.01',
            'text-transform' => 'none',
        ],
    ],
    [
        'id' => 'sub-menu-font',
        'title' => esc_html__('Submenu Font', 'lunfest'),
        'color' => false,
        'line-height' => true,
        'font-size' => true,
        'subsets' => true,
        'letter-spacing' => true,
        'defs' => [
            'google' => true,
            'font-family' => 'Krona One',
            'font-size' => '14px',
            'font-weight' => '400',
            'line-height' => '30px',
            'letter-spacing' => '0.025',
            'text-transform' => 'none',
        ],
    ],
];
$menu_typography_array = [];
foreach ($menu_typography as $key => $value) {
    array_push($menu_typography_array, [
        'id' => $value['id'],
        'type' => 'custom_typography',
        'title' => $value['title'],
        'color' => $value['color'],
        'line-height' => $value['line-height'],
        'font-size' => $value['font-size'],
        'subsets' => $value['subsets'],
        'letter-spacing' => $value['letter-spacing'],
        'google' => true,
        'font-style' => true,
        'font-backup' => false,
        'text-align' => false,
        'all_styles' => false,
        'default' => $value['defs'],
    ]);
}

Redux::set_section(
    $theme_slug,
    [
        'id' => 'main_menu_typography',
        'title' => esc_html__('Menu', 'lunfest'),
        'subsection' => true,
        'fields' => $menu_typography_array
    ]
);
//* ↑ menu typography

//* ↓ Headings Typography
$headings = [
    [
        'id' => 'header-h1',
        'title' => esc_html__('‹h1›', 'lunfest'),
        'defs' => [
            'font-family' => 'Prompt',
            'font-size' => '70px',
            'line-height' => '78px',
            'font-weight' => '500',
            'letter-spacing' => '0',
            'text-transform' => 'none',
        ],
    ],
    [
        'id' => 'header-h2',
        'title' => esc_html__('‹h2›', 'lunfest'),
        'defs' => [
            'font-family' => 'Prompt',
            'font-size' => '58px',
            'line-height' => '72px',
            'font-weight' => '500',
            'letter-spacing' => '0',
            'text-transform' => 'none',
        ],
    ],
    [
        'id' => 'header-h3',
        'title' => esc_html__('‹h3›', 'lunfest'),
        'defs' => [
            'font-family' => 'Prompt',
            'font-size' => '48px',
            'line-height' => '62px',
            'font-weight' => '500',
            'letter-spacing' => '0',
            'text-transform' => 'none',
        ],
    ],
    [
        'id' => 'header-h4',
        'title' => esc_html__('‹h4›', 'lunfest'),
        'defs' => [
            'font-family' => 'Prompt',
            'font-size' => '30px',
            'line-height' => '40px',
            'font-weight' => '500',
            'letter-spacing' => '0',
            'text-transform' => 'none',
        ],
    ],
    [
        'id' => 'header-h5',
        'title' => esc_html__('‹h5›', 'lunfest'),
        'defs' => [
            'font-family' => 'Prompt',
            'font-size' => '28px',
            'line-height' => '36px',
            'font-weight' => '500',
            'letter-spacing' => '0',
            'text-transform' => 'none',
        ],
    ],
    [
        'id' => 'header-h6',
        'title' => esc_html__('‹h6›', 'lunfest'),
        'defs' => [
            'font-family' => 'Prompt',
            'font-size' => '24px',
            'line-height' => '36px',
            'font-weight' => '500',
            'letter-spacing' => '0',
            'text-transform' => 'none',
        ],
    ],
];
$headings_array = [];
foreach ($headings as $key => $heading) {
    array_push($headings_array, [
        'id' => $heading['id'],
        'type' => 'custom_typography',
        'title' => $heading['title'],
        'google' => true,
        'font-backup' => false,
        'font-size' => true,
        'line-height' => true,
        'color' => false,
        'word-spacing' => false,
        'letter-spacing' => true,
        'text-align' => false,
        'text-transform' => true,
        'default' => $heading['defs'],
    ]);
}

Redux::set_section(
    $theme_slug,
    [
        'id' => 'main_headings_typography',
        'title' => esc_html__('Headings', 'lunfest'),
        'subsection' => true,
        'fields' => $headings_array
    ]
);

if (class_exists('EM_Events')) {
    Redux::set_section($theme_slug, [
        'title' => esc_html__('Events', 'lunfest'),
        'id' => 'events-option',
        'icon' => 'el-icon-calendar',
        'fields' => [
        ]
    ]);

    Redux::set_section($theme_slug, [
        'title' => esc_html__('Single', 'lunfest'),
        'id' => 'events-single-option',
        'subsection' => true,
        'fields' => [
            [
                'id' => 'event_title_conditional',
                'title' => esc_html__('Events Title Text', 'lunfest'),
                'type' => 'switch',
                'on' => esc_html__('Events Type Name', 'lunfest'),
                'off' => esc_html__('Events Title', 'lunfest'),
                'default' => true,
            ],
            [
                'id' => 'event_single_type_layout',
                'title' => esc_html__('Default Events Single Type', 'lunfest'),
                'type' => 'button_set',
                'desc' => esc_html__('Note: each Post can be separately customized within its Metaboxes section.', 'lunfest'),
                'options' => [
                    '1' => esc_html__('Title First', 'lunfest'),
                    '2' => esc_html__('Image First', 'lunfest'),
                    '3' => esc_html__('Overlay Image', 'lunfest')
                ],
                'default' => '3',
            ],
            [
                'id' => 'event_single_page_title-start',
                'title' => esc_html__('Page Title', 'lunfest'),
                'type' => 'section',
                'required' => ['page_title_switch', '=', '1'],
                'indent' => true,
            ],
            [
                'id' => 'event_title_conditional',
                'title' => esc_html__('Page Title Text', 'lunfest'),
                'type' => 'switch',
                'on' => esc_html__('Post Type Name', 'lunfest'),
                'off' => esc_html__('Post Title', 'lunfest'),
                'default' => true,
            ],
            [
                'id' => 'event_single__page_title_breadcrumbs_switch',
                'title' => esc_html__('Breadcrumbs', 'lunfest'),
                'type' => 'switch',
                'required' => ['event_single_type_layout', '!=', '3'],
                'on' => esc_html__('Use', 'lunfest'),
                'off' => esc_html__('Hide', 'lunfest'),
                'default' => true,
            ],
            [
                'id' => 'event_single__page_title_bg_switch',
                'title' => esc_html__('Use Background Image/Color?', 'lunfest'),
                'type' => 'switch',
                'required' => ['event_single_type_layout', '!=', '3'],
                'on' => esc_html__('Use', 'lunfest'),
                'off' => esc_html__('Hide', 'lunfest'),
                'default' => true,
            ],
            [
                'id' => 'event_single__page_title_bg_image',
                'title' => esc_html__('Background Image/Color', 'lunfest'),
                'type' => 'background',
                'required' => ['event_single_type_layout', '!=', '3'],
                'preview' => false,
                'preview_media' => true,
                'background-color' => true,
                'transparent' => false,
                'default' => [
                    'background-repeat' => 'repeat',
                    'background-size' => 'cover',
                    'background-attachment' => 'scroll',
                    'background-position' => 'center center',
                ],
            ],
            [
                'id' => 'event_single_layout_3_bg_image',
                'type' => 'background',
                'title' => esc_html__('Default Background', 'lunfest'),
                'required' => ['event_single_type_layout', '=', '3'],
                'desc' => esc_html__('Note: If Featured Image doesn\'t exist.', 'lunfest'),
                'preview' => false,
                'preview_media' => true,
                'background-color' => true,
                'transparent' => false,
                'background-repeat' => false,
                'background-size' => false,
                'background-attachment' => false,
                'background-position' => false,
                'default' => [
                    'background-color' => '#3a3a3a',
                ],
            ],
            [
                'id' => 'event_single_padding_layout_3',
                'type' => 'spacing',
                'title' => esc_html__('Padding Top/Bottom', 'lunfest'),
                'required' => ['event_single_type_layout', '=', '3'],
                'mode' => 'padding',
                'all' => false,
                'top' => true,
                'right' => false,
                'bottom' => true,
                'left' => false,
                'default' => [
                    'padding-top' => '355',
                    'padding-bottom' => '0',
                ],
            ],
            [
                'id' => 'event_single_page_title-end',
                'type' => 'section',
                'indent' => false,
            ],
            [
                'id' => 'event_single_sidebar-start',
                'type' => 'section',
                'title' => esc_html__('Sidebar', 'lunfest'),
                'indent' => true,
            ],
            [
                'id' => 'event_single_sidebar_layout',
                'title' => esc_html__('Sidebar Layout', 'lunfest'),
                'type' => 'image_select',
                'options' => [
                    'none' => [
                        'alt' => esc_html__('None', 'lunfest'),
                        'img' => get_template_directory_uri() . '/core/admin/img/options/1col.png'
                    ],
                    'left' => [
                        'alt' => esc_html__('Left', 'lunfest'),
                        'img' => get_template_directory_uri() . '/core/admin/img/options/2cl.png'
                    ],
                    'right' => [
                        'alt' => esc_html__('Right', 'lunfest'),
                        'img' => get_template_directory_uri() . '/core/admin/img/options/2cr.png'
                    ]
                ],
                'default' => 'none'
            ],
            [
                'id' => 'single_sidebar_def',
                'title' => esc_html__('Sidebar Template', 'lunfest'),
                'type' => 'select',
                'required' => ['single_sidebar_layout', '!=', 'none'],
                'data' => 'sidebars',
                'default' => 'sidebar_main-sidebar',
            ],
            [
                'id' => 'event_single_sidebar_def_width',
                'title' => esc_html__('Sidebar Width', 'lunfest'),
                'type' => 'button_set',
                'required' => ['event_single_sidebar_layout', '!=', 'none'],
                'options' => [
                    '9' => esc_html( '25%' ),
                    '8' => esc_html( '33%' ),
                ],
                'default' => '8',
            ],
            [
                'id' => 'event_single_sidebar_sticky',
                'type' => 'switch',
                'title' => esc_html__('Sticky Sidebar', 'lunfest'),
                'default' => false,
                'required' => ['event_single_sidebar_layout', '!=', 'none'],
            ],
            [
                'id' => 'event_single_sidebar_gap',
                'title' => esc_html__( 'Sidebar Side Gap', 'lunfest' ),
                'type' => 'select',
                'required' => [ 'event_single_sidebar_layout', '!=', 'none' ],
                'options' => [
                    'def' => esc_html__( 'Default', 'lunfest' ),
                    '0' => esc_html( '15' ),
                    '15' => esc_html( '30' ),
                    '20' => esc_html( '35' ),
                    '25' => esc_html( '40' ),
                    '30' => esc_html( '45' ),
                    '35' => esc_html( '50' ),
                    '40' => esc_html( '55' ),
                    '45' => esc_html( '60' ),
                ],
                'default' => 'def',
            ],
            [
                'id' => 'event_single_sidebar-end',
                'type' => 'section',
                'indent' => false,
            ],

            [
                'id' => 'event_single_appearance-start',
                'title' => esc_html__('Appearance', 'lunfest'),
                'type' => 'section',
                'indent' => true,
            ],
            [
                'id' => 'event_featured_image_type',
                'title' => esc_html__('Featured Image', 'lunfest'),
                'type' => 'button_set',
                'options' => [
                    'default' => esc_html__('Default', 'lunfest'),
                    'off' => esc_html__('Off', 'lunfest'),
                    'replace' => esc_html__('Replace', 'lunfest')
                ],
                'default' => 'default',
            ],
            [
                'id' => 'event_featured_image_replace',
                'title' => esc_html__('Image To Replace On', 'lunfest'),
                'type' => 'media',
                'required' => ['event_featured_image_type', '=', 'replace'],
            ],
            [
                'id' => 'event_single_apply_animation',
                'title' => esc_html__('Apply Animation?', 'lunfest'),
                'type' => 'switch',
                'required' => ['event_single_type_layout', '=', '3'],
                'desc' => lunfest_quick_tip(
                    wp_kses(
                        __('Fade out the Post Title during page scrolling. <br>Note: affects only <code>Overlay Image</code> post layouts', 'lunfest'),
                        ['br' => [], 'code' => []]
                    )
                ),
                'on' => esc_html__('Yes', 'lunfest'),
                'off' => esc_html__('No', 'lunfest'),
                'default' => true,
            ],
            [
                'id' => 'event_single_likes',
                'title' => esc_html__('Likes', 'lunfest'),
                'type' => 'switch',
                'on' => esc_html__('Use', 'lunfest'),
                'off' => esc_html__('Hide', 'lunfest'),
                'default' => false,
            ],
            [
                'id' => 'event_single_views',
                'title' => esc_html__('Views', 'lunfest'),
                'type' => 'switch',
                'on' => esc_html__('Use', 'lunfest'),
                'off' => esc_html__('Hide', 'lunfest'),
                'default' => false,
            ],
            [
                'id' => 'event_single_share',
                'title' => esc_html__('Shares', 'lunfest'),
                'type' => 'switch',
                'on' => esc_html__('Use', 'lunfest'),
                'off' => esc_html__('Hide', 'lunfest'),
                'default' => false,
            ],
            [
                'id' => 'event_single_meta_tags',
                'title' => esc_html__('Tags', 'lunfest'),
                'type' => 'switch',
                'on' => esc_html__('Use', 'lunfest'),
                'off' => esc_html__('Hide', 'lunfest'),
                'default' => false,
            ],
            [
                'id' => 'event_single_meta',
                'title' => esc_html__('Hide all post-meta?', 'lunfest'),
                'type' => 'switch',
                'on' => esc_html__('Yes', 'lunfest'),
                'off' => esc_html__('No', 'lunfest'),
                'default' => false,
            ],
            [
                'id' => 'event_single_meta_author',
                'title' => esc_html__('Hide post-meta author?', 'lunfest'),
                'type' => 'switch',
                'required' => ['event_single_meta', '=', false],
                'on' => esc_html__('Yes', 'lunfest'),
                'off' => esc_html__('No', 'lunfest'),
                'default' => true,
            ],
            [
                'id' => 'event_single_meta_comments',
                'title' => esc_html__('Hide post-meta comments?', 'lunfest'),
                'type' => 'switch',
                'required' => ['event_single_meta', '=', false],
                'on' => esc_html__('Yes', 'lunfest'),
                'off' => esc_html__('No', 'lunfest'),
                'default' => true,
            ],
            [
                'id' => 'event_single_meta_categories',
                'title' => esc_html__('Hide post-meta categories?', 'lunfest'),
                'type' => 'switch',
                'required' => ['event_single_meta', '=', false],
                'on' => esc_html__('Yes', 'lunfest'),
                'off' => esc_html__('No', 'lunfest'),
                'default' => false,
            ],
            [
                'id' => 'event_single_meta_date',
                'title' => esc_html__('Hide post-meta date?', 'lunfest'),
                'type' => 'switch',
                'required' => ['event_single_meta', '=', false],
                'on' => esc_html__('Yes', 'lunfest'),
                'off' => esc_html__('No', 'lunfest'),
                'default' => false,
            ],
            [
                'id' => 'event_single_appearance-end',
                'type' => 'section',
                'indent' => false,
            ],
        ],
    ]);

    Redux::set_section($theme_slug, [
        'title' => esc_html__('Related', 'lunfest'),
        'id' => 'events-related-option',
        'subsection' => true,
        'fields' => [
            [
                'id' => 'event_single_related_posts',
                'title' => esc_html__('Related Posts', 'lunfest'),
                'type' => 'switch',
                'default' => true,
            ],
            [
                'id' => 'event_title_r',
                'title' => esc_html__('Related Section Title', 'lunfest'),
                'type' => 'text',
                'required' => ['event_single_related_posts', '=', '1'],
                'default' => esc_html__('Related Posts', 'lunfest'),
            ],
            [
                'id'       => 'event_cat_r',
                'type'     => 'select',
                'multi'    => true,
                'title'    => esc_html__( 'Select Categories', 'lunfest' ),
                'data'     => 'terms',
                'width'    => '20%',
                'args' => array('taxonomies'=>'event-categories', 'args'=>array()),
                'required' => ['event_single_related_posts', '=', '1'],
            ],
            [
                'id' => 'event_scope_r',
                'title' => esc_html__( 'Scope', 'lunfest' ),
                'type' => 'select',
                'required' => ['event_single_related_posts', '=', '1'],
                'options' => [
                    'all_events' => esc_html__('All events','lunfest'),
                    'future' => esc_html__('Future events','lunfest'),
                    'past' => esc_html__('Past events','lunfest'),
                    'today' => esc_html__('Today\'s events','lunfest'),
                    'tomorrow' => esc_html__('Tomorrow\'s events','lunfest'),
                    'month' => esc_html__('Events this month','lunfest'),
                    'next-month' => esc_html__('Events next month','lunfest'),
                    '1-months'  => esc_html__('Events current and next month','lunfest'),
                    '2-months'  => esc_html__('Events within 2 months','lunfest'),
                    '3-months'  => esc_html__('Events within 3 months','lunfest'),
                    '6-months'  => esc_html__('Events within 6 months','lunfest'),
                    '12-months' => esc_html__('Events within 12 months','lunfest')
                ],
                'default' => 'all_events',
            ],
            [
                'id' => 'event_column_r',
                'title' => esc_html__('Columns', 'lunfest'),
                'type' => 'button_set',
                'required' => ['event_single_related_posts', '=', '1'],
                'options' => [
                    '12' => '1',
                    '6' => '2',
                    '4' => '3',
                    '3' => '4'
                ],
                'default' => '4',
            ],
            [
                'id' => 'event_number_r',
                'title' => esc_html__('Number of Related Items', 'lunfest'),
                'type' => 'text',
                'required' => ['event_single_related_posts', '=', '1'],
                'default' => '3',
            ],
            [
                'id' => 'event_carousel_r',
                'title' => esc_html__('Display items in the carousel', 'lunfest'),
                'type' => 'switch',
                'required' => ['event_single_related_posts', '=', '1'],
                'default' => true,
            ],
        ],
    ]);

    Redux::set_section($theme_slug, [
        'title' => esc_html__('Single Location', 'lunfest'),
        'id' => 'events-location-option',
        'subsection' => true,
        'fields' => [
            [
                'id' => 'location_title_conditional',
                'title' => esc_html__('Location Title Text', 'lunfest'),
                'type' => 'switch',
                'on' => esc_html__('Location Type Name', 'lunfest'),
                'off' => esc_html__('Location Title', 'lunfest'),
                'default' => true,
            ],
            [
                'id' => 'location_single_type_layout',
                'title' => esc_html__('Default Location Single Type', 'lunfest'),
                'type' => 'button_set',
                'desc' => esc_html__('Note: each Post can be separately customized within its Metaboxes section.', 'lunfest'),
                'options' => [
                    '1' => esc_html__('Title First', 'lunfest'),
                    '2' => esc_html__('Image First', 'lunfest'),
                    '3' => esc_html__('Overlay Image', 'lunfest')
                ],
                'default' => '2',
            ],
            [
                'id' => 'location_single_page_title-start',
                'title' => esc_html__('Page Title', 'lunfest'),
                'type' => 'section',
                'required' => ['page_title_switch', '=', '1'],
                'indent' => true,
            ],
            [
                'id' => 'location_title_conditional',
                'title' => esc_html__('Page Title Text', 'lunfest'),
                'type' => 'switch',
                'on' => esc_html__('Post Type Name', 'lunfest'),
                'off' => esc_html__('Post Title', 'lunfest'),
                'default' => true,
            ],
            [
                'id' => 'location_single__page_title_breadcrumbs_switch',
                'title' => esc_html__('Breadcrumbs', 'lunfest'),
                'type' => 'switch',
                'required' => ['location_single_type_layout', '!=', '3'],
                'on' => esc_html__('Use', 'lunfest'),
                'off' => esc_html__('Hide', 'lunfest'),
                'default' => true,
            ],
            [
                'id' => 'location_single__page_title_bg_switch',
                'title' => esc_html__('Use Background Image/Color?', 'lunfest'),
                'type' => 'switch',
                'required' => ['location_single_type_layout', '!=', '3'],
                'on' => esc_html__('Use', 'lunfest'),
                'off' => esc_html__('Hide', 'lunfest'),
                'default' => true,
            ],
            [
                'id' => 'location_single__page_title_bg_image',
                'title' => esc_html__('Background Image/Color', 'lunfest'),
                'type' => 'background',
                'required' => ['location_single_type_layout', '!=', '3'],
                'preview' => false,
                'preview_media' => true,
                'background-color' => true,
                'transparent' => false,
                'default' => [
                    'background-repeat' => 'repeat',
                    'background-size' => 'cover',
                    'background-attachment' => 'scroll',
                    'background-position' => 'center center',
                ],
            ],
            [
                'id' => 'location_single_layout_3_bg_image',
                'type' => 'background',
                'title' => esc_html__('Default Background', 'lunfest'),
                'required' => ['location_single_type_layout', '=', '3'],
                'desc' => esc_html__('Note: If Featured Image doesn\'t exist.', 'lunfest'),
                'preview' => false,
                'preview_media' => true,
                'background-color' => true,
                'transparent' => false,
                'background-repeat' => false,
                'background-size' => false,
                'background-attachment' => false,
                'background-position' => false,
                'default' => [
                    'background-color' => '#3a3a3a',
                ],
            ],
            [
                'id' => 'location_single_padding_layout_3',
                'type' => 'spacing',
                'title' => esc_html__('Padding Top/Bottom', 'lunfest'),
                'required' => ['location_single_type_layout', '=', '3'],
                'mode' => 'padding',
                'all' => false,
                'top' => true,
                'right' => false,
                'bottom' => true,
                'left' => false,
                'default' => [
                    'padding-top' => '355',
                    'padding-bottom' => '0',
                ],
            ],
            [
                'id' => 'location_single_page_title-end',
                'type' => 'section',
                'indent' => false,
            ],
            [
                'id' => 'location_single_sidebar-start',
                'type' => 'section',
                'title' => esc_html__('Sidebar', 'lunfest'),
                'indent' => true,
            ],
            [
                'id' => 'location_single_sidebar_layout',
                'title' => esc_html__('Sidebar Layout', 'lunfest'),
                'type' => 'image_select',
                'options' => [
                    'none' => [
                        'alt' => esc_html__('None', 'lunfest'),
                        'img' => get_template_directory_uri() . '/core/admin/img/options/1col.png'
                    ],
                    'left' => [
                        'alt' => esc_html__('Left', 'lunfest'),
                        'img' => get_template_directory_uri() . '/core/admin/img/options/2cl.png'
                    ],
                    'right' => [
                        'alt' => esc_html__('Right', 'lunfest'),
                        'img' => get_template_directory_uri() . '/core/admin/img/options/2cr.png'
                    ]
                ],
                'default' => 'none'
            ],
            [
                'id' => 'single_sidebar_def',
                'title' => esc_html__('Sidebar Template', 'lunfest'),
                'type' => 'select',
                'required' => ['single_sidebar_layout', '!=', 'none'],
                'data' => 'sidebars',
                'default' => 'sidebar_main-sidebar',
            ],
            [
                'id' => 'location_single_sidebar_def_width',
                'title' => esc_html__('Sidebar Width', 'lunfest'),
                'type' => 'button_set',
                'required' => ['location_single_sidebar_layout', '!=', 'none'],
                'options' => [
                    '9' => esc_html( '25%' ),
                    '8' => esc_html( '33%' ),
                ],
                'default' => '8',
            ],
            [
                'id' => 'location_single_sidebar_sticky',
                'type' => 'switch',
                'title' => esc_html__('Sticky Sidebar', 'lunfest'),
                'default' => false,
                'required' => ['location_single_sidebar_layout', '!=', 'none'],
            ],
            [
                'id' => 'location_single_sidebar_gap',
                'title' => esc_html__( 'Sidebar Side Gap', 'lunfest' ),
                'type' => 'select',
                'required' => [ 'location_single_sidebar_layout', '!=', 'none' ],
                'options' => [
                    'def' => esc_html__( 'Default', 'lunfest' ),
                    '0' => esc_html( '15' ),
                    '15' => esc_html( '30' ),
                    '20' => esc_html( '35' ),
                    '25' => esc_html( '40' ),
                    '30' => esc_html( '45' ),
                    '35' => esc_html( '50' ),
                    '40' => esc_html( '55' ),
                    '45' => esc_html( '60' ),
                ],
                'default' => 'def',
            ],
            [
                'id' => 'location_single_sidebar-end',
                'type' => 'section',
                'indent' => false,
            ],

            [
                'id' => 'location_single_appearance-start',
                'title' => esc_html__('Appearance', 'lunfest'),
                'type' => 'section',
                'indent' => true,
            ],
            [
                'id' => 'location_featured_image_type',
                'title' => esc_html__('Featured Image', 'lunfest'),
                'type' => 'button_set',
                'options' => [
                    'default' => esc_html__('Default', 'lunfest'),
                    'off' => esc_html__('Off', 'lunfest'),
                    'replace' => esc_html__('Replace', 'lunfest')
                ],
                'default' => 'default',
            ],
            [
                'id' => 'location_featured_image_replace',
                'title' => esc_html__('Image To Replace On', 'lunfest'),
                'type' => 'media',
                'required' => ['location_featured_image_type', '=', 'replace'],
            ],
            [
                'id' => 'location_single_apply_animation',
                'title' => esc_html__('Apply Animation?', 'lunfest'),
                'type' => 'switch',
                'required' => ['location_single_type_layout', '=', '3'],
                'desc' => lunfest_quick_tip(
                    wp_kses(
                        __('Fade out the Post Title during page scrolling. <br>Note: affects only <code>Overlay Image</code> post layouts', 'lunfest'),
                        ['br' => [], 'code' => []]
                    )
                ),
                'on' => esc_html__('Yes', 'lunfest'),
                'off' => esc_html__('No', 'lunfest'),
                'default' => true,
            ],
            [
                'id' => 'location_single_appearance-end',
                'type' => 'section',
                'indent' => false,
            ],
        ],
    ]);
}

if (class_exists('WooCommerce')) {
    Redux::set_section(
        $theme_slug,
        [
            'id' => 'shop-option',
            'title' => esc_html__('Shop', 'lunfest'),
            'icon' => 'el-icon-shopping-cart',
            'fields' => []
        ]
    );

    Redux::set_section(
        $theme_slug,
        [
            'id' => 'shop-catalog-option',
            'title' => esc_html__('Catalog', 'lunfest'),
            'subsection' => true,
            'fields' => [
                [
                    'id' => 'shop_catalog__page_title_bg_image',
                    'title' => esc_html__('Page Title Background Image', 'lunfest'),
                    'type' => 'background',
                    'required' => ['page_title_switch', '=', true],
                    'preview' => false,
                    'preview_media' => true,
                    'background-color' => false,
                    'default' => [
                        'background-repeat' => 'repeat',
                        'background-size' => 'cover',
                        'background-attachment' => 'scroll',
                        'background-position' => 'center center',
                        'background-color' => '',
                    ]
                ],
                [
                    'id' => 'shop_catalog_sidebar-start',
                    'title' => esc_html__('Sidebar Settings', 'lunfest'),
                    'type' => 'section',
                    'indent' => true,
                ],
                [
                    'id' => 'shop_catalog_sidebar_layout',
                    'title' => esc_html__('Sidebar Layout', 'lunfest'),
                    'type' => 'image_select',
                    'options' => [
                        'none' => [
                            'alt' => esc_html__('None', 'lunfest'),
                            'img' => get_template_directory_uri() . '/core/admin/img/options/1col.png'
                        ],
                        'left' => [
                            'alt' => esc_html__('Left', 'lunfest'),
                            'img' => get_template_directory_uri() . '/core/admin/img/options/2cl.png'
                        ],
                        'right' => [
                            'alt' => esc_html__('Right', 'lunfest'),
                            'img' => get_template_directory_uri() . '/core/admin/img/options/2cr.png'
                        ],
                    ],
                    'default' => 'left',
                ],
                [
                    'id' => 'shop_catalog_sidebar_def',
                    'title' => esc_html__('Shop Catalog Sidebar', 'lunfest'),
                    'type' => 'select',
                    'required' => ['shop_catalog_sidebar_layout', '!=', 'none'],
                    'data' => 'sidebars',
                ],
                [
                    'id' => 'shop_catalog_sidebar_def_width',
                    'title' => esc_html__('Shop Sidebar Width', 'lunfest'),
                    'type' => 'button_set',
                    'required' => ['shop_catalog_sidebar_layout', '!=', 'none'],
                    'options' => [
                        '9' => esc_html( '25%' ),
                        '8' => esc_html( '33%' ),
                    ],
                    'default' => '9',
                ],
                [
                    'id' => 'shop_catalog_sidebar_sticky',
                    'title' => esc_html__('Sticky Sidebar', 'lunfest'),
                    'type' => 'switch',
                    'required' => ['shop_catalog_sidebar_layout', '!=', 'none'],
                    'default' => false,
                ],
                [
                    'id' => 'shop_catalog_sidebar_gap',
                    'title' => esc_html__( 'Sidebar Side Gap', 'lunfest' ),
                    'type' => 'select',
                    'required' => [ 'shop_catalog_sidebar_layout', '!=', 'none' ],
                    'options' => [
                        'def' => esc_html__( 'Default', 'lunfest' ),
                        '0' => esc_html( '15' ),
	                    '15' => esc_html( '30' ),
	                    '20' => esc_html( '35' ),
	                    '25' => esc_html( '40' ),
	                    '30' => esc_html( '45' ),
	                    '35' => esc_html( '50' ),
	                    '40' => esc_html( '55' ),
	                    '45' => esc_html( '60' ),
                    ],
                    'default' => 'def',
                ],
                [
                    'id' => 'shop_catalog_sidebar-end',
                    'type' => 'section',
                    'indent' => false,
                ],
                [
                    'id' => 'shop_products_appearance-start',
                    'title' => esc_html__('Appearance', 'lunfest'),
                    'type' => 'section',
                    'indent' => true,
                ],
                [
                    'id' => 'shop_column',
                    'title' => esc_html__('Shop Column', 'lunfest'),
                    'type' => 'button_set',
                    'options' => [
                        '1' => esc_html('1'),
                        '2' => esc_html('2'),
                        '3' => esc_html('3'),
                        '4' => esc_html('4'),
                    ],
                    'default' => '3',
                ],
                [
                    'id' => 'shop_products_per_page',
                    'title' => esc_html__('Products per page', 'lunfest'),
                    'type' => 'spinner',
                    'min' => '1',
                    'max' => '100',
                    'default' => '12',
                ],
                [
                    'id' => 'use_animation_shop',
                    'title' => esc_html__('Use Animation Shop?', 'lunfest'),
                    'type' => 'switch',
                    'default' => true,
                ],
                [
                    'id' => 'shop_catalog_animation_style',
                    'title' => esc_html__('Animation Style', 'lunfest'),
                    'type' => 'select',
                    'required' => ['use_animation_shop', '=', true],
                    'select2' => ['allowClear' => false],
                    'options' => [
                        'fade-in' => esc_html__('Fade In', 'lunfest'),
                        'slide-top' => esc_html__('Slide Top', 'lunfest'),
                        'slide-bottom' => esc_html__('Slide Bottom', 'lunfest'),
                        'slide-left' => esc_html__('Slide Left', 'lunfest'),
                        'slide-right' => esc_html__('Slide Right', 'lunfest'),
                        'zoom' => esc_html__('Zoom', 'lunfest'),
                    ],
                    'default' => 'slide-left',
                ],
                [
                    'id' => 'shop_products_stars',
                    'title' => esc_html__('Star Rating', 'lunfest'),
                    'type' => 'switch',
                    'on' => esc_html__('Use', 'lunfest'),
                    'off' => esc_html__('Hide', 'lunfest'),
                    'default' => true,
                ],
	            [
		            'id' => 'shop_products_overlay',
		            'title' => esc_html__('Overlay Background Color for Products', 'lunfest'),
		            'type' => 'color_rgba',
		            'mode' => 'background',
		            'default' => [
			            'alpha' => '0',
			            'rgba' => 'rgba(255,255,255,0)',
			            'color' => '#ffffff',
		            ],
	            ],
            ]
        ]
    );

    Redux::set_section(
        $theme_slug,
        [
            'id' => 'shop-single-option',
            'title' => esc_html__('Single', 'lunfest'),
            'subsection' => true,
            'fields' => [
                [
                    'id' => 'shop_single_page_title-start',
                    'title' => esc_html__('Page Title Settings', 'lunfest'),
                    'type' => 'section',
                    'required' => ['page_title_switch', '=', true],
                    'indent' => true,
                ],
                [
                    'id' => 'shop_title_conditional',
                    'title' => esc_html__('Page Title Text', 'lunfest'),
                    'type' => 'switch',
                    'on' => esc_html__('Post Type Name', 'lunfest'),
                    'off' => esc_html__('Post Title', 'lunfest'),
                    'default' => true,
                ],
                [
                    'id' => 'shop_single_title_align',
                    'title' => esc_html__('Title Alignment', 'lunfest'),
                    'type' => 'button_set',
                    'options' => [
                        'left' => esc_html__('Left', 'lunfest'),
                        'center' => esc_html__('Center', 'lunfest'),
                        'right' => esc_html__('Right', 'lunfest'),
                    ],
                    'default' => 'center',
                ],
                [
                    'id' => 'shop_single_breadcrumbs_block_switch',
                    'title' => esc_html__('Breadcrumbs Display', 'lunfest'),
                    'type' => 'switch',
                    'required' => ['page_title_breadcrumbs_switch', '=', true],
                    'on' => esc_html__('Block', 'lunfest'),
                    'off' => esc_html__('Inline', 'lunfest'),
                    'default' => true,
                ],
                [
                    'id' => 'shop_single_breadcrumbs_align',
                    'title' => esc_html__('Title Breadcrumbs Alignment', 'lunfest'),
                    'type' => 'button_set',
                    'required' => [
                        ['page_title_breadcrumbs_switch', '=', true],
                        ['shop_single_breadcrumbs_block_switch', '=', true]
                    ],
                    'options' => [
                        'left' => esc_html__('Left', 'lunfest'),
                        'center' => esc_html__('Center', 'lunfest'),
                        'right' => esc_html__('Right', 'lunfest'),
                    ],
                    'default' => 'center',
                ],
                [
                    'id' => 'shop_single__page_title_bg_switch',
                    'title' => esc_html__('Use Background Image/Color?', 'lunfest'),
                    'type' => 'switch',
                    'on' => esc_html__('Use', 'lunfest'),
                    'off' => esc_html__('Hide', 'lunfest'),
                    'default' => true,
                ],
                [
                    'id' => 'shop_single__page_title_bg_image',
                    'title' => esc_html__('Background Image/Color', 'lunfest'),
                    'type' => 'background',
                    'required' => ['shop_single__page_title_bg_switch', '=', true],
                    'preview' => false,
                    'preview_media' => true,
                    'background-color' => true,
                    'transparent' => false,
                    'default' => [
                        'background-repeat' => 'repeat',
                        'background-size' => 'cover',
                        'background-attachment' => 'scroll',
                        'background-position' => 'center center',
                        'background-color' => '',
                    ],
                ],
                [
                    'id' => 'shop_single__page_title_padding',
                    'title' => esc_html__('Paddings Top/Bottom', 'lunfest'),
                    'type' => 'spacing',
                    'mode' => 'padding',
                    'all' => false,
                    'bottom' => true,
                    'top' => true,
                    'left' => false,
                    'right' => false,
                ],
                [
                    'id' => 'shop_single__page_title_margin',
                    'title' => esc_html__('Margin Bottom', 'lunfest'),
                    'type' => 'spacing',
                    'mode' => 'margin',
                    'all' => false,
                    'bottom' => true,
                    'top' => false,
                    'left' => false,
                    'right' => false,
                    'default' => ['margin-bottom' => '50'],
                ],
                [
                    'id' => 'shop_single_page_title-end',
                    'type' => 'section',
                    'indent' => false,
                ],
                [
                    'id' => 'shop_single_sidebar-start',
                    'title' => esc_html__('Sidebar Settings', 'lunfest'),
                    'type' => 'section',
                    'indent' => true,
                ],
                [
                    'id' => 'shop_single_sidebar_layout',
                    'title' => esc_html__('Sidebar Layout', 'lunfest'),
                    'type' => 'image_select',
                    'options' => [
                        'none' => [
                            'alt' => esc_html__('None', 'lunfest'),
                            'img' => get_template_directory_uri() . '/core/admin/img/options/1col.png'
                        ],
                        'left' => [
                            'alt' => esc_html__('Left', 'lunfest'),
                            'img' => get_template_directory_uri() . '/core/admin/img/options/2cl.png'
                        ],
                        'right' => [
                            'alt' => esc_html__('Right', 'lunfest'),
                            'img' => get_template_directory_uri() . '/core/admin/img/options/2cr.png'
                        ],
                    ],
                    'default' => 'none',
                ],
                [
                    'id' => 'shop_single_sidebar_def',
                    'title' => esc_html__('Sidebar Template', 'lunfest'),
                    'type' => 'select',
                    'required' => ['shop_single_sidebar_layout', '!=', 'none'],
                    'data' => 'sidebars',
                ],
                [
                    'id' => 'shop_single_sidebar_def_width',
                    'title' => esc_html__('Sidebar Width', 'lunfest'),
                    'type' => 'button_set',
                    'required' => ['shop_single_sidebar_layout', '!=', 'none'],
                    'options' => [
                        '9' => esc_html( '25%' ),
                        '8' => esc_html( '33%' ),
                    ],
                    'default' => '9',
                ],
                [
                    'id' => 'shop_single_sidebar_sticky',
                    'title' => esc_html__('Sticky Sidebar', 'lunfest'),
                    'type' => 'switch',
                    'required' => ['shop_single_sidebar_layout', '!=', 'none'],
                    'default' => false,
                ],
                [
                    'id' => 'shop_single_sidebar_gap',
                    'title' => esc_html__( 'Sidebar Side Gap', 'lunfest' ),
                    'type' => 'select',
                    'required' => [ 'shop_single_sidebar_layout', '!=', 'none' ],
                    'options' => [
                        'def' => esc_html__( 'Default', 'lunfest' ),
                        '0' => esc_html( '15' ),
	                    '15' => esc_html( '30' ),
	                    '20' => esc_html( '35' ),
	                    '25' => esc_html( '40' ),
	                    '30' => esc_html( '45' ),
	                    '35' => esc_html( '50' ),
	                    '40' => esc_html( '55' ),
	                    '45' => esc_html( '60' ),
                    ],
                    'default' => 'def',
                ],
                [
                    'id' => 'shop_single_sidebar-end',
                    'type' => 'section',
                    'indent' => false,
                ],
            ]
        ]
    );

    Redux::set_section(
        $theme_slug,
        [
            'title' => esc_html__('Related', 'lunfest'),
            'id' => 'shop-related-option',
            'subsection' => true,
            'fields' => [
                [
                    'id' => 'shop_related_columns',
                    'title' => esc_html__('Related products column', 'lunfest'),
                    'type' => 'button_set',
                    'options' => [
                        '1' => esc_html('1'),
                        '2' => esc_html('2'),
                        '3' => esc_html('3'),
                        '4' => esc_html('4'),
                    ],
                    'default' => '4',
                ],
                [
                    'id' => 'shop_r_products_per_page',
                    'title' => esc_html__('Related products per page', 'lunfest'),
                    'type' => 'spinner',
                    'min' => '1',
                    'max' => '100',
                    'default' => '4',
                ],
            ]
        ]
    );

    Redux::set_section(
        $theme_slug,
        [
            'title' => esc_html__('Cart', 'lunfest'),
            'id' => 'shop-cart-option',
            'subsection' => true,
            'fields' => [
                [
                    'id' => 'shop_cart__page_title_bg_image',
                    'title' => esc_html__('Page Title Background Image', 'lunfest'),
                    'type' => 'background',
                    'required' => ['page_title_switch', '=', true],
                    'background-color' => false,
                    'preview_media' => true,
                    'preview' => false,
                    'default' => [
                        'background-repeat' => 'repeat',
                        'background-size' => 'cover',
                        'background-attachment' => 'scroll',
                        'background-position' => 'center center',
                        'background-color' => '',
                    ],
                ],
            ]
        ]
    );

    Redux::set_section(
        $theme_slug,
        [
            'id' => 'shop-checkout-option',
            'title' => esc_html__('Checkout', 'lunfest'),
            'subsection' => true,
            'fields' => [
                [
                    'id' => 'shop_checkout__page_title_bg_image',
                    'title' => esc_html__('Page Title Background Image', 'lunfest'),
                    'type' => 'background',
                    'required' => ['page_title_switch', '=', true],
                    'background-color' => false,
                    'preview_media' => true,
                    'preview' => false,
                    'default' => [
                        'background-repeat' => 'repeat',
                        'background-size' => 'cover',
                        'background-attachment' => 'scroll',
                        'background-position' => 'center center',
                        'background-color' => '',
                    ],
                ],
            ]
        ]
    );
}

$advanced_fields = [
    [
        'id' => 'advanced_warning',
        'title' => esc_html__('Attention! This tab stores functionality that can harm site reliability.', 'lunfest'),
        'type' => 'info',
        'desc' => esc_html__('Site troublefree operation is not ensured, if any of the following options is changed.', 'lunfest'),
        'style' => 'critical',
        'icon' => 'el el-warning-sign',
    ],
    [
        'id' => 'advanced_divider',
        'type' => 'divide'
    ],
    [
        'id' => 'advanced-wp-start',
        'title' => esc_html__('WordPress', 'lunfest'),
        'type' => 'section',
        'indent' => true,
    ],
    [
        'id' => 'disable_wp_gutenberg',
        'title' => esc_html__('Gutenberg Stylesheet', 'lunfest'),
        'type' => 'switch',
        'desc' => esc_html__('Dequeue CSS files.', 'lunfest') . lunfest_quick_tip(
            wp_kses(
                __('Eliminates <code>wp-block-library-css</code> stylesheet. <br>Before disabling ensure that Gutenberg editor is not used anywhere throughout the site.', 'lunfest'),
                ['br' => [], 'code' => []]
            )
        ),
        'on' => esc_html__('Dequeue', 'lunfest'),
        'off' => esc_html__('Default', 'lunfest'),
    ],
    [
        'id' => 'advanced-wp-end',
        'type' => 'section',
        'indent' => false,
    ],
];

if (class_exists('Elementor\Plugin')) {
    $advanced_elementor = [
        [
            'id' => 'advanced-elementor-start',
            'title' => esc_html__('Elementor', 'lunfest'),
            'type' => 'section',
            'indent' => true,
        ],
        [
            'id' => 'disable_elementor_googlefonts',
            'title' => esc_html__('Google Fonts', 'lunfest'),
            'type' => 'switch',
            'desc' => esc_html__('Dequeue font pack.', 'lunfest') . lunfest_quick_tip(sprintf(
                '%s <a href="%s" target="_blank">%s</a>%s',
                esc_html__('See: ', 'lunfest'),
                esc_url('https://docs.elementor.com/article/286-speed-up-a-slow-site'),
                esc_html__('Optimizing a Slow Site w/ Elementor', 'lunfest'),
                wp_kses(
                    __('<br>Note: breaks all fonts selected within <code>Group_Control_Typography</code> (if any). Has no affect on <code>Theme Options->Typography</code> fonts.', 'lunfest'),
                    ['br' => [], 'code' => []]
                )
            )),
            'on' => esc_html__('Disable', 'lunfest'),
            'off' => esc_html__('Default', 'lunfest'),
        ],
        [
            'id' => 'disable_elementor_fontawesome',
            'title' => esc_html__('Font Awesome Pack', 'lunfest'),
            'type' => 'switch',
            'desc' => esc_html__('Dequeue icon pack.', 'lunfest')
                . lunfest_quick_tip(esc_html__('Note: Font Awesome is essential for Lunfest theme. Disable only if it already enqueued by some other plugin.', 'lunfest')),
            'on' => esc_html__('Disable', 'lunfest'),
            'off' => esc_html__('Default', 'lunfest'),
        ],
        [
            'id' => 'advanced-elelemntor-end',
            'type' => 'section',
            'indent' => false,
        ],
    ];
    array_push($advanced_fields, ...$advanced_elementor);
}

Redux::set_section(
    $theme_slug,
    [
        'id' => 'advanced',
        'title' => esc_html__('Advanced', 'lunfest'),
        'icon' => 'el el-warning-sign',
        'fields' => $advanced_fields
    ]
);
