<?php

use WGL_Extensions\WGL_Framework_Global_Variables as WGL_Globals;

function lunfest_get_default_option()
{
	$default_theme_options = '{"last_tab":"","use_minified":"","preloader":"","preloader_background":"#ffffff","preloader_color":"#9d99f2","search_style":"standard_fw","cursor_switch":"1","cursor_color":{"color":"#9d99f2","alpha":"0","rgba":"rgba(60,133,153,0)"},"scroll_up":"1","scroll_up_appearance":"","scroll_up_text":"BACK TO TOP","scroll_up_arrow_color":"#ffffff","scroll_up_arrow_color_bg":"#2e2e2e","custom_js":"","header_custom_js":"","header_switch":"1","header_building_tool":"default","header_page_select":"","bottom_header_layout":{"items":{"placebo":"placebo","html1":"{\"title\":\"HTML 1\",\"settings\":true}","html2":"{\"title\":\"HTML 2\",\"settings\":true}","html3":"{\"title\":\"HTML 3\",\"settings\":true}","html4":"{\"title\":\"HTML 4\",\"settings\":true}","html5":"{\"title\":\"HTML 5\",\"settings\":true}","html6":"{\"title\":\"HTML 6\",\"settings\":true}","html7":"{\"title\":\"HTML 7\",\"settings\":true}","html8":"{\"title\":\"HTML 8\",\"settings\":true}","delimiter1":"{\"title\":\"|\",\"settings\":true}","delimiter2":"{\"title\":\"|\",\"settings\":true}","delimiter3":"{\"title\":\"|\",\"settings\":true}","delimiter4":"{\"title\":\"|\",\"settings\":true}","delimiter5":"{\"title\":\"|\",\"settings\":true}","delimiter6":"{\"title\":\"|\",\"settings\":true}","spacer3":"{\"title\":\"Spacer 3\",\"settings\":true}","spacer4":"{\"title\":\"Spacer 4\",\"settings\":true}","spacer5":"{\"title\":\"Spacer 5\",\"settings\":true}","spacer6":"{\"title\":\"Spacer 6\",\"settings\":true}","spacer7":"{\"title\":\"Spacer 7\",\"settings\":true}","spacer8":"{\"title\":\"Spacer 8\",\"settings\":true}","button1":"{\"title\":\"Button\",\"settings\":true}","button2":"{\"title\":\"Button\",\"settings\":true}","wpml":"{\"title\":\"WPML\",\"settings\":false}","cart":"{\"title\":\"Cart\",\"settings\":true}","login":"{\"title\":\"WC Login\",\"settings\":false}","side_panel":"{\"title\":\"Side Panel\",\"settings\":true}"},"Top Left area":{"disable_row":"false","placebo":"placebo"},"Top Center area":{"placebo":"placebo"},"Top Right area":{"placebo":"placebo"},"Middle Left area":{"disable_row":"false","placebo":"placebo","spacer1":"{\"title\":\"Spacer 1\",\"settings\":false}","logo":"{\"title\":\"Logo\",\"settings\":false}"},"Middle Center area":{"placebo":"placebo","menu":"{\"title\":\"Menu\",\"settings\":false}"},"Middle Right area":{"placebo":"placebo","item_search":"{\"title\":\"Search\",\"settings\":true}","spacer2":"{\"title\":\"Spacer 2\",\"settings\":false}"},"Bottom Left area":{"disable_row":"false","placebo":"placebo"},"Bottom Center area":{"placebo":"placebo"},"Bottom Right area":{"placebo":"placebo"}},"bottom_header_spacer1":{"width":"40px","units":"px"},"bottom_header_spacer2":{"width":"40px","units":"px"},"bottom_header_spacer3":{"width":"25px","units":"px"},"bottom_header_spacer4":{"width":"25px","units":"px"},"bottom_header_spacer5":{"width":"25px","units":"px"},"bottom_header_spacer6":{"width":"25px","units":"px"},"bottom_header_spacer7":{"width":"25px","units":"px"},"bottom_header_spacer8":{"width":"25px","units":"px"},"bottom_header_item_search_custom":"","bottom_header_item_search_color_txt":{"color":"#232323","alpha":"1","rgba":"rgba(35,35,35,1)"},"bottom_header_item_search_hover_color_txt":{"color":"#232323","alpha":"1","rgba":"rgba(35,35,35,1)"},"bottom_header_cart_custom":"","bottom_header_cart_color_txt":{"color":"#232323","alpha":"1","rgba":"rgba(35,35,35,1)"},"bottom_header_cart_hover_color_txt":{"color":"#232323","alpha":"1","rgba":"rgba(35,35,35,1)"},"bottom_header_delimiter1_height":{"height":"50px","units":"px"},"bottom_header_delimiter1_width":{"width":"1px","units":"px"},"bottom_header_delimiter1_bg":{"color":"#000000","alpha":"0.1","rgba":"rgba(0, 0, 0, 0.1)"},"bottom_header_delimiter1_margin":{"units":"px","margin-right":"30px","margin-left":"20px"},"bottom_header_delimiter2_height":{"height":"100px","units":"px"},"bottom_header_delimiter2_width":{"width":"1px","units":"px"},"bottom_header_delimiter2_bg":{"color":"#ffffff","alpha":".9","rgba":"rgba(255,255,255,0.9)"},"bottom_header_delimiter2_margin":{"units":"px","margin-right":"30px","margin-left":"30px"},"bottom_header_delimiter3_height":{"height":"100px","units":"px"},"bottom_header_delimiter3_width":{"width":"1px","units":"px"},"bottom_header_delimiter3_bg":{"color":"#ffffff","alpha":".9","rgba":"rgba(255,255,255,0.9)"},"bottom_header_delimiter3_margin":{"units":"px","margin-right":"30px","margin-left":"30px"},"bottom_header_delimiter4_height":{"height":"100px","units":"px"},"bottom_header_delimiter4_width":{"width":"1px","units":"px"},"bottom_header_delimiter4_bg":{"color":"#ffffff","alpha":".9","rgba":"rgba(255,255,255,0.9)"},"bottom_header_delimiter4_margin":{"units":"px","margin-right":"30px","margin-left":"30px"},"bottom_header_delimiter5_height":{"height":"100px","units":"px"},"bottom_header_delimiter5_width":{"width":"1px","units":"px"},"bottom_header_delimiter5_bg":{"color":"#ffffff","alpha":".9","rgba":"rgba(255,255,255,0.9)"},"bottom_header_delimiter5_margin":{"units":"px","margin-right":"30px","margin-left":"30px"},"bottom_header_delimiter6_height":{"height":"100px","units":"px"},"bottom_header_delimiter6_width":{"width":"1px","units":"px"},"bottom_header_delimiter6_bg":{"color":"#ffffff","alpha":".9","rgba":"rgba(255,255,255,0.9)"},"bottom_header_delimiter6_margin":{"units":"px","margin-right":"30px","margin-left":"30px"},"bottom_header_button1_title":"Contact Us","bottom_header_button1_link":"#","bottom_header_button1_target":"1","bottom_header_button1_size":"md","bottom_header_button1_radius":"","bottom_header_button1_custom":"","bottom_header_button1_color_txt":{"color":"#ffffff","alpha":"1","rgba":"rgba(255,255,255,1)"},"bottom_header_button1_hover_color_txt":{"color":"#232323","alpha":"1","rgba":"rgba(35,35,35,1)"},"bottom_header_button1_bg":{"color":"#232323","alpha":"1","rgba":"rgba(35,35,35,1)"},"bottom_header_button1_hover_bg":{"color":"#ffffff","alpha":"1","rgba":"rgba(255,255,255,1)"},"bottom_header_button1_border":{"color":"#232323","alpha":"1","rgba":"rgba(35,35,35,1)"},"bottom_header_button1_hover_border":{"color":"#232323","alpha":"1","rgba":"rgba(35,35,35,1)"},"bottom_header_button2_title":"Contact Us","bottom_header_button2_link":"","bottom_header_button2_target":"1","bottom_header_button2_size":"md","bottom_header_button2_radius":"","bottom_header_button2_custom":"","bottom_header_button2_color_txt":{"color":"#ffffff","alpha":"1","rgba":"rgba(255,255,255,1)"},"bottom_header_button2_hover_color_txt":{"color":"#232323","alpha":"1","rgba":"rgba(35,35,35,1)"},"bottom_header_button2_bg":{"color":"#232323","alpha":"1","rgba":"rgba(35,35,35,1)"},"bottom_header_button2_hover_bg":{"color":"#ffffff","alpha":"1","rgba":"rgba(255,255,255,1)"},"bottom_header_button2_border":{"color":"#232323","alpha":"1","rgba":"rgba(35,35,35,1)"},"bottom_header_button2_hover_border":{"color":"#232323","alpha":"1","rgba":"rgba(35,35,35,1)"},"bottom_header_bar_html1_editor":"","bottom_header_bar_html2_editor":"","bottom_header_bar_html3_editor":"","bottom_header_bar_html4_editor":"","bottom_header_bar_html5_editor":"","bottom_header_bar_html6_editor":"","bottom_header_bar_html7_editor":"","bottom_header_bar_html8_editor":"","bottom_header_side_panel_color":{"color":"#252525","alpha":"1","rgba":"rgba(38,38,38,1)"},"bottom_header_side_panel_background":{"color":"#ffffff","alpha":"0","rgba":"rgba(255,255,255,0)"},"header_top_full_width":"","header_top_max_width_custom":"","header_top_max_width":{"width":"1290px","units":"px"},"header_top_height":{"height":"49px","units":"px"},"header_top_background_image":{"url":"","id":"","height":"","width":"","thumbnail":""},"header_top_background":{"color":"#ffffff","alpha":"1","rgba":"rgba(255,255,255,1)"},"header_top_color":"#a2a2a2","header_top_bottom_border":"1","header_top_border_height":{"height":"1px","units":"px"},"header_top_bottom_border_color":{"color":"#a2a2a2","alpha":".2","rgba":"rgba(162,162,162,0.2)"},"header_middle_full_width":"1","header_middle_max_width_custom":"","header_middle_max_width":{"width":"1290px","units":"px"},"header_middle_height":{"height":"100px","units":"px"},"header_middle_background_image":{"url":"","id":"","height":"","width":"","thumbnail":""},"header_middle_background":{"color":"#ffffff","alpha":"1","rgba":"rgba(255,255,255,1)"},"header_middle_color":"#252525","header_middle_bottom_border":"","header_middle_border_height":{"height":"1px","units":"px"},"header_middle_bottom_border_color":{"color":"#f5f5f5","alpha":"1","rgba":"rgba(245,245,245,1)"},"header_bottom_full_width":"","header_bottom_max_width_custom":"","header_bottom_max_width":{"width":"1290px","units":"px"},"header_bottom_height":{"height":"100px","units":"px"},"header_bottom_background_image":{"url":"","id":"","height":"","width":"","thumbnail":""},"header_bottom_background":{"color":"#ffffff","alpha":".9","rgba":"rgba(255,255,255,0.9)"},"header_bottom_color":"#fefefe","header_bottom_bottom_border":"1","header_bottom_border_height":{"height":"1px","units":"px"},"header_bottom_bottom_border_color":{"color":"#ffffff","alpha":"1","rgba":"rgba(255,255,255,0.2)"},"header_column_top_left_horz":"left","header_column_top_left_vert":"middle","header_column_top_left_display":"normal","header_column_top_center_horz":"left","header_column_top_center_vert":"middle","header_column_top_center_display":"normal","header_column_top_right_horz":"right","header_column_top_right_vert":"middle","header_column_top_right_display":"normal","header_column_middle_left_horz":"left","header_column_middle_left_vert":"middle","header_column_middle_left_display":"normal","header_column_middle_center_horz":"center","header_column_middle_center_vert":"middle","header_column_middle_center_display":"normal","header_column_middle_right_horz":"right","header_column_middle_right_vert":"middle","header_column_middle_right_display":"normal","header_column_bottom_left_horz":"left","header_column_bottom_left_vert":"middle","header_column_bottom_left_display":"normal","header_column_bottom_center_horz":"left","header_column_bottom_center_vert":"middle","header_column_bottom_center_display":"normal","header_column_bottom_right_horz":"right","header_column_bottom_right_vert":"middle","header_column_bottom_right_display":"normal","header_shadow":"","header_on_bg":"","lavalamp_active":"","sub_menu_background":{"color":"#161a1d","alpha":"1","rgba":"rgba(22,26,29,1)"},"sub_menu_color":"#ffffff","header_sub_menu_bottom_border":"","header_sub_menu_border_height":{"height":"1px","units":"px"},"header_sub_menu_bottom_border_color":{"color":"#ffffff","alpha":"1","rgba":"rgba(0, 0, 0, 0.08)"},"header_mobile_queris":"1200","header_sticky":"1","header_sticky_page_select":"","header_sticky_style":"scroll_up","mobile_header":"","header_mobile_height":{"height":"60px","units":"px"},"header_mobile_full_width":"","mobile_sticky":"","mobile_over_content":"","mobile_background":{"color":"#161a1d","alpha":"1","rgba":"rgba(22,26,29, 1)"},"mobile_color":"#ffffff","mobile_position":"left","custom_mobile_menu":"","mobile_menu":"Main Menu","mobile_sub_menu_color":"#ffffff","mobile_sub_menu_background":{"color":"#161a1d","alpha":"1","rgba":"rgba(22,26,29,1)"},"mobile_sub_menu_overlay":{"color":"#161a1d","alpha":"1","rgba":"rgba(22,26,29,0.8)"},"mobile_header_layout":{"items":{"placebo":"placebo","html1":"HTML 1","html2":"HTML 2","html3":"HTML 3","html4":"HTML 4","html5":"HTML 5","html6":"HTML 6","spacer1":"Spacer 1","spacer2":"Spacer 2","spacer3":"Spacer 3","spacer4":"Spacer 4","spacer5":"Spacer 5","spacer6":"Spacer 6","side_panel":"Side Panel","wpml":"WPML","cart":"Cart","login":"WC Login"},"Left align side":{"placebo":"placebo","menu":"Hamburger Menu"},"Center align side":{"placebo":"placebo","logo":"Logo"},"Right align side":{"placebo":"placebo","item_search":"Search"}},"mobile_content_header_layout":{"items":{"placebo":"placebo","html1":"HTML 1","html2":"HTML 2","html3":"HTML 3","html4":"HTML 4","html5":"HTML 5","html6":"HTML 6","wpml":"WPML","spacer1":"Spacer 1","spacer2":"Spacer 2","spacer3":"Spacer 3","spacer4":"Spacer 4","spacer5":"Spacer 5","spacer6":"Spacer 6"},"Left align side":{"placebo":"placebo","logo":"Logo","menu":"Menu","item_search":"Search"}},"mobile_header_bar_html1_editor":"","mobile_header_bar_html2_editor":"","mobile_header_bar_html3_editor":"","mobile_header_bar_html4_editor":"","mobile_header_bar_html5_editor":"","mobile_header_bar_html6_editor":"","mobile_header_spacer1":{"width":"25px","units":"px"},"mobile_header_spacer2":{"width":"25px","units":"px"},"mobile_header_spacer3":{"width":"25px","units":"px"},"mobile_header_spacer4":{"width":"25px","units":"px"},"mobile_header_spacer5":{"width":"25px","units":"px"},"mobile_header_spacer6":{"width":"25px","units":"px"},"header_logo":{"url":"","id":"","height":"","width":"","thumbnail":""},"logo_height_custom":"","logo_height":{"height":"90px","units":"px"},"sticky_header_logo":{"url":"","id":"","height":"","width":"","thumbnail":""},"sticky_logo_height_custom":"","sticky_logo_height":{"height":"90px","units":"px"},"logo_mobile":{"url":"","id":"","height":"","width":"","thumbnail":""},"mobile_logo_height_custom":"","mobile_logo_height":{"height":"60px","units":"px"},"logo_mobile_menu":{"url":"","id":"","height":"","width":"","thumbnail":""},"mobile_logo_menu_height_custom":"","mobile_logo_menu_height":{"height":"60px","units":"px"},"page_title_switch":"1","page_title_bg_switch":"1","page_title_bg_image":{"background-color":"#3a3a3a","background-repeat":"no-repeat","background-size":"cover","background-attachment":"scroll","background-position":"center bottom","background-image":"","media":{"id":"","height":"","width":"","thumbnail":""}},"page_title_height":{"height":"400px","units":"px"},"page_title_padding":{"units":"px","padding-top":"56px","padding-bottom":"60px"},"page_title_margin":{"units":"px","margin-bottom":"50px"},"page_title_align":"center","page_title_breadcrumbs_switch":"1","page_title_breadcrumbs_block_switch":"1","page_title_breadcrumbs_align":"center","page_title_parallax":"","page_title_parallax_speed":"0.3","page_title_font":{"font-size":"70px","line-height":"90px","letter-spacing":"0","color":"#ffffff"},"page_title_breadcrumbs_font":{"font-size":"14px","line-height":"34px","letter-spacing":"0","color":"#ffffff"},"page_title_resp_switch":"1","page_title_resp_resolution":"1200","page_title_resp_padding":{"units":"px","padding-top":"90px","padding-bottom":"90px"},"page_title_resp_font":{"font-size":"32px","line-height":"42px","color":"#ffffff"},"page_title_resp_breadcrumbs_switch":"1","page_title_resp_breadcrumbs_font":{"font-size":"14px","line-height":"24px","color":"#ffffff"},"footer_switch":"1","footer_building_tool":"widgets","widget_columns":"4","widget_columns_2":"6-6","widget_columns_3":"4-4-4","footer_spacing":{"units":"px","padding-top":"50px","padding-right":"0","padding-bottom":"0","padding-left":"0"},"footer_full_width":"","footer_bg_image":{"background-repeat":"repeat","background-size":"cover","background-attachment":"scroll","background-position":"center center","background-image":"","media":{"id":"","height":"","width":"","thumbnail":""}},"footer_align":"center","footer_bg_color":"#252525","footer_heading_color":"#ffffff","footer_text_color":"#dce0f5","footer_add_border":"","footer_border_color":"#dcdcdc","copyright_switch":"1","copyright_editor":"<p>Copyright \u00a9 2022 Lunfest by WebGeniusLab. All Rights Reserved<\/p>","copyright_text_color":"#d5d5d5","copyright_bg_color":"#000000","copyright_spacing":{"units":"px","padding-top":"20px","padding-bottom":"20px"},"post_archive__page_title_bg_image":{"background-repeat":"repeat","background-size":"cover","background-attachment":"scroll","background-position":"center center","background-image":"","media":{"id":"","height":"","width":"","thumbnail":""}},"blog_list_sidebar_layout":"none","blog_list_sidebar_def":"","blog_list_sidebar_def_width":"9","blog_list_sidebar_sticky":"","blog_list_sidebar_gap":"35","blog_list_columns":"12","blog_list_likes":"","blog_list_views":"","blog_list_share":"","blog_list_hide_media":"","blog_list_hide_title":"","blog_list_hide_content":"","blog_post_listing_content":"","blog_list_letter_count":"85","blog_list_read_more":"","blog_list_meta":"","blog_list_meta_author":"","blog_list_meta_comments":"1","blog_list_meta_categories":"","blog_list_meta_date":"","post_single_type_layout":"3","blog_title_conditional":"1","blog_single__page_title_breadcrumbs_switch":"1","post_single__page_title_bg_switch":"1","post_single__page_title_bg_image":{"background-color":"","background-repeat":"repeat","background-size":"cover","background-attachment":"scroll","background-position":"center center","background-image":"","media":{"id":"","height":"","width":"","thumbnail":""}},"post_single_layout_3_bg_image":{"background-color":"#3a3a3a","background-image":"","media":{"id":"","height":"","width":"","thumbnail":""}},"single_padding_layout_3":{"units":"px","padding-top":"355px","padding-bottom":"0"},"single_sidebar_layout":"right","single_sidebar_def":"sidebar_main-sidebar","single_sidebar_def_width":"9","single_sidebar_sticky":"1","single_sidebar_gap":"35","featured_image_type":"default","featured_image_replace":{"url":"","id":"","height":"","width":"","thumbnail":""},"single_apply_animation":"1","single_likes":"","single_views":"","single_share":"","single_meta_tags":"1","single_author_info":"","single_meta":"","single_meta_author":"1","single_meta_comments":"1","single_meta_categories":"","single_meta_date":"","single_related_posts":"1","blog_title_r":"Related Posts","blog_column_r":"6","blog_number_r":"2","blog_carousel_r":"1","portfolio_slug":"portfolio","portfolio_archive__page_title_bg_image":{"background-repeat":"repeat","background-size":"cover","background-attachment":"scroll","background-position":"center center","background-image":"","media":{"id":"","height":"","width":"","thumbnail":""}},"portfolio_list_sidebar_layout":"none","portfolio_list_sidebar_def":"","portfolio_list_sidebar_def_width":"9","portfolio_list_columns":"3","portfolio_list_show_title":"1","portfolio_list_show_content":"","portfolio_list_show_cat":"1","portfolio_single_type_layout":"2","portfolio_title_conditional":"1","portfolio_single_title_align":"center","portfolio_single_breadcrumbs_align":"center","portfolio_single_breadcrumbs_block_switch":"1","portfolio_single__page_title_bg_switch":"1","portfolio_single__page_title_bg_image":{"background-color":"","background-repeat":"repeat","background-size":"cover","background-attachment":"scroll","background-position":"center center","background-image":"","media":{"id":"","height":"","width":"","thumbnail":""}},"portfolio_single__page_title_height":{"height":"","units":"px"},"portfolio_single__page_title_padding":{"units":"px","padding-top":"","padding-bottom":""},"portfolio_single__page_title_margin":{"units":"px","margin-bottom":""},"portfolio_single_sidebar_layout":"none","portfolio_single_sidebar_def":"","portfolio_single_sidebar_def_width":"8","portfolio_single_sidebar_sticky":"","portfolio_single_sidebar_gap":"def","portfolio_above_content_cats":"","portfolio_above_content_share":"","portfolio_single_meta_likes":"","portfolio_single_meta":"","portfolio_single_meta_author":"","portfolio_single_meta_comments":"","portfolio_single_meta_categories":"1","portfolio_single_meta_date":"","portfolio_related_switch":"1","portfolio_related_title":"Related Projects","pf_carousel_r":"1","pf_column_r":"3","pf_number_r":"3","portfolio_archives":"1","portfolio_singular":"1","team_title_conditional":"1","team_single__page_title_bg_switch":"1","team_single__page_title_bg_image":{"background-color":"","background-repeat":"repeat","background-size":"cover","background-attachment":"scroll","background-position":"center center","background-image":"","media":{"id":"","height":"","width":"","thumbnail":""}},"team_single__page_title_height":{"height":"","units":"px"},"team_single__page_title_padding":{"units":"px","padding-top":"","padding-bottom":""},"team_single__page_title_margin":{"units":"px","margin-bottom":""},"team_slug":"team","team_singular":"1","team_archives":"1","404_building_tool":"default","404_template_select":"","404_show_header":"1","404_page_title_switcher":"1","404_custom_title_switch":"","404_page_title_text":"","404_page__page_title_bg_switch":"1","404_page__page_title_bg_image":{"background-color":"","background-repeat":"repeat","background-size":"cover","background-attachment":"scroll","background-position":"center center","background-image":"","media":{"id":"","height":"","width":"","thumbnail":""}},"404_page__page_title_height":{"height":"","units":"px"},"404_page__page_title_padding":{"units":"px","padding-top":"","padding-bottom":""},"404_page__page_title_margin":{"units":"px","margin-bottom":"0"},"404_page_main_bg_image":{"background-repeat":"repeat","background-size":"cover","background-attachment":"scroll","background-position":"center center","background-image":"","media":{"id":"","height":"","width":"","thumbnail":""}},"404_page_main_padding":{"units":"px","padding-top":"","padding-bottom":""},"404_show_footer":"1","side_panel_enabled":"","side_panel_building_tool":"elementor","side_panel_spacing":{"units":"px","margin-top":"50px","margin-right":"50px","margin-bottom":"50px","margin-left":"50px"},"side_panel_title_color":"#161a1d","side_panel_text_color":"#161a1d","side_panel_bg":{"color":"#ffffff","alpha":"1","rgba":"rgba(255,255,255,1)"},"side_panel_text_alignment":"left","side_panel_width":{"width":"370px","units":"px"},"side_panel_position":"right","sidebars":["Main Sidebar"],"page_sidebar_layout":"none","page_sidebar_def":"","page_sidebar_def_width":"9","page_sidebar_sticky":"","page_sidebar_gap":"35","post_shares":{"telegram":"","reddit":"","twitter":"1","whatsapp":"","facebook":"1","pinterest":"1","linkedin":"1"},"show_soc_icon_page":"","soc_icon_style":"standard","soc_icon_offset":{"units":"px","margin-top":"250px"},"soc_icon_facebook":"","soc_icon_twitter":"","soc_icon_linkedin":"","soc_icon_pinterest":"","soc_icon_tumblr":"","add_custom_share":"","share_name-1":"","share_link-1":"","share_icons-1":"","share_name-2":"","share_link-2":"","share_icons-2":"","share_name-3":"","share_link-3":"","share_icons-3":"","share_name-4":"","share_link-4":"","share_icons-4":"","share_name-5":"","share_link-5":"","share_icons-5":"","share_name-6":"","share_link-6":"","share_icons-6":"","theme-primary-color":"#9d99f2","theme-secondary-color":"#161A1D","theme-tertiary-color":"#FFF79A","theme-content-color":"#515151","theme-headings-color":"#161A1D","body-background-color":"#FFFFFF","button-color-idle":"#FFFFFF","button-bg-idle":"#161A1D","button-color-hover":"#161A1D","button-bg-hover":"#9d99f2","main-font":{"font-family":"Prompt","font-options":"","google":"1","font-weight":"400","font-style":"","font-size":"16px","line-height":"30px","font-weight-multi":"300,400","font-style-multi":""},"header-font":{"font-family":"Prompt","font-options":"","google":"1","font-weight":"500","font-style":"","font-weight-multi":"300,400,500,600,700","font-style-multi":""},"additional-font":{"font-family":"Krona One","font-options":"","google":"1","font-weight":"400","font-style":""},"menu-font":{"font-family":"Krona One","font-options":"","google":"1","font-weight":"400","font-style":"","subsets":"","font-size":"14px","line-height":"30px","letter-spacing":"0.01"},"sub-menu-font":{"font-family":"Krona One","font-options":"","google":"1","font-weight":"400","font-style":"","subsets":"","font-size":"14px","line-height":"30px","letter-spacing":"0.025"},"header-h1":{"font-family":"Prompt","font-options":"","google":"1","font-weight":"500","font-style":"","subsets":"","text-transform":"none","font-size":"70px","line-height":"78px","letter-spacing":"0"},"header-h2":{"font-family":"Prompt","font-options":"","google":"1","font-weight":"500","font-style":"","subsets":"","text-transform":"none","font-size":"58px","line-height":"72px","letter-spacing":"0"},"header-h3":{"font-family":"Prompt","font-options":"","google":"1","font-weight":"500","font-style":"","subsets":"","text-transform":"none","font-size":"48px","line-height":"62px","letter-spacing":"0"},"header-h4":{"font-family":"Prompt","font-options":"","google":"1","font-weight":"500","font-style":"","subsets":"","text-transform":"none","font-size":"30px","line-height":"40px","letter-spacing":"0"},"header-h5":{"font-family":"Prompt","font-options":"","google":"1","font-weight":"500","font-style":"","subsets":"","text-transform":"none","font-size":"28px","line-height":"36px","letter-spacing":"0"},"header-h6":{"font-family":"Prompt","font-options":"","google":"1","font-weight":"500","font-style":"","subsets":"","text-transform":"none","font-size":"24px","line-height":"36px","letter-spacing":"0"},"shop_catalog__page_title_bg_image":{"background-repeat":"repeat","background-size":"cover","background-attachment":"scroll","background-position":"center center","background-image":"","media":{"id":"","height":"","width":"","thumbnail":""}},"shop_catalog_sidebar_layout":"left","shop_catalog_sidebar_def":"","shop_catalog_sidebar_def_width":"9","shop_catalog_sidebar_sticky":"","shop_catalog_sidebar_gap":"def","shop_column":"3","shop_products_per_page":"12","use_animation_shop":"1","shop_catalog_animation_style":"slide-left","shop_products_stars":"1","shop_products_overlay":{"color":"#ffffff","alpha":"0","rgba":"rgba(255,255,255,0)"},"shop_title_conditional":"1","shop_single_title_align":"center","shop_single_breadcrumbs_block_switch":"1","shop_single_breadcrumbs_align":"center","shop_single__page_title_bg_switch":"1","shop_single__page_title_bg_image":{"background-color":"","background-repeat":"repeat","background-size":"cover","background-attachment":"scroll","background-position":"center center","background-image":"","media":{"id":"","height":"","width":"","thumbnail":""}},"shop_single__page_title_padding":{"units":"px","padding-top":"","padding-bottom":""},"shop_single__page_title_margin":{"units":"px","margin-bottom":"50px"},"shop_single_sidebar_layout":"none","shop_single_sidebar_def":"","shop_single_sidebar_def_width":"9","shop_single_sidebar_sticky":"","shop_single_sidebar_gap":"def","shop_related_columns":"4","shop_r_products_per_page":"4","shop_cart__page_title_bg_image":{"background-repeat":"repeat","background-size":"cover","background-attachment":"scroll","background-position":"center center","background-image":"","media":{"id":"","height":"","width":"","thumbnail":""}},"shop_checkout__page_title_bg_image":{"background-repeat":"repeat","background-size":"cover","background-attachment":"scroll","background-position":"center center","background-image":"","media":{"id":"","height":"","width":"","thumbnail":""}},"disable_wp_gutenberg":"","disable_elementor_googlefonts":"","disable_elementor_fontawesome":"","search_post_type":[],"redux-backup":1}';

	$default_theme_options = json_decode($default_theme_options, true);
	$default_theme_options = inject_unit_test_related_values($default_theme_options);

	update_option('lunfest_default_options', $default_theme_options);
}

function inject_unit_test_related_values(Array $default_theme_options)
{
	$default_theme_options['side_panel_enabled'] = false;
	$default_theme_options['footer_spacing']['padding-top'] = '50px';
	$default_theme_options['footer_spacing']['padding-bottom'] = '0px';

	return $default_theme_options;
}

add_action('after_switch_theme', 'lunfest_get_default_option');
add_action('after_setup_theme', function() {
	$version = '1.0.3';
	if (get_option('lunfest_option_version') != $version) {
		lunfest_get_default_option();
		update_option('lunfest_option_version', $version);
	}
});

function lunfest_fonts_url()
{
	$font1 = esc_html_x( 'on', 'Prompt: on or off', 'lunfest' );
	$font2 = esc_html_x('on', 'Krona One: on or off', 'lunfest');

	if ('off' !== $font1 || 'off' !== $font2) {
		$font_families = [];

		if ('off' !== $font1) $font_families[] = 'Prompt:300,400,500,600,700';
		if ('off' !== $font2) $font_families[] = 'Krona One:400';

		$query_args = [
			'family' => urlencode(implode('|', $font_families)),
			'subset' => urlencode('latin,latin-ext'),
		];

		$fonts_url = add_query_arg($query_args, 'https://fonts.googleapis.com/css');
	}

	return esc_url_raw($fonts_url ?? '');
}

add_action('admin_enqueue_scripts', function() {
	wp_enqueue_style(
		'editor-google-fonts',
		lunfest_fonts_url(),
		[],
		WGL_Globals::get_theme_version()
	);
});

if (!class_exists('WGL_Extensions_Core')) {
	add_action('wp_enqueue_scripts', function () {
		wp_enqueue_style(
			'lunfest-default-font',
			lunfest_fonts_url(),
			[],
			WGL_Globals::get_theme_version()
		);
	});
}
