<?php

defined('ABSPATH') || exit;

if (!class_exists('WGL_Admin_Icon')) {
    /**
     * Lunfest WGL_Admin_Icon
     *
     *
     * @package lunfest\core\class
     * @author WebGeniusLab <webgeniuslab@gmail.com>
     * @since 1.0.0
     */
    class WGL_Admin_Icon
    {
        private $icons = [];

        private static $instance = null;
        public static function get_instance()
        {
            if (is_null(self::$instance)) {
                self::$instance = new self();
            }

            return self::$instance;
        }

        private function __construct()
        {
            $this->load();
        }

        public function load()
        {
            $this->setup_stylesheet_data();
        }

        private function setup_stylesheet_data()
        {
            $this->icons = $this->setup_icon_array();
        }

        private function setup_icon_array()
        {
            $icons = array();

            $icons = $this->get_icon_list();
            $icons = apply_filters('lunfest_icon_list', $icons);

            return $icons;
        }

        /*----------------------------------------------------------------------------*
         * Public Helper Functions
         *----------------------------------------------------------------------------*/
        public function get_icons_name($get_icons_value = false)
        {
            $icons = [];

            if (!empty($this->icons)) {
                foreach ($this->icons as $key => $value) {
                    $icons[$key] = (bool) $get_icons_value ? esc_html($key) : esc_html($value);
                }

                return $icons;
            } else {
                return $icons;
            }
        }

        public function get_icon_list()
        {
            return [
                'fab fa-500px' => esc_html__( '500px', 'lunfest' ),
                'fab fa-accessible-icon' => esc_html__( 'accessible-icon', 'lunfest' ),
                'fab fa-accusoft' => esc_html__( 'accusoft', 'lunfest' ),
                'fas fa-address-book' => esc_html__( 'address-book', 'lunfest' ),
                'far fa-address-book' => esc_html__( 'address-book', 'lunfest' ),
                'fas fa-address-card' => esc_html__( 'address-card', 'lunfest' ),
                'far fa-address-card' => esc_html__( 'address-card', 'lunfest' ),
                'fas fa-adjust' => esc_html__( 'adjust', 'lunfest' ),
                'fab fa-adn' => esc_html__( 'adn', 'lunfest' ),
                'fab fa-adversal' => esc_html__( 'adversal', 'lunfest' ),
                'fab fa-affiliatetheme' => esc_html__( 'affiliatetheme', 'lunfest' ),
                'fab fa-algolia' => esc_html__( 'algolia', 'lunfest' ),
                'fas fa-align-center' => esc_html__( 'align-center', 'lunfest' ),
                'fas fa-align-justify' => esc_html__( 'align-justify', 'lunfest' ),
                'fas fa-align-left' => esc_html__( 'align-left', 'lunfest' ),
                'fas fa-align-right' => esc_html__( 'align-right', 'lunfest' ),
                'fas fa-allergies' => esc_html__( 'allergies', 'lunfest' ),
                'fab fa-amazon' => esc_html__( 'amazon', 'lunfest' ),
                'fab fa-amazon-pay' => esc_html__( 'amazon-pay', 'lunfest' ),
                'fas fa-ambulance' => esc_html__( 'ambulance', 'lunfest' ),
                'fas fa-american-sign-language-interpreting' => esc_html__( 'american-sign-language-interpreting', 'lunfest' ),
                'fab fa-amilia' => esc_html__( 'amilia', 'lunfest' ),
                'fas fa-anchor' => esc_html__( 'anchor', 'lunfest' ),
                'fab fa-android' => esc_html__( 'android', 'lunfest' ),
                'fab fa-angellist' => esc_html__( 'angellist', 'lunfest' ),
                'fas fa-angle-double-down' => esc_html__( 'angle-double-down', 'lunfest' ),
                'fas fa-angle-double-left' => esc_html__( 'angle-double-left', 'lunfest' ),
                'fas fa-angle-double-right' => esc_html__( 'angle-double-right', 'lunfest' ),
                'fas fa-angle-double-up' => esc_html__( 'angle-double-up', 'lunfest' ),
                'fas fa-angle-down' => esc_html__( 'angle-down', 'lunfest' ),
                'fas fa-angle-left' => esc_html__( 'angle-left', 'lunfest' ),
                'fas fa-angle-right' => esc_html__( 'angle-right', 'lunfest' ),
                'fas fa-angle-up' => esc_html__( 'angle-up', 'lunfest' ),
                'fab fa-angrycreative' => esc_html__( 'angrycreative', 'lunfest' ),
                'fab fa-angular' => esc_html__( 'angular', 'lunfest' ),
                'fab fa-app-store' => esc_html__( 'app-store', 'lunfest' ),
                'fab fa-app-store-ios' => esc_html__( 'app-store-ios', 'lunfest' ),
                'fab fa-apper' => esc_html__( 'apper', 'lunfest' ),
                'fab fa-apple' => esc_html__( 'apple', 'lunfest' ),
                'fab fa-apple-pay' => esc_html__( 'apple-pay', 'lunfest' ),
                'fas fa-archive' => esc_html__( 'archive', 'lunfest' ),
                'fas fa-arrow-alt-circle-down' => esc_html__( 'arrow-alt-circle-down', 'lunfest' ),
                'far fa-arrow-alt-circle-down' => esc_html__( 'arrow-alt-circle-down', 'lunfest' ),
                'fas fa-arrow-alt-circle-left' => esc_html__( 'arrow-alt-circle-left', 'lunfest' ),
                'far fa-arrow-alt-circle-left' => esc_html__( 'arrow-alt-circle-left', 'lunfest' ),
                'fas fa-arrow-alt-circle-right' => esc_html__( 'arrow-alt-circle-right', 'lunfest' ),
                'far fa-arrow-alt-circle-right' => esc_html__( 'arrow-alt-circle-right', 'lunfest' ),
                'fas fa-arrow-alt-circle-up' => esc_html__( 'arrow-alt-circle-up', 'lunfest' ),
                'far fa-arrow-alt-circle-up' => esc_html__( 'arrow-alt-circle-up', 'lunfest' ),
                'fas fa-arrow-circle-down' => esc_html__( 'arrow-circle-down', 'lunfest' ),
                'fas fa-arrow-circle-left' => esc_html__( 'arrow-circle-left', 'lunfest' ),
                'fas fa-arrow-circle-right' => esc_html__( 'arrow-circle-right', 'lunfest' ),
                'fas fa-arrow-circle-up' => esc_html__( 'arrow-circle-up', 'lunfest' ),
                'fas fa-arrow-down' => esc_html__( 'arrow-down', 'lunfest' ),
                'fas fa-arrow-left' => esc_html__( 'arrow-left', 'lunfest' ),
                'fas fa-arrow-right' => esc_html__( 'arrow-right', 'lunfest' ),
                'fas fa-arrow-up' => esc_html__( 'arrow-up', 'lunfest' ),
                'fas fa-arrows-alt' => esc_html__( 'arrows-alt', 'lunfest' ),
                'fas fa-arrows-alt-h' => esc_html__( 'arrows-alt-h', 'lunfest' ),
                'fas fa-arrows-alt-v' => esc_html__( 'arrows-alt-v', 'lunfest' ),
                'fas fa-assistive-listening-systems' => esc_html__( 'assistive-listening-systems', 'lunfest' ),
                'fas fa-asterisk' => esc_html__( 'asterisk', 'lunfest' ),
                'fab fa-asymmetrik' => esc_html__( 'asymmetrik', 'lunfest' ),
                'fas fa-at' => esc_html__( 'at', 'lunfest' ),
                'fab fa-audible' => esc_html__( 'audible', 'lunfest' ),
                'fas fa-audio-description' => esc_html__( 'audio-description', 'lunfest' ),
                'fab fa-autoprefixer' => esc_html__( 'autoprefixer', 'lunfest' ),
                'fab fa-avianex' => esc_html__( 'avianex', 'lunfest' ),
                'fab fa-aviato' => esc_html__( 'aviato', 'lunfest' ),
                'fab fa-aws' => esc_html__( 'aws', 'lunfest' ),
                'fas fa-backward' => esc_html__( 'backward', 'lunfest' ),
                'fas fa-balance-scale' => esc_html__( 'balance-scale', 'lunfest' ),
                'fas fa-ban' => esc_html__( 'ban', 'lunfest' ),
                'fas fa-band-aid' => esc_html__( 'band-aid', 'lunfest' ),
                'fab fa-bandcamp' => esc_html__( 'bandcamp', 'lunfest' ),
                'fas fa-barcode' => esc_html__( 'barcode', 'lunfest' ),
                'fas fa-bars' => esc_html__( 'bars', 'lunfest' ),
                'fas fa-baseball-ball' => esc_html__( 'baseball-ball', 'lunfest' ),
                'fas fa-basketball-ball' => esc_html__( 'basketball-ball', 'lunfest' ),
                'fas fa-bath' => esc_html__( 'bath', 'lunfest' ),
                'fas fa-battery-empty' => esc_html__( 'battery-empty', 'lunfest' ),
                'fas fa-battery-full' => esc_html__( 'battery-full', 'lunfest' ),
                'fas fa-battery-half' => esc_html__( 'battery-half', 'lunfest' ),
                'fas fa-battery-quarter' => esc_html__( 'battery-quarter', 'lunfest' ),
                'fas fa-battery-three-quarters' => esc_html__( 'battery-three-quarters', 'lunfest' ),
                'fas fa-bed' => esc_html__( 'bed', 'lunfest' ),
                'fas fa-beer' => esc_html__( 'beer', 'lunfest' ),
                'fab fa-behance' => esc_html__( 'behance', 'lunfest' ),
                'fab fa-behance-square' => esc_html__( 'behance-square', 'lunfest' ),
                'fas fa-bell' => esc_html__( 'bell', 'lunfest' ),
                'far fa-bell' => esc_html__( 'bell', 'lunfest' ),
                'fas fa-bell-slash' => esc_html__( 'bell-slash', 'lunfest' ),
                'far fa-bell-slash' => esc_html__( 'bell-slash', 'lunfest' ),
                'fas fa-bicycle' => esc_html__( 'bicycle', 'lunfest' ),
                'fab fa-bimobject' => esc_html__( 'bimobject', 'lunfest' ),
                'fas fa-binoculars' => esc_html__( 'binoculars', 'lunfest' ),
                'fas fa-birthday-cake' => esc_html__( 'birthday-cake', 'lunfest' ),
                'fab fa-bitbucket' => esc_html__( 'bitbucket', 'lunfest' ),
                'fab fa-bitcoin' => esc_html__( 'bitcoin', 'lunfest' ),
                'fab fa-bity' => esc_html__( 'bity', 'lunfest' ),
                'fab fa-black-tie' => esc_html__( 'black-tie', 'lunfest' ),
                'fab fa-blackberry' => esc_html__( 'blackberry', 'lunfest' ),
                'fas fa-blind' => esc_html__( 'blind', 'lunfest' ),
                'fab fa-blogger' => esc_html__( 'blogger', 'lunfest' ),
                'fab fa-blogger-b' => esc_html__( 'blogger-b', 'lunfest' ),
                'fab fa-bluetooth' => esc_html__( 'bluetooth', 'lunfest' ),
                'fab fa-bluetooth-b' => esc_html__( 'bluetooth-b', 'lunfest' ),
                'fas fa-bold' => esc_html__( 'bold', 'lunfest' ),
                'fas fa-bolt' => esc_html__( 'bolt', 'lunfest' ),
                'fas fa-bomb' => esc_html__( 'bomb', 'lunfest' ),
                'fas fa-book' => esc_html__( 'book', 'lunfest' ),
                'fas fa-bookmark' => esc_html__( 'bookmark', 'lunfest' ),
                'far fa-bookmark' => esc_html__( 'bookmark', 'lunfest' ),
                'fas fa-bowling-ball' => esc_html__( 'bowling-ball', 'lunfest' ),
                'fas fa-box' => esc_html__( 'box', 'lunfest' ),
                'fas fa-box-open' => esc_html__( 'box-open', 'lunfest' ),
                'fas fa-boxes' => esc_html__( 'boxes', 'lunfest' ),
                'fas fa-braille' => esc_html__( 'braille', 'lunfest' ),
                'fas fa-briefcase' => esc_html__( 'briefcase', 'lunfest' ),
                'fas fa-briefcase-medical' => esc_html__( 'briefcase-medical', 'lunfest' ),
                'fab fa-btc' => esc_html__( 'btc', 'lunfest' ),
                'fas fa-bug' => esc_html__( 'bug', 'lunfest' ),
                'fas fa-building' => esc_html__( 'building', 'lunfest' ),
                'far fa-building' => esc_html__( 'building', 'lunfest' ),
                'fas fa-bullhorn' => esc_html__( 'bullhorn', 'lunfest' ),
                'fas fa-bullseye' => esc_html__( 'bullseye', 'lunfest' ),
                'fas fa-burn' => esc_html__( 'burn', 'lunfest' ),
                'fab fa-buromobelexperte' => esc_html__( 'buromobelexperte', 'lunfest' ),
                'fas fa-bus' => esc_html__( 'bus', 'lunfest' ),
                'fab fa-buysellads' => esc_html__( 'buysellads', 'lunfest' ),
                'fas fa-calculator' => esc_html__( 'calculator', 'lunfest' ),
                'fas fa-calendar' => esc_html__( 'calendar', 'lunfest' ),
                'far fa-calendar' => esc_html__( 'calendar', 'lunfest' ),
                'fas fa-calendar-alt' => esc_html__( 'calendar-alt', 'lunfest' ),
                'far fa-calendar-alt' => esc_html__( 'calendar-alt', 'lunfest' ),
                'fas fa-calendar-check' => esc_html__( 'calendar-check', 'lunfest' ),
                'far fa-calendar-check' => esc_html__( 'calendar-check', 'lunfest' ),
                'fas fa-calendar-minus' => esc_html__( 'calendar-minus', 'lunfest' ),
                'far fa-calendar-minus' => esc_html__( 'calendar-minus', 'lunfest' ),
                'fas fa-calendar-plus' => esc_html__( 'calendar-plus', 'lunfest' ),
                'far fa-calendar-plus' => esc_html__( 'calendar-plus', 'lunfest' ),
                'fas fa-calendar-times' => esc_html__( 'calendar-times', 'lunfest' ),
                'far fa-calendar-times' => esc_html__( 'calendar-times', 'lunfest' ),
                'fas fa-camera' => esc_html__( 'camera', 'lunfest' ),
                'fas fa-camera-retro' => esc_html__( 'camera-retro', 'lunfest' ),
                'fas fa-capsules' => esc_html__( 'capsules', 'lunfest' ),
                'fas fa-car' => esc_html__( 'car', 'lunfest' ),
                'fas fa-caret-down' => esc_html__( 'caret-down', 'lunfest' ),
                'fas fa-caret-left' => esc_html__( 'caret-left', 'lunfest' ),
                'fas fa-caret-right' => esc_html__( 'caret-right', 'lunfest' ),
                'fas fa-caret-square-down' => esc_html__( 'caret-square-down', 'lunfest' ),
                'far fa-caret-square-down' => esc_html__( 'caret-square-down', 'lunfest' ),
                'fas fa-caret-square-left' => esc_html__( 'caret-square-left', 'lunfest' ),
                'far fa-caret-square-left' => esc_html__( 'caret-square-left', 'lunfest' ),
                'fas fa-caret-square-right' => esc_html__( 'caret-square-right', 'lunfest' ),
                'far fa-caret-square-right' => esc_html__( 'caret-square-right', 'lunfest' ),
                'fas fa-caret-square-up' => esc_html__( 'caret-square-up', 'lunfest' ),
                'far fa-caret-square-up' => esc_html__( 'caret-square-up', 'lunfest' ),
                'fas fa-caret-up' => esc_html__( 'caret-up', 'lunfest' ),
                'fas fa-cart-arrow-down' => esc_html__( 'cart-arrow-down', 'lunfest' ),
                'fas fa-cart-plus' => esc_html__( 'cart-plus', 'lunfest' ),
                'fab fa-cc-amazon-pay' => esc_html__( 'cc-amazon-pay', 'lunfest' ),
                'fab fa-cc-amex' => esc_html__( 'cc-amex', 'lunfest' ),
                'fab fa-cc-apple-pay' => esc_html__( 'cc-apple-pay', 'lunfest' ),
                'fab fa-cc-diners-club' => esc_html__( 'cc-diners-club', 'lunfest' ),
                'fab fa-cc-discover' => esc_html__( 'cc-discover', 'lunfest' ),
                'fab fa-cc-jcb' => esc_html__( 'cc-jcb', 'lunfest' ),
                'fab fa-cc-mastercard' => esc_html__( 'cc-mastercard', 'lunfest' ),
                'fab fa-cc-paypal' => esc_html__( 'cc-paypal', 'lunfest' ),
                'fab fa-cc-stripe' => esc_html__( 'cc-stripe', 'lunfest' ),
                'fab fa-cc-visa' => esc_html__( 'cc-visa', 'lunfest' ),
                'fab fa-centercode' => esc_html__( 'centercode', 'lunfest' ),
                'fas fa-certificate' => esc_html__( 'certificate', 'lunfest' ),
                'fas fa-chart-area' => esc_html__( 'chart-area', 'lunfest' ),
                'fas fa-chart-bar' => esc_html__( 'chart-bar', 'lunfest' ),
                'far fa-chart-bar' => esc_html__( 'chart-bar', 'lunfest' ),
                'fas fa-chart-line' => esc_html__( 'chart-line', 'lunfest' ),
                'fas fa-chart-pie' => esc_html__( 'chart-pie', 'lunfest' ),
                'fas fa-check' => esc_html__( 'check', 'lunfest' ),
                'fas fa-check-circle' => esc_html__( 'check-circle', 'lunfest' ),
                'far fa-check-circle' => esc_html__( 'check-circle', 'lunfest' ),
                'fas fa-check-square' => esc_html__( 'check-square', 'lunfest' ),
                'far fa-check-square' => esc_html__( 'check-square', 'lunfest' ),
                'fas fa-chess' => esc_html__( 'chess', 'lunfest' ),
                'fas fa-chess-bishop' => esc_html__( 'chess-bishop', 'lunfest' ),
                'fas fa-chess-board' => esc_html__( 'chess-board', 'lunfest' ),
                'fas fa-chess-king' => esc_html__( 'chess-king', 'lunfest' ),
                'fas fa-chess-knight' => esc_html__( 'chess-knight', 'lunfest' ),
                'fas fa-chess-pawn' => esc_html__( 'chess-pawn', 'lunfest' ),
                'fas fa-chess-queen' => esc_html__( 'chess-queen', 'lunfest' ),
                'fas fa-chess-rook' => esc_html__( 'chess-rook', 'lunfest' ),
                'fas fa-chevron-circle-down' => esc_html__( 'chevron-circle-down', 'lunfest' ),
                'fas fa-chevron-circle-left' => esc_html__( 'chevron-circle-left', 'lunfest' ),
                'fas fa-chevron-circle-right' => esc_html__( 'chevron-circle-right', 'lunfest' ),
                'fas fa-chevron-circle-up' => esc_html__( 'chevron-circle-up', 'lunfest' ),
                'fas fa-chevron-down' => esc_html__( 'chevron-down', 'lunfest' ),
                'fas fa-chevron-left' => esc_html__( 'chevron-left', 'lunfest' ),
                'fas fa-chevron-right' => esc_html__( 'chevron-right', 'lunfest' ),
                'fas fa-chevron-up' => esc_html__( 'chevron-up', 'lunfest' ),
                'fas fa-child' => esc_html__( 'child', 'lunfest' ),
                'fab fa-chrome' => esc_html__( 'chrome', 'lunfest' ),
                'fas fa-circle' => esc_html__( 'circle', 'lunfest' ),
                'far fa-circle' => esc_html__( 'circle', 'lunfest' ),
                'fas fa-circle-notch' => esc_html__( 'circle-notch', 'lunfest' ),
                'fas fa-clipboard' => esc_html__( 'clipboard', 'lunfest' ),
                'far fa-clipboard' => esc_html__( 'clipboard', 'lunfest' ),
                'fas fa-clipboard-check' => esc_html__( 'clipboard-check', 'lunfest' ),
                'fas fa-clipboard-list' => esc_html__( 'clipboard-list', 'lunfest' ),
                'fas fa-clock' => esc_html__( 'clock', 'lunfest' ),
                'far fa-clock' => esc_html__( 'clock', 'lunfest' ),
                'fas fa-clone' => esc_html__( 'clone', 'lunfest' ),
                'far fa-clone' => esc_html__( 'clone', 'lunfest' ),
                'fas fa-closed-captioning' => esc_html__( 'closed-captioning', 'lunfest' ),
                'far fa-closed-captioning' => esc_html__( 'closed-captioning', 'lunfest' ),
                'fas fa-cloud' => esc_html__( 'cloud', 'lunfest' ),
                'fas fa-cloud-download-alt' => esc_html__( 'cloud-download-alt', 'lunfest' ),
                'fas fa-cloud-upload-alt' => esc_html__( 'cloud-upload-alt', 'lunfest' ),
                'fab fa-cloudscale' => esc_html__( 'cloudscale', 'lunfest' ),
                'fab fa-cloudsmith' => esc_html__( 'cloudsmith', 'lunfest' ),
                'fab fa-cloudversify' => esc_html__( 'cloudversify', 'lunfest' ),
                'fas fa-code' => esc_html__( 'code', 'lunfest' ),
                'fas fa-code-branch' => esc_html__( 'code-branch', 'lunfest' ),
                'fab fa-codepen' => esc_html__( 'codepen', 'lunfest' ),
                'fab fa-codiepie' => esc_html__( 'codiepie', 'lunfest' ),
                'fas fa-coffee' => esc_html__( 'coffee', 'lunfest' ),
                'fas fa-cog' => esc_html__( 'cog', 'lunfest' ),
                'fas fa-cogs' => esc_html__( 'cogs', 'lunfest' ),
                'fas fa-columns' => esc_html__( 'columns', 'lunfest' ),
                'fas fa-comment' => esc_html__( 'comment', 'lunfest' ),
                'far fa-comment' => esc_html__( 'comment', 'lunfest' ),
                'fas fa-comment-alt' => esc_html__( 'comment-alt', 'lunfest' ),
                'far fa-comment-alt' => esc_html__( 'comment-alt', 'lunfest' ),
                'fas fa-comment-dots' => esc_html__( 'comment-dots', 'lunfest' ),
                'fas fa-comment-slash' => esc_html__( 'comment-slash', 'lunfest' ),
                'fas fa-comments' => esc_html__( 'comments', 'lunfest' ),
                'far fa-comments' => esc_html__( 'comments', 'lunfest' ),
                'fas fa-compass' => esc_html__( 'compass', 'lunfest' ),
                'far fa-compass' => esc_html__( 'compass', 'lunfest' ),
                'fas fa-compress' => esc_html__( 'compress', 'lunfest' ),
                'fab fa-connectdevelop' => esc_html__( 'connectdevelop', 'lunfest' ),
                'fab fa-contao' => esc_html__( 'contao', 'lunfest' ),
                'fas fa-copy' => esc_html__( 'copy', 'lunfest' ),
                'far fa-copy' => esc_html__( 'copy', 'lunfest' ),
                'fas fa-copyright' => esc_html__( 'copyright', 'lunfest' ),
                'far fa-copyright' => esc_html__( 'copyright', 'lunfest' ),
                'fas fa-couch' => esc_html__( 'couch', 'lunfest' ),
                'fab fa-cpanel' => esc_html__( 'cpanel', 'lunfest' ),
                'fab fa-creative-commons' => esc_html__( 'creative-commons', 'lunfest' ),
                'fas fa-credit-card' => esc_html__( 'credit-card', 'lunfest' ),
                'far fa-credit-card' => esc_html__( 'credit-card', 'lunfest' ),
                'fas fa-crop' => esc_html__( 'crop', 'lunfest' ),
                'fas fa-crosshairs' => esc_html__( 'crosshairs', 'lunfest' ),
                'fab fa-css3' => esc_html__( 'css3', 'lunfest' ),
                'fab fa-css3-alt' => esc_html__( 'css3-alt', 'lunfest' ),
                'fas fa-cube' => esc_html__( 'cube', 'lunfest' ),
                'fas fa-cubes' => esc_html__( 'cubes', 'lunfest' ),
                'fas fa-cut' => esc_html__( 'cut', 'lunfest' ),
                'fab fa-cuttlefish' => esc_html__( 'cuttlefish', 'lunfest' ),
                'fab fa-d-and-d' => esc_html__( 'd-and-d', 'lunfest' ),
                'fab fa-dashcube' => esc_html__( 'dashcube', 'lunfest' ),
                'fas fa-database' => esc_html__( 'database', 'lunfest' ),
                'fas fa-deaf' => esc_html__( 'deaf', 'lunfest' ),
                'fab fa-delicious' => esc_html__( 'delicious', 'lunfest' ),
                'fab fa-deploydog' => esc_html__( 'deploydog', 'lunfest' ),
                'fab fa-deskpro' => esc_html__( 'deskpro', 'lunfest' ),
                'fas fa-desktop' => esc_html__( 'desktop', 'lunfest' ),
                'fab fa-deviantart' => esc_html__( 'deviantart', 'lunfest' ),
                'fas fa-diagnoses' => esc_html__( 'diagnoses', 'lunfest' ),
                'fab fa-digg' => esc_html__( 'digg', 'lunfest' ),
                'fab fa-digital-ocean' => esc_html__( 'digital-ocean', 'lunfest' ),
                'fab fa-discord' => esc_html__( 'discord', 'lunfest' ),
                'fab fa-discourse' => esc_html__( 'discourse', 'lunfest' ),
                'fas fa-dna' => esc_html__( 'dna', 'lunfest' ),
                'fab fa-dochub' => esc_html__( 'dochub', 'lunfest' ),
                'fab fa-docker' => esc_html__( 'docker', 'lunfest' ),
                'fas fa-dollar-sign' => esc_html__( 'dollar-sign', 'lunfest' ),
                'fas fa-dolly' => esc_html__( 'dolly', 'lunfest' ),
                'fas fa-dolly-flatbed' => esc_html__( 'dolly-flatbed', 'lunfest' ),
                'fas fa-donate' => esc_html__( 'donate', 'lunfest' ),
                'fas fa-dot-circle' => esc_html__( 'dot-circle', 'lunfest' ),
                'far fa-dot-circle' => esc_html__( 'dot-circle', 'lunfest' ),
                'fas fa-dove' => esc_html__( 'dove', 'lunfest' ),
                'fas fa-download' => esc_html__( 'download', 'lunfest' ),
                'fab fa-draft2digital' => esc_html__( 'draft2digital', 'lunfest' ),
                'fab fa-dribbble' => esc_html__( 'dribbble', 'lunfest' ),
                'fab fa-dribbble-square' => esc_html__( 'dribbble-square', 'lunfest' ),
                'fab fa-dropbox' => esc_html__( 'dropbox', 'lunfest' ),
                'fab fa-drupal' => esc_html__( 'drupal', 'lunfest' ),
                'fab fa-dyalog' => esc_html__( 'dyalog', 'lunfest' ),
                'fab fa-earlybirds' => esc_html__( 'earlybirds', 'lunfest' ),
                'fab fa-edge' => esc_html__( 'edge', 'lunfest' ),
                'fas fa-edit' => esc_html__( 'edit', 'lunfest' ),
                'far fa-edit' => esc_html__( 'edit', 'lunfest' ),
                'fas fa-eject' => esc_html__( 'eject', 'lunfest' ),
                'fab fa-elementor' => esc_html__( 'elementor', 'lunfest' ),
                'fas fa-ellipsis-h' => esc_html__( 'ellipsis-h', 'lunfest' ),
                'fas fa-ellipsis-v' => esc_html__( 'ellipsis-v', 'lunfest' ),
                'fab fa-ember' => esc_html__( 'ember', 'lunfest' ),
                'fab fa-empire' => esc_html__( 'empire', 'lunfest' ),
                'fas fa-envelope' => esc_html__( 'envelope', 'lunfest' ),
                'far fa-envelope' => esc_html__( 'envelope', 'lunfest' ),
                'fas fa-envelope-open' => esc_html__( 'envelope-open', 'lunfest' ),
                'far fa-envelope-open' => esc_html__( 'envelope-open', 'lunfest' ),
                'fas fa-envelope-square' => esc_html__( 'envelope-square', 'lunfest' ),
                'fab fa-envira' => esc_html__( 'envira', 'lunfest' ),
                'fas fa-eraser' => esc_html__( 'eraser', 'lunfest' ),
                'fab fa-erlang' => esc_html__( 'erlang', 'lunfest' ),
                'fab fa-ethereum' => esc_html__( 'ethereum', 'lunfest' ),
                'fab fa-etsy' => esc_html__( 'etsy', 'lunfest' ),
                'fas fa-euro-sign' => esc_html__( 'euro-sign', 'lunfest' ),
                'fas fa-exchange-alt' => esc_html__( 'exchange-alt', 'lunfest' ),
                'fas fa-exclamation' => esc_html__( 'exclamation', 'lunfest' ),
                'fas fa-exclamation-circle' => esc_html__( 'exclamation-circle', 'lunfest' ),
                'fas fa-exclamation-triangle' => esc_html__( 'exclamation-triangle', 'lunfest' ),
                'fas fa-expand' => esc_html__( 'expand', 'lunfest' ),
                'fas fa-expand-arrows-alt' => esc_html__( 'expand-arrows-alt', 'lunfest' ),
                'fab fa-expeditedssl' => esc_html__( 'expeditedssl', 'lunfest' ),
                'fas fa-external-link-alt' => esc_html__( 'external-link-alt', 'lunfest' ),
                'fas fa-external-link-square-alt' => esc_html__( 'external-link-square-alt', 'lunfest' ),
                'fas fa-eye' => esc_html__( 'eye', 'lunfest' ),
                'fas fa-eye-dropper' => esc_html__( 'eye-dropper', 'lunfest' ),
                'fas fa-eye-slash' => esc_html__( 'eye-slash', 'lunfest' ),
                'far fa-eye-slash' => esc_html__( 'eye-slash', 'lunfest' ),
                'fab fa-facebook' => esc_html__( 'facebook', 'lunfest' ),
                'fab fa-facebook-f' => esc_html__( 'facebook-f', 'lunfest' ),
                'fab fa-facebook-messenger' => esc_html__( 'facebook-messenger', 'lunfest' ),
                'fab fa-facebook-square' => esc_html__( 'facebook-square', 'lunfest' ),
                'fas fa-fast-backward' => esc_html__( 'fast-backward', 'lunfest' ),
                'fas fa-fast-forward' => esc_html__( 'fast-forward', 'lunfest' ),
                'fas fa-fax' => esc_html__( 'fax', 'lunfest' ),
                'fas fa-female' => esc_html__( 'female', 'lunfest' ),
                'fas fa-fighter-jet' => esc_html__( 'fighter-jet', 'lunfest' ),
                'fas fa-file' => esc_html__( 'file', 'lunfest' ),
                'far fa-file' => esc_html__( 'file', 'lunfest' ),
                'fas fa-file-alt' => esc_html__( 'file-alt', 'lunfest' ),
                'far fa-file-alt' => esc_html__( 'file-alt', 'lunfest' ),
                'fas fa-file-archive' => esc_html__( 'file-archive', 'lunfest' ),
                'far fa-file-archive' => esc_html__( 'file-archive', 'lunfest' ),
                'fas fa-file-audio' => esc_html__( 'file-audio', 'lunfest' ),
                'far fa-file-audio' => esc_html__( 'file-audio', 'lunfest' ),
                'fas fa-file-code' => esc_html__( 'file-code', 'lunfest' ),
                'far fa-file-code' => esc_html__( 'file-code', 'lunfest' ),
                'fas fa-file-excel' => esc_html__( 'file-excel', 'lunfest' ),
                'far fa-file-excel' => esc_html__( 'file-excel', 'lunfest' ),
                'fas fa-file-image' => esc_html__( 'file-image', 'lunfest' ),
                'far fa-file-image' => esc_html__( 'file-image', 'lunfest' ),
                'fas fa-file-medical' => esc_html__( 'file-medical', 'lunfest' ),
                'fas fa-file-medical-alt' => esc_html__( 'file-medical-alt', 'lunfest' ),
                'fas fa-file-pdf' => esc_html__( 'file-pdf', 'lunfest' ),
                'far fa-file-pdf' => esc_html__( 'file-pdf', 'lunfest' ),
                'fas fa-file-powerpoint' => esc_html__( 'file-powerpoint', 'lunfest' ),
                'far fa-file-powerpoint' => esc_html__( 'file-powerpoint', 'lunfest' ),
                'fas fa-file-video' => esc_html__( 'file-video', 'lunfest' ),
                'far fa-file-video' => esc_html__( 'file-video', 'lunfest' ),
                'fas fa-file-word' => esc_html__( 'file-word', 'lunfest' ),
                'far fa-file-word' => esc_html__( 'file-word', 'lunfest' ),
                'fas fa-film' => esc_html__( 'film', 'lunfest' ),
                'fas fa-filter' => esc_html__( 'filter', 'lunfest' ),
                'fas fa-fire' => esc_html__( 'fire', 'lunfest' ),
                'fas fa-fire-extinguisher' => esc_html__( 'fire-extinguisher', 'lunfest' ),
                'fab fa-firefox' => esc_html__( 'firefox', 'lunfest' ),
                'fas fa-first-aid' => esc_html__( 'first-aid', 'lunfest' ),
                'fab fa-first-order' => esc_html__( 'first-order', 'lunfest' ),
                'fab fa-firstdraft' => esc_html__( 'firstdraft', 'lunfest' ),
                'fas fa-flag' => esc_html__( 'flag', 'lunfest' ),
                'far fa-flag' => esc_html__( 'flag', 'lunfest' ),
                'fas fa-flag-checkered' => esc_html__( 'flag-checkered', 'lunfest' ),
                'fas fa-flask' => esc_html__( 'flask', 'lunfest' ),
                'fab fa-flickr' => esc_html__( 'flickr', 'lunfest' ),
                'fab fa-flipboard' => esc_html__( 'flipboard', 'lunfest' ),
                'fab fa-fly' => esc_html__( 'fly', 'lunfest' ),
                'fas fa-folder' => esc_html__( 'folder', 'lunfest' ),
                'far fa-folder' => esc_html__( 'folder', 'lunfest' ),
                'fas fa-folder-open' => esc_html__( 'folder-open', 'lunfest' ),
                'far fa-folder-open' => esc_html__( 'folder-open', 'lunfest' ),
                'fas fa-font' => esc_html__( 'font', 'lunfest' ),
                'fab fa-font-awesome' => esc_html__( 'font-awesome', 'lunfest' ),
                'fab fa-font-awesome-alt' => esc_html__( 'font-awesome-alt', 'lunfest' ),
                'fab fa-font-awesome-flag' => esc_html__( 'font-awesome-flag', 'lunfest' ),
                'fab fa-fonticons' => esc_html__( 'fonticons', 'lunfest' ),
                'fab fa-fonticons-fi' => esc_html__( 'fonticons-fi', 'lunfest' ),
                'fas fa-football-ball' => esc_html__( 'football-ball', 'lunfest' ),
                'fab fa-fort-awesome' => esc_html__( 'fort-awesome', 'lunfest' ),
                'fab fa-fort-awesome-alt' => esc_html__( 'fort-awesome-alt', 'lunfest' ),
                'fab fa-forumbee' => esc_html__( 'forumbee', 'lunfest' ),
                'fas fa-forward' => esc_html__( 'forward', 'lunfest' ),
                'fab fa-foursquare' => esc_html__( 'foursquare', 'lunfest' ),
                'fab fa-free-code-camp' => esc_html__( 'free-code-camp', 'lunfest' ),
                'fab fa-freebsd' => esc_html__( 'freebsd', 'lunfest' ),
                'fas fa-frown' => esc_html__( 'frown', 'lunfest' ),
                'far fa-frown' => esc_html__( 'frown', 'lunfest' ),
                'fas fa-futbol' => esc_html__( 'futbol', 'lunfest' ),
                'far fa-futbol' => esc_html__( 'futbol', 'lunfest' ),
                'fas fa-gamepad' => esc_html__( 'gamepad', 'lunfest' ),
                'fas fa-gavel' => esc_html__( 'gavel', 'lunfest' ),
                'fas fa-gem' => esc_html__( 'gem', 'lunfest' ),
                'far fa-gem' => esc_html__( 'gem', 'lunfest' ),
                'fas fa-genderless' => esc_html__( 'genderless', 'lunfest' ),
                'fab fa-get-pocket' => esc_html__( 'get-pocket', 'lunfest' ),
                'fab fa-gg' => esc_html__( 'gg', 'lunfest' ),
                'fab fa-gg-circle' => esc_html__( 'gg-circle', 'lunfest' ),
                'fas fa-gift' => esc_html__( 'gift', 'lunfest' ),
                'fab fa-git' => esc_html__( 'git', 'lunfest' ),
                'fab fa-git-square' => esc_html__( 'git-square', 'lunfest' ),
                'fab fa-github' => esc_html__( 'github', 'lunfest' ),
                'fab fa-github-alt' => esc_html__( 'github-alt', 'lunfest' ),
                'fab fa-github-square' => esc_html__( 'github-square', 'lunfest' ),
                'fab fa-gitkraken' => esc_html__( 'gitkraken', 'lunfest' ),
                'fab fa-gitlab' => esc_html__( 'gitlab', 'lunfest' ),
                'fab fa-gitter' => esc_html__( 'gitter', 'lunfest' ),
                'fas fa-glass-martini' => esc_html__( 'glass-martini', 'lunfest' ),
                'fab fa-glide' => esc_html__( 'glide', 'lunfest' ),
                'fab fa-glide-g' => esc_html__( 'glide-g', 'lunfest' ),
                'fas fa-globe' => esc_html__( 'globe', 'lunfest' ),
                'fab fa-gofore' => esc_html__( 'gofore', 'lunfest' ),
                'fas fa-golf-ball' => esc_html__( 'golf-ball', 'lunfest' ),
                'fab fa-goodreads' => esc_html__( 'goodreads', 'lunfest' ),
                'fab fa-goodreads-g' => esc_html__( 'goodreads-g', 'lunfest' ),
                'fab fa-google' => esc_html__( 'google', 'lunfest' ),
                'fab fa-google-drive' => esc_html__( 'google-drive', 'lunfest' ),
                'fab fa-google-play' => esc_html__( 'google-play', 'lunfest' ),
                'fab fa-google-plus' => esc_html__( 'google-plus', 'lunfest' ),
                'fab fa-google-plus-g' => esc_html__( 'google-plus-g', 'lunfest' ),
                'fab fa-google-plus-square' => esc_html__( 'google-plus-square', 'lunfest' ),
                'fab fa-google-wallet' => esc_html__( 'google-wallet', 'lunfest' ),
                'fas fa-graduation-cap' => esc_html__( 'graduation-cap', 'lunfest' ),
                'fab fa-gratipay' => esc_html__( 'gratipay', 'lunfest' ),
                'fab fa-grav' => esc_html__( 'grav', 'lunfest' ),
                'fab fa-gripfire' => esc_html__( 'gripfire', 'lunfest' ),
                'fab fa-grunt' => esc_html__( 'grunt', 'lunfest' ),
                'fab fa-gulp' => esc_html__( 'gulp', 'lunfest' ),
                'fas fa-h-square' => esc_html__( 'h-square', 'lunfest' ),
                'fab fa-hacker-news' => esc_html__( 'hacker-news', 'lunfest' ),
                'fab fa-hacker-news-square' => esc_html__( 'hacker-news-square', 'lunfest' ),
                'fas fa-hand-holding' => esc_html__( 'hand-holding', 'lunfest' ),
                'fas fa-hand-holding-heart' => esc_html__( 'hand-holding-heart', 'lunfest' ),
                'fas fa-hand-holding-usd' => esc_html__( 'hand-holding-usd', 'lunfest' ),
                'fas fa-hand-lizard' => esc_html__( 'hand-lizard', 'lunfest' ),
                'far fa-hand-lizard' => esc_html__( 'hand-lizard', 'lunfest' ),
                'fas fa-hand-paper' => esc_html__( 'hand-paper', 'lunfest' ),
                'far fa-hand-paper' => esc_html__( 'hand-paper', 'lunfest' ),
                'fas fa-hand-peace' => esc_html__( 'hand-peace', 'lunfest' ),
                'far fa-hand-peace' => esc_html__( 'hand-peace', 'lunfest' ),
                'fas fa-hand-point-down' => esc_html__( 'hand-point-down', 'lunfest' ),
                'far fa-hand-point-down' => esc_html__( 'hand-point-down', 'lunfest' ),
                'fas fa-hand-point-left' => esc_html__( 'hand-point-left', 'lunfest' ),
                'far fa-hand-point-left' => esc_html__( 'hand-point-left', 'lunfest' ),
                'fas fa-hand-point-right' => esc_html__( 'hand-point-right', 'lunfest' ),
                'far fa-hand-point-right' => esc_html__( 'hand-point-right', 'lunfest' ),
                'fas fa-hand-point-up' => esc_html__( 'hand-point-up', 'lunfest' ),
                'far fa-hand-point-up' => esc_html__( 'hand-point-up', 'lunfest' ),
                'fas fa-hand-pointer' => esc_html__( 'hand-pointer', 'lunfest' ),
                'far fa-hand-pointer' => esc_html__( 'hand-pointer', 'lunfest' ),
                'fas fa-hand-rock' => esc_html__( 'hand-rock', 'lunfest' ),
                'far fa-hand-rock' => esc_html__( 'hand-rock', 'lunfest' ),
                'fas fa-hand-scissors' => esc_html__( 'hand-scissors', 'lunfest' ),
                'far fa-hand-scissors' => esc_html__( 'hand-scissors', 'lunfest' ),
                'fas fa-hand-spock' => esc_html__( 'hand-spock', 'lunfest' ),
                'far fa-hand-spock' => esc_html__( 'hand-spock', 'lunfest' ),
                'fas fa-hands' => esc_html__( 'hands', 'lunfest' ),
                'fas fa-hands-helping' => esc_html__( 'hands-helping', 'lunfest' ),
                'fas fa-handshake' => esc_html__( 'handshake', 'lunfest' ),
                'far fa-handshake' => esc_html__( 'handshake', 'lunfest' ),
                'fas fa-hashtag' => esc_html__( 'hashtag', 'lunfest' ),
                'fas fa-hdd' => esc_html__( 'hdd', 'lunfest' ),
                'far fa-hdd' => esc_html__( 'hdd', 'lunfest' ),
                'fas fa-heading' => esc_html__( 'heading', 'lunfest' ),
                'fas fa-headphones' => esc_html__( 'headphones', 'lunfest' ),
                'fas fa-heart' => esc_html__( 'heart', 'lunfest' ),
                'far fa-heart' => esc_html__( 'heart', 'lunfest' ),
                'fas fa-heartbeat' => esc_html__( 'heartbeat', 'lunfest' ),
                'fab fa-hips' => esc_html__( 'hips', 'lunfest' ),
                'fab fa-hire-a-helper' => esc_html__( 'hire-a-helper', 'lunfest' ),
                'fas fa-history' => esc_html__( 'history', 'lunfest' ),
                'fas fa-hockey-puck' => esc_html__( 'hockey-puck', 'lunfest' ),
                'fas fa-home' => esc_html__( 'home', 'lunfest' ),
                'fab fa-hooli' => esc_html__( 'hooli', 'lunfest' ),
                'fas fa-hospital' => esc_html__( 'hospital', 'lunfest' ),
                'far fa-hospital' => esc_html__( 'hospital', 'lunfest' ),
                'fas fa-hospital-alt' => esc_html__( 'hospital-alt', 'lunfest' ),
                'fas fa-hospital-symbol' => esc_html__( 'hospital-symbol', 'lunfest' ),
                'fab fa-hotjar' => esc_html__( 'hotjar', 'lunfest' ),
                'fas fa-hourglass' => esc_html__( 'hourglass', 'lunfest' ),
                'far fa-hourglass' => esc_html__( 'hourglass', 'lunfest' ),
                'fas fa-hourglass-end' => esc_html__( 'hourglass-end', 'lunfest' ),
                'fas fa-hourglass-half' => esc_html__( 'hourglass-half', 'lunfest' ),
                'fas fa-hourglass-start' => esc_html__( 'hourglass-start', 'lunfest' ),
                'fab fa-houzz' => esc_html__( 'houzz', 'lunfest' ),
                'fab fa-html5' => esc_html__( 'html5', 'lunfest' ),
                'fab fa-hubspot' => esc_html__( 'hubspot', 'lunfest' ),
                'fas fa-i-cursor' => esc_html__( 'i-cursor', 'lunfest' ),
                'fas fa-id-badge' => esc_html__( 'id-badge', 'lunfest' ),
                'far fa-id-badge' => esc_html__( 'id-badge', 'lunfest' ),
                'fas fa-id-card' => esc_html__( 'id-card', 'lunfest' ),
                'far fa-id-card' => esc_html__( 'id-card', 'lunfest' ),
                'fas fa-id-card-alt' => esc_html__( 'id-card-alt', 'lunfest' ),
                'fas fa-image' => esc_html__( 'image', 'lunfest' ),
                'far fa-image' => esc_html__( 'image', 'lunfest' ),
                'fas fa-images' => esc_html__( 'images', 'lunfest' ),
                'far fa-images' => esc_html__( 'images', 'lunfest' ),
                'fab fa-imdb' => esc_html__( 'imdb', 'lunfest' ),
                'fas fa-inbox' => esc_html__( 'inbox', 'lunfest' ),
                'fas fa-indent' => esc_html__( 'indent', 'lunfest' ),
                'fas fa-industry' => esc_html__( 'industry', 'lunfest' ),
                'fas fa-info' => esc_html__( 'info', 'lunfest' ),
                'fas fa-info-circle' => esc_html__( 'info-circle', 'lunfest' ),
                'fab fa-instagram' => esc_html__( 'instagram', 'lunfest' ),
                'fab fa-internet-explorer' => esc_html__( 'internet-explorer', 'lunfest' ),
                'fab fa-ioxhost' => esc_html__( 'ioxhost', 'lunfest' ),
                'fas fa-italic' => esc_html__( 'italic', 'lunfest' ),
                'fab fa-itunes' => esc_html__( 'itunes', 'lunfest' ),
                'fab fa-itunes-note' => esc_html__( 'itunes-note', 'lunfest' ),
                'fab fa-java' => esc_html__( 'java', 'lunfest' ),
                'fab fa-jenkins' => esc_html__( 'jenkins', 'lunfest' ),
                'fab fa-joget' => esc_html__( 'joget', 'lunfest' ),
                'fab fa-joomla' => esc_html__( 'joomla', 'lunfest' ),
                'fab fa-js' => esc_html__( 'js', 'lunfest' ),
                'fab fa-js-square' => esc_html__( 'js-square', 'lunfest' ),
                'fab fa-jsfiddle' => esc_html__( 'jsfiddle', 'lunfest' ),
                'fas fa-key' => esc_html__( 'key', 'lunfest' ),
                'fas fa-keyboard' => esc_html__( 'keyboard', 'lunfest' ),
                'far fa-keyboard' => esc_html__( 'keyboard', 'lunfest' ),
                'fab fa-keycdn' => esc_html__( 'keycdn', 'lunfest' ),
                'fab fa-kickstarter' => esc_html__( 'kickstarter', 'lunfest' ),
                'fab fa-kickstarter-k' => esc_html__( 'kickstarter-k', 'lunfest' ),
                'fab fa-korvue' => esc_html__( 'korvue', 'lunfest' ),
                'fas fa-language' => esc_html__( 'language', 'lunfest' ),
                'fas fa-laptop' => esc_html__( 'laptop', 'lunfest' ),
                'fab fa-laravel' => esc_html__( 'laravel', 'lunfest' ),
                'fab fa-lastfm' => esc_html__( 'lastfm', 'lunfest' ),
                'fab fa-lastfm-square' => esc_html__( 'lastfm-square', 'lunfest' ),
                'fas fa-leaf' => esc_html__( 'leaf', 'lunfest' ),
                'fab fa-leanpub' => esc_html__( 'leanpub', 'lunfest' ),
                'fas fa-lemon' => esc_html__( 'lemon', 'lunfest' ),
                'far fa-lemon' => esc_html__( 'lemon', 'lunfest' ),
                'fab fa-less' => esc_html__( 'less', 'lunfest' ),
                'fas fa-level-down-alt' => esc_html__( 'level-down-alt', 'lunfest' ),
                'fas fa-level-up-alt' => esc_html__( 'level-up-alt', 'lunfest' ),
                'fas fa-life-ring' => esc_html__( 'life-ring', 'lunfest' ),
                'far fa-life-ring' => esc_html__( 'life-ring', 'lunfest' ),
                'fas fa-lightbulb' => esc_html__( 'lightbulb', 'lunfest' ),
                'far fa-lightbulb' => esc_html__( 'lightbulb', 'lunfest' ),
                'fab fa-line' => esc_html__( 'line', 'lunfest' ),
                'fas fa-link' => esc_html__( 'link', 'lunfest' ),
                'fab fa-linkedin' => esc_html__( 'linkedin', 'lunfest' ),
                'fab fa-linkedin-in' => esc_html__( 'linkedin-in', 'lunfest' ),
                'fab fa-linode' => esc_html__( 'linode', 'lunfest' ),
                'fab fa-linux' => esc_html__( 'linux', 'lunfest' ),
                'fas fa-lira-sign' => esc_html__( 'lira-sign', 'lunfest' ),
                'fas fa-list' => esc_html__( 'list', 'lunfest' ),
                'fas fa-list-alt' => esc_html__( 'list-alt', 'lunfest' ),
                'far fa-list-alt' => esc_html__( 'list-alt', 'lunfest' ),
                'fas fa-list-ol' => esc_html__( 'list-ol', 'lunfest' ),
                'fas fa-list-ul' => esc_html__( 'list-ul', 'lunfest' ),
                'fas fa-location-arrow' => esc_html__( 'location-arrow', 'lunfest' ),
                'fas fa-lock' => esc_html__( 'lock', 'lunfest' ),
                'fas fa-lock-open' => esc_html__( 'lock-open', 'lunfest' ),
                'fas fa-long-arrow-alt-down' => esc_html__( 'long-arrow-alt-down', 'lunfest' ),
                'fas fa-long-arrow-alt-left' => esc_html__( 'long-arrow-alt-left', 'lunfest' ),
                'fas fa-long-arrow-alt-right' => esc_html__( 'long-arrow-alt-right', 'lunfest' ),
                'fas fa-long-arrow-alt-up' => esc_html__( 'long-arrow-alt-up', 'lunfest' ),
                'fas fa-low-vision' => esc_html__( 'low-vision', 'lunfest' ),
                'fab fa-lyft' => esc_html__( 'lyft', 'lunfest' ),
                'fab fa-magento' => esc_html__( 'magento', 'lunfest' ),
                'fas fa-magic' => esc_html__( 'magic', 'lunfest' ),
                'fas fa-magnet' => esc_html__( 'magnet', 'lunfest' ),
                'fas fa-male' => esc_html__( 'male', 'lunfest' ),
                'fas fa-map' => esc_html__( 'map', 'lunfest' ),
                'far fa-map' => esc_html__( 'map', 'lunfest' ),
                'fas fa-map-marker' => esc_html__( 'map-marker', 'lunfest' ),
                'fas fa-map-marker-alt' => esc_html__( 'map-marker-alt', 'lunfest' ),
                'fas fa-map-pin' => esc_html__( 'map-pin', 'lunfest' ),
                'fas fa-map-signs' => esc_html__( 'map-signs', 'lunfest' ),
                'fas fa-mars' => esc_html__( 'mars', 'lunfest' ),
                'fas fa-mars-double' => esc_html__( 'mars-double', 'lunfest' ),
                'fas fa-mars-stroke' => esc_html__( 'mars-stroke', 'lunfest' ),
                'fas fa-mars-stroke-h' => esc_html__( 'mars-stroke-h', 'lunfest' ),
                'fas fa-mars-stroke-v' => esc_html__( 'mars-stroke-v', 'lunfest' ),
                'fab fa-maxcdn' => esc_html__( 'maxcdn', 'lunfest' ),
                'fab fa-medapps' => esc_html__( 'medapps', 'lunfest' ),
                'fab fa-medium' => esc_html__( 'medium', 'lunfest' ),
                'fab fa-medium-m' => esc_html__( 'medium-m', 'lunfest' ),
                'fas fa-medkit' => esc_html__( 'medkit', 'lunfest' ),
                'fab fa-medrt' => esc_html__( 'medrt', 'lunfest' ),
                'fab fa-meetup' => esc_html__( 'meetup', 'lunfest' ),
                'fas fa-meh' => esc_html__( 'meh', 'lunfest' ),
                'far fa-meh' => esc_html__( 'meh', 'lunfest' ),
                'fas fa-mercury' => esc_html__( 'mercury', 'lunfest' ),
                'fas fa-microchip' => esc_html__( 'microchip', 'lunfest' ),
                'fas fa-microphone' => esc_html__( 'microphone', 'lunfest' ),
                'fas fa-microphone-slash' => esc_html__( 'microphone-slash', 'lunfest' ),
                'fab fa-microsoft' => esc_html__( 'microsoft', 'lunfest' ),
                'fas fa-minus' => esc_html__( 'minus', 'lunfest' ),
                'fas fa-minus-circle' => esc_html__( 'minus-circle', 'lunfest' ),
                'fas fa-minus-square' => esc_html__( 'minus-square', 'lunfest' ),
                'far fa-minus-square' => esc_html__( 'minus-square', 'lunfest' ),
                'fab fa-mix' => esc_html__( 'mix', 'lunfest' ),
                'fab fa-mixcloud' => esc_html__( 'mixcloud', 'lunfest' ),
                'fab fa-mizuni' => esc_html__( 'mizuni', 'lunfest' ),
                'fas fa-mobile' => esc_html__( 'mobile', 'lunfest' ),
                'fas fa-mobile-alt' => esc_html__( 'mobile-alt', 'lunfest' ),
                'fab fa-modx' => esc_html__( 'modx', 'lunfest' ),
                'fab fa-monero' => esc_html__( 'monero', 'lunfest' ),
                'fas fa-money-bill-alt' => esc_html__( 'money-bill-alt', 'lunfest' ),
                'far fa-money-bill-alt' => esc_html__( 'money-bill-alt', 'lunfest' ),
                'fas fa-moon' => esc_html__( 'moon', 'lunfest' ),
                'far fa-moon' => esc_html__( 'moon', 'lunfest' ),
                'fas fa-motorcycle' => esc_html__( 'motorcycle', 'lunfest' ),
                'fas fa-mouse-pointer' => esc_html__( 'mouse-pointer', 'lunfest' ),
                'fas fa-music' => esc_html__( 'music', 'lunfest' ),
                'fab fa-napster' => esc_html__( 'napster', 'lunfest' ),
                'fas fa-neuter' => esc_html__( 'neuter', 'lunfest' ),
                'fas fa-newspaper' => esc_html__( 'newspaper', 'lunfest' ),
                'far fa-newspaper' => esc_html__( 'newspaper', 'lunfest' ),
                'fab fa-nintendo-switch' => esc_html__( 'nintendo-switch', 'lunfest' ),
                'fab fa-node' => esc_html__( 'node', 'lunfest' ),
                'fab fa-node-js' => esc_html__( 'node-js', 'lunfest' ),
                'fas fa-notes-medical' => esc_html__( 'notes-medical', 'lunfest' ),
                'fab fa-npm' => esc_html__( 'npm', 'lunfest' ),
                'fab fa-ns8' => esc_html__( 'ns8', 'lunfest' ),
                'fab fa-nutritionix' => esc_html__( 'nutritionix', 'lunfest' ),
                'fas fa-object-group' => esc_html__( 'object-group', 'lunfest' ),
                'far fa-object-group' => esc_html__( 'object-group', 'lunfest' ),
                'fas fa-object-ungroup' => esc_html__( 'object-ungroup', 'lunfest' ),
                'far fa-object-ungroup' => esc_html__( 'object-ungroup', 'lunfest' ),
                'fab fa-odnoklassniki' => esc_html__( 'odnoklassniki', 'lunfest' ),
                'fab fa-odnoklassniki-square' => esc_html__( 'odnoklassniki-square', 'lunfest' ),
                'fab fa-opencart' => esc_html__( 'opencart', 'lunfest' ),
                'fab fa-openid' => esc_html__( 'openid', 'lunfest' ),
                'fab fa-opera' => esc_html__( 'opera', 'lunfest' ),
                'fab fa-optin-monster' => esc_html__( 'optin-monster', 'lunfest' ),
                'fab fa-osi' => esc_html__( 'osi', 'lunfest' ),
                'fas fa-outdent' => esc_html__( 'outdent', 'lunfest' ),
                'fab fa-page4' => esc_html__( 'page4', 'lunfest' ),
                'fab fa-pagelines' => esc_html__( 'pagelines', 'lunfest' ),
                'fas fa-paint-brush' => esc_html__( 'paint-brush', 'lunfest' ),
                'fab fa-palfed' => esc_html__( 'palfed', 'lunfest' ),
                'fas fa-pallet' => esc_html__( 'pallet', 'lunfest' ),
                'fas fa-paper-plane' => esc_html__( 'paper-plane', 'lunfest' ),
                'far fa-paper-plane' => esc_html__( 'paper-plane', 'lunfest' ),
                'fas fa-paperclip' => esc_html__( 'paperclip', 'lunfest' ),
                'fas fa-parachute-box' => esc_html__( 'parachute-box', 'lunfest' ),
                'fas fa-paragraph' => esc_html__( 'paragraph', 'lunfest' ),
                'fas fa-paste' => esc_html__( 'paste', 'lunfest' ),
                'fab fa-patreon' => esc_html__( 'patreon', 'lunfest' ),
                'fas fa-pause' => esc_html__( 'pause', 'lunfest' ),
                'fas fa-pause-circle' => esc_html__( 'pause-circle', 'lunfest' ),
                'far fa-pause-circle' => esc_html__( 'pause-circle', 'lunfest' ),
                'fas fa-paw' => esc_html__( 'paw', 'lunfest' ),
                'fab fa-paypal' => esc_html__( 'paypal', 'lunfest' ),
                'fas fa-pen-square' => esc_html__( 'pen-square', 'lunfest' ),
                'fas fa-pencil-alt' => esc_html__( 'pencil-alt', 'lunfest' ),
                'fas fa-people-carry' => esc_html__( 'people-carry', 'lunfest' ),
                'fas fa-percent' => esc_html__( 'percent', 'lunfest' ),
                'fab fa-periscope' => esc_html__( 'periscope', 'lunfest' ),
                'fab fa-phabricator' => esc_html__( 'phabricator', 'lunfest' ),
                'fab fa-phoenix-framework' => esc_html__( 'phoenix-framework', 'lunfest' ),
                'fas fa-phone' => esc_html__( 'phone', 'lunfest' ),
                'fas fa-phone-slash' => esc_html__( 'phone-slash', 'lunfest' ),
                'fas fa-phone-square' => esc_html__( 'phone-square', 'lunfest' ),
                'fas fa-phone-volume' => esc_html__( 'phone-volume', 'lunfest' ),
                'fab fa-php' => esc_html__( 'php', 'lunfest' ),
                'fab fa-pied-piper' => esc_html__( 'pied-piper', 'lunfest' ),
                'fab fa-pied-piper-alt' => esc_html__( 'pied-piper-alt', 'lunfest' ),
                'fab fa-pied-piper-hat' => esc_html__( 'pied-piper-hat', 'lunfest' ),
                'fab fa-pied-piper-pp' => esc_html__( 'pied-piper-pp', 'lunfest' ),
                'fas fa-piggy-bank' => esc_html__( 'piggy-bank', 'lunfest' ),
                'fas fa-pills' => esc_html__( 'pills', 'lunfest' ),
                'fab fa-pinterest' => esc_html__( 'pinterest', 'lunfest' ),
                'fab fa-pinterest-p' => esc_html__( 'pinterest-p', 'lunfest' ),
                'fab fa-pinterest-square' => esc_html__( 'pinterest-square', 'lunfest' ),
                'fas fa-plane' => esc_html__( 'plane', 'lunfest' ),
                'fas fa-play' => esc_html__( 'play', 'lunfest' ),
                'fas fa-play-circle' => esc_html__( 'play-circle', 'lunfest' ),
                'far fa-play-circle' => esc_html__( 'play-circle', 'lunfest' ),
                'fab fa-playstation' => esc_html__( 'playstation', 'lunfest' ),
                'fas fa-plug' => esc_html__( 'plug', 'lunfest' ),
                'fas fa-plus' => esc_html__( 'plus', 'lunfest' ),
                'fas fa-plus-circle' => esc_html__( 'plus-circle', 'lunfest' ),
                'fas fa-plus-square' => esc_html__( 'plus-square', 'lunfest' ),
                'far fa-plus-square' => esc_html__( 'plus-square', 'lunfest' ),
                'fas fa-podcast' => esc_html__( 'podcast', 'lunfest' ),
                'fas fa-poo' => esc_html__( 'poo', 'lunfest' ),
                'fas fa-pound-sign' => esc_html__( 'pound-sign', 'lunfest' ),
                'fas fa-power-off' => esc_html__( 'power-off', 'lunfest' ),
                'fas fa-prescription-bottle' => esc_html__( 'prescription-bottle', 'lunfest' ),
                'fas fa-prescription-bottle-alt' => esc_html__( 'prescription-bottle-alt', 'lunfest' ),
                'fas fa-print' => esc_html__( 'print', 'lunfest' ),
                'fas fa-procedures' => esc_html__( 'procedures', 'lunfest' ),
                'fab fa-product-hunt' => esc_html__( 'product-hunt', 'lunfest' ),
                'fab fa-pushed' => esc_html__( 'pushed', 'lunfest' ),
                'fas fa-puzzle-piece' => esc_html__( 'puzzle-piece', 'lunfest' ),
                'fab fa-python' => esc_html__( 'python', 'lunfest' ),
                'fab fa-qq' => esc_html__( 'qq', 'lunfest' ),
                'fas fa-qrcode' => esc_html__( 'qrcode', 'lunfest' ),
                'fas fa-question' => esc_html__( 'question', 'lunfest' ),
                'fas fa-question-circle' => esc_html__( 'question-circle', 'lunfest' ),
                'far fa-question-circle' => esc_html__( 'question-circle', 'lunfest' ),
                'fas fa-quidditch' => esc_html__( 'quidditch', 'lunfest' ),
                'fab fa-quinscape' => esc_html__( 'quinscape', 'lunfest' ),
                'fab fa-quora' => esc_html__( 'quora', 'lunfest' ),
                'fas fa-quote-left' => esc_html__( 'quote-left', 'lunfest' ),
                'fas fa-quote-right' => esc_html__( 'quote-right', 'lunfest' ),
                'fas fa-random' => esc_html__( 'random', 'lunfest' ),
                'fab fa-ravelry' => esc_html__( 'ravelry', 'lunfest' ),
                'fab fa-react' => esc_html__( 'react', 'lunfest' ),
                'fab fa-readme' => esc_html__( 'readme', 'lunfest' ),
                'fab fa-rebel' => esc_html__( 'rebel', 'lunfest' ),
                'fas fa-recycle' => esc_html__( 'recycle', 'lunfest' ),
                'fab fa-red-river' => esc_html__( 'red-river', 'lunfest' ),
                'fab fa-reddit' => esc_html__( 'reddit', 'lunfest' ),
                'fab fa-reddit-alien' => esc_html__( 'reddit-alien', 'lunfest' ),
                'fab fa-reddit-square' => esc_html__( 'reddit-square', 'lunfest' ),
                'fas fa-redo' => esc_html__( 'redo', 'lunfest' ),
                'fas fa-redo-alt' => esc_html__( 'redo-alt', 'lunfest' ),
                'fas fa-registered' => esc_html__( 'registered', 'lunfest' ),
                'far fa-registered' => esc_html__( 'registered', 'lunfest' ),
                'fab fa-rendact' => esc_html__( 'rendact', 'lunfest' ),
                'fab fa-renren' => esc_html__( 'renren', 'lunfest' ),
                'fas fa-reply' => esc_html__( 'reply', 'lunfest' ),
                'fas fa-reply-all' => esc_html__( 'reply-all', 'lunfest' ),
                'fab fa-replyd' => esc_html__( 'replyd', 'lunfest' ),
                'fab fa-resolving' => esc_html__( 'resolving', 'lunfest' ),
                'fas fa-retweet' => esc_html__( 'retweet', 'lunfest' ),
                'fas fa-ribbon' => esc_html__( 'ribbon', 'lunfest' ),
                'fas fa-road' => esc_html__( 'road', 'lunfest' ),
                'fas fa-rocket' => esc_html__( 'rocket', 'lunfest' ),
                'fab fa-rocketchat' => esc_html__( 'rocketchat', 'lunfest' ),
                'fab fa-rockrms' => esc_html__( 'rockrms', 'lunfest' ),
                'fas fa-rss' => esc_html__( 'rss', 'lunfest' ),
                'fas fa-rss-square' => esc_html__( 'rss-square', 'lunfest' ),
                'fas fa-ruble-sign' => esc_html__( 'ruble-sign', 'lunfest' ),
                'fas fa-rupee-sign' => esc_html__( 'rupee-sign', 'lunfest' ),
                'fab fa-safari' => esc_html__( 'safari', 'lunfest' ),
                'fab fa-sass' => esc_html__( 'sass', 'lunfest' ),
                'fas fa-save' => esc_html__( 'save', 'lunfest' ),
                'far fa-save' => esc_html__( 'save', 'lunfest' ),
                'fab fa-schlix' => esc_html__( 'schlix', 'lunfest' ),
                'fab fa-scribd' => esc_html__( 'scribd', 'lunfest' ),
                'fas fa-search' => esc_html__( 'search', 'lunfest' ),
                'fas fa-search-minus' => esc_html__( 'search-minus', 'lunfest' ),
                'fas fa-search-plus' => esc_html__( 'search-plus', 'lunfest' ),
                'fab fa-searchengin' => esc_html__( 'searchengin', 'lunfest' ),
                'fas fa-seedling' => esc_html__( 'seedling', 'lunfest' ),
                'fab fa-sellcast' => esc_html__( 'sellcast', 'lunfest' ),
                'fab fa-sellsy' => esc_html__( 'sellsy', 'lunfest' ),
                'fas fa-server' => esc_html__( 'server', 'lunfest' ),
                'fab fa-servicestack' => esc_html__( 'servicestack', 'lunfest' ),
                'fas fa-share' => esc_html__( 'share', 'lunfest' ),
                'fas fa-share-alt' => esc_html__( 'share-alt', 'lunfest' ),
                'fas fa-share-alt-square' => esc_html__( 'share-alt-square', 'lunfest' ),
                'fas fa-share-square' => esc_html__( 'share-square', 'lunfest' ),
                'far fa-share-square' => esc_html__( 'share-square', 'lunfest' ),
                'fas fa-shekel-sign' => esc_html__( 'shekel-sign', 'lunfest' ),
                'fas fa-shield-alt' => esc_html__( 'shield-alt', 'lunfest' ),
                'fas fa-ship' => esc_html__( 'ship', 'lunfest' ),
                'fas fa-shipping-fast' => esc_html__( 'shipping-fast', 'lunfest' ),
                'fab fa-shirtsinbulk' => esc_html__( 'shirtsinbulk', 'lunfest' ),
                'fas fa-shopping-bag' => esc_html__( 'shopping-bag', 'lunfest' ),
                'fas fa-shopping-basket' => esc_html__( 'shopping-basket', 'lunfest' ),
                'fas fa-shopping-cart' => esc_html__( 'shopping-cart', 'lunfest' ),
                'fas fa-shower' => esc_html__( 'shower', 'lunfest' ),
                'fas fa-sign' => esc_html__( 'sign', 'lunfest' ),
                'fas fa-sign-in-alt' => esc_html__( 'sign-in-alt', 'lunfest' ),
                'fas fa-sign-language' => esc_html__( 'sign-language', 'lunfest' ),
                'fas fa-sign-out-alt' => esc_html__( 'sign-out-alt', 'lunfest' ),
                'fas fa-signal' => esc_html__( 'signal', 'lunfest' ),
                'fab fa-simplybuilt' => esc_html__( 'simplybuilt', 'lunfest' ),
                'fab fa-sistrix' => esc_html__( 'sistrix', 'lunfest' ),
                'fas fa-sitemap' => esc_html__( 'sitemap', 'lunfest' ),
                'fab fa-skyatlas' => esc_html__( 'skyatlas', 'lunfest' ),
                'fab fa-skype' => esc_html__( 'skype', 'lunfest' ),
                'fab fa-slack' => esc_html__( 'slack', 'lunfest' ),
                'fab fa-slack-hash' => esc_html__( 'slack-hash', 'lunfest' ),
                'fas fa-sliders-h' => esc_html__( 'sliders-h', 'lunfest' ),
                'fab fa-slideshare' => esc_html__( 'slideshare', 'lunfest' ),
                'fas fa-smile' => esc_html__( 'smile', 'lunfest' ),
                'far fa-smile' => esc_html__( 'smile', 'lunfest' ),
                'fas fa-smoking' => esc_html__( 'smoking', 'lunfest' ),
                'fab fa-snapchat' => esc_html__( 'snapchat', 'lunfest' ),
                'fab fa-snapchat-ghost' => esc_html__( 'snapchat-ghost', 'lunfest' ),
                'fab fa-snapchat-square' => esc_html__( 'snapchat-square', 'lunfest' ),
                'fas fa-snowflake' => esc_html__( 'snowflake', 'lunfest' ),
                'far fa-snowflake' => esc_html__( 'snowflake', 'lunfest' ),
                'fas fa-sort' => esc_html__( 'sort', 'lunfest' ),
                'fas fa-sort-alpha-down' => esc_html__( 'sort-alpha-down', 'lunfest' ),
                'fas fa-sort-alpha-up' => esc_html__( 'sort-alpha-up', 'lunfest' ),
                'fas fa-sort-amount-down' => esc_html__( 'sort-amount-down', 'lunfest' ),
                'fas fa-sort-amount-up' => esc_html__( 'sort-amount-up', 'lunfest' ),
                'fas fa-sort-down' => esc_html__( 'sort-down', 'lunfest' ),
                'fas fa-sort-numeric-down' => esc_html__( 'sort-numeric-down', 'lunfest' ),
                'fas fa-sort-numeric-up' => esc_html__( 'sort-numeric-up', 'lunfest' ),
                'fas fa-sort-up' => esc_html__( 'sort-up', 'lunfest' ),
                'fab fa-soundcloud' => esc_html__( 'soundcloud', 'lunfest' ),
                'fas fa-space-shuttle' => esc_html__( 'space-shuttle', 'lunfest' ),
                'fab fa-speakap' => esc_html__( 'speakap', 'lunfest' ),
                'fas fa-spinner' => esc_html__( 'spinner', 'lunfest' ),
                'fab fa-spotify' => esc_html__( 'spotify', 'lunfest' ),
                'fas fa-square' => esc_html__( 'square', 'lunfest' ),
                'far fa-square' => esc_html__( 'square', 'lunfest' ),
                'fas fa-square-full' => esc_html__( 'square-full', 'lunfest' ),
                'fab fa-stack-exchange' => esc_html__( 'stack-exchange', 'lunfest' ),
                'fab fa-stack-overflow' => esc_html__( 'stack-overflow', 'lunfest' ),
                'fas fa-star' => esc_html__( 'star', 'lunfest' ),
                'far fa-star' => esc_html__( 'star', 'lunfest' ),
                'fas fa-star-half' => esc_html__( 'star-half', 'lunfest' ),
                'far fa-star-half' => esc_html__( 'star-half', 'lunfest' ),
                'fab fa-staylinked' => esc_html__( 'staylinked', 'lunfest' ),
                'fab fa-steam' => esc_html__( 'steam', 'lunfest' ),
                'fab fa-steam-square' => esc_html__( 'steam-square', 'lunfest' ),
                'fab fa-steam-symbol' => esc_html__( 'steam-symbol', 'lunfest' ),
                'fas fa-step-backward' => esc_html__( 'step-backward', 'lunfest' ),
                'fas fa-step-forward' => esc_html__( 'step-forward', 'lunfest' ),
                'fas fa-stethoscope' => esc_html__( 'stethoscope', 'lunfest' ),
                'fab fa-sticker-mule' => esc_html__( 'sticker-mule', 'lunfest' ),
                'fas fa-sticky-note' => esc_html__( 'sticky-note', 'lunfest' ),
                'far fa-sticky-note' => esc_html__( 'sticky-note', 'lunfest' ),
                'fas fa-stop' => esc_html__( 'stop', 'lunfest' ),
                'fas fa-stop-circle' => esc_html__( 'stop-circle', 'lunfest' ),
                'far fa-stop-circle' => esc_html__( 'stop-circle', 'lunfest' ),
                'fas fa-stopwatch' => esc_html__( 'stopwatch', 'lunfest' ),
                'fab fa-strava' => esc_html__( 'strava', 'lunfest' ),
                'fas fa-street-view' => esc_html__( 'street-view', 'lunfest' ),
                'fas fa-strikethrough' => esc_html__( 'strikethrough', 'lunfest' ),
                'fab fa-stripe' => esc_html__( 'stripe', 'lunfest' ),
                'fab fa-stripe-s' => esc_html__( 'stripe-s', 'lunfest' ),
                'fab fa-studiovinari' => esc_html__( 'studiovinari', 'lunfest' ),
                'fab fa-stumbleupon' => esc_html__( 'stumbleupon', 'lunfest' ),
                'fab fa-stumbleupon-circle' => esc_html__( 'stumbleupon-circle', 'lunfest' ),
                'fas fa-subscript' => esc_html__( 'subscript', 'lunfest' ),
                'fas fa-subway' => esc_html__( 'subway', 'lunfest' ),
                'fas fa-suitcase' => esc_html__( 'suitcase', 'lunfest' ),
                'fas fa-sun' => esc_html__( 'sun', 'lunfest' ),
                'far fa-sun' => esc_html__( 'sun', 'lunfest' ),
                'fab fa-superpowers' => esc_html__( 'superpowers', 'lunfest' ),
                'fas fa-superscript' => esc_html__( 'superscript', 'lunfest' ),
                'fab fa-supple' => esc_html__( 'supple', 'lunfest' ),
                'fas fa-sync' => esc_html__( 'sync', 'lunfest' ),
                'fas fa-sync-alt' => esc_html__( 'sync-alt', 'lunfest' ),
                'fas fa-syringe' => esc_html__( 'syringe', 'lunfest' ),
                'fas fa-table' => esc_html__( 'table', 'lunfest' ),
                'fas fa-table-tennis' => esc_html__( 'table-tennis', 'lunfest' ),
                'fas fa-tablet' => esc_html__( 'tablet', 'lunfest' ),
                'fas fa-tablet-alt' => esc_html__( 'tablet-alt', 'lunfest' ),
                'fas fa-tablets' => esc_html__( 'tablets', 'lunfest' ),
                'fas fa-tachometer-alt' => esc_html__( 'tachometer-alt', 'lunfest' ),
                'fas fa-tag' => esc_html__( 'tag', 'lunfest' ),
                'fas fa-tags' => esc_html__( 'tags', 'lunfest' ),
                'fas fa-tape' => esc_html__( 'tape', 'lunfest' ),
                'fas fa-tasks' => esc_html__( 'tasks', 'lunfest' ),
                'fas fa-taxi' => esc_html__( 'taxi', 'lunfest' ),
                'fab fa-telegram' => esc_html__( 'telegram', 'lunfest' ),
                'fab fa-telegram-plane' => esc_html__( 'telegram-plane', 'lunfest' ),
                'fab fa-tencent-weibo' => esc_html__( 'tencent-weibo', 'lunfest' ),
                'fas fa-terminal' => esc_html__( 'terminal', 'lunfest' ),
                'fas fa-text-height' => esc_html__( 'text-height', 'lunfest' ),
                'fas fa-text-width' => esc_html__( 'text-width', 'lunfest' ),
                'fas fa-th' => esc_html__( 'th', 'lunfest' ),
                'fas fa-th-large' => esc_html__( 'th-large', 'lunfest' ),
                'fas fa-th-list' => esc_html__( 'th-list', 'lunfest' ),
                'fab fa-themeisle' => esc_html__( 'themeisle', 'lunfest' ),
                'fas fa-thermometer' => esc_html__( 'thermometer', 'lunfest' ),
                'fas fa-thermometer-empty' => esc_html__( 'thermometer-empty', 'lunfest' ),
                'fas fa-thermometer-full' => esc_html__( 'thermometer-full', 'lunfest' ),
                'fas fa-thermometer-half' => esc_html__( 'thermometer-half', 'lunfest' ),
                'fas fa-thermometer-quarter' => esc_html__( 'thermometer-quarter', 'lunfest' ),
                'fas fa-thermometer-three-quarters' => esc_html__( 'thermometer-three-quarters', 'lunfest' ),
                'fas fa-thumbs-down' => esc_html__( 'thumbs-down', 'lunfest' ),
                'far fa-thumbs-down' => esc_html__( 'thumbs-down', 'lunfest' ),
                'fas fa-thumbs-up' => esc_html__( 'thumbs-up', 'lunfest' ),
                'far fa-thumbs-up' => esc_html__( 'thumbs-up', 'lunfest' ),
                'fas fa-thumbtack' => esc_html__( 'thumbtack', 'lunfest' ),
                'fas fa-ticket-alt' => esc_html__( 'ticket-alt', 'lunfest' ),
                'fas fa-times' => esc_html__( 'times', 'lunfest' ),
                'fas fa-times-circle' => esc_html__( 'times-circle', 'lunfest' ),
                'far fa-times-circle' => esc_html__( 'times-circle', 'lunfest' ),
                'fas fa-tint' => esc_html__( 'tint', 'lunfest' ),
                'fas fa-toggle-off' => esc_html__( 'toggle-off', 'lunfest' ),
                'fas fa-toggle-on' => esc_html__( 'toggle-on', 'lunfest' ),
                'fas fa-trademark' => esc_html__( 'trademark', 'lunfest' ),
                'fas fa-train' => esc_html__( 'train', 'lunfest' ),
                'fas fa-transgender' => esc_html__( 'transgender', 'lunfest' ),
                'fas fa-transgender-alt' => esc_html__( 'transgender-alt', 'lunfest' ),
                'fas fa-trash' => esc_html__( 'trash', 'lunfest' ),
                'fas fa-trash-alt' => esc_html__( 'trash-alt', 'lunfest' ),
                'far fa-trash-alt' => esc_html__( 'trash-alt', 'lunfest' ),
                'fas fa-tree' => esc_html__( 'tree', 'lunfest' ),
                'fab fa-trello' => esc_html__( 'trello', 'lunfest' ),
                'fab fa-tripadvisor' => esc_html__( 'tripadvisor', 'lunfest' ),
                'fas fa-trophy' => esc_html__( 'trophy', 'lunfest' ),
                'fas fa-truck' => esc_html__( 'truck', 'lunfest' ),
                'fas fa-truck-loading' => esc_html__( 'truck-loading', 'lunfest' ),
                'fas fa-truck-moving' => esc_html__( 'truck-moving', 'lunfest' ),
                'fas fa-tty' => esc_html__( 'tty', 'lunfest' ),
                'fab fa-tumblr' => esc_html__( 'tumblr', 'lunfest' ),
                'fab fa-tumblr-square' => esc_html__( 'tumblr-square', 'lunfest' ),
                'fas fa-tv' => esc_html__( 'tv', 'lunfest' ),
                'fab fa-twitch' => esc_html__( 'twitch', 'lunfest' ),
                'fab fa-twitter' => esc_html__( 'twitter', 'lunfest' ),
                'fab fa-twitter-square' => esc_html__( 'twitter-square', 'lunfest' ),
                'fab fa-typo3' => esc_html__( 'typo3', 'lunfest' ),
                'fab fa-uber' => esc_html__( 'uber', 'lunfest' ),
                'fab fa-uikit' => esc_html__( 'uikit', 'lunfest' ),
                'fas fa-umbrella' => esc_html__( 'umbrella', 'lunfest' ),
                'fas fa-underline' => esc_html__( 'underline', 'lunfest' ),
                'fas fa-undo' => esc_html__( 'undo', 'lunfest' ),
                'fas fa-undo-alt' => esc_html__( 'undo-alt', 'lunfest' ),
                'fab fa-uniregistry' => esc_html__( 'uniregistry', 'lunfest' ),
                'fas fa-universal-access' => esc_html__( 'universal-access', 'lunfest' ),
                'fas fa-university' => esc_html__( 'university', 'lunfest' ),
                'fas fa-unlink' => esc_html__( 'unlink', 'lunfest' ),
                'fas fa-unlock' => esc_html__( 'unlock', 'lunfest' ),
                'fas fa-unlock-alt' => esc_html__( 'unlock-alt', 'lunfest' ),
                'fab fa-untappd' => esc_html__( 'untappd', 'lunfest' ),
                'fas fa-upload' => esc_html__( 'upload', 'lunfest' ),
                'fab fa-usb' => esc_html__( 'usb', 'lunfest' ),
                'fas fa-user' => esc_html__( 'user', 'lunfest' ),
                'far fa-user' => esc_html__( 'user', 'lunfest' ),
                'fas fa-user-circle' => esc_html__( 'user-circle', 'lunfest' ),
                'far fa-user-circle' => esc_html__( 'user-circle', 'lunfest' ),
                'fas fa-user-md' => esc_html__( 'user-md', 'lunfest' ),
                'fas fa-user-plus' => esc_html__( 'user-plus', 'lunfest' ),
                'fas fa-user-secret' => esc_html__( 'user-secret', 'lunfest' ),
                'fas fa-user-times' => esc_html__( 'user-times', 'lunfest' ),
                'fas fa-users' => esc_html__( 'users', 'lunfest' ),
                'fab fa-ussunnah' => esc_html__( 'ussunnah', 'lunfest' ),
                'fas fa-utensil-spoon' => esc_html__( 'utensil-spoon', 'lunfest' ),
                'fas fa-utensils' => esc_html__( 'utensils', 'lunfest' ),
                'fab fa-vaadin' => esc_html__( 'vaadin', 'lunfest' ),
                'fas fa-venus' => esc_html__( 'venus', 'lunfest' ),
                'fas fa-venus-double' => esc_html__( 'venus-double', 'lunfest' ),
                'fas fa-venus-mars' => esc_html__( 'venus-mars', 'lunfest' ),
                'fab fa-viacoin' => esc_html__( 'viacoin', 'lunfest' ),
                'fab fa-viadeo' => esc_html__( 'viadeo', 'lunfest' ),
                'fab fa-viadeo-square' => esc_html__( 'viadeo-square', 'lunfest' ),
                'fas fa-vial' => esc_html__( 'vial', 'lunfest' ),
                'fas fa-vials' => esc_html__( 'vials', 'lunfest' ),
                'fab fa-viber' => esc_html__( 'viber', 'lunfest' ),
                'fas fa-video' => esc_html__( 'video', 'lunfest' ),
                'fas fa-video-slash' => esc_html__( 'video-slash', 'lunfest' ),
                'fab fa-vimeo' => esc_html__( 'vimeo', 'lunfest' ),
                'fab fa-vimeo-square' => esc_html__( 'vimeo-square', 'lunfest' ),
                'fab fa-vimeo-v' => esc_html__( 'vimeo-v', 'lunfest' ),
                'fab fa-vine' => esc_html__( 'vine', 'lunfest' ),
                'fab fa-vk' => esc_html__( 'vk', 'lunfest' ),
                'fab fa-vnv' => esc_html__( 'vnv', 'lunfest' ),
                'fas fa-volleyball-ball' => esc_html__( 'volleyball-ball', 'lunfest' ),
                'fas fa-volume-down' => esc_html__( 'volume-down', 'lunfest' ),
                'fas fa-volume-off' => esc_html__( 'volume-off', 'lunfest' ),
                'fas fa-volume-up' => esc_html__( 'volume-up', 'lunfest' ),
                'fab fa-vuejs' => esc_html__( 'vuejs', 'lunfest' ),
                'fas fa-warehouse' => esc_html__( 'warehouse', 'lunfest' ),
                'fab fa-weibo' => esc_html__( 'weibo', 'lunfest' ),
                'fas fa-weight' => esc_html__( 'weight', 'lunfest' ),
                'fab fa-weixin' => esc_html__( 'weixin', 'lunfest' ),
                'fab fa-whatsapp' => esc_html__( 'whatsapp', 'lunfest' ),
                'fab fa-whatsapp-square' => esc_html__( 'whatsapp-square', 'lunfest' ),
                'fas fa-wheelchair' => esc_html__( 'wheelchair', 'lunfest' ),
                'fab fa-whmcs' => esc_html__( 'whmcs', 'lunfest' ),
                'fas fa-wifi' => esc_html__( 'wifi', 'lunfest' ),
                'fab fa-wikipedia-w' => esc_html__( 'wikipedia-w', 'lunfest' ),
                'fas fa-window-close' => esc_html__( 'window-close', 'lunfest' ),
                'far fa-window-close' => esc_html__( 'window-close', 'lunfest' ),
                'fas fa-window-maximize' => esc_html__( 'window-maximize', 'lunfest' ),
                'far fa-window-maximize' => esc_html__( 'window-maximize', 'lunfest' ),
                'fas fa-window-minimize' => esc_html__( 'window-minimize', 'lunfest' ),
                'far fa-window-minimize' => esc_html__( 'window-minimize', 'lunfest' ),
                'fas fa-window-restore' => esc_html__( 'window-restore', 'lunfest' ),
                'far fa-window-restore' => esc_html__( 'window-restore', 'lunfest' ),
                'fab fa-windows' => esc_html__( 'windows', 'lunfest' ),
                'fas fa-wine-glass' => esc_html__( 'wine-glass', 'lunfest' ),
                'fas fa-won-sign' => esc_html__( 'won-sign', 'lunfest' ),
                'fab fa-wordpress' => esc_html__( 'wordpress', 'lunfest' ),
                'fab fa-wordpress-simple' => esc_html__( 'wordpress-simple', 'lunfest' ),
                'fab fa-wpbeginner' => esc_html__( 'wpbeginner', 'lunfest' ),
                'fab fa-wpexplorer' => esc_html__( 'wpexplorer', 'lunfest' ),
                'fab fa-wpforms' => esc_html__( 'wpforms', 'lunfest' ),
                'fas fa-wrench' => esc_html__( 'wrench', 'lunfest' ),
                'fas fa-x-ray' => esc_html__( 'x-ray', 'lunfest' ),
                'fab fa-xbox' => esc_html__( 'xbox', 'lunfest' ),
                'fab fa-xing' => esc_html__( 'xing', 'lunfest' ),
                'fab fa-xing-square' => esc_html__( 'xing-square', 'lunfest' ),
                'fab fa-y-combinator' => esc_html__( 'y-combinator', 'lunfest' ),
                'fab fa-yahoo' => esc_html__( 'yahoo', 'lunfest' ),
                'fab fa-yandex' => esc_html__( 'yandex', 'lunfest' ),
                'fab fa-yandex-international' => esc_html__( 'yandex-international', 'lunfest' ),
                'fab fa-yelp' => esc_html__( 'yelp', 'lunfest' ),
                'fas fa-yen-sign' => esc_html__( 'yen-sign', 'lunfest' ),
                'fab fa-yoast' => esc_html__( 'yoast', 'lunfest' ),
                'fab fa-youtube' => esc_html__( 'youtube', 'lunfest' ),
                'fab fa-youtube-square' => esc_html__( 'youtube-square', 'lunfest' ),
            ];
        }
    }

    function WGLAdminIcon()
    {
        return WGL_Admin_Icon::get_instance();
    }

    // Call Admin Function
    WGLAdminIcon();
}
