<?php
/* @var \Tangibledesign\Framework\Widgets\User\UserImageWidget $lstCurrentWidget */
global $lstCurrentWidget, $lstUser;

$lstUser = $lstCurrentWidget->getUser();
if (!$lstUser) {
    return;
}

$lstImageUrl = $lstUser->getImageUrl($lstCurrentWidget->getImageSize());
if (!$lstImageUrl) { ?>
    <a
            class="listivo-avatar-link-wrapper"
            href="<?php echo esc_url($lstUser->getUrl()); ?>"
    >
        <div class="listivo-avatar listivo-user-image-control-size">
            <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                      d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"/>
            </svg>
        </div>
    </a>
    <?php
    return;
}

if ($lstCurrentWidget->linkUser()) : ?>
    <a
            class="listivo-user-image"
            href="<?php echo esc_url($lstUser->getUrl()); ?>"
    >
        <img
                src="<?php echo esc_url($lstImageUrl); ?>"
                alt="<?php echo esc_attr($lstUser->getDisplayName()); ?>"
                class="listivo-user-image-control-size"
        >
    </a>
<?php else : ?>
    <div class="listivo-user-image listivo-user-image-control-size">
        <img
                src="<?php echo esc_url($lstImageUrl); ?>"
                alt="<?php echo esc_attr($lstUser->getDisplayName()); ?>"
        >
    </div>
<?php
endif;