<?php

use Tangibledesign\Framework\Core\Image\RenderUserImage;
use Tangibledesign\Listivo\Widgets\User\UserHeroWidget;

/* @var UserHeroWidget $lstCurrentWidget */
global $lstCurrentWidget;
$lstUser = $lstCurrentWidget->getUser();
if (!$lstUser) {
    return;
}
?>
<div
    <?php if ($lstCurrentWidget->isFullWidth()) : ?>
        class="listivo-user-hero listivo-user-hero--full-width"
    <?php else : ?>
        class="listivo-user-hero"
    <?php endif; ?>
>
    <?php if ($lstCurrentWidget->decorationEnabled()) : ?>
        <div class="listivo-user-hero__decoration-container">
            <div class="listivo-user-hero__circle listivo-user-hero__circle--1"></div>

            <div class="listivo-user-hero__circle listivo-user-hero__circle--2"></div>

            <div class="listivo-user-hero__small-circle listivo-user-hero__small-circle--1"></div>

            <div class="listivo-user-hero__small-circle listivo-user-hero__small-circle--2"></div>

            <div class="listivo-user-hero__x listivo-user-hero__x--1">
                <svg xmlns="http://www.w3.org/2000/svg" width="45" height="45" viewBox="0 0 45 45" fill="none">
                    <path d="M13.7572 35.3434L9.63333 31.2196L31.2199 9.63304L35.3437 13.7569L13.7572 35.3434ZM9.0733 13.2478L13.299 9.02209L35.9547 31.6778L31.729 35.9035L9.0733 13.2478Z"
                          fill="#E6F0FA"/>
                </svg>
            </div>

            <div class="listivo-user-hero__x listivo-user-hero__x--2">
                <svg xmlns="http://www.w3.org/2000/svg" width="45" height="45" viewBox="0 0 45 45" fill="none">
                    <path d="M13.7572 35.3434L9.63333 31.2196L31.2199 9.63304L35.3437 13.7569L13.7572 35.3434ZM9.0733 13.2478L13.299 9.02209L35.9547 31.6778L31.729 35.9035L9.0733 13.2478Z"
                          fill="#E6F0FA"/>
                </svg>
            </div>
        </div>
    <?php endif; ?>

    <?php if (!empty($lstCurrentWidget->getBackgroundImage())) : ?>
        <div class="listivo-user-hero__top">
            <div class="listivo-user-hero__background">
                <img
                        class="lazyload"
                        src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAMAAAACCAQAAAA3fa6RAAAADklEQVR42mNkAANGCAUAACMAA2w/AMgAAAAASUVORK5CYII="
                        data-src="<?php echo esc_url($lstCurrentWidget->getBackgroundImage()); ?>"
                        alt=""
                >
            </div>
        </div>
    <?php endif; ?>

    <div class="listivo-user-hero__content-wrapper">
        <div
            <?php if (empty($lstCurrentWidget->getBackgroundImage())) : ?>
                class="listivo-user-hero__content listivo-user-hero__content--no-background"
            <?php else : ?>
                class="listivo-user-hero__content"
            <?php endif; ?>
        >
            <div class="listivo-user-hero__avatar">
                <?php RenderUserImage::render($lstUser, 'listivo_400_400', RenderUserImage::PLACEHOLDER_CIRCLE); ?>
            </div>

            <h1 class="listivo-user-hero__name">
                <?php echo esc_html($lstUser->getDisplayName()); ?>
            </h1>

            <div class="listivo-user-hero__meta">
                <div class="listivo-user-hero__data">
                    <div class="listivo-user-hero__data-icon-wrapper">
                        <div class="listivo-user-hero__data-icon listivo-small-icon listivo-small-icon--circle listivo-small-icon--primary-2">
                            <svg xmlns="http://www.w3.org/2000/svg" width="10" height="11" viewBox="0 0 10 11"
                                 fill="none">
                                <path d="M5 0C3.07227 0 1.5 1.57227 1.5 3.5C1.5 4.70508 2.11523 5.77539 3.04688 6.40625C1.26367 7.17188 0 8.94141 0 11H1C1 9.55469 1.76367 8.29688 2.90625 7.59375C3.24219 8.41797 4.06055 9 5 9C5.93945 9 6.75781 8.41797 7.09375 7.59375C8.23633 8.29688 9 9.55469 9 11H10C10 8.94141 8.73633 7.17188 6.95312 6.40625C7.88477 5.77539 8.5 4.70508 8.5 3.5C8.5 1.57227 6.92773 0 5 0ZM5 1C6.38672 1 7.5 2.11328 7.5 3.5C7.5 4.88672 6.38672 6 5 6C3.61328 6 2.5 4.88672 2.5 3.5C2.5 2.11328 3.61328 1 5 1ZM5 7C5.41016 7 5.80078 7.05859 6.17188 7.17188C5.99805 7.6543 5.54492 8 5 8C4.45508 8 4.00195 7.6543 3.82812 7.17188C4.19922 7.05859 4.58984 7 5 7Z"
                                      fill="#FDFDFE"/>
                            </svg>
                        </div>
                    </div>

                    <div class="listivo-user-hero__data-text">
                        <?php echo esc_html(tdf_string('member_since') . ' ' . $lstUser->getRegistrationDateDiff()); ?>
                    </div>
                </div>

                <?php if (!empty($lstUser->getAddress())) : ?>
                    <div class="listivo-user-hero__data">
                        <div class="listivo-user-hero__data-icon-wrapper">
                            <div class="listivo-user-hero__data-icon listivo-small-icon listivo-small-icon--circle listivo-small-icon--primary-2">
                                <svg xmlns="http://www.w3.org/2000/svg" width="10" height="14" viewBox="0 0 10 14"
                                     fill="none">
                                    <path fill-rule="evenodd" clip-rule="evenodd"
                                          d="M5 0C2.24609 0 0 2.27981 0 5.07505C0 5.8601 0.316406 6.72048 0.753906 7.62843C1.19141 8.54036 1.76172 9.49193 2.33594 10.3602C3.47656 12.1008 4.61328 13.5163 4.61328 13.5163L5 14L5.38672 13.5163C5.38672 13.5163 6.52344 12.1008 7.66797 10.3602C8.23828 9.49193 8.80859 8.54036 9.24609 7.62843C9.68359 6.72048 10 5.8601 10 5.07505C10 2.27981 7.75391 0 5 0ZM5 1.01514C7.21484 1.01514 9 2.82709 9 5.07518C9 5.55096 8.75391 6.33997 8.34766 7.18449C7.94141 8.03298 7.38672 8.95283 6.83594 9.80132C5.99563 11.0789 5.40082 11.8315 5.08146 12.2356L5 12.3388L4.91854 12.2356C4.59919 11.8315 4.00437 11.0789 3.16406 9.80132C2.61328 8.95283 2.05859 8.03298 1.65234 7.18449C1.24609 6.33997 1 5.55096 1 5.07518C1 2.82709 2.78516 1.01514 5 1.01514ZM4.00002 5.06006C4.00002 4.50928 4.44924 4.06006 5.00002 4.06006C5.5508 4.06006 6.00002 4.50928 6.00002 5.06006C6.00002 5.61084 5.5508 6.06006 5.00002 6.06006C4.44924 6.06006 4.00002 5.61084 4.00002 5.06006Z"
                                          fill="#FDFDFE"/>
                                </svg>
                            </div>
                        </div>

                        <div class="listivo-user-hero__data-text">
                            <?php echo esc_html($lstUser->getAddress()); ?>
                        </div>
                    </div>
                <?php endif; ?>
            </div>

            <div class="listivo-user-hero__socials">
                <div class="listivo-social-icons-wrapper">
                    <div class="listivo-social-icons">
                        <?php if (!empty($lstUser->getFacebookProfile()))  : ?>
                            <a
                                    class="listivo-social-icons__icon listivo-social-icon listivo-social-icon--color-1 listivo-social-icon--hover-color-primary"
                                    href="<?php echo esc_url($lstUser->getFacebookProfile()); ?>"
                            >
                                <i class="fab fa-facebook-f"></i>
                            </a>
                        <?php endif; ?>

                        <?php if (!empty($lstUser->getTwitterProfile()))  : ?>
                            <a
                                    class="listivo-social-icons__icon listivo-social-icon listivo-social-icon--color-1 listivo-social-icon--hover-color-primary"
                                    href="<?php echo esc_url($lstUser->getTwitterProfile()); ?>"
                            >
                                <i class="fab fa-twitter"></i>
                            </a>
                        <?php endif; ?>

                        <?php if (!empty($lstUser->getLinkedInProfile()))  : ?>
                            <a
                                    class="listivo-social-icons__icon listivo-social-icon listivo-social-icon--color-1 listivo-social-icon--hover-color-primary"
                                    href="<?php echo esc_url($lstUser->getLinkedInProfile()); ?>"
                            >
                                <i class="fab fa-linkedin-in"></i>
                            </a>
                        <?php endif; ?>

                        <?php if (!empty($lstUser->getInstagramProfile()))  : ?>
                            <a
                                    class="listivo-social-icons__icon listivo-social-icon listivo-social-icon--color-1 listivo-social-icon--hover-color-primary"
                                    href="<?php echo esc_url($lstUser->getInstagramProfile()); ?>"
                            >
                                <i class="fab fa-instagram"></i>
                            </a>
                        <?php endif; ?>

                        <?php if (!empty($lstUser->getYouTubeProfile()))  : ?>
                            <a
                                    class="listivo-social-icons__icon listivo-social-icon listivo-social-icon--color-1 listivo-social-icon--hover-color-primary"
                                    href="<?php echo esc_url($lstUser->getYouTubeProfile()); ?>"
                            >
                                <i class="fab fa-youtube"></i>
                            </a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>