<?php

use Tangibledesign\Framework\Core\Image\RenderUserImage;
use Tangibledesign\Framework\Widgets\General\UserProfilesWidget;

/* @var UserProfilesWidget $lstCurrentWidget */
global $lstCurrentWidget;

$lstUsers = $lstCurrentWidget->getUsers();
if ($lstUsers->isEmpty()) {
    return;
}
?>
<div class="listivo-user-profiles">
    <?php foreach ($lstUsers as $lstUser) :
        ?>
        <div
            <?php if ($lstCurrentWidget->smallerIcons()) : ?>
                class="listivo-single-user-profile listivo-single-user-profile--icons-smaller"
            <?php else : ?>
                class="listivo-single-user-profile"
            <?php endif; ?>
        >
            <a class="listivo-single-user-profile__link" href="<?php echo esc_url($lstUser->getUrl()); ?>"></a>

            <div class="listivo-single-user-profile__image">
                <?php RenderUserImage::render($lstUser, 'listivo_400_400'); ?>
            </div>

            <div class="listivo-single-user-profile__content">
                <a href="<?php echo esc_url($lstUser->getUrl()); ?>">
                    <h3 class="listivo-single-user-profile__label">
                        <?php echo esc_html($lstUser->getDisplayName()); ?>
                    </h3>
                </a>

                <?php if (!empty($lstUser->getJobTitle())) : ?>
                    <div class="listivo-single-user-profile__job-title">
                        <?php echo esc_html($lstUser->getJobTitle()); ?>
                    </div>
                <?php endif; ?>

                <div class="listivo-single-user-profile__socials">
                    <div class="listivo-social-icons">
                        <?php if (!empty($lstUser->getFacebookProfile()))  : ?>
                            <a
                                <?php if ($lstCurrentWidget->smallerIcons()) : ?>
                                    class="listivo-social-icon listivo-social-icon--smaller listivo-social-icon--color-1 listivo-social-icon--hover-color-primary"
                                <?php else : ?>
                                    class="listivo-social-icon listivo-social-icon--color-1 listivo-social-icon--hover-color-primary"
                                <?php endif; ?>
                                    href="<?php echo esc_url($lstUser->getFacebookProfile()); ?>"
                            >
                                <i class="fab fa-facebook-f"></i>
                            </a>
                        <?php endif; ?>

                        <?php if (!empty($lstUser->getTwitterProfile()))  : ?>
                            <a
                                <?php if ($lstCurrentWidget->smallerIcons()) : ?>
                                    class="listivo-social-icon listivo-social-icon--smaller listivo-social-icon--color-1 listivo-social-icon--hover-color-primary"
                                <?php else : ?>
                                    class="listivo-social-icon listivo-social-icon--color-1 listivo-social-icon--hover-color-primary"
                                <?php endif; ?>
                                    href="<?php echo esc_url($lstUser->getTwitterProfile()); ?>"
                            >
                                <i class="fab fa-twitter"></i>
                            </a>
                        <?php endif; ?>

                        <?php if (!empty($lstUser->getLinkedInProfile()))  : ?>
                            <a
                                <?php if ($lstCurrentWidget->smallerIcons()) : ?>
                                    class="listivo-social-icon listivo-social-icon--smaller listivo-social-icon--color-1 listivo-social-icon--hover-color-primary"
                                <?php else : ?>
                                    class="listivo-social-icon listivo-social-icon--color-1 listivo-social-icon--hover-color-primary"
                                <?php endif; ?>
                                    href="<?php echo esc_url($lstUser->getLinkedInProfile()); ?>"
                            >
                                <i class="fab fa-linkedin-in"></i>
                            </a>
                        <?php endif; ?>

                        <?php if (!empty($lstUser->getInstagramProfile()))  : ?>
                            <a
                                <?php if ($lstCurrentWidget->smallerIcons()) : ?>
                                    class="listivo-social-icon listivo-social-icon--smaller listivo-social-icon--color-1 listivo-social-icon--hover-color-primary"
                                <?php else : ?>
                                    class="listivo-social-icon listivo-social-icon--color-1 listivo-social-icon--hover-color-primary"
                                <?php endif; ?>
                                    href="<?php echo esc_url($lstUser->getInstagramProfile()); ?>"
                            >
                                <i class="fab fa-instagram"></i>
                            </a>
                        <?php endif; ?>

                        <?php if (!empty($lstUser->getYouTubeProfile()))  : ?>
                            <a
                                <?php if ($lstCurrentWidget->smallerIcons()) : ?>
                                    class="listivo-social-icon listivo-social-icon--smaller listivo-social-icon--color-1 listivo-social-icon--hover-color-primary"
                                <?php else : ?>
                                    class="listivo-social-icon listivo-social-icon--color-1 listivo-social-icon--hover-color-primary"
                                <?php endif; ?>
                                    href="<?php echo esc_url($lstUser->getYouTubeProfile()); ?>"
                            >
                                <i class="fab fa-youtube"></i>
                            </a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    <?php endforeach; ?>
</div>