<?php

use Tangibledesign\Framework\Models\Order;

/* @var Order\OrderInterface $lstCurrentOrder */
global $lstCurrentOrder;

$lstPaymentPackage = $lstCurrentOrder->getPaymentPackage();
?>
<div class="listivo-panel-orders__row listivo-panel-orders__row--my-orders">
    <div class="listivo-panel-orders__main-col">
        <div class="listivo-panel-order">
            <?php if ($lstPaymentPackage) : ?>
                <h3 class="listivo-panel-order__heading">
                    <span><?php echo esc_html($lstPaymentPackage->getName()); ?></span>

                    <span class="listivo-panel-order__order">
                        (<?php echo esc_html(tdf_string('order')); ?>
                        #<?php echo esc_html($lstCurrentOrder->getId()); ?>)
                    </span>
                </h3>
            <?php endif; ?>

            <div class="listivo-panel-order__info">
                <div class="listivo-panel-order__attributes">
                    <div class="listivo-panel-order__meta">
                        <span><?php echo esc_html(tdf_string('created')); ?>:</span>

                        <?php echo esc_html($lstCurrentOrder->getCreatedDate()); ?>
                    </div>

                    <?php if ($lstCurrentOrder->getModifiedDate() !== $lstCurrentOrder->getCreatedDate()) : ?>
                        <div class="listivo-panel-order__meta">
                            <span><?php echo esc_html(tdf_string('modified')); ?>:</span>

                            <?php echo esc_html($lstCurrentOrder->getModifiedDate()); ?>
                        </div>
                    <?php endif; ?>
                </div>

                <div class="listivo-panel-order__status">
                    <div class="listivo-panel-order-status listivo-panel-order-status--<?php echo esc_attr($lstCurrentOrder->getStatus()); ?>">
                        <?php echo esc_html($lstCurrentOrder->getFormattedStatus()); ?>
                    </div>
                </div>

                <div class="listivo-panel-order__data">
                    <div class="listivo-panel-order__price">
                        <?php echo wp_kses_post($lstCurrentOrder->getPrice()); ?>

                        <span class="listivo-panel-order__payment-method">
                            <?php echo esc_html(tdf_string('via') . ' ' . $lstCurrentOrder->getPaymentMethods()); ?>
                        </span>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="listivo-panel-orders__col listivo-panel-orders__col--status">
        <div class="listivo-panel-order-status listivo-panel-order-status--<?php echo esc_attr($lstCurrentOrder->getStatus()); ?>">
            <?php echo esc_html($lstCurrentOrder->getFormattedStatus()); ?>
        </div>
    </div>
</div>