<?php

use Tangibledesign\Framework\Models\PanelFields\NamePanelField;
use Tangibledesign\Framework\Models\PanelFields\PanelField;
use Tangibledesign\Listivo\Widgets\General\PanelWidget;

/* @var PanelWidget $lstCurrentWidget */
global $lstCurrentWidget;

$lstNameRequired = tdf_settings()->getAutoGenerateModelTitleFields()->isEmpty() && tdf_settings()->nameRequired();

if (is_user_logged_in()) :
    get_template_part('templates/widgets/general/panel/header');
endif;
?>
<div class="listivo-panel-section">
    <lst-panel-model-form
            class="listivo-container"
            request-url="<?php echo esc_url(tdf_action_url('listivo/listings/create')); ?>"
            :initial-model="<?php echo htmlspecialchars(json_encode($lstCurrentWidget->getInitialModel())); ?>"
            :dependency-terms="<?php echo htmlspecialchars(json_encode(tdf_app('dependency_terms'))); ?>"
            error-title-text="<?php echo esc_attr(tdf_string('required_field_is_empty')); ?>"
            error-message-text="<?php echo esc_attr(tdf_string('complete_all_required_fields')); ?>"
            confirm-button-text="<?php echo esc_attr(tdf_string('ok')); ?>"
            error-title="<?php echo esc_attr(tdf_string('something_went_wrong')); ?>"
            error-selector=".listivo-has-error, .listivo-field-error"
            :name-required="<?php echo esc_attr($lstNameRequired ? 'true' : 'false'); ?>"
            :description-required="<?php echo esc_attr(tdf_settings()->descriptionRequired() ? 'true' : 'false'); ?>"
            redirect-url="<?php echo esc_url($lstCurrentWidget->getModelFormRedirectUrl()); ?>"
            nonce="<?php echo esc_attr(wp_create_nonce(tdf_prefix().'_create_model')); ?>"
            td-nonce="<?php echo esc_attr(wp_create_nonce(tdf_prefix().'_create_model')); ?>"
        <?php if (!empty($lstCurrentWidget->getPackageId())) : ?>
            :package-id="<?php echo esc_attr($lstCurrentWidget->getPackageId()); ?>"
        <?php endif; ?>
    >
        <div class="listivo-container" slot-scope="modelForm">
            <div class="listivo-panel-section__top">
                <h1 class="listivo-panel-section__label">
                    <?php echo esc_html(tdf_string('add_listing')); ?>
                </h1>

                <?php get_template_part('templates/widgets/general/panel/packages_bar'); ?>
            </div>

            <?php if (!is_user_logged_in()) : ?>
                <div class="listivo-panel-form__not-logged">
                    <?php echo esc_html(tdf_string('you_can_also')) ?> <a
                            href="<?php echo esc_url(tdf_settings()->getLoginPageUrl()) ?>"
                    ><?php echo esc_html(tdf_string('log_in')); ?></a>
                    <?php if (tdf_settings()->userRegistrationOpen()) : ?>
                        <?php echo esc_html(tdf_string('or')); ?> <a
                                href="<?php echo esc_url(tdf_settings()->getRegisterPageUrl()); ?>"
                        ><?php echo esc_html(tdf_string('register')); ?></a>
                    <?php endif; ?>
                    <?php echo esc_html(tdf_string('first.')); ?>
                </div>
            <?php endif; ?>

            <template>
                <div class="listivo-panel-section__form listivo-panel-form">
                    <div class="listivo-panel-form__fields">
                        <div class="listivo-panel-form__single-column">
                            <div class="listivo-panel-form-label listivo-panel-form-label--small-margin-bottom">
                                <h3 class="listivo-panel-form-label__text">
                                    <?php echo esc_html(tdf_string('general_info')); ?>
                                </h3>

                                <div class="listivo-panel-form-label__line"></div>

                                <div class="listivo-panel-form-label__icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="11" height="12" viewBox="0 0 11 12"
                                         fill="none">
                                        <path d="M0.195669 7.13805C0.0653349 7.00772 0.00033474 6.83738 0.00033474 6.66671C0.00033474 6.49604 0.0653349 6.32571 0.195669 6.19538C0.456004 5.93504 0.878008 5.93504 1.13834 6.19538L4.66703 9.72407L4.66703 0.666672C4.66703 0.298669 4.9657 0 5.3337 0C5.70171 0 6.00038 0.298669 6.00038 0.666672L6.00038 9.72407L9.52907 6.19538C9.7894 5.93504 10.2114 5.93504 10.4717 6.19538C10.7321 6.45571 10.7321 6.87771 10.4717 7.13805L5.80504 11.8047C5.54471 12.0651 5.1227 12.0651 4.86237 11.8047L0.195669 7.13805Z"
                                              fill="#D5E3EE"/>
                                    </svg>
                                </div>
                            </div>
                        </div>
                        <?php

                        if (tdf_settings()->getAutoGenerateModelTitleFields()->isEmpty()) :
                            $lstCurrentWidget->getNameField()->loadTemplate();
                        endif;

                        $lstMainCategory = $lstCurrentWidget->getMainCategoryField();
                        if ($lstMainCategory) :
                            $lstMainCategory->loadTemplate();
                        endif;

                        /* @var PanelField $lstField */
                        foreach ($lstCurrentWidget->getMultilevelTaxonomyFields() as $lstField) :
                            if ($lstMainCategory && $lstMainCategory->getKey() === $lstField->getKey()) {
                                continue;
                            }

                            $lstField->loadTemplate();
                        endforeach;

                        foreach ($lstCurrentWidget->getSingleValueFields() as $lstField) :
                            if ($lstField instanceof NamePanelField) {
                                continue;
                            }

                            if ($lstMainCategory && $lstMainCategory->getKey() === $lstField->getKey()) {
                                continue;
                            }

                            $lstField->loadTemplate();
                        endforeach;

                        foreach ($lstCurrentWidget->getMultipleValueTaxonomyFields() as $lstField):
                            $lstField->loadTemplate();
                        endforeach;

                        foreach ($lstCurrentWidget->getDescriptionFields() as $lstField) :
                            $lstField->loadTemplate();
                        endforeach;

                        foreach ($lstCurrentWidget->getEmbedFields() as $lstField) :
                            $lstField->loadTemplate();
                        endforeach;

                        foreach ($lstCurrentWidget->getGalleryFields() as $lstField) :
                            $lstField->loadTemplate();
                        endforeach;

                        foreach ($lstCurrentWidget->getAttachmentsFields() as $lstField) :
                            $lstField->loadTemplate();
                        endforeach;

                        foreach ($lstCurrentWidget->getRichTextFields() as $lstField) :
                            $lstField->loadTemplate();
                        endforeach;

                        foreach ($lstCurrentWidget->getLocationFields() as $lstField) :
                            $lstField->loadTemplate();
                        endforeach;
                        ?>
                    </div>

                    <div class="listivo-panel-form__bottom">
                        <button
                                class="listivo-button listivo-button--primary-1"
                                :class="{'listivo-button--loading': modelForm.isDisabled}"
                                :disabled="modelForm.isDisabled"
                                @click.prevent="modelForm.onSubmit"
                        >
                            <span>
                                <?php echo esc_html(tdf_string('add_listing')); ?>

                                <svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" viewBox="0 0 12 12"
                                     fill="none">
                                    <path d="M5.00488 11.525V7.075H0.854883V5.125H5.00488V0.65H7.00488V5.125H11.1549V7.075H7.00488V11.525H5.00488Z"
                                          fill="#FDFDFE"/>
                                </svg>
                            </span>

                            <template>
                                <svg
                                        width='40'
                                        height='10'
                                        viewBox='0 0 120 30'
                                        xmlns='http://www.w3.org/2000/svg'
                                        fill='#fff'
                                        class="listivo-button__loading"
                                >
                                    <circle cx='15' cy='15' r='15'>
                                        <animate attributeName='r' from='15' to='15' begin='0s' dur='0.8s'
                                                 values='15;9;15'
                                                 calcMode='linear' repeatCount='indefinite'/>
                                        <animate attributeName='fill-opacity' from='1' to='1' begin='0s' dur='0.8s'
                                                 values='1;.5;1'
                                                 calcMode='linear' repeatCount='indefinite'/>
                                    </circle>

                                    <circle cx='60' cy='15' r='9' fill-opacity='0.3'>
                                        <animate attributeName='r' from='9' to='9' begin='0s' dur='0.8s' values='9;15;9'
                                                 calcMode='linear' repeatCount='indefinite'/>
                                        <animate attributeName='fill-opacity' from='0.5' to='0.5' begin='0s' dur='0.8s'
                                                 values='.5;1;.5' calcMode='linear' repeatCount='indefinite'/>
                                    </circle>

                                    <circle cx='105' cy='15' r='15'>
                                        <animate attributeName='r' from='15' to='15' begin='0s' dur='0.8s'
                                                 values='15;9;15'
                                                 calcMode='linear' repeatCount='indefinite'/>
                                        <animate attributeName='fill-opacity' from='1' to='1' begin='0s' dur='0.8s'
                                                 values='1;.5;1'
                                                 calcMode='linear' repeatCount='indefinite'/>
                                    </circle>
                                </svg>
                            </template>
                        </button>
                    </div>
                </div>
            </template>
        </div>
    </lst-panel-model-form>
</div>