<?php

use Tangibledesign\Framework\Models\Term\CustomTerm;
use Tangibledesign\Listivo\Widgets\General\HeroSearchV7Widget;

/* @var HeroSearchV7Widget $lstCurrentWidget */
global $lstCurrentWidget;
?>
<div class="listivo-hero-search-v7 listivo-app">
    <div class="listivo-hero-search-v7__bottom-background">
        <svg xmlns="http://www.w3.org/2000/svg" width="1074" height="101" viewBox="0 0 1074 101" fill="none">
            <path fill-rule="evenodd" clip-rule="evenodd"
                  d="M633.15 231.714C718.486 230.762 806.195 234.791 877.414 227.136C964.06 217.824 1082.04 203.397 1073.52 183.087C1050.34 139.005 928.633 123.096 854.927 106.988C781.181 90.8715 509.937 83.5206 425.017 59.9007C346.25 37.992 253.15 -15.9594 138.66 4.78448C37.7631 23.0655 65.2077 113.21 2.4489 145.517C-21.94 158.072 160.875 217.115 266.974 233.946C372.559 250.694 506.852 233.123 633.15 231.714Z"
                  fill="#F2F4F8" class="listivo-fill-color-4"/>
        </svg>
    </div>

    <div class="listivo-hero-search-v7__background listivo-hero-search-v7__background--desktop">
        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1500 778" fill="none">
            <mask id="mask0_5119_799" style="mask-type:alpha" maskUnits="userSpaceOnUse" x="0" y="0" width="1500"
                  height="778">
                <rect width="1500" height="778" fill="#9F2626"/>
            </mask>
            <g mask="url(#mask0_5119_799)">
                <path fill-rule="evenodd" clip-rule="evenodd"
                      d="M958.937 -256.471C836.506 -244.925 710.48 -250.863 608.568 -216.834C484.58 -175.434 315.825 -112.856 328.834 -41.453C363.795 113.073 549.852 39.8434 656.25 90.0695C762.706 140.323 835.602 317.776 958.382 393.641C1038.54 443.169 1294.43 619.16 1677.34 503.14C1824.09 458.676 1703.88 60.3615 1699.54 -30.4511C1695.35 -118.035 1637.27 -249.726 1484.35 -299.423C1332.18 -348.879 1140.13 -273.558 958.937 -256.471Z"
                      fill="#E6F0FA"
                      class="listivo-fill-color-4"
                />

                <path fill-rule="evenodd" clip-rule="evenodd"
                      d="M-251.745 401.205C-209.952 414.338 -24.6633 401.821 16.9291 364.442C53.1309 331.907 2.48868 218.643 25.2522 170.439C54.8676 107.726 131.044 12.3932 117.04 -47.0128C102.87 -107.119 80.4456 -129.402 30.6837 -138.339C-13.5573 -146.285 -60.282 -128.45 -104.675 -95.8047C-149.142 -63.1046 -194.706 16.4328 -210.996 76.706C-226.18 132.882 -199.903 228.21 -186.197 276.809C-171.821 327.785 -293.432 388.106 -251.745 401.205Z"
                      fill="#E6F0FA"
                      class="listivo-fill-color-4"
                />
                <path fill-rule="evenodd" clip-rule="evenodd"
                      d="M-260.669 389.391C-218.876 402.524 -33.5874 390.006 8.00497 352.627C44.2068 320.093 7.99903 168.565 30.7625 120.361C60.3779 57.6475 114.824 6.5116 100.82 -52.8943C86.6506 -113.001 57.511 -148.577 7.74913 -157.514C-36.4919 -165.459 -69.2061 -140.264 -113.599 -107.619C-158.067 -74.919 -215.363 -11.7836 -219.921 64.8916C-224.912 148.861 -208.827 216.396 -195.121 264.995C-180.745 315.971 -302.357 376.291 -260.669 389.391Z"
                      fill="#3F71F0"
                      class="listivo-fill-primary-1"
                />
                <path fill-rule="evenodd" clip-rule="evenodd"
                      d="M938.104 -290.471C815.673 -278.925 689.647 -284.863 587.735 -250.834C463.747 -209.434 294.992 -146.856 308.001 -75.453C342.962 79.0734 529.019 5.84336 635.417 56.0695C741.873 106.323 814.769 283.776 937.549 359.641C1017.7 409.169 1273.6 585.16 1656.51 469.14C1803.26 424.676 1683.05 26.3615 1678.71 -64.4511C1674.52 -152.035 1616.43 -283.726 1463.52 -333.423C1311.35 -382.879 1119.3 -307.558 938.104 -290.471Z"
                      fill="#FA823E"
                      class="listivo-fill-primary-2"
                />
                <path opacity="0.6" d="M1418.39 164.387L1417.78 188.664L1396.19 176.021L1418.39 164.387Z"
                      stroke="#FDFDFE"/>
                <g opacity="0.6">
                    <rect x="770" y="80" width="0.625833" height="15" fill="#FDFDFE"/>
                    <rect x="762.5" y="87.8005" width="0.60002" height="15.625" transform="rotate(-90 762.5 87.8005)"
                          fill="#FDFDFE"/>
                </g>
                <g opacity="0.6">
                    <rect x="29.375" y="241" width="0.625833" height="15" fill="#FDFDFE"/>
                    <rect x="21.875" y="248.8" width="0.60002" height="15.625" transform="rotate(-90 21.875 248.8)"
                          fill="#FDFDFE"/>
                </g>
            </g>
        </svg>
    </div>

    <div class="listivo-hero-search-v7__background listivo-hero-search-v7__background--mobile">
        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 390 942" fill="none">
            <mask id="mask0_5131_816" style="mask-type:alpha" maskUnits="userSpaceOnUse" x="0" y="0" width="390"
                  height="942">
                <rect width="390" height="942" fill="#9F2626"/>
            </mask>
            <g mask="url(#mask0_5131_816)">
                <path fill-rule="evenodd" clip-rule="evenodd"
                      d="M749.811 -263.471C633.176 -251.925 513.114 -257.863 416.025 -223.834C297.906 -182.434 137.137 -119.856 149.53 -48.453C182.837 106.073 360.088 32.8434 461.45 83.0695C562.868 133.323 632.314 310.776 749.283 386.641C825.645 436.169 1069.43 612.16 1434.22 496.14C1574.02 451.676 1459.5 53.3615 1455.36 -37.4511C1451.37 -125.035 1396.04 -256.726 1250.36 -306.423C1105.39 -355.879 922.432 -280.558 749.811 -263.471Z"
                      fill="#E6F0FA"
                      class="listivo-fill-color-4"
                />
                <path fill-rule="evenodd" clip-rule="evenodd"
                      d="M55.8472 769.597C128.861 726.355 206.374 686.256 263.925 644.215C333.943 593.067 428.419 521.908 411.066 508.519C369.366 481.787 256.712 528.478 185.299 551.136C113.846 573.806 -123.349 702.248 -208.123 723.961C-286.756 744.101 -393.536 743.561 -481.892 818.467C-559.757 884.481 -491.661 949.06 -529.767 1008.29C-544.576 1031.3 -358.03 991.671 -258.367 953.539C-159.186 915.592 -52.2133 833.595 55.8472 769.597Z"
                      fill="#E6F0FA"
                      class="listivo-fill-color-4"
                />
                <path fill-rule="evenodd" clip-rule="evenodd"
                      d="M-290.015 785.158C-251.604 802.009 -74.6985 806.288 -31.7593 772.833C5.61473 743.714 -31.8377 626.377 -5.74565 580.444C28.2003 520.685 109.353 432.658 101.619 372.251C93.7944 311.131 74.6073 286.92 28.2457 273.527C-12.9723 261.619 -58.9538 275.153 -104.107 303.643C-149.336 332.18 -199.979 407.247 -221.059 465.781C-240.707 520.336 -224.688 617.615 -216.228 667.237C-207.354 719.285 -328.33 768.35 -290.015 785.158Z"
                      fill="#E6F0FA"
                      class="listivo-fill-color-4"
                />
                <path fill-rule="evenodd" clip-rule="evenodd"
                      d="M-297.375 772.59C-258.964 789.44 -82.0588 793.72 -39.1197 760.265C-1.74558 731.146 -21.9339 577.019 4.15817 531.086C38.1041 471.327 94.5195 425.337 86.7857 364.93C78.9607 303.81 54.6462 265.759 8.28468 252.366C-32.9333 240.458 -66.3141 262.585 -111.467 291.074C-156.696 319.612 -216.936 377.29 -228.42 453.213C-240.996 536.358 -232.048 605.047 -223.588 654.669C-214.714 706.717 -335.69 755.782 -297.375 772.59Z"
                      fill="#3F71F0"
                      class="listivo-fill-primary-1"
                />
                <path fill-rule="evenodd" clip-rule="evenodd"
                      d="M744.849 -279.471C628.214 -267.925 508.152 -273.863 411.063 -239.834C292.944 -198.434 132.175 -135.856 144.569 -64.453C177.875 90.0734 355.126 16.8433 456.488 67.0695C557.906 117.323 627.352 294.776 744.321 370.641C820.683 420.169 1064.47 596.16 1429.25 480.14C1569.06 435.676 1454.54 37.3615 1450.4 -53.4511C1446.41 -141.035 1391.07 -272.726 1245.4 -322.423C1100.43 -371.879 917.47 -296.558 744.849 -279.471Z"
                      fill="#FA823E"
                      class="listivo-fill-primary-2"
                />
                <path fill-rule="evenodd" clip-rule="evenodd"
                      d="M-306.067 875.529C-422.702 887.075 -542.764 881.137 -639.853 915.166C-757.972 956.566 -918.741 1019.14 -906.348 1090.55C-873.041 1245.07 -695.79 1171.84 -594.428 1222.07C-493.01 1272.32 -423.564 1449.78 -306.595 1525.64C-230.233 1575.17 13.5501 1751.16 378.338 1635.14C518.141 1590.68 403.621 1192.36 399.485 1101.55C395.495 1013.97 340.158 882.274 194.482 832.577C49.5121 783.121 -133.446 858.442 -306.067 875.529Z"
                      fill="#E6F0FA"
                      class="listivo-fill-color-4"
                />
                <path fill-rule="evenodd" clip-rule="evenodd"
                      d="M-311.029 891.529C-427.664 903.075 -547.726 897.137 -644.815 931.166C-762.934 972.566 -923.703 1035.14 -911.309 1106.55C-878.003 1261.07 -700.752 1187.84 -599.39 1238.07C-497.972 1288.32 -428.526 1465.78 -311.557 1541.64C-235.195 1591.17 8.58825 1767.16 373.376 1651.14C513.179 1606.68 398.66 1208.36 394.523 1117.55C390.533 1029.97 335.196 898.274 189.52 848.577C44.5502 799.121 -138.407 874.442 -311.029 891.529Z"
                      fill="#FA823E"
                      class="listivo-fill-primary-2"
                />
                <g opacity="0.6">
                    <rect x="27.9849" y="241" width="0.59542" height="15" fill="#FDFDFE"/>
                    <rect x="20.8398" y="248.8" width="0.60002" height="14.8855" transform="rotate(-90 20.8398 248.8)"
                          fill="#FDFDFE"/>
                </g>
            </g>
        </svg>
    </div>

    <div class="listivo-hero-search-v7__container">
        <div class="listivo-hero-search-v7__content">
            <div class="listivo-hero-search-v7__left">
                <h1 class="listivo-hero-search-v7__heading">
                    <?php echo nl2br(wp_kses_post($lstCurrentWidget->getHeading())); ?>

                    <div class="listivo-hero-search-v7__arrow">
                        <svg xmlns="http://www.w3.org/2000/svg" width="163" height="67" viewBox="0 0 163 67"
                             fill="none">
                            <path d="M2 9.8269C14.5 26.8269 33.5 58.121 68 60.8269C93.5 62.8269 127.476 60.3988 155.882 23.0184"
                                  stroke="#FA823E" stroke-width="3" stroke-dasharray="8"/>
                            <path d="M140.836 21.3741C165.55 19.621 160.458 12.0261 159.983 34.7033" stroke="#FA823E"
                                  stroke-width="3"/>
                        </svg>
                    </div>
                </h1>

                <div class="listivo-hero-search-v7__text">
                    <?php echo nl2br(wp_kses_post($lstCurrentWidget->getText())); ?>
                </div>

                <div class="listivo-hero-search-v7__terms-container">
                    <div class="listivo-hero-search-v7__terms">
                        <?php foreach ($lstCurrentWidget->getTerms() as $lstItem) :
                            /* @var CustomTerm $lstTerm */
                            $lstTerm = $lstItem['term'];
                            ?>
                            <a
                                    class="listivo-hero-search-v7__term"
                                    href="<?php echo esc_url($lstTerm->getUrl()); ?>"
                            >
                                <div class="listivo-hero-search-v7__term-image">
                                    <?php if (!empty($lstItem['image']['url'])) : ?>
                                        <img
                                                src="<?php echo esc_url($lstItem['image']['url']); ?>"
                                                alt="<?php echo esc_attr($lstTerm->getName()); ?>"
                                        >
                                    <?php endif; ?>
                                </div>

                                <div class="listivo-hero-search-v7__term-label">
                                    <?php echo esc_html($lstTerm->getName()); ?>
                                </div>
                            </a>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>

            <lst-search-form
                    base-url="<?php echo esc_url(get_post_type_archive_link(tdf_model_post_type())); ?>"
                    request-url="<?php echo esc_url(get_rest_url() . 'listivo/v1/listings'); ?>"
                    :dependency-terms="<?php echo htmlspecialchars(json_encode(tdf_app('dependency_terms'))); ?>"
                    :initial-term-count="<?php echo htmlspecialchars(json_encode($lstCurrentWidget->getTermCount())); ?>"
                    initial-sort-by="<?php echo esc_attr(tdf_slug('newest')); ?>"
                    class="listivo-hero-search-v7__form"
            >
                <div slot-scope="props">
                    <div class="listivo-hero-search-v7__label">
                        <?php echo esc_html($lstCurrentWidget->getFormLabel()); ?>
                    </div>

                    <div class="listivo-hero-search-v7__fields">
                        <?php
                        global $lstSearchField;
                        foreach ($lstCurrentWidget->getFields() as $lstSearchField) : ?>
                            <?php get_template_part('templates/partials/search/v2/' . $lstSearchField->getType()); ?>
                        <?php endforeach; ?>
                    </div>

                    <button
                            class="listivo-hero-search-v7__button"
                            :class="{'listivo-hero-search-v7__button--loading': props.inProgress}"
                            @click="props.onSearch"
                    >
                        <span>
                            <?php echo esc_html(tdf_string('search')); ?>
                        </span>

                        <template>
                            <svg
                                    width='40'
                                    height='10'
                                    viewBox='0 0 120 30'
                                    xmlns='http://www.w3.org/2000/svg'
                                    fill='#fff'
                            >
                                <circle cx='15' cy='15' r='15'>
                                    <animate attributeName='r' from='15' to='15' begin='0s' dur='0.8s'
                                             values='15;9;15'
                                             calcMode='linear' repeatCount='indefinite'/>
                                    <animate attributeName='fill-opacity' from='1' to='1' begin='0s' dur='0.8s'
                                             values='1;.5;1'
                                             calcMode='linear' repeatCount='indefinite'/>
                                </circle>

                                <circle cx='60' cy='15' r='9' fill-opacity='0.3'>
                                    <animate attributeName='r' from='9' to='9' begin='0s' dur='0.8s' values='9;15;9'
                                             calcMode='linear' repeatCount='indefinite'/>
                                    <animate attributeName='fill-opacity' from='0.5' to='0.5' begin='0s' dur='0.8s'
                                             values='.5;1;.5' calcMode='linear' repeatCount='indefinite'/>
                                </circle>

                                <circle cx='105' cy='15' r='15'>
                                    <animate attributeName='r' from='15' to='15' begin='0s' dur='0.8s'
                                             values='15;9;15'
                                             calcMode='linear' repeatCount='indefinite'/>
                                    <animate attributeName='fill-opacity' from='1' to='1' begin='0s' dur='0.8s'
                                             values='1;.5;1'
                                             calcMode='linear' repeatCount='indefinite'/>
                                </circle>
                            </svg>
                        </template>
                    </button>
                </div>
            </lst-search-form>
        </div>
    </div>
</div>