<?php
/* @var \Tangibledesign\Listivo\Widgets\General\HeroSearchV1Widget $lstCurrentWidget */
global $lstCurrentWidget;

$lstFirstImage = $lstCurrentWidget->getFirstImage();
$lstSecondImage = $lstCurrentWidget->getSecondImage();
?>
<div class="listivo-hero">
    <svg viewBox="0 0 600 630" class="listivo-hero__image-clip">
        <defs>
            <clipPath id="listivo-hero-image">
                <path
                        d="M19.9667,29.0461l580.03326,-29.04623v0v600.92394v0l-580.03326,29.04623c-11.0273,0.55246 -19.96674,-7.96817 -19.96674,-19.0307v-560.86268c0,-11.06253 8.93944,-20.47852 19.96674,-21.03056z"
                        fill="none"
                ></path>
            </clipPath>
        </defs>
    </svg>

    <div class="listivo-hero__inner">
        <div class="listivo-hero__main">
            <div class="listivo-hero__top">
                    <div class="listivo-hero__subheading">
                        <div class="listivo-hero__cloud">
                            <svg
                                    width="127"
                                    height="30"
                                    xmlns="http://www.w3.org/2000/svg"
                                    xmlns:xlink="http://www.w3.org/1999/xlink"
                                    viewBox="0 0 127 30"
                            >
                                <g>
                                    <g opacity="0.4">
                                        <path d="M123.22319,-0.00158h-90.10448c-2.07722,0 -3.77666,1.70446 -3.77666,3.78681v0c0,2.08277 1.69945,3.78639 3.77666,3.78639h7.6252c-0.16045,0 -0.31689,0.01333 -0.46989,0.03541c1.2672,0.17957 2.23824,1.06951 2.23824,2.13443v0c0,0.53121 -0.24193,1.01743 -0.64087,1.39573h-26.48941c-2.07722,0 -3.77666,1.70404 -3.77666,3.78598v0c0,2.08277 1.69945,3.78598 3.77666,3.78598h5.08621c0.33234,0.09708 0.68287,0.15041 1.0453,0.15041h1.52802c1.0112,0.31456 1.73401,1.10159 1.73401,2.02027v0c0,0.60371 -0.31265,1.15075 -0.8139,1.54447h-20.18486c-2.07722,0 -3.77678,1.70363 -3.77678,3.78598v0c0,2.08318 1.69956,3.78723 3.77678,3.78723h90.10437c2.0771,0 3.77678,-1.70404 3.77678,-3.78723v0c0,-2.08235 -1.69968,-3.78598 -3.77678,-3.78598h-6.7067c-0.50045,-0.39455 -0.81253,-0.9416 -0.81253,-1.54447v0c0,-0.91785 0.72086,-1.70404 1.72977,-2.02027h23.52619c2.07722,0 3.77678,-1.70446 3.77678,-3.78681v0c0,-2.08235 -1.69956,-3.78681 -3.77678,-3.78681h-5.0861c-0.33245,-0.09624 -0.68287,-0.14874 -1.0453,-0.14874h-0.74787c-0.39825,-0.37872 -0.63984,-0.86535 -0.63984,-1.39573v0c0,-1.19325 1.21857,-2.16984 2.7079,-2.16984h16.41655c2.0771,0 3.77666,-1.70363 3.77666,-3.78639v0c0,-2.08235 -1.69956,-3.78681 -3.77666,-3.78681z"
                                              fill="#d7eff7" fill-opacity="1"></path>
                                    </g>
                                </g>
                            </svg>
                        </div>

                        <?php if (!empty($lstCurrentWidget->getSubheading())) : ?>
                        <h2 class="listivo-pretty-heading">
                            <?php echo esc_html($lstCurrentWidget->getSubheading()); ?>
                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 36 39">
                                <g>
                                    <g>
                                        <path d="M35.386 13.26a1.437 1.437 0 0 1-2.027 0l-4.415-4.4-4.415 4.4a1.437 1.437 0 0 1-2.027 0 1.425 1.425 0 0 1 0-2.02l4.415-4.4-4.415-4.399a1.425 1.425 0 0 1 0-2.02 1.437 1.437 0 0 1 2.027 0l4.415 4.4 4.415-4.4a1.437 1.437 0 0 1 2.027 0c.56.558.56 1.462 0 2.02L30.97 6.84l4.415 4.4c.56.557.56 1.461 0 2.02zM11.58 33.58c0 2.932-2.384 5.307-5.326 5.307-2.94 0-5.325-2.375-5.325-5.307 0-2.93 2.384-5.306 5.325-5.306 2.942 0 5.326 2.376 5.326 5.306z"/>
                                    </g>
                                </g>
                            </svg>
                        </h2>
                        <?php endif; ?>
                    </div>

                <h1 class="listivo-large-heading">
                    <?php echo nl2br(wp_kses_post($lstCurrentWidget->getHeading())); ?>
                </h1>

                <div class="listivo-hero__arrow">
                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"
                         height="298.7951807228916" viewBox="0, 0, 400,298.7951807228916">
                        <g>
                            <path
                                    d="M216.867 7.229 C 216.867 11.245,221.151 14.458,226.506 14.458 C 231.861 14.458,236.145 11.245,236.145 7.229 C 236.145 3.213,231.861 0.000,226.506 0.000 C 221.151 0.000,216.867 3.213,216.867 7.229 M250.602 7.229 C 250.602 11.727,255.154 14.458,262.651 14.458 C 276.111 14.458,278.808 7.427,267.076 2.925 C 255.016 -1.702,250.602 -0.549,250.602 7.229 M181.657 7.901 C 176.633 12.926,182.997 19.277,193.056 19.277 C 198.200 19.277,202.410 16.024,202.410 12.048 C 202.410 4.900,187.615 1.943,181.657 7.901 M284.337 12.201 C 284.337 17.954,294.496 24.096,304.009 24.096 C 314.078 24.096,307.490 10.582,296.386 8.459 C 288.714 6.992,284.337 8.352,284.337 12.201 M152.610 17.671 C 145.597 24.684,149.699 32.754,159.036 30.312 C 164.337 28.926,168.675 24.791,168.675 21.125 C 168.675 14.238,158.278 12.003,152.610 17.671 M318.072 25.944 C 318.072 34.070,336.146 39.581,340.372 32.744 C 343.636 27.462,333.925 19.471,324.096 19.351 C 320.783 19.310,318.072 22.277,318.072 25.944 M120.522 33.608 C 114.934 37.141,114.620 39.439,119.113 43.932 C 123.606 48.426,126.547 48.339,132.326 43.543 C 146.725 31.593,136.853 23.283,120.522 33.608 M349.547 38.312 C 347.080 42.303,360.784 53.012,368.358 53.012 C 374.577 53.012,370.488 39.357,363.461 36.660 C 353.512 32.842,352.881 32.917,349.547 38.312 M94.167 54.686 C 87.772 59.362,86.899 62.176,91.047 64.740 C 97.024 68.433,110.843 59.834,110.843 52.422 C 110.843 46.335,104.390 47.211,94.167 54.686 M380.723 55.573 C 380.723 63.342,393.550 70.707,398.485 65.772 C 401.917 62.340,391.027 48.193,384.952 48.193 C 382.626 48.193,380.723 51.514,380.723 55.573 M67.373 79.635 C 64.020 83.674,62.774 88.477,64.605 90.307 C 68.624 94.327,83.016 85.893,85.657 77.969 C 88.402 69.733,74.543 70.995,67.373 79.635 M48.193 110.843 C 44.232 118.245,44.528 120.482,49.469 120.482 C 56.553 120.482,67.470 111.129,67.470 105.060 C 67.470 97.232,53.184 101.517,48.193 110.843 M36.948 133.333 C 35.181 135.100,33.735 140.703,33.735 145.783 C 33.735 158.282,45.374 153.830,47.323 140.586 C 48.814 130.454,43.525 126.756,36.948 133.333 M27.309 167.068 C 21.247 173.131,24.097 187.952,31.325 187.952 C 35.823 187.952,38.554 183.400,38.554 175.904 C 38.554 164.203,33.862 160.516,27.309 167.068 M24.096 202.015 C 24.096 204.449,22.780 209.871,21.171 214.064 C 19.252 219.066,20.908 221.687,25.990 221.687 C 31.038 221.687,33.735 217.492,33.735 209.639 C 33.735 203.012,31.566 197.590,28.916 197.590 C 26.265 197.590,24.096 199.582,24.096 202.015 M24.096 245.783 C 24.096 251.138,27.309 255.422,31.325 255.422 C 39.436 255.422,39.762 254.539,35.629 243.768 C 31.497 232.999,24.096 234.293,24.096 245.783 M48.193 257.987 C 48.193 267.725,28.896 274.813,17.973 269.087 C 8.436 264.089,-1.690 268.065,2.658 275.101 C 5.711 280.040,43.744 300.453,45.188 297.927 C 61.085 270.111,65.304 250.602,55.422 250.602 C 51.446 250.602,48.193 253.925,48.193 257.987 "
                                    stroke="none" fill-rule="evenodd">
                            </path>
                        </g>
                    </svg>
                </div>
            </div>

            <div class="listivo-hero__search-form">
                <?php get_template_part('templates/widgets/general/search_form'); ?>
            </div>

            <div class="listivo-relative">
                <?php get_template_part('templates/widgets/general/popular_terms'); ?>

                <div class="listivo-hero__arrow-up">
                    <svg xmlns="http://www.w3.org/2000/svg" version="1.1" viewBox="0 0 55 41" width="55.0pt" height="41.0pt">
                        <path d="M 4.05 0.00 L 5.92 0.00 C 6.61 1.97 7.38 3.86 7.95 5.87 C 5.08 2.78 3.98 3.20 0.00 3.72 L 0.00 2.82 C 1.67 2.35 2.94 1.29 4.05 0.00 Z" fill="#6193a3"/>
                        <path d="M 3.20 6.20 C 4.18 5.65 4.74 5.86 4.88 6.81 C 4.31 8.54 2.13 7.94 3.20 6.20 Z" fill="#6193a3"/>
                        <path d="M 3.17 10.34 C 3.99 10.17 4.35 10.71 4.24 11.97 C 3.25 14.04 2.08 11.32 3.17 10.34 Z" fill="#6193a3"/>
                        <path d="M 3.14 15.35 C 4.46 14.67 5.63 16.79 4.73 17.79 C 3.13 18.75 2.23 16.49 3.14 15.35 Z" fill="#6193a3"/>
                        <path d="M 4.41 20.13 C 5.90 19.39 6.68 21.59 5.85 22.61 C 4.84 23.12 3.84 20.83 4.41 20.13 Z" fill="#6193a3"/>
                        <path d="M 6.32 25.12 C 7.23 24.67 7.84 24.95 8.14 25.96 C 7.90 27.80 5.52 26.44 6.32 25.12 Z" fill="#6193a3"/>
                        <path d="M 9.18 28.34 C 10.37 27.75 11.56 29.70 10.82 30.66 C 9.63 31.25 8.44 29.30 9.18 28.34 Z" fill="#6193a3"/>
                        <path d="M 12.34 32.18 C 13.30 31.44 15.25 32.63 14.66 33.82 C 13.70 34.56 11.75 33.37 12.34 32.18 Z" fill="#6193a3"/>
                        <path d="M 55.00 32.22 L 55.00 33.04 C 52.39 35.50 51.96 31.16 55.00 32.22 Z" fill="#6193a3"/>
                        <path d="M 49.23 34.08 C 51.12 33.48 51.25 35.15 49.77 35.92 C 47.88 36.52 47.75 34.85 49.23 34.08 Z" fill="#6193a3"/>
                        <path d="M 16.34 35.18 C 17.30 34.44 19.25 35.63 18.66 36.82 C 17.70 37.56 15.75 36.37 16.34 35.18 Z" fill="#6193a3"/>
                        <path d="M 45.19 36.12 C 46.15 36.26 46.35 36.82 45.80 37.80 C 44.05 38.87 43.47 36.69 45.19 36.12 Z" fill="#6193a3"/>
                        <path d="M 20.34 37.18 C 21.30 36.44 23.25 37.63 22.66 38.82 C 21.70 39.56 19.75 38.37 20.34 37.18 Z" fill="#6193a3"/>
                        <path d="M 40.23 38.08 C 42.12 37.48 42.25 39.15 40.77 39.92 C 38.88 40.52 38.75 38.85 40.23 38.08 Z" fill="#6193a3"/>
                        <path d="M 25.34 39.17 C 26.11 38.57 26.89 38.57 27.66 39.17 C 28.15 40.64 24.85 40.64 25.34 39.17 Z" fill="#6193a3"/>
                        <path d="M 31.81 41.00 L 29.86 41.00 C 29.35 38.21 32.82 38.18 31.81 41.00 Z" fill="#6193a3"/>
                        <path d="M 36.79 41.00 L 34.84 41.00 C 34.35 38.21 37.83 38.18 36.79 41.00 Z" fill="#6193a3"/>
                    </svg>
                </div>
            </div>
        </div>
    </div>

    <?php if ($lstFirstImage || $lstSecondImage) : ?>
        <div class="listivo-hero__images">
            <div class="listivo-hero__images-container">
                <div class="listivo-hero__circle-pattern"></div>

                <div class="listivo-hero__wave">
                    <svg xmlns="http://www.w3.org/2000/svg" width="65" height="35" viewBox="0 0 65 35">
                        <g>
                            <g>
                                <path d="M1.996 17.764c3.454-1.313 5.977-.028 8.005 1.005 1.99 1.014 3.207 1.553 5.067.846 1.86-.707 2.412-1.917 3.227-3.998.831-2.12 1.865-4.756 5.32-6.069 3.453-1.312 5.976-.027 8.003 1.006 1.99 1.015 3.207 1.553 5.066.847 1.86-.707 2.411-1.917 3.227-3.998.83-2.119 1.864-4.756 5.318-6.068 3.454-1.313 5.976-.027 8.004 1.006 1.99 1.014 3.206 1.553 5.065.847a1.82 1.82 0 1 1 1.293 3.406c-3.454 1.312-5.977.026-8.004-1.008-1.99-1.013-3.206-1.552-5.065-.845-1.86.706-2.412 1.917-3.227 3.996-.83 2.12-1.864 4.757-5.318 6.07-3.454 1.313-5.977.027-8.005-1.007-1.99-1.014-3.206-1.553-5.065-.846-1.86.706-2.412 1.918-3.228 3.998-.83 2.12-1.865 4.757-5.319 6.07-3.454 1.312-5.977.026-8.005-1.007-1.99-1.014-3.206-1.553-5.066-.846a1.82 1.82 0 0 1-2.346-1.057 1.82 1.82 0 0 1 1.053-2.348zm4.04 10.64c3.453-1.312 5.977-.026 8.004 1.006 1.99 1.015 3.207 1.554 5.067.847 1.86-.707 2.412-1.918 3.228-3.998.83-2.12 1.865-4.757 5.319-6.069 3.453-1.312 5.977-.027 8.004 1.006 1.99 1.014 3.206 1.553 5.066.847 1.859-.707 2.41-1.918 3.227-3.998.83-2.119 1.864-4.756 5.317-6.068 3.454-1.313 5.977-.027 8.005 1.006 1.99 1.014 3.206 1.553 5.065.847a1.818 1.818 0 0 1 2.345 1.056 1.82 1.82 0 0 1-1.052 2.349c-3.454 1.312-5.977.027-8.004-1.007-1.99-1.014-3.207-1.553-5.066-.846-1.859.706-2.411 1.918-3.226 3.997-.83 2.12-1.865 4.757-5.318 6.07-3.454 1.312-5.978.026-8.005-1.007-1.99-1.014-3.206-1.553-5.065-.847-1.86.707-2.412 1.919-3.228 3.999-.83 2.119-1.865 4.757-5.32 6.069-3.453 1.312-5.977.027-8.004-1.007-1.99-1.013-3.207-1.552-5.067-.846a1.819 1.819 0 0 1-2.345-1.057 1.82 1.82 0 0 1 1.053-2.348z"/>
                            </g>
                        </g>
                    </svg>
                </div>

                <?php if ($lstFirstImage) : ?>
                    <div class="listivo-hero__image listivo-hero__image--first">
                        <img
                                src="<?php echo esc_url($lstFirstImage->getImageUrl()); ?>"
                                alt="<?php echo esc_attr($lstFirstImage->getAlt()); ?>"
                        >
                    </div>
                <?php endif; ?>

                <?php if ($lstSecondImage) : ?>
                    <div class="listivo-relative">
                        <div class="listivo-shape-triangle">
                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 121.000000 121.000000"
                                 preserveAspectRatio="xMidYMid meet">
                                <g transform="translate(0.000000,121.000000) scale(0.100000,-0.100000)" stroke="none">
                                    <path d="M1127 1196 c-3 -8 -23 -18 -44 -21 -21 -3 -67 -14 -103 -25 -124 -35 -185 -51 -240 -64 -30 -7 -71 -18 -90 -24 -40 -13 -128 -37 -210 -56 -30 -7 -77 -21 -103 -30 -26 -9 -57 -16 -67 -16 -11 0 -46 -9 -77 -19 -32 -11 -76 -22 -98 -26 -46 -8 -65 -21 -65 -44 0 -21 820 -841 841 -841 23 0 36 19 44 65 4 22 15 66 26 98 10 31 19 66 19 77 0 10 7 41 16 67 9 26 23 73 30 103 19 82 43 170 56 210 6 19 17 60 24 90 13 55 29 116 64 240 11 36 22 82 25 103 3 21 13 41 21 44 9 3 14 19 14 44 0 39 0 39 -39 39 -25 0 -41 -5 -44 -14z m-78 -149 c11 -14 -1 -90 -32 -192 -19 -65 -35 -126 -51 -195 -7 -30 -20 -77 -29 -105 -20 -63 -44 -151 -62 -234 -15 -64 -38 -111 -55 -111 -12 0 -610 598 -610 610 0 17 47 40 111 55 83 18 171 42 234 62 28 9 75 22 105 29 70 16 131 32 195 52 48 14 148 38 171 41 6 0 17 -5 23 -12z"></path>
                                </g>
                            </svg>
                        </div>

                        <div class="listivo-hero__image listivo-hero__image--second">
                            <img
                                    src="<?php echo esc_url($lstSecondImage->getImageUrl()); ?>"
                                    alt="<?php echo esc_attr($lstSecondImage->getAlt()); ?>"
                            >
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    <?php endif; ?>
</div>
