<?php

use Tangibledesign\Listivo\Widgets\General\BreadcrumbsV2Widget;

/* @var BreadcrumbsV2Widget $lstCurrentWidget */
global $lstCurrentWidget;

$lstBreadcrumbs = $lstCurrentWidget->getBreadcrumbs();
if (empty($lstBreadcrumbs)) {
    return;
}

$lstBreadcrumbsNumber = count($lstBreadcrumbs) - 1;
?>
<div class="listivo-app listivo-breadcrumbs-widget">
    <lst-breadcrumbs>
        <div slot-scope="props" class="listivo-breadcrumbs-wrapper-v2">
            <div
                    v-if="!props.breadcrumbs"
                <?php if ($lstCurrentWidget->hasBackground()) : ?>
                    class="listivo-breadcrumbs-v2 listivo-breadcrumbs-v2--with-background"
                <?php else : ?>
                    class="listivo-breadcrumbs-v2"
                <?php endif; ?>
            >
                <?php foreach ($lstBreadcrumbs as $lstIndex => $lstBreadcrumb) : ?>
                    <?php if ($lstIndex < $lstBreadcrumbsNumber) : ?>
                        <a
                                class="listivo-breadcrumbs-v2__item"
                                href="<?php echo esc_url($lstBreadcrumb['url']); ?>"
                                title="<?php echo esc_attr($lstBreadcrumb['name']); ?>"
                        >
                            <?php echo esc_html($lstBreadcrumb['name']); ?>
                        </a>

                        <span class="listivo-breadcrumbs-v2__separator">
                            <svg xmlns="http://www.w3.org/2000/svg" width="5" height="7" viewBox="0 0 5 7" fill="none">
                                <path d="M2.56744 3.5L0.192673 1.12523C-0.0646296 0.86793 -0.0646296 0.45028 0.192673 0.192977C0.449976 -0.0643258 0.867626 -0.0643258 1.12493 0.192977L3.99255 3.0606C4.23556 3.3036 4.23556 3.69702 3.99255 3.9394L1.12493 6.80702C0.867626 7.06433 0.449976 7.06433 0.192673 6.80702C-0.0646296 6.54972 -0.0646296 6.13207 0.192673 5.87477L2.56744 3.5Z"
                                      fill="#F09965"/>
                            </svg>
                        </span>
                    <?php else : ?>
                        <span class="listivo-breadcrumbs-v2__item">
                            <?php echo esc_html($lstBreadcrumb['name']); ?>
                        </span>
                    <?php endif; ?>
                <?php endforeach; ?>
            </div>

            <template v-if="props.breadcrumbs">
                <div
                    <?php if ($lstCurrentWidget->hasBackground()) : ?>
                        class="listivo-breadcrumbs-v2 listivo-breadcrumbs-v2--with-background"
                    <?php else : ?>
                        class="listivo-breadcrumbs-v2"
                    <?php endif; ?>
                >
                    <div
                            class="listivo-breadcrumbs-v2__element"
                            v-for="(breadcrumb, index) in props.breadcrumbs"
                            :key="breadcrumb.key + '-' + index"
                    >
                        <template v-if="index < props.breadcrumbs.length - 1">
                            <a
                                    class="listivo-breadcrumbs-v2__item"
                                    :href="breadcrumb.url"
                                    v-html="breadcrumb.name"
                            ></a>

                            <span class="listivo-breadcrumbs-v2__separator">
                                <svg xmlns="http://www.w3.org/2000/svg" width="5" height="7" viewBox="0 0 5 7"
                                     fill="none">
                                    <path d="M2.56744 3.5L0.192673 1.12523C-0.0646296 0.86793 -0.0646296 0.45028 0.192673 0.192977C0.449976 -0.0643258 0.867626 -0.0643258 1.12493 0.192977L3.99255 3.0606C4.23556 3.3036 4.23556 3.69702 3.99255 3.9394L1.12493 6.80702C0.867626 7.06433 0.449976 7.06433 0.192673 6.80702C-0.0646296 6.54972 -0.0646296 6.13207 0.192673 5.87477L2.56744 3.5Z"
                                          fill="#F09965"/>
                                </svg>
                            </span>
                        </template>

                        <span
                                class="listivo-breadcrumbs-v2__item"
                                v-if="index === props.breadcrumbs.length - 1"
                                v-html="breadcrumb.name"
                        ></span>
                    </div>
                </div>
            </template>
        </div>
    </lst-breadcrumbs>

    <div class="listivo-breadcrumbs-v2-widget__share">
        <div class="listivo-social-icons listivo-social-icons--no-wrap">
            <?php if ($lstCurrentWidget->showFacebook()) : ?>
                <a
                        class="listivo-social-icons__icon listivo-social-icon listivo-social-icon--color-1 listivo-social-icon--hover-color-primary"
                        href="https://www.facebook.com/sharer/sharer.php?u=<?php echo esc_url(tdf_app('current_url')); ?>"
                        target="_blank"
                >
                    <i class="fab fa-facebook-f"></i>

                    <div class="listivo-social-icon__notice">
                        <?php echo esc_html(tdf_string('share_on_facebook')); ?>
                    </div>
                </a>
            <?php endif; ?>

            <?php if ($lstCurrentWidget->showTwitter()) : ?>
                <a
                        class="listivo-social-icons__icon listivo-social-icon listivo-social-icon--color-1 listivo-social-icon--hover-color-primary"
                        href="https://twitter.com/share?url=<?php echo esc_url(tdf_app('current_url')); ?>"
                        target="_blank"
                >
                    <i class="fab fa-twitter"></i>

                    <div class="listivo-social-icon__notice">
                        <?php echo esc_html(tdf_string('share_on_twitter')); ?>
                    </div>
                </a>
            <?php endif; ?>

            <?php if ($lstCurrentWidget->showWhatsApp()) : ?>
                <a
                        class="listivo-social-icons__icon listivo-social-icon listivo-social-icon--mobile listivo-social-icon--color-1 listivo-social-icon--hover-color-primary"
                        href="whatsapp://send?text=<?php echo urlencode(tdf_app('current_url')); ?>"
                        target="_blank"
                >
                    <i class="fab fa-whatsapp"></i>

                    <div class="listivo-social-icon__notice">
                        <?php echo esc_html(tdf_string('share_on_whats_app')); ?>
                    </div>
                </a>
            <?php endif; ?>

            <?php if ($lstCurrentWidget->showMessenger()) : ?>
                <a
                        class="listivo-social-icons__icon listivo-social-icon listivo-social-icon--mobile listivo-social-icon--color-1 listivo-social-icon--hover-color-primary"
                        href="fb-messenger://share?link=<?php echo urlencode(tdf_app('current_url')); ?>"
                        target="_blank"
                >
                    <i class="fab fa-facebook-messenger"></i>

                    <div class="listivo-social-icon__notice">
                        <?php echo esc_html(tdf_string('share_on_messenger')); ?>
                    </div>
                </a>
            <?php endif; ?>
        </div>
    </div>
</div>