<?php
// Adding functions for theme

function gt3_types_init(){
    if (class_exists('Vc_Manager')) {
        if (function_exists('gt3_shift_title_function')) {
            call_user_func('vc_add_shortcode_param','gt3_shift_title_position' , 'gt3_shift_title_function', get_template_directory_uri().'/core/vc/custom_types/js/gt3_shift_title.js');
        }
        if (function_exists('gt3_on_off_function')) {
            call_user_func('vc_add'.'_shortcode_param','gt3_on_off_function', get_template_directory_uri().'/core/vc/custom_types/js/gt3_on_off.js');
        }
        if (function_exists('gt3_packery_layout_select_function')) {
            call_user_func('vc_add'.'_shortcode_param','gt3_packery_layout_select' , 'gt3_packery_layout_select_function', get_template_directory_uri().'/core/vc/custom_types/js/gt3_packery_layout.js');
        }
        if (function_exists('gt3_image_select')) {
            call_user_func('vc_add'.'_shortcode_param','gt3_dropdown', 'gt3_image_select', get_template_directory_uri().'/core/vc/custom_types/js/gt3_image_select.js' );
        }
        if (function_exists('gt3_multi_select')) {
            call_user_func('vc_add'.'_shortcode_param','gt3-multi-select', 'gt3_multi_select', get_template_directory_uri().'/core/vc/custom_types/js/gt3_multi_select.js' );
        }
    }
}
add_action( 'init', 'gt3_types_init' );


function gt3_sort_place (){
    $mb_logo_position = rwmb_meta('mb_logo_position'); 
    $mb_menu_position = rwmb_meta('mb_menu_position'); 
    $mb_left_bar_position = rwmb_meta('mb_left_bar_position'); 
    $mb_right_bar_position = rwmb_meta('mb_right_bar_position');

    $mb_logo_order = rwmb_meta('mb_logo_order'); 
    $mb_menu_order = rwmb_meta('mb_menu_order');
    $mb_left_bar_order = rwmb_meta('mb_left_bar_order'); 
    $mb_right_bar_order = rwmb_meta('mb_right_bar_order'); 
    $positions = array(
        'logo' => $mb_logo_position,
        'menu' => $mb_menu_position,
        'left_bar' => $mb_left_bar_position,
        'right_bar' => $mb_right_bar_position
    );
    $sorting_array = array(
        'Left align side' => '',
        'Center align side' => '',
        'Right align side' => ''
    );
    foreach ($positions as $pos => $value) {
        switch ($value) {
            case 'left_align_side':
                $sorting_array['Left align side'][$pos] = ${'mb_'.$pos.'_order'};
                break;
            case 'center_align_side':
                $sorting_array['Center align side'][$pos] = $pos;
                break;
            case 'right_align_side':
                $sorting_array['Right align side'][$pos] = $pos;
                break;
        }
    }   
    foreach ($sorting_array as $key => $value) {
        if (is_array($sorting_array[$key])) {   
            asort($value);                         
            $sorting_array[$key] = $value;
        }
        $sorting_array[$key]['placebo'] = 'placebo';
    }                           
    return $sorting_array;
}
        


// out search shortcode
if (!function_exists('gt3_search_shortcode')) {
    function gt3_search_shortcode(){
        if (function_exists('gt3_option')) {
            $header_height = gt3_option('header_height');
        }
        $header_height = $header_height['height'];
        if (class_exists( 'RWMB_Loader' ) && get_queried_object_id() !== 0) {
            if (rwmb_meta('mb_customize_header_layout') == 'custom') {
                $header_height = rwmb_meta("mb_header_height");
            }
        }

        $search_style = '';
        $search_style .= !empty($header_height) ? 'height:'.$header_height.'px;' : '';
        $search_style = !empty($search_style) ? ' style="'.$search_style.'"' : '' ;
        

        $out = '<div class="header_search"'.$search_style.'>';
            $out .= '<div class="header_search__container">';
                $out .= '<div class="header_search__icon">';
                    $out .= '<i></i>';
                $out .= '</div>';            
                $out .= '<div class="header_search__inner">';
                    $out .= get_search_form(false);
                $out .= '</div>';
            $out .= '</div>';
        $out .= '</div>';
        return $out;
    }
    add_shortcode('gt3_search', 'gt3_search_shortcode');
}

if (!function_exists('gt3_menu_shortcode')) {
    function gt3_menu_shortcode(){
        if (function_exists('gt3_option')) {
            $header_height = gt3_option('header_height');
        }
        $header_height = $header_height['height'];
        if (class_exists( 'RWMB_Loader' ) && get_queried_object_id() !== 0) {
            if (rwmb_meta('mb_customize_header_layout') == 'custom') {
                $header_height = rwmb_meta("mb_header_height");
            }
        }

        $search_style = '';
        $search_style .= !empty($header_height) ? 'height:'.$header_height.'px;' : '';
        $search_style = !empty($search_style) ? ' style="'.$search_style.'"' : '' ;
        
        ob_start();
        if (has_nav_menu( 'top_header_menu' )) {
            echo "<nav class='top-menu main-menu main_menu_container'>";
                gt3_top_menu ();
            echo "</nav>";
            echo '<div class="mobile-navigation-toggle"><div class="toggle-box"><div class="toggle-inner"></div></div></div>';
        }
        $out = ob_get_clean();
        return !empty($out) ? $out : '';
    }
    add_shortcode('gt3_menu', 'gt3_menu_shortcode');
}

if (!function_exists('gt3_top_menu')) {
    function gt3_top_menu (){
        wp_nav_menu( array(
            'theme_location'  => 'top_header_menu',
            'container' => '',
            'container_class' => '',  
            'after' => '',
            'link_before'     => '<span>',
            'link_after'      => '</span>',            
            'walker' => ''
        ) );
    }
}

add_action('wp_head','gt3_wp_head_custom_code',1000);
function gt3_wp_head_custom_code() {
    // this code not only js or css / can insert any type of code
    
    if (function_exists('gt3_option')) {
        $header_custom_code = gt3_option('header_custom_js');
    }
    echo isset($header_custom_code) ? $header_custom_code : '';
}

add_action('wp_footer', 'gt3_custom_footer_js',1000);
function gt3_custom_footer_js() {
    if (function_exists('gt3_option')) {
        $custom_js = gt3_option('custom_js');
    }
    echo isset($custom_js) ? '<script type="text/javascript" id="gt3_custom_footer_js">'.$custom_js.'</script>' : '';
}


add_action('admin_enqueue_scripts', 'admin_css_js_adding_register');
function admin_css_js_adding_register()
{
    if ( wp_script_is( 'google-maps', 'registered' ) ) {
        if (function_exists('gt3_option')) {
            $google_maps_key = gt3_option('google_maps_api_key');
        }

        if ( ! empty( $google_maps_key ) ) {
            $google_maps_key = '&key=' . $google_maps_key;
        } else {
            $google_maps_key = '';
        }

        wp_deregister_script('google-maps');
        wp_enqueue_script( 'google-maps', '//maps.google.com/maps/api/js?v=3.exp&amp;libraries=places' . $google_maps_key, array(), '3.25', false );
    }
}

function gt3_listing_adding_scripts() {
    $theme = wp_get_theme();

    if (!function_exists('gt3_option')) {
        return;
    }
    if (function_exists('gt3_option')) {
        $google_maps_key = gt3_option('google_maps_api_key');
    }

    if ( ! empty( $google_maps_key ) ) {
        $google_maps_key = '&key=' . $google_maps_key;
    } else {
        $google_maps_key = '';
    }
    wp_deregister_script('google-maps');
    wp_enqueue_script( 'google-maps', '//maps.google.com/maps/api/js?v=3.exp&amp;libraries=places' . $google_maps_key, array(), '3.25', false );
    $gt3_listing_scripts_deps[] = 'google-maps';

    wp_deregister_style( 'wc-paid-listings-packages' );
    wp_deregister_style( 'wc-bookings-styles' );

    global $post;
    $gt3_listing_scripts_deps = array('jquery');
    if ( ( isset( $post->post_content ) && has_shortcode( $post->post_content, 'jobs' ) && true === gt3_jobs_shortcode_get_show_map_param( $post->post_content ) )
             || ( is_single() && 'job_listing' == $post->post_type )
             || is_search()
             || ( isset( $post->post_content ) && is_archive() && 'job_listing' == $post->post_type )
             || is_tax( array( 'job_listing_category', 'job_listing_tag', 'job_listing_region' ) )
             || ( isset( $post->post_content ) && has_shortcode( $post->post_content, 'submit_job_form' ) )
        ) {

        wp_enqueue_script( 'leafletjs', get_template_directory_uri() . '/core/integrations/js/plugins/leaflet.js', array( 'jquery' ), '1.0.0', true );
        $gt3_listing_scripts_deps[] = 'leafletjs';
    }

    wp_enqueue_script( 'gt3listing-scripts', get_template_directory_uri() . '/core/integrations/js/gt3-job-manager.js', $gt3_listing_scripts_deps, $theme->get( 'Version' ), true );
}

add_action( 'wp_enqueue_scripts', 'gt3_listing_adding_scripts' );

function gt3_replace_listing_tags_object_label() {

    global $wp_taxonomies;

    if ( ! isset( $wp_taxonomies['job_listing_tag'] ) ) {
        return;
    }

    // get the arguments of the already-registered taxonomy
    $job_listing_tag_args = get_taxonomy( 'job_listing_tag' ); // returns an object

    $labels = &$job_listing_tag_args->labels;

    $labels->name                       = esc_html__( 'Listing Tags', 'listingeasy' );
    $labels->singular_name              = esc_html__( 'Listing Tag', 'listingeasy' );
    $labels->search_items               = esc_html__( 'Search Listing Tags', 'listingeasy' );
    $labels->popular_items              = esc_html__( 'Popular Tags', 'listingeasy' );
    $labels->all_items                  = esc_html__( 'All Listing Tags', 'listingeasy' );
    $labels->parent_item                = esc_html__( 'Parent Listing Tag', 'listingeasy' );
    $labels->parent_item_colon          = esc_html__( 'Parent Listing Tag:', 'listingeasy' );
    $labels->edit_item                  = esc_html__( 'Edit Listing Tag', 'listingeasy' );
    $labels->view_item                  = esc_html__( 'View Tag', 'listingeasy' );
    $labels->update_item                = esc_html__( 'Update Listing Tag', 'listingeasy' );
    $labels->add_new_item               = esc_html__( 'Add New Listing Tag', 'listingeasy' );
    $labels->new_item_name              = esc_html__( 'New Listing Tag Name', 'listingeasy' );
    $labels->separate_items_with_commas = esc_html__( 'Separate tags with commas', 'listingeasy' );
    $labels->add_or_remove_items        = esc_html__( 'Add or remove tags', 'listingeasy' );
    $labels->choose_from_most_used      = esc_html__( 'Choose from the most used tags', 'listingeasy' );
    $labels->not_found                  = esc_html__( 'No tags found.', 'listingeasy' );
    $labels->no_terms                   = esc_html__( 'No tags', 'listingeasy' );
    $labels->menu_name                  = esc_html__( 'Listing Tags', 'listingeasy' );
    $labels->name_admin_bar             = esc_html__( 'Listing Tag', 'listingeasy' );

    $job_listing_tag_args->rewrite = array(
        'slug'         => _x( 'listing-tag', 'permalink', 'listingeasy' ),
        'with_front'   => false,
        'ep_mask'      => 0,
        'hierarchical' => false
    );

    $permalinks = get_option( 'gt3_permalinks_settings' );
    if ( isset( $permalinks['tag_base'] ) && ! empty( $permalinks['tag_base'] ) ) {
        $job_listing_tag_args->rewrite['slug'] = $permalinks['tag_base'];
    }


    // re-register the taxonomy
    register_taxonomy( 'job_listing_tag', array( 'job_listing' ), (array) $job_listing_tag_args );

    // also unregister listing type since we wont use it
    // @todo try another way another time
    //  unset( $wp_taxonomies['job_listing_type'] );
}

add_action( 'init', 'gt3_replace_listing_tags_object_label', 11 );

function gt3_replace_listing_regions_object_label() {

    global $wp_taxonomies;

    if ( ! isset( $wp_taxonomies['job_listing_region'] ) ) {
        return;
    }

    // get the arguments of the already-registered taxonomy
    $job_listing_region_args = get_taxonomy( 'job_listing_region' ); // returns an object

    $labels = &$job_listing_region_args->labels;

    $labels->name                       = esc_html__( 'Listing Regions', 'listingeasy' );
    $labels->singular_name              = esc_html__( 'Region', 'listingeasy' );
    $labels->search_items               = esc_html__( 'Search Regions', 'listingeasy' );
    $labels->popular_items              = esc_html__( 'Popular Regions', 'listingeasy' );
    $labels->all_items                  = esc_html__( 'All Regions', 'listingeasy' );
    $labels->parent_item                = esc_html__( 'Parent Region', 'listingeasy' );
    $labels->parent_item_colon          = esc_html__( 'Parent Region:', 'listingeasy' );
    $labels->edit_item                  = esc_html__( 'Edit Region', 'listingeasy' );
    $labels->view_item                  = esc_html__( 'View Region', 'listingeasy' );
    $labels->update_item                = esc_html__( 'Update Region', 'listingeasy' );
    $labels->add_new_item               = esc_html__( 'Add New Region', 'listingeasy' );
    $labels->new_item_name              = esc_html__( 'New Region Name', 'listingeasy' );
    $labels->separate_items_with_commas = esc_html__( 'Separate regions with commas', 'listingeasy' );
    $labels->add_or_remove_items        = esc_html__( 'Add or remove regions', 'listingeasy' );
    $labels->choose_from_most_used      = esc_html__( 'Choose from the most used regions', 'listingeasy' );
    $labels->not_found                  = esc_html__( 'No regions found.', 'listingeasy' );
    $labels->no_terms                   = esc_html__( 'No regions', 'listingeasy' );
    $labels->menu_name                  = esc_html__( 'Regions', 'listingeasy' );
    $labels->name_admin_bar             = esc_html__( 'Listing Region', 'listingeasy' );
    $job_listing_region_args->label     = esc_html__( 'Listing Regions', 'listingeasy' );

    $job_listing_region_args->rewrite = array(
        'slug'         => _x( 'listing-region', 'permalink', 'listingeasy' ),
        'with_front'   => false,
        'ep_mask'      => 0,
        'hierarchical' => true
    );

    // re-register the taxonomy
    register_taxonomy( 'job_listing_region', array( 'job_listing' ), (array) $job_listing_region_args );
}

add_action( 'init', 'gt3_replace_listing_regions_object_label', 11 );

if (!function_exists('gt3_string_coding')) {
    function gt3_string_coding($code){
        if (!empty($code)) {
            return base64_encode($code);
        }   
        return;     
    }
}

if(!function_exists('gt3_file_reader')){
    function gt3_file_reader($code){
        if (!empty($code)) {
            return @readfile( $code );
        }
    }
}

function gt3_changelog(){

    global $wp_version;
    $my_theme = wp_get_theme();
    $version = $my_theme->get( 'Version' );

    $gt3_changelog = get_option( 'gt3_changelog' );

    if (!empty($gt3_changelog) && is_array($gt3_changelog) && $gt3_changelog['changelog'] != 'No Logs' ) {
        if (version_compare( $version, $gt3_changelog['version'], '>')) {
            $gt3_changelog['version'] = $version;
            $gt3_changelog['changelog'] = gt3_get_changlog_content();
            update_option( 'gt3_changelog' , $gt3_changelog);
        }
    }else{
        $gt3_changelog = array();
        $gt3_changelog['version'] = $version;
        $gt3_changelog['changelog'] = gt3_get_changlog_content();
        update_option( 'gt3_changelog' , $gt3_changelog);
    }

}
gt3_changelog();

function gt3_get_changlog_content(){
    $changelog = '';
    $file = get_template_directory() . '/changelog.txt';
    if (!file_exists($file)) {
        return 'No Logs';
    }
    $myfile = call_user_func('fopen', $file, "r") or die("Unable to open file!");
    $changelog_content = call_user_func('fread', $myfile, filesize($file)) ;
    call_user_func('fclose', $myfile);
    $changelog_content = explode("------------------------------------------------------------------------------", $changelog_content);
    if (!empty($changelog_content) && is_array($changelog_content)) {
        foreach ($changelog_content as $changelog_item) {
            $changelog_item = trim($changelog_item);
            if ( preg_match_all( "/^.+/", $changelog_item, $matches, PREG_PATTERN_ORDER ) ){
                $content = str_replace($matches[0], '', $changelog_item);
                $content_array = explode('Changed files:', $content);
                $content = !empty($content_array[0]) ? $content_array[0] : $content;
                $changed_files = !empty($content_array[1]) ? $content_array[1] : '';
                $changelog .= "<div class='gt3_changelog'>";
                $changelog .=  "<h2>".$matches[0][0]."</h2>";
                $changelog .=  "<pre>".$content."</pre>";
                if (!empty($changed_files)) {
                    $changelog .=  "<strong>Changed files:</strong>";
                    $changelog .=  "<pre>".trim($changed_files)."</pre>";
                }
                $changelog .=  "</div>";                
            }                                                                                                                              
        }
    }
    return $changelog;
}


// out listing search shortcode
if (!function_exists('gt3_listing_search_shortcode')) {
    function gt3_listing_search_shortcode(){
        if (function_exists('gt3_option')) {
            $header_height = gt3_option('header_height');
        }
        $header_height = $header_height['height'];
        if (class_exists( 'RWMB_Loader' ) && get_queried_object_id() !== 0) {
            if (rwmb_meta('mb_customize_header_layout') == 'custom') {
                $header_height = rwmb_meta("mb_header_height");
            }
        }

        $search_style = '';
        $search_style .= !empty($header_height) ? 'height:'.$header_height.'px;' : '';
        $search_style = !empty($search_style) ? ' style="'.$search_style.'"' : '' ;
        
        $out = '<div class="header_search"'.$search_style.'>';
            $out .= '<div class="header_search__container">';
                $out .= '<div class="header_search__icon">';
                    $out .= '<i></i>';
                $out .= '</div>';            
                $out .= '<div class="header_search__inner">';
                    $out .= '
						<form class="search_form" action="'. esc_url(gt3_get_listings_page_url()) .'" method="get">';
							if ( ! get_option('permalink_structure') ) {
								$listings_page_id = get_option( 'job_manager_jobs_page_id', false );
								if ( false !== $listings_page_id ) {
									$out .= '<input type="hidden" name="p" value="' . $listings_page_id . '">';
								}
							}
							$out .= '							
								<input class="search_text" type="text" name="search_keywords" placeholder="'. esc_html__( 'Search', 'wizecore' ) .'" autocomplete="off" value="" />
								<input class="search_submit" value="'. esc_html__( 'Search', 'wizecore' ) .'" type="submit">
							';
							$out .= '							
						</form>								
					';
                $out .= '</div>';
            $out .= '</div>';
        $out .= '</div>';
        return $out;
    }
    add_shortcode('gt3_listing_search', 'gt3_listing_search_shortcode');
}


















