<?php
ob_start() ;?>

    <section class="price-section <?php echo esc_attr(wp_kses_post($class));?>">
    	<!--Image Layer-->
        <div class="image-layer" style="background-image:url(<?php echo wp_get_attachment_url( $bgimage, 'full' ); ?>);"></div>
    	<div class="auto-container">
        	<!--Sec Title-->
            <div class="sec-title light centered">
            	<h2><?php echo wp_kses_post($title1);?></h2>
                <div class="text"><?php echo wp_kses_post($subtitle);?></div>
            </div>
            <!--Price Content-->
            <div class="price-content">
            	<div class="row clearfix">
                <?php $skills_array = (array)json_decode(urldecode($pricing_table));
				if( $skills_array && is_array($skills_array) ): 
				foreach( (array)$skills_array as $value ):
			?>	
                    <!--Price Block-->
                    <div class="price-block col-md-<?php echo esc_attr(wp_kses_post($column));?> col-sm-6 col-xs-12">
                    	<div class="inner-box">
                        <?php if (wp_kses_post(lisbon_set( $value, 'featured' ))) : ?>	
							<div class="ribbon"><span><?php echo wp_kses_post(lisbon_set( $value, 'featured' )); ?></span></div>
						<?php endif ; ?>	
                        	<div class="title-box">
                            	<h2><?php echo wp_kses_post(lisbon_set( $value, 'title' )); ?></h2>
                                <div class="plan"><?php echo wp_kses_post(lisbon_set( $value, 'text' )); ?></div>
                            </div>
                            <div class="price"><sup><?php echo wp_kses_post(lisbon_set( $value, 'currency' )); ?></sup><?php echo wp_kses_post(lisbon_set( $value, 'price' )); ?><sub><?php echo wp_kses_post(lisbon_set( $value, 'duration' )); ?></sub></div>
                            <ul>
                            	 <?php $fearures = explode("\n",lisbon_set($value, 'feature_str'));?>
							<?php foreach($fearures as $feature):?>
								<li><?php echo wp_kses_post($feature ); ?></li>
                            <?php endforeach;?>
                            </ul>
                            <a href="<?php echo esc_url(lisbon_set( $value, 'link' )); ?>" class="theme-btn btn-style-one detail-btn"><?php echo wp_kses_post(lisbon_set( $value, 'btn' )); ?></a>
                        </div>
                    </div>
                <?php endforeach; endif;?>    
                </div>
            </div>
        </div>
    </section>
    <!--End Price Section-->
<?php
	$output = ob_get_contents(); 
   ob_end_clean(); 
   return $output ; ?>
   