<?php
class Bunch_About_us extends WP_Widget
{
	
	/** constructor */
	function __construct()
	{
		parent::__construct( /* Base ID */'Bunch_About_us', /* Name */esc_html__('lisbon About Us','lisbon'), array( 'description' => esc_html__('Show the information about company', 'lisbon' )) );
	}

	/** @see WP_Widget::widget */
	function widget($args, $instance)
	{
		extract( $args );
		$title = apply_filters( 'widget_title', $instance['title'] );
		
		echo wp_kses_post($before_widget);?>
      	<!--Footer Column-->
			
				<div class="footer-widget logo-widget">
					<div class="footer-logo">
						<a href="<?php echo esc_url( home_url( '/' ) ); ?>" ><img src="<?php echo esc_url($instance['link']); ?>" alt="<?php esc_attr_e('Awesome Image', 'lisbon'); ?>" /></a>
					</div>
					<div class="widget-content">
						<div class="text"><?php echo wp_kses_post($instance['content']); ?></div>
						<a href="<?php echo esc_url($instance['link1']); ?>" class="read-more"><?php echo wp_kses_post($instance['button']); ?><span class="arrow flaticon-right-arrow-1"></span></a>
					</div>
				</div>
			
		<?php
		
		echo wp_kses_post($after_widget);
	}
	
	
	/** @see WP_Widget::update */
	function update($new_instance, $old_instance)
	{
		$instance = $old_instance;

		$instance['title'] = strip_tags($new_instance['title']);
		$instance['content'] = $new_instance['content'];
		$instance['button'] = $new_instance['button'];
		$instance['link'] = $new_instance['link'];
	    $instance['link1'] = $new_instance['link1'];
		return $instance;
	}

	/** @see WP_Widget::form */
	function form($instance)
	{
		$title = ($instance) ? esc_attr($instance['title']) : '';
		$content = ($instance) ? esc_attr($instance['content']) : '';
		$button = ($instance) ? esc_attr($instance['button']) : '';
		$link = ($instance) ? esc_attr($instance['link']) : ''; 
		$link1 = ($instance) ? esc_attr($instance['link1']) : ''; 
		?>
		
        
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('title')); ?>"><?php esc_html_e('Title:', 'lisbon'); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php echo esc_attr($title); ?>" />
        </p>
		<p>
            <label for="<?php echo esc_attr($this->get_field_id('link')); ?>"><?php esc_html_e('Image Link:', 'lisbon'); ?></label>
            <textarea class="widefat" id="<?php echo esc_attr($this->get_field_id('link')); ?>" name="<?php echo esc_attr($this->get_field_name('link')); ?>" ><?php echo wp_kses_post($link); ?></textarea>
        </p>
		
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('content')); ?>"><?php esc_html_e('Content:', 'lisbon'); ?></label>
            <textarea class="widefat" id="<?php echo esc_attr($this->get_field_id('content')); ?>" name="<?php echo esc_attr($this->get_field_name('content')); ?>" ><?php echo wp_kses_post($content); ?></textarea>
        </p>
		<p>
            <label for="<?php echo esc_attr($this->get_field_id('button')); ?>"><?php esc_html_e('Subscribe:', 'lisbon'); ?></label>
            <textarea class="widefat" id="<?php echo esc_attr($this->get_field_id('button')); ?>" name="<?php echo esc_attr($this->get_field_name('button')); ?>" ><?php echo wp_kses_post($button); ?></textarea>
        </p>
		<p>
            <label for="<?php echo esc_attr($this->get_field_id('link1')); ?>"><?php esc_html_e('Link:', 'lisbon'); ?></label>
            <textarea class="widefat" id="<?php echo esc_attr($this->get_field_id('link1')); ?>" name="<?php echo esc_attr($this->get_field_name('link1')); ?>" ><?php echo wp_kses_post($link1); ?></textarea>
        </p>
		
            
                
		<?php 
	}
	
}

/// Recent Posts 
class Bunch_Recent_Post_With_Image extends WP_Widget
{
	/** constructor */
	function __construct()
	{
		parent::__construct( /* Base ID */'Bunch_Recent_Post_With_Image', /* Name */esc_html__('lisbon Recent Posts with image','lisbon'), array( 'description' => esc_html__('Show the recent posts with images', 'lisbon' )) );
	}
 
	/** @see WP_Widget::widget */
	function widget($args, $instance)
	{
		extract( $args );
		$title = apply_filters( 'widget_title', $instance['title'] );
		
		echo wp_kses_post($before_widget); ?>
		
		<!--Start single sidebar-->
        
		<div class="popular-posts">
            <?php echo wp_kses_post($before_title.$title.$after_title); ?>
            
            <?php $query_string = 'posts_per_page='.$instance['number'];
					if( $instance['cat'] ) $query_string .= '&cat='.$instance['cat'];
					query_posts( $query_string ); 
					
					$this->posts();
					wp_reset_query();
			?>
            
        </div>
        <!--End single sidebar-->
		 
		<?php echo wp_kses_post($after_widget);
	}
 
 
	/** @see WP_Widget::update */
	function update($new_instance, $old_instance)
	{
		$instance = $old_instance;
		
		$instance['title'] = strip_tags($new_instance['title']);
		$instance['number'] = $new_instance['number'];
		$instance['cat'] = $new_instance['cat'];
		
		return $instance;
	}
	/** @see WP_Widget::form */
	function form($instance)
	{
		$title = ( $instance ) ? esc_attr($instance['title']) : esc_html__('Recent Posts', 'lisbon');
		$number = ( $instance ) ? esc_attr($instance['number']) : 3;
		$cat = ( $instance ) ? esc_attr($instance['cat']) : '';?>
			
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('title')); ?>"><?php esc_html_e('Title: ', 'lisbon'); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('number')); ?>"><?php esc_html_e('No. of Posts:', 'lisbon'); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id('number')); ?>" name="<?php echo esc_attr($this->get_field_name('number')); ?>" type="text" value="<?php echo esc_attr( $number ); ?>" />
        </p>
       
    	<p>
            <label for="<?php echo esc_attr($this->get_field_id('cat')); ?>"><?php esc_html_e('Category', 'lisbon'); ?></label>
            <?php wp_dropdown_categories( array('show_option_all'=>esc_html__('All Categories', 'lisbon'), 'selected'=>$cat, 'class'=>'widefat', 'name'=>$this->get_field_name('cat')) ); ?>
        </p>
            
		<?php 
	}
	
	function posts()
	{
		
		if( have_posts() ):?>
        	
                
                <?php while( have_posts() ): the_post(); ?>
                 <article class="post ">
                        <figure class="post-thumb"><a href="<?php echo esc_url(get_permalink(get_the_id()));?>"><?php the_post_thumbnail();?></a></figure>
                                <div class="text"><a href="<?php echo esc_url(get_permalink(get_the_id()));?>"><?php echo wp_kses_post(lisbon_trim(get_the_title(), 9));?></a></div>
                                <div class="post-info"><?php echo get_the_date();?></div>
                            </article>
                <?php endwhile; ?>
             
        <?php endif;
    }
}

/// Recent Posts 
class Bunch_Recent_Post_footer extends WP_Widget
{
	/** constructor */
	function __construct()
	{
		parent::__construct( /* Base ID */'Bunch_Recent_Post_footer', /* Name */esc_html__('lisbon Recent Posts Footer','lisbon'), array( 'description' => esc_html__('Show the recent posts Footer', 'lisbon' )) );
	}
 
	/** @see WP_Widget::widget */
	function widget($args, $instance)
	{
		extract( $args );
		$title = apply_filters( 'widget_title', $instance['title'] );
		
		echo wp_kses_post($before_widget); ?>
		
		<!--Start single sidebar-->
        
		<div class="footer-widget posts-widget">
            <?php echo wp_kses_post($before_title.$title.$after_title); ?>
            <div class="widget-content">
            <div class="posts">
           
            
            <?php $query_string = 'posts_per_page='.$instance['number'];
					if( $instance['cat'] ) $query_string .= '&cat='.$instance['cat'];
					query_posts( $query_string ); 
					
					$this->posts();
					wp_reset_query();
			?>
            
        </div> </div> </div>
        <!--End single sidebar-->
		 
		<?php echo wp_kses_post($after_widget);
	}
 
 
	/** @see WP_Widget::update */
	function update($new_instance, $old_instance)
	{
		$instance = $old_instance;
		
		$instance['title'] = strip_tags($new_instance['title']);
		$instance['number'] = $new_instance['number'];
		$instance['cat'] = $new_instance['cat'];
		
		return $instance;
	}
	/** @see WP_Widget::form */
	function form($instance)
	{
		$title = ( $instance ) ? esc_attr($instance['title']) : esc_html__('Recent Posts', 'lisbon');
		$number = ( $instance ) ? esc_attr($instance['number']) : 3;
		$cat = ( $instance ) ? esc_attr($instance['cat']) : '';?>
			
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('title')); ?>"><?php esc_html_e('Title: ', 'lisbon'); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('number')); ?>"><?php esc_html_e('No. of Posts:', 'lisbon'); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id('number')); ?>" name="<?php echo esc_attr($this->get_field_name('number')); ?>" type="text" value="<?php echo esc_attr( $number ); ?>" />
        </p>
       
    	<p>
            <label for="<?php echo esc_attr($this->get_field_id('cat')); ?>"><?php esc_html_e('Category', 'lisbon'); ?></label>
            <?php wp_dropdown_categories( array('show_option_all'=>esc_html__('All Categories', 'lisbon'), 'selected'=>$cat, 'class'=>'widefat', 'name'=>$this->get_field_name('cat')) ); ?>
        </p>
            
		<?php 
	}
	
	function posts()
	{
		
		if( have_posts() ):?>
        	
                
                <?php while( have_posts() ): the_post(); ?>
                <div class="post">
					<figure class="post-thumb"><?php the_post_thumbnail();?></figure>
					<div class="desc-text"><a href="<?php echo esc_url(get_permalink(get_the_id()));?>"><?php echo wp_kses_post(lisbon_trim(get_the_title(), 9));?></a></div>
					<div class="time"><?php echo get_the_date();?></div>
				</div>
                <?php endwhile; ?>
             
        <?php endif;
    }
}

///*******Footer Widget
/// Contact info 
class Bunch_Contact_Info extends WP_Widget
{
	/** constructor */
	function __construct()
	{
		parent::__construct( /* Base ID */'Bunch_Conatct_Info', /* Name */esc_html__('lisbon Contact Info Footer','lisbon'), array( 'description' => esc_html__('Show the Contact Information', 'lisbon' )) );
	}
 
	/** @see WP_Widget::widget */
	function widget($args, $instance)
	{
		extract( $args );
		$title = apply_filters( 'widget_title', $instance['title'] );
		
		echo wp_kses_post($before_widget); ?>
        <!--Footer Column / Address Widget-->
		<div class="footer-widget address-widget">
			<?php echo wp_kses_post($before_title.$title.$after_title); ?>
			<div class="widget-content">
				<ul class="list-style-one">
					<li><span class="icon flaticon-map-marker"></span><?php echo nl2br(wp_kses_post($instance['address']));?></li>
					<li><span class="icon flaticon-telephone-handle-silhouette"></span><?php echo nl2br(wp_kses_post($instance['phone']));?></li>
					<li><span class="icon fa fa-envelope"></span> <?php echo sanitize_email($instance['email']);?></li>
					<li><span class="icon fa fa-clock-o"></span><?php echo nl2br(wp_kses_post($instance['time']));?></li>
				</ul>
			</div>
		</div>

		<?php echo wp_kses_post($after_widget);
	}
 
 
	/** @see WP_Widget::update */
	function update($new_instance, $old_instance)
	{
		$instance = $old_instance;
		
		$instance['title'] = strip_tags($new_instance['title']);
		$instance['address'] = $new_instance['address'];
		$instance['phone'] = $new_instance['phone'];
		$instance['email'] = $new_instance['email'];
		$instance['time'] = $new_instance['time'];
		
		return $instance;
	}
	/** @see WP_Widget::form */
	function form($instance)
	{
		$title = ( $instance ) ? esc_attr($instance['title']) : esc_html__('follow instagram', 'lisbon');
		$address = ( $instance ) ? esc_attr($instance['address']) : '';
		$email = ( $instance ) ? esc_attr($instance['email']) : '';
		$phone = ( $instance ) ? esc_attr($instance['phone']) : '';
		$time = ( $instance ) ? esc_attr($instance['time']) : '';
		
		?>
			
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('title')); ?>"><?php esc_html_e('Title: ', 'lisbon'); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
        </p>
		<p>
            <label for="<?php echo esc_attr($this->get_field_id('address')); ?>"><?php esc_html_e('Address:', 'lisbon'); ?></label>
            <textarea class="widefat" id="<?php echo esc_attr($this->get_field_id('address')); ?>" name="<?php echo esc_attr($this->get_field_name('address')); ?>" ><?php echo nl2br(wp_kses_post($address)); ?></textarea>
        </p>
		<p>
            <label for="<?php echo esc_attr($this->get_field_id('phone')); ?>"><?php esc_html_e('Phone:', 'lisbon'); ?></label>
            <textarea class="widefat" id="<?php echo esc_attr($this->get_field_id('phone')); ?>" name="<?php echo esc_attr($this->get_field_name('phone')); ?>" ><?php echo nl2br(wp_kses_post($phone)); ?></textarea>
        </p>
		<p>
            <label for="<?php echo esc_attr($this->get_field_id('email')); ?>"><?php esc_html_e('Email:', 'lisbon'); ?></label>
            <textarea class="widefat" id="<?php echo esc_attr($this->get_field_id('email')); ?>" name="<?php echo esc_attr($this->get_field_name('email')); ?>" ><?php echo nl2br(wp_kses_post($email)); ?></textarea>
        </p>
		<p>
            <label for="<?php echo esc_attr($this->get_field_id('time')); ?>"><?php esc_html_e('Time:', 'lisbon'); ?></label>
            <textarea class="widefat" id="<?php echo esc_attr($this->get_field_id('time')); ?>" name="<?php echo esc_attr($this->get_field_name('time')); ?>" ><?php echo nl2br(wp_kses_post($time)); ?></textarea>
        </p>
		
		<?php 
	}
	
}

/// Gallery_Post 
class Bunch_Footer_Gallery_Post extends WP_Widget
{
	/** constructor */
	function __construct()
	{
		parent::__construct( /* Base ID */'Bunch_Footer_Gallery_Post', /* Name */esc_html__('lisbon Gallery Widget','lisbon'), array( 'description' => esc_html__('Show the Gallery images', 'lisbon' )) );
	}
 

	/** @see WP_Widget::widget */
	function widget($args, $instance)
	{
		extract( $args );
		$title = apply_filters( 'widget_title', $instance['title'] );
		
		echo wp_kses_post($before_widget); ?>
		
		<div class="gallery-widget">
            <?php echo wp_kses_post($before_title.$title.$after_title); ?>
            
			<?php 
				$args = array('post_type' => 'bunch_portfolio', 'showposts'=>$instance['number']);
				if( $instance['cat'] ) $args['tax_query'] = array(array('taxonomy' => 'portfolios_category','field' => 'id','terms' => (array)$instance['cat']));
				query_posts($args); 
					$this->posts();
					wp_reset_query();
				?>
            
        </div>
        
        <?php echo wp_kses_post($after_widget);
	}
 
 
	/** @see WP_Widget::update */
	function update($new_instance, $old_instance)
	{
		$instance = $old_instance;
		
		$instance['title'] = strip_tags($new_instance['title']);
		$instance['number'] = $new_instance['number'];
		$instance['cat'] = $new_instance['cat'];
		
		return $instance;
	}

	/** @see WP_Widget::form */
	function form($instance)
	{
		$title = ( $instance ) ? esc_attr($instance['title']) : esc_html__('Gallery Widget', 'lisbon');
		$number = ( $instance ) ? esc_attr($instance['number']) : 8;
		$cat = ( $instance ) ? esc_attr($instance['cat']) : '';?>
			
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('title')); ?>"><?php esc_html_e('Title: ', 'lisbon'); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('number')); ?>"><?php esc_html_e('No. of Posts:', 'lisbon'); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id('number')); ?>" name="<?php echo esc_attr($this->get_field_name('number')); ?>" type="text" value="<?php echo esc_attr( $number ); ?>" />
        </p>
       
    	<p>
            <label for="<?php echo esc_attr($this->get_field_id('cat')); ?>"><?php esc_html_e('Category', 'lisbon'); ?></label>
            <?php wp_dropdown_categories( array('show_option_all'=>esc_html__('All Categories', 'lisbon'), 'selected'=>$cat, 'taxonomy' => 'portfolios_category', 'class'=>'widefat', 'name'=>$this->get_field_name('cat')) ); ?>
        </p>
            
		<?php 
	}
	
	function posts()
	{
		
		if( have_posts() ):?>
        
           	<div class="widget-content">
                <div class="images-outer clearfix">
				<?php while( have_posts() ): the_post(); ?>
                <?php 
					$post_thumbnail_id = get_post_thumbnail_id($post->ID);
					$post_thumbnail_url = wp_get_attachment_url( $post_thumbnail_id );
				?>
                    <figure class="image-box"><a href="<?php echo esc_url($post_thumbnail_url);?>" class="lightbox-image" title="Image Title Here" data-fancybox-group="footer-gallery">
					<?php the_post_thumbnail('80x65', array('class' => 'img-responsive'));?></a></figure>
                <?php endwhile; ?>
                </div> 
			</div>
        <?php endif;
    }
}