<?php
add_action('after_setup_theme', 'lisbon_bunch_theme_setup');
function lisbon_bunch_theme_setup()
{
	global $wp_version;
	if(!defined('LISBON_VERSION')) define('LISBON_VERSION', '1.0');
	if( !defined( 'LISBON_ROOT' ) ) define('LISBON_ROOT', get_template_directory().'/');
	if( !defined( 'LISBON_URL' ) ) define('LISBON_URL', get_template_directory_uri().'/');	
	include_once get_template_directory() . '/includes/loader.php';
	
	load_theme_textdomain('lisbon', get_template_directory() . '/languages');
	//ADD THUMBNAIL SUPPORT
	add_theme_support('post-thumbnails');
	add_theme_support('automatic-feed-links'); //Enables post and comment RSS feed links to head.
	add_theme_support('widgets'); //Add widgets and sidebar support
	add_theme_support( "title-tag" );
	add_theme_support( 'wp-block-styles' );
	add_theme_support( 'align-wide' );
	add_theme_support( 'editor-styles' );
	/*
	 * Switch default core markup for search form, comment form, and comments
	 * to output valid HTML5.
	 */
	add_theme_support( 'html5', array(
		'search-form', 'comment-form', 'comment-list', 'gallery', 'caption'
	) );
	/** Register wp_nav_menus */
	if(function_exists('register_nav_menu'))
	{
		register_nav_menus(
			array(
				/** Register Main Menu location header */
				'main_menu' => esc_html__('Main Menu', 'lisbon'),
				'service_menu' => esc_html__('Single Service Menu', 'lisbon'),
				'project_menu' => esc_html__('Project Details Menu', 'lisbon'),
			)
		);
	}
	if ( ! isset( $content_width ) ) $content_width = 960;
	add_image_size( 'lisbon_370x280', 370, 280, true ); // '370x280 services_3_col'
	add_image_size( 'lisbon_360x236', 360, 236, true ); // '360x236 Our Blog V2'
	add_image_size( 'lisbon_264x366', 264, 366, true ); // '264x366 Our Team'
	add_image_size( 'lisbon_86x86', 86, 86, true ); // '86x86 Testimonial V3'
	add_image_size( 'lisbon_200x46', 200, 46, true ); // '200x46 Clients V2'
	add_image_size( 'lisbon_370x250', 370, 250, true ); // '370x250 Blog V3'
	add_image_size( 'lisbon_360x300', 360, 300, true ); // '360x300 Recent'
	add_image_size( 'lisbon_234x324', 234, 324, true ); // '234x324 Our V2'
	add_image_size( 'lisbon_158x95', 158, 95, true ); // '158x95 Clients V3'
	add_image_size( 'lisbon_370x352', 370, 352, true ); // '370x352 Our Blog'
	add_image_size( 'lisbon_480x360', 480, 360, true ); // '480x360 Recent Work (Portfolio)'
	add_image_size( 'lisbon_427x427', 427, 427, true ); // '427x427 Recent Work V2'
	add_image_size( 'lisbon_130x95', 130, 95, true ); // '130x95 Clients'
	add_image_size( 'lisbon_120x120', 120, 120, true ); // '120x120 Testimonial V2'
	add_image_size( 'lisbon_31x31', 31, 31, true ); // '31x31 Services We Provide'
	add_image_size( 'lisbon_95x95', 95, 95, true ); // '95x95 Testimonial'
	add_image_size( 'lisbon_573x467', 573, 467, true ); // '573x467 Portfolio V1'
	add_image_size( 'lisbon_270x270', 270, 270, true ); // '270x270 Portfolio V3'
	add_image_size( 'lisbon_370x580', 370, 580, true ); // '370x580 Portfolio V5'
	add_image_size( 'lisbon_370x370', 370, 370, true ); // '370x370 Portfolio V5'
	add_image_size( 'lisbon_370x460', 370, 460, true ); // '370x460 Portfolio V5'
	add_image_size( 'lisbon_270x540', 270, 540, true ); // '270x540 Portfolio V6'
	add_image_size( 'lisbon_270x405', 270, 405, true ); // '270x405 Portfolio V6'
	add_image_size( 'lisbon_810x352', 810, 352, true ); // '810x352 Blog Page'
	add_image_size( 'lisbon_72x72', 72, 72, true ); // '72x72 Recent Post'
}
function lisbon_gutenberg_editor_palette_styles() {
    add_theme_support( 'editor-color-palette', array(
        array(
            'name' => esc_html__( 'strong yellow', 'lisbon' ),
            'slug' => 'strong-yellow',
            'color' => '#f7bd00',
        ),
        array(
            'name' => esc_html__( 'strong white', 'lisbon' ),
            'slug' => 'strong-white',
            'color' => '#fff',
        ),
		array(
            'name' => esc_html__( 'light black', 'lisbon' ),
            'slug' => 'light-black',
            'color' => '#242424',
        ),
        array(
            'name' => esc_html__( 'very light gray', 'lisbon' ),
            'slug' => 'very-light-gray',
            'color' => '#797979',
        ),
        array(
            'name' => esc_html__( 'very dark black', 'lisbon' ),
            'slug' => 'very-dark-black',
            'color' => '#000000',
        ),
    ) );
	
	add_theme_support( 'editor-font-sizes', array(
		array(
			'name' => esc_html__( 'Small', 'lisbon' ),
			'size' => 10,
			'slug' => 'small'
		),
		array(
			'name' => esc_html__( 'Normal', 'lisbon' ),
			'size' => 15,
			'slug' => 'normal'
		),
		array(
			'name' => esc_html__( 'Large', 'lisbon' ),
			'size' => 24,
			'slug' => 'large'
		),
		array(
			'name' => esc_html__( 'Huge', 'lisbon' ),
			'size' => 36,
			'slug' => 'huge'
		)
	) );
	
}
add_action( 'after_setup_theme', 'lisbon_gutenberg_editor_palette_styles' );
function lisbon_bunch_widget_init()
{
	global $wp_registered_sidebars;
	$theme_options = _WSH()->option();
	
	register_sidebar(array(
	  'name' => esc_html__( 'Default Sidebar', 'lisbon' ),
	  'id' => 'default-sidebar',
	  'description' => esc_html__( 'Widgets in this area will be shown on the right-hand side.', 'lisbon' ),
	  'before_widget'=>'<div id="%1$s" class="widget sidebar-widget single-sidebar %2$s">',
	  'after_widget'=>'</div>',
	  'before_title' => ' <div class="sidebar-title"><h2>',
	  'after_title' => '</h2></div>'
	));
	register_sidebar(array(
	  'name' => esc_html__( 'Footer Sidebar', 'lisbon' ),
	  'id' => 'footer-sidebar',
	  'description' => esc_html__( 'Widgets in this area will be shown in Footer Area.', 'lisbon' ),
	  'before_widget'=>'<div id="%1$s"  class="footer-widget col-md-3 col-sm-8 col-xs-12 single-footer-widget %2$s">',
	  'after_widget'=>'</div>',
	  'before_title' => '<div class="footer-title"><h2>',
	  'after_title' => '</h2></div>'
	));
	
	register_sidebar(array(
	  'name' => esc_html__( 'Blog Listing', 'lisbon' ),
	  'id' => 'blog-sidebar',
	  'description' => esc_html__( 'Widgets in this area will be shown on the right-hand side.', 'lisbon' ),
	  'before_widget'=>'<div id="%1$s" class="widget sidebar-widget single-sidebar %2$s">',
	  'after_widget'=>'</div>',
	  'before_title' => '<h2>',
	  'after_title' => '</h2>'
	));
	if( !is_object( _WSH() )  )  return;
	$sidebars = lisbon_set(lisbon_set( $theme_options, 'dynamic_sidebar' ) , 'dynamic_sidebar' ); 
	foreach( array_filter((array)$sidebars) as $sidebar)
	{
		if(lisbon_set($sidebar , 'topcopy')) continue ;
		
		$name = lisbon_set( $sidebar, 'sidebar_name' );
		
		if( ! $name ) continue;
		$slug = lisbon_bunch_slug( $name ) ;
		
		register_sidebar( array(
			'name' => $name,
			'id' =>  $slug ,
			'before_widget'=>'<div id="%1$s" class="widget sidebar-widget single-sidebar %2$s">',
		  'after_widget'=>'</div>',
		  'before_title' => '<h2>',
		  'after_title' => '</h2>'
		) );		
	}
	
	update_option('wp_registered_sidebars' , $wp_registered_sidebars) ;
}
add_action( 'widgets_init', 'lisbon_bunch_widget_init' );

function lisbon_load_head_scripts() {
	$options = _WSH()->option();
    if ( !is_admin() ) {
	$protocol = is_ssl() ? 'https://' : 'http://';	
	if(lisbon_set($options, 'map_api_key')){
	$map_path = '?key='.lisbon_set($options, 'map_api_key');
	wp_enqueue_script( 'map-api', ''.$protocol.'maps.google.com/maps/api/js'.$map_path, array(), false, false );
	}
	wp_enqueue_script( 'html5shiv', get_template_directory_uri().'/js/html5shiv.js', array(), false, false );
	wp_script_add_data( 'html5shiv', 'conditional', 'lt IE 9' );
	wp_enqueue_script( 'respond', get_template_directory_uri().'/js/respond.js', array(), false, false );
	wp_script_add_data( 'respond', 'conditional', 'lt IE 9' );
    }
}
    add_action( 'wp_enqueue_scripts', 'lisbon_load_head_scripts' );
//global variables
function lisbon_bunch_global_variable() {
    global $wp_query;
}

function lisbon_enqueue_scripts() {
	$options = _WSH()->option();
	$theme_options = _WSH()->option();
	$maincolor = str_replace( '#', '' , lisbon_set( $theme_options, 'main_color_scheme', '#e85889' ) );
	
	//styles
	wp_enqueue_style( 'bootstrap', get_template_directory_uri() . '/css/bootstrap.css' );
	wp_enqueue_style( 'font-awesome', get_template_directory_uri() . '/css/font-awesome.css' );
	wp_enqueue_style( 'animate', get_template_directory_uri() . '/css/animate.css' );
	wp_enqueue_style( 'jquery-fancybox', get_template_directory_uri() . '/css/jquery.fancybox.css' );
	wp_enqueue_style( 'jquery-ui', get_template_directory_uri() . '/css/jquery-ui.css' );
	wp_enqueue_style( 'hover', get_template_directory_uri() . '/css/hover.css');
	wp_enqueue_style( 'flaticons', get_template_directory_uri() . '/css/flaticon.css' );
	wp_enqueue_style( 'owl-carousel', get_template_directory_uri() . '/css/owl.css' );
	wp_enqueue_style( 'lisbon-main-style', get_stylesheet_uri() );
	wp_enqueue_style( 'lisbon-responsive', get_template_directory_uri() . '/css/responsive.css' );
	wp_enqueue_style( 'lisbon-custom_style', get_template_directory_uri() . '/css/custom.css' );
	wp_enqueue_style( 'lisbon-tut-style', get_template_directory_uri() . '/css/tut.css' );
	wp_enqueue_style( 'lisbon-gb-style', get_template_directory_uri() . '/css/gutenberg.css' );
   
    //scripts
	wp_enqueue_script( 'bootstrap', get_template_directory_uri().'/js/bootstrap.min.js', array('jquery'), false, true );
	wp_enqueue_script( 'owl-carousel', get_template_directory_uri().'/js/owl.js', array(), false, true );
	wp_enqueue_script( 'appear', get_template_directory_uri().'/js/appear.js', array(), false, true );
	wp_enqueue_script( 'bootstrap', get_template_directory_uri().'/js/jquery.bootstrap-touchspin.js', array('jquery'), '2.1.2', true );
	wp_enqueue_script( 'mixitup', get_template_directory_uri().'/js/mixitup.js', array(), false, true );
	wp_enqueue_script( 'wow', get_template_directory_uri().'/js/wow.js', array(), false, true );
	if(lisbon_set($options, 'map_api_key')){
	wp_enqueue_script( 'lisbon-gmaps', get_template_directory_uri().'/js/gmaps.js', array(), false, true );
	wp_enqueue_script( 'lisbon-gmaps-setup', get_template_directory_uri().'/js/gmaps-setup.js', array(), false, true );
	wp_enqueue_script( 'lisbon-googlemaps', get_template_directory_uri().'/js/googlemaps.js', array(), false, true );
	}
	wp_enqueue_script( 'jquery-countdown', get_template_directory_uri().'/js/jquery.countdown.js', array('jquery'), '2.1.2', true );
	wp_enqueue_script( 'jquery-easing', get_template_directory_uri().'/js/jquery.easing.min.js', array('jquery'), '2.1.2', true );
	wp_enqueue_script( 'jquery-fancybox', get_template_directory_uri().'/js/jquery.fancybox.pack.js', array('jquery'), '2.1.2', true );
	wp_enqueue_script( 'validate', get_template_directory_uri().'/js/validate.js', array(), false, true );

	wp_enqueue_script( 'jquery-fancybox-media', get_template_directory_uri().'/js/jquery.fancybox-media.js', array('jquery'), '2.1.2', true );
	wp_enqueue_script( 'lisbon-script', get_template_directory_uri().'/js/script.js', array(), false, true );
	if ( (!is_admin()) && is_singular() && comments_open() && get_option('thread_comments') ) wp_enqueue_script( 'comment-reply' );

}
add_action( 'wp_enqueue_scripts', 'lisbon_enqueue_scripts' );

/*-------------------------------------------------------------*/
function lisbon_theme_slug_fonts_url() {
    $fonts_url = '';
 
    /* Translators: If there are characters in your language that are not
    * supported by Lora, translate this to 'off'. Do not translate
    * into your own language.
    */
	$Lato = _x( 'on', 'Lato font: on or off', 'lisbon' );

    $pt_sans = _x( 'on', 'PT Sans font: on or off', 'lisbon' );
 
    if ( 'off' !== $Lato || 'off' !== $pt_sans ) {
        $font_families = array();
 
        if ( 'off' !== $Lato ) {
			$font_families[] = 'Lato:300,300italic,400,400italic,700,700italic,900,900italic';
        }
		
		if ( 'off' !== $pt_sans ) {
            $font_families[] = 'PT Sans:400,400italic,700,700italic';
        }
		
        $query_args = array(
            'family' => urlencode( implode( '|', $font_families ) ),
            'subset' => urlencode( 'latin,latin-ext' ),
        );
 
        $fonts_url = add_query_arg( $query_args, 'https://fonts.googleapis.com/css' );
    }
 
    return esc_url_raw( $fonts_url );
}
function lisbon_theme_slug_scripts_styles() {
    wp_enqueue_style( 'lisbon-theme-slug-fonts', lisbon_theme_slug_fonts_url(), array(), null );
}
add_action( 'wp_enqueue_scripts', 'lisbon_theme_slug_scripts_styles' );
add_action( 'admin_enqueue_scripts', 'lisbon_theme_slug_scripts_styles' );
/*---------------------------------------------------------------------*/
function lisbon_add_editor_styles() {
    add_editor_style( 'editor-style.css' );
}
add_action( 'admin_init', 'lisbon_add_editor_styles' );
