<?php
/**
 * The template for displaying Comments.
 *
 * The area of the page that contains comments and the comment form.
 *
 * @package WordPress
 * @subpackage Twenty_Thirteen
 * @since Twenty Thirteen 1.0
 */
/*
 * If the current post is protected by a password and the visitor has not yet
 * entered the password we will return early without loading the comments.
 */
if ( post_password_required() )
	return;
?>
<?php $protocol = is_ssl() ? 'https://' : 'http://';?>
<div itemscope itemtype="<?php echo esc_attr($protocol);?>schema.org/Comment" id="comments" class="post-comments comment-area clearfix">
	<?php if ( have_comments() ) : ?>
<!--Comments Area-->
 <!--Comments Area-->
<div class="comments-area">
	<div class="group-title"><h2><?php comments_number(); ?></h2></div>
	
	<?php
		wp_list_comments( array(
			'style'       => 'div',
			'short_ping'  => true,
			'avatar_size' => 90,
			'callback'=>'lisbon_bunch_list_comments'
		) );
	?>
	<?php
		if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) :
		?>
		<nav class="navigation comment-navigation" role="navigation">
			<div class="nav-previous"><?php previous_comments_link( esc_html__( '&larr; Older Comments', 'lisbon' ) ); ?></div>
			<div class="nav-next"><?php next_comments_link( esc_html__( 'Newer Comments &rarr;', 'lisbon' ) ); ?></div>
		</nav><!-- .comment-navigation -->
	<?php endif; // Check for comment navigation ?>
	
	<?php if ( ! comments_open() && get_comments_number() ) : ?>
		<p class="no-comments"><?php esc_html_e( 'Comments are closed.' , 'lisbon' ); ?></p>
	<?php endif; ?>	
	
</div>
<?php endif; // have_comments() ?>
	<!-- Comment Form -->
    <?php if ( comments_open()) : ?>
<!-- Comment Form -->
    <div class="comment-form">
	    <?php lisbon_bunch_comment_form(); ?>
	</div>
	<!--End Comment Form --> 
    <?php endif; ?>	 
</div><!-- #comments -->
