<?php

/*

Taxonomy Image

*/

/*
====================================================================================================
Get Taxonomy Image Src
====================================================================================================
*/

if ( ! function_exists( 'forqy_get_taxonomy_image_src' ) ) {

	function forqy_get_taxonomy_image_src( $tax_term, $size = 'thumbnail' ) {

		if ( ! is_object( $tax_term ) ) {
			return false;
		}

		$src = get_option( 'fy_tax_image_' . $tax_term->taxonomy . '_' . $tax_term->term_id );
		$tmp = false;

		if ( is_numeric( $src ) ) {

			$tmp = wp_get_attachment_image_src( $src, $size );

			if ( $tmp && ! is_wp_error( $tmp ) && is_array( $tmp ) && count( $tmp ) >= 3 ) {
				$tmp = array( 'ID' => $src, 'src' => $tmp[0], 'width' => $tmp[1], 'height' => $tmp[2] );
			} else {
				return false;
			}

		} else if ( ! empty( $src ) ) {

			$tmp = array( 'src' => $src );

		}

		if ( $tmp && ! is_wp_error( $tmp ) && is_array( $tmp ) && isset( $tmp['src'] ) ) {
			return $tmp;
		} else {
			return false;
		}

	}

}

/*
====================================================================================================
Get Category Image Src
====================================================================================================
*/

if ( ! function_exists( 'forqy_get_category_image_src' ) ) {

	function forqy_get_category_image_src( $category, $size = 'thumbnail' ) {

		$src = get_option( 'fy_tax_image_' . $category->taxonomy . '_' . $category->term_id );
		$tmp = false;

		if ( is_numeric( $src ) ) {

			$tmp = wp_get_attachment_image_src( $src, $size );

			if ( $tmp && ! is_wp_error( $tmp ) && is_array( $tmp ) && count( $tmp ) >= 3 ) {
				$tmp = array( 'ID' => $src, 'src' => $tmp[0], 'width' => $tmp[1], 'height' => $tmp[2] );
			} else {
				return false;
			}

		} else if ( ! empty( $src ) ) {

			$tmp = array( 'src' => $src );

		}

		if ( $tmp && ! is_wp_error( $tmp ) && is_array( $tmp ) && isset( $tmp['src'] ) ) {
			return $tmp;
		} else {
			return false;
		}

	}

}

/*
====================================================================================================
Get Taxonomy Image
====================================================================================================
*/

if ( ! function_exists( 'forqy_get_taxonomy_image' ) ) {

	function forqy_get_taxonomy_image( $tax_term, $size = 'thumbnail' ) {

		$image = forqy_get_taxonomy_image_src( $tax_term, $size );

		if ( ! $image ) {
			return false;
		}

		return '<img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAQAAAC1HAwCAAAAC0lEQVR42mNkYAAAAAYAAjCB0C8AAAAASUVORK5CYII=" data-src="' . $image['src'] . '" alt="' . $tax_term->name . '" class="fy-term-image">';

	}

}
