<?php

/*

Common

*/

/*
====================================================================================================
Browser Body Class
====================================================================================================
*/

if ( ! function_exists( 'forqy_body_class' ) ) {

	function forqy_body_class( $classes ) {
		// the list of WordPress global browser checks
		// https://codex.wordpress.org/Global_Variables#Browser_Detection_Booleans
		global $is_ios, $is_lynx, $is_iphone, $is_ipad, $is_chrome, $is_safari, $is_NS4, $is_opera, $is_macIE, $is_winIE, $is_gecko, $is_IE, $is_edge;

		if ( $is_chrome ) {
			$classes[] = 'chrome';
		} else if ( $is_safari ) {
			$classes[] = 'safari';
		} else if ( $is_NS4 ) {
			$classes[] = 'ns4';
		} else if ( $is_opera ) {
			$classes[] = 'opera';
		} else if ( $is_macIE ) {
			$classes[] = 'macie';
		} else if ( $is_winIE ) {
			$classes[] = 'winie';
		} else if ( $is_gecko ) {
			$classes[] = 'gecko';
		} else if ( $is_lynx ) {
			$classes[] = 'lynx';
		} else if ( $is_IE ) {
			$classes[] = 'ie';
		} else if ( $is_edge ) {
			$classes[] = 'edge';
		} else {
			$classes[] = 'unknown';
		}

		if ( $is_ios ) {
			$classes[] = 'ios';
		}
		if ( $is_lynx ) {
			$classes[] = 'lynx';
		}
		if ( $is_iphone ) {
			$classes[] = 'iphone';
		}
		if ( $is_ipad ) {
			$classes[] = 'ipad';
		}

		return $classes;

	}

	add_filter( 'body_class', 'forqy_body_class' );

}