/*jslint browser this:true */
/*global window, jQuery, Pace */

/**
 * Theme
 * @version 1.0.1
 * @requires jQuery, Pace
 * @deprecated
 */

(function ($) {
    "use strict";

    // selectors
    const root = $("html, body");
    const body = $("body");

    /**
     * Loading
     * pace.js
     */

    Pace.options = {
        ajax: false,
        eventLag: false,
        restartOnRequestAfter: false,
        document: true,
        elements: {
            selectors: ["body"]
        }
    };

    Pace.on("done", function () {
        body.addClass("loading-hiding");

        if (body.hasClass("loading-hiding")) {

            setTimeout(function () {
                body.removeClass("loading-hiding");
                body.addClass("loading-hidden");
            }, 600);

        }

    });

    /**
     * Forms
     */

    // classes
    const CLASS_FIELD_EMPTY = "field-empty";
    const CLASS_FIELD_ACTIVE = "field-active";

    // selectors
    const field = ".fy-field";
    const input = $(field).find(".fy-input");

    // input
    input.each(function (ignore, el) {

        const container = $(el).parents(field);

        if (el.value && el.value.trim() === "") {
            container.addClass(CLASS_FIELD_EMPTY);
        }

        $(el).on("focus", function () {
            container.addClass(CLASS_FIELD_ACTIVE);
            container.removeClass(CLASS_FIELD_EMPTY);
        });

        $(el).on("blur", function () {

            container.removeClass(CLASS_FIELD_ACTIVE);

            if (el.value.trim() === "") {
                container.addClass(CLASS_FIELD_EMPTY);
            } else {
                container.removeClass(CLASS_FIELD_EMPTY);
            }

        });

    });

    /**
     * Anchor Link Scroll
     */

    $("a[href^='#']").on("click", function (e) {
        e.preventDefault();

        const target = $(this).attr("href");

        if (target !== "#") {
            const $target = $(target);

            if ($target.length) {
                root.animate({
                    "scrollTop": $target.offset().top
                }, 500);
            }

        }

    });

}(jQuery));