/*jslint browser */
/*global window, jQuery */

/**
 * Sticky
 * @version 1.0.1
 * @requires jQuery
 */

(function ($) {
    "use strict";

    // classes
    const CS_STUCK = "is-stuck";
    const CS_ON_TOP = "is-on-top";

    // selectors
    const doc = $(document);

    const sticky = $(".js-sticky");
    const stickyOffset = sticky.innerHeight();

    /**
     * Sticky Class
     */

    function forqyStickyClass() {
        const currentTop = doc.scrollTop();

        if (currentTop === 0) {
            sticky.addClass(CS_ON_TOP);
            sticky.removeClass(CS_STUCK);
        } else if (currentTop > 0 && currentTop >= stickyOffset) {
            sticky.removeClass(CS_ON_TOP);
            sticky.addClass(CS_STUCK);
        } else {
            sticky.removeClass(CS_ON_TOP);
            sticky.addClass(CS_STUCK);
        }

    }

    // stick
    forqyStickyClass();

    // stick on scroll
    $(window).on("scroll touchmove", function () {
        forqyStickyClass();
    });

}(jQuery));