/*jslint browser */
/*global window, jQuery */

/**
 * Sticky - Clone
 * @version 1.0.1
 * @requires jQuery
 */

(function ($) {
    "use strict";

    // classes
    const CS = "is-sticky";
    const CS_VISIBLE = "is-sticky-visible";
    const CS_HIDDEN = "is-sticky-hidden";
    const CS_CLONE = "sticky-clone";

    // selectors
    const sticky = $(".js-sticky");
    const stickyContainer = $(".js-sticky-container");

    /**
     * Sticky
     * @param sticky
     */

    function forqySticky(sticky) {
        sticky.addClass(CS);

        // sticky start on
        const start = $(window).height();

        $(window).on("scroll touchmove", function () {

            if ($(window).scrollTop() >= start) {
                sticky.addClass(CS_VISIBLE);
                sticky.removeClass(CS_HIDDEN);
            } else {
                sticky.addClass(CS_HIDDEN);
                sticky.removeClass(CS_VISIBLE);
            }
        });
    }

    /**
     * Stick Clone
     */

    if (sticky.length) {

        // create clone
        const clone = sticky.clone(true).addClass(CS_CLONE);

        // find all elements with id attribute
        // and remove to maintain accessibility
        clone.find("*").removeAttr("id").end();

        // find all links and add negative tabindex
        clone.find("a").attr("tabindex", "-1");

        // append clone
        clone.prependTo(stickyContainer);

        // init sticky
        forqySticky(clone);

    }

}(jQuery));