/*jslint browser long:true */
/*global window, jQuery */

/**
 * Navigation - Relocate
 * @description Relocate navigation in a DOM
 * @version 1.0.0
 * @requires jQuery
 */

(function ($) {
    "use strict";

    // selectors
    const body = $("body");

    const navigation = $(".js-navigation");
    const navigationContainer = $(".js-navigation-container");

    const navigationBar = $(".js-navigation-bar");
    const navigationBarContainer = $(".js-navigation-container-bar");

    /**
     * Navigation - Relocate
     */

    function forqyNavigationRelocate(element, container, append_to) {

        const viewportWidth = window.innerWidth;

        if (viewportWidth < "1024" || body.hasClass("navigation-mobile-enabled")) {
            element.detach().prependTo(append_to);
        }

        // on resize
        $(window).on("resize", function () {

            const viewportWidthResized = window.innerWidth;

            if (viewportWidthResized < "1024") {
                element.detach().prependTo(append_to);
            } else {
                element.detach().prependTo(container);
            }
        });

    }

    // navigation
    if (navigation.length) {
        forqyNavigationRelocate(navigation, navigationContainer, body);
    }

    // navigation - bar
    if (navigationBar.length) {
        forqyNavigationRelocate(navigationBar, navigationBarContainer, body);
    }

}(jQuery));