/*jslint browser */
/*global window, jQuery */

/**
 * Navigation
 * @version 1.0.1
 * @requires jQuery, Double Tap to Go
 */

(function ($) {
    "use strict";

    // classes
    const CN_ACTIVE = "navigation-active";
    const CN_CLOSING = "navigation-closing";

    // selectors
    const body = $("body");

    const navigation = $(".js-navigation");

    const navigationTrigger = $(".js-navigation-trigger");
    const navigationClose = $(".js-navigation-close");

    const navigationLinkAnchor = navigation.find("a[href*='#']");
    const navigationLinkAnchorEmpty = navigation.find("a[href='#']");

    const navigationHasSub = navigation.find("li:has(ul)");

    /**
     * Double Tap To Go
     */

    if (body.innerWidth() >= "1024") {
        navigationHasSub.doubleTapToGo();
    }
    $(window).on("resize", function () {

        if (body.innerWidth() >= "1024") {
            navigationHasSub.doubleTapToGo();
        }

    });

    /**
     * Anchor Links
     */

    navigationLinkAnchorEmpty.on("click", function (e) {
        e.preventDefault();
    });

    /**
     * Mobile
     */

    navigationTrigger.each(function (ignore, el) {

        $(el).on("click", function (e) {
            e.preventDefault();

            if (body.hasClass(CN_ACTIVE)) {
                body.addClass(CN_CLOSING);

                setTimeout(function () {
                    body.removeClass(CN_CLOSING);
                    body.removeClass(CN_ACTIVE);
                }, 250);

            } else {
                body.addClass(CN_ACTIVE);
            }

        });

    });

    // close navigation
    navigationClose.each(function (ignore, el) {

        $(el).on("click", function () {

            if (body.hasClass(CN_ACTIVE)) {
                body.addClass(CN_CLOSING);

                setTimeout(function () {
                    body.removeClass(CN_CLOSING);
                    body.removeClass(CN_ACTIVE);
                }, 250);

            }

        });

    });

    // close navigation on click to anchor link
    navigationLinkAnchor.each(function (ignore, el) {

        $(el).on("click", function () {

            if (body.hasClass(CN_ACTIVE)) {
                body.addClass(CN_CLOSING);

                setTimeout(function () {
                    body.removeClass(CN_CLOSING);
                    body.removeClass(CN_ACTIVE);
                }, 250);

            }

        });

    });

    // close navigation on esc
    $(document).keyup(function (e) {

        if (e.key === "Escape") {

            if (body.hasClass(CN_ACTIVE)) {
                body.addClass(CN_CLOSING);

                setTimeout(function () {
                    body.removeClass(CN_CLOSING);
                    body.removeClass(CN_ACTIVE);
                }, 250);
            }

        }

    });

}(jQuery));