/*jslint browser */
/*global window, jQuery */

/**
 * Links
 * @version 1.0.1
 * @requires jQuery
 */

(function ($) {
    "use strict";

    //selectors
    const root = $("html, body");

    /**
     * Anchor Link Scroll
     */

    $("a[href^='#']").on("click", function (e) {
        e.preventDefault();

        const target = $(this).attr("href");

        if (target !== "#") {
            const $target = $(target);

            if ($target.length) {
                root.animate({
                    "scrollTop": $target.offset().top
                }, 500);
            }

        }

    });

}(jQuery));