/*jslint browser */
/*global window, jQuery */

/**
 * Bar
 * @version 1.0.2
 * @requires jQuery, Double Tap to Go
 */

(function ($) {
    "use strict";

    // classes
    const CN_BAR_ACTIVE = "navigation-active-bar";
    const CN_BAR_CLOSING = "navigation-closing-bar";

    // selectors
    const html = $("html");
    const body = $("body");

    const bar = $(".js-bar");
    const barNavigation = bar.find(".js-navigation");

    const barNavigationTrigger = $(".js-bar-trigger");
    const barNavigationClose = $(".js-bar-close");

    const barNavigationLinkAnchor = barNavigation.find("a[href*='#']");
    const barNavigationLinkAnchorEmpty = barNavigation.find("a[href='#']");

    const barNavigationHasSub = barNavigation.find("li:has(ul)");

    /**
     * Double Tap To Go
     */

    if (body.innerWidth() >= "1024") {
        barNavigationHasSub.doubleTapToGo();
    }

    $(window).on("resize", function () {

        if (body.innerWidth() >= "1024") {
            barNavigationHasSub.doubleTapToGo();
        }

    });

    /**
     * Empty Anchor Links
     */

    barNavigationLinkAnchorEmpty.on("click", function (e) {
        e.preventDefault();
    });

    /**
     * Mobile
     */

    barNavigationTrigger.each(function (ignore, el) {

        $(el).on("click", function (e) {
            e.preventDefault();

            if (body.hasClass(CN_BAR_ACTIVE)) {
                body.addClass(CN_BAR_CLOSING);

                setTimeout(function () {
                    html.removeClass(CN_BAR_ACTIVE);
                    body.removeClass(CN_BAR_CLOSING);
                    body.removeClass(CN_BAR_ACTIVE);
                }, 250);

            } else {
                html.addClass(CN_BAR_ACTIVE);
                body.addClass(CN_BAR_ACTIVE);
            }

        });

    });

    // close navigation
    barNavigationClose.each(function (ignore, el) {

        $(el).on("click", function () {

            if (body.hasClass(CN_BAR_ACTIVE)) {
                body.addClass(CN_BAR_CLOSING);

                setTimeout(function () {
                    html.removeClass(CN_BAR_ACTIVE);
                    body.removeClass(CN_BAR_CLOSING);
                    body.removeClass(CN_BAR_ACTIVE);
                }, 250);

            }

        });

    });

    // close navigation on click to anchor link
    barNavigationLinkAnchor.each(function (ignore, el) {

        $(el).on("click", function () {

            if (body.hasClass(CN_BAR_ACTIVE)) {
                body.addClass(CN_BAR_CLOSING);

                setTimeout(function () {
                    html.removeClass(CN_BAR_ACTIVE);
                    body.removeClass(CN_BAR_CLOSING);
                    body.removeClass(CN_BAR_ACTIVE);
                }, 250);

            }

        });

    });

    // close navigation on esc
    $(document).keyup(function (e) {

        if (e.key === "Escape") {

            if (body.hasClass(CN_BAR_ACTIVE)) {
                body.addClass(CN_BAR_CLOSING);

                setTimeout(function () {
                    html.addClass(CN_BAR_ACTIVE);
                    body.removeClass(CN_BAR_CLOSING);
                    body.removeClass(CN_BAR_ACTIVE);
                }, 250);

            }

        }

    });

}(jQuery));