/*jslint browser */
/*global window, jQuery */

/**
 * Back to Top
 * @version 1.0.1
 * @requires jQuery
 */

(function ($) {
    "use strict";

    // selectors
    const backToTop = $(".js-back-to-top");

    /**
     * Back to Top Class
     * @param selector
     */

    function forqyBackToTopClass(selector) {

        const windowHeight = $(window).innerHeight();

        if ($(window).scrollTop() > windowHeight) {
            selector.addClass("active");
        } else {
            selector.removeClass("active");
        }

    }

    forqyBackToTopClass(backToTop);

    $(window).on("scroll", function () {
        forqyBackToTopClass(backToTop);
    });

}(jQuery));