<?php

/*

Microdata Restaurant Template

*/

?>

<div class="fy-microdata fy-microdata-restaurant" itemscope itemtype="https://schema.org/Restaurant">

    <meta itemprop="name" content="<?php echo get_bloginfo( 'name' ); ?>">

	<?php if ( get_theme_mod( 'fy_restaurant_image' ) ) { ?>
        <meta itemprop="image" content="<?php echo esc_url( get_theme_mod( 'fy_restaurant_image' ) ); ?>">
	<?php }

	if ( get_theme_mod( 'fy_restaurant_phone' ) ) { ?>
        <meta itemprop="telephone" content="<?php echo esc_attr( get_theme_mod( 'fy_restaurant_phone' ) ); ?>">
	<?php }

	if ( get_theme_mod( 'fy_restaurant_email' ) ) { ?>
        <meta itemprop="email" content="<?php echo esc_attr( get_theme_mod( 'fy_restaurant_email' ) ); ?>">
	<?php }

	if ( get_theme_mod( 'fy_restaurant_hours' ) ) { ?>
        <meta itemprop="openingHours" content="<?php echo esc_attr( get_theme_mod( 'fy_restaurant_hours' ) ); ?>">
	<?php }

	if ( get_theme_mod( 'fy_restaurant_cuisine' ) ) { ?>
        <meta itemprop="servesCuisine" content="<?php echo esc_attr( get_theme_mod( 'fy_restaurant_cuisine' ) ); ?>">
	<?php }

	if ( get_theme_mod( 'fy_restaurant_price' ) != 'none' ) { ?>
        <meta itemprop="priceRange" content="<?php echo esc_attr( get_theme_mod( 'fy_restaurant_price' ) ); ?>">
	<?php }

	if ( get_theme_mod( 'fy_restaurant_reservations' ) ) { ?>
        <meta itemprop="acceptsReservations" content="<?php echo esc_attr( get_theme_mod( 'fy_restaurant_reservations', linguini_default( 'fy_restaurant_reservations' ) ) ); ?>">
	<?php }

	if ( get_theme_mod( 'fy_restaurant_address' ) ) { ?>
        <div itemprop="address" itemscope itemtype="https://schema.org/PostalAddress">
            <meta itemprop="streetAddress" content="<?php echo esc_html( get_theme_mod( 'fy_restaurant_address' ) ); ?>">
        </div>
	<?php }

	get_template_part( 'templates/microdata/global/socials' );
	?>
</div>