<?php

/*

Logo

*/

if ( get_theme_mod( 'fy_logo_image' ) ) { ?>
    <h1 class="fy-logo fy-logo-image">
		<?php
		$id    = attachment_url_to_postid( get_theme_mod( 'fy_logo_image' ) );
		$image = wp_get_attachment_metadata( $id );
		?>
        <a href="<?php echo esc_url( home_url() ); ?>"
           style="width: <?php echo( esc_attr( $image['width'] / 2 ) ); ?>px; height: <?php echo( esc_attr( $image['height'] / 2 ) ); ?>px;"
           rel="home">
            <img src="<?php echo esc_url( get_theme_mod( 'fy_logo_image' ) ); ?>"
                 width="<?php echo( esc_attr( $image['width'] / 2 ) ); ?>"
                 height="<?php echo( esc_attr( $image['height'] / 2 ) ); ?>"
                 alt="<?php echo esc_attr( get_bloginfo( 'name' ) ); ?>">
        </a>
    </h1>
<?php } else { ?>
    <h1 class="fy-logo fy-logo-default">
        <a href="<?php echo esc_url( home_url() ); ?>" rel='home'>
			<?php echo esc_html( get_theme_mod( 'fy_logo_text', get_bloginfo( 'name' ) ) ); ?>
        </a>
    </h1>
<?php }
