<?php

/*

Loading

*/

if ( get_theme_mod( 'fy_loading', linguini_default( 'fy_loading' ) ) != 'disabled' ) { ?>
    <div class="fy-page-loading js-page-loading">
        <div class="fy-page-loading-logo">

			<?php if ( get_theme_mod( 'fy_loading_image' ) ) {
				$loading_image_id    = attachment_url_to_postid( get_theme_mod( 'fy_loading_image' ) );
				$loading_image_image = wp_get_attachment_metadata( $loading_image_id );
				?>
                <img src="<?php echo esc_url( get_theme_mod( 'fy_loading_image' ) ); ?>"
                     width="<?php echo( $loading_image_image['width'] / 2 ); ?>" height="<?php echo( $loading_image_image['height'] / 2 ); ?>"
                     alt="<?php echo esc_attr( get_bloginfo( 'name' ) ); ?> &ndash; <?php echo esc_attr( get_bloginfo( 'description' ) ); ?>">

			<?php } else if ( get_theme_mod( 'fy_logo_image' ) ) {
				$id    = attachment_url_to_postid( get_theme_mod( 'fy_logo_image' ) );
				$image = wp_get_attachment_metadata( $id );
				?>
                <img src="<?php echo esc_url( get_theme_mod( 'fy_logo_image' ) ); ?>"
                     width="<?php echo( $image['width'] / 2 ); ?>" height="<?php echo( $image['height'] / 2 ); ?>"
                     alt="<?php echo esc_attr( get_bloginfo( 'name' ) ); ?> &ndash; <?php echo esc_attr( get_bloginfo( 'description' ) ); ?>">

			<?php } else {
			    echo esc_html( get_theme_mod( 'fy_logo_text', get_bloginfo( 'name' ) ) );
			} ?>

        </div>

		<?php get_template_part( 'templates/element/loading' ); ?>
    </div>
<?php }
