<?php

/*

Thumbnail Template

*/

global $post;

// Images
$images       = get_post_meta( $post->ID, 'fy-gallery-images', true );
$images_count = $images ? count( $images ) : 0;

// Content
$content = get_the_content();

// Thumbnail
$thumbnail = wp_get_attachment_image_src( get_post_thumbnail_id(), 'fy-medium-fixed' );
// Thumbnail Attributes
$thumbnail_attr = array( 'class' => 'fy-image fy-image-responsive js-lazy' );
// Thumbnail Image
$thumbnail_image = $thumbnail[0];
// Thumbnail Width
$thumbnail_width = $thumbnail[1];
// Thumbnail Height
$thumbnail_height = $thumbnail[2];

// Thumbnail Ratio
if ( $thumbnail_width > $thumbnail_height ) {
	$thumbnail_size = 'landscape';
} else if ( $thumbnail_width < $thumbnail_height ) {
	$thumbnail_size = 'portrait';
} else if ( $thumbnail_width == $thumbnail_height ) {
	$thumbnail_size = 'square';
} else {
	$thumbnail_size = 'default';
}
?>

<figure class="fy-post-image">
    <a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>" class="js-lazy-parent" tabindex="-1">
		<?php
		the_post_thumbnail( 'fy-medium-fixed', $thumbnail_attr );
		get_template_part( 'templates/element/loading' );

		if ( $images_count > '1' && ( get_post_format() == 'gallery' || get_post_type() == 'gallery' ) ) { ?>
            <div class="fy-post-image-counter">
				<?php echo esc_html( $images_count ); ?>
            </div>
		<?php }

		if ( get_post_format() == 'video' || get_post_format() == 'audio' || has_shortcode( $content, 'video' ) || has_shortcode( $content, 'audio' ) || has_shortcode( $content, 'playlist' ) ) { ?>
            <div class="fy-post-play">
				<?php get_template_part( 'images/icons/icon', 'play' ); ?>
            </div>
		<?php } ?>
    </a>
</figure>
