<?php

/*

Thumbnail Single Template

*/

// Thumbnail
$thumbnail = wp_get_attachment_image_src( get_post_thumbnail_id(), 'fy-xlarge-fixed' );
// Thumbnail Attributes
$thumbnail_attr = array( 'class' => 'fy-image fy-image-responsive js-lazy' );
// Thumbnail Image
$thumbnail_image = $thumbnail[0];
// Thumbnail Width
$thumbnail_width = $thumbnail[1];
// Thumbnail Height
$thumbnail_height = $thumbnail[2];

// Attachment
$attachment = get_post( get_post_thumbnail_id() );
// Attachment Title
$attachment_title = $attachment->post_title;
// Attachment Image
$attachment_image = wp_get_attachment_image_src( get_post_thumbnail_id(), 'fy-huge' );
// Attachment URL
$attachment_url = $attachment_image[0];
// Attachment Width
$attachment_width = $attachment_image[1];
// Attachment Height
$attachment_height = $attachment_image[2];
?>

<div class="js-images">
    <figure class="fy-post-image">
        <a href="<?php echo esc_url( $attachment_url ); ?>" title="<?php the_title(); ?>" class="js-image js-lazy-parent" tabindex="-1"
           data-size="<?php echo esc_attr( $attachment_width ); ?>x<?php echo esc_attr( $attachment_height ); ?>">

			<?php
			the_post_thumbnail( 'fy-xlarge-fixed', $thumbnail_attr );
			get_template_part( 'templates/element/loading' );
			?>
        </a>

        <figcaption class="fy-post-image-caption fy-hide">
			<?php echo esc_html( $attachment_title ); ?>
        </figcaption>
    </figure>
</div>
