<?php

/*

Template Name: Sitemap

*/

// Current Date
$current_date = date( 'Y/m/d', current_time( 'timestamp' ) );

get_header();
get_template_part( 'heading' );
?>

    <div class="fy-wrap">

        <div class="fy-centerer">

            <main class="fy-main fy-main-page fy-main-sitemap">

				<?php if ( have_posts() ) {
				    while ( have_posts() ) {
				        the_post();

				        get_template_part( 'templates/page/content' );

				    }
				} ?>

                <div class="fy-flex-container">

					<?php
					// Pages
					$query = new WP_Query( array(
						'post_type'      => 'page',
						'post_status'    => 'publish',
						'posts_per_page' => - 1,
						'post_parent'    => 0,
						'orderby'        => 'menu_order'
					) );

					if ( $query->have_posts() ) { ?>

                        <div class="fy-flex-column-25 fy-flex-column-tablet-50 fy-flex-column-phone-100">

                            <section class="fy-padding fy-page-content fy-content fy-sitemap-content">

                                <h3><?php esc_html_e( 'Pages', 'linguini' ); ?></h3>

                                <ul>
									<?php while ( $query->have_posts() ) {
									    $query->the_post(); ?>

                                        <li>
                                            <a href="<?php the_permalink(); ?>" rel="alternate" title="<?php the_title(); ?>">
												<?php the_title(); ?>
                                            </a>
                                        </li>

									<?php } ?>
                                </ul>
                            </section>

                        </div>

						<?php
                        wp_reset_postdata();
					}

					// Posts
					$query = new WP_Query( array(
						'post_type'      => 'post',
						'post_status'    => 'publish',
						'posts_per_page' => - 1
					) );

					if ( $query->have_posts() ) { ?>

                        <div class="fy-flex-column-25 fy-flex-column-tablet-50 fy-flex-column-phone-100">

                            <section class="fy-padding fy-page-content fy-content fy-sitemap-content">

                                <h3><?php esc_html_e( 'Posts', 'linguini' ); ?></h3>

                                <ul>
									<?php while ( $query->have_posts() ) {
									    $query->the_post(); ?>

                                        <li>
                                            <a href="<?php the_permalink(); ?>" rel="alternate" title="<?php the_title(); ?>">
												<?php the_title(); ?>
                                            </a>
                                            <div>
												<?php the_time( get_option( 'date_format' ) ); ?>
                                            </div>
                                        </li>

									<?php } ?>
                                </ul>
                            </section>

                        </div>

						<?php
                        wp_reset_postdata();
					}

					// Events
					$query = new WP_Query( array(
						'post_type'      => 'event',
						'meta_key'       => 'fy_event_date',
						'meta_value'     => 'fy_event_date_end',
						'meta_compare'   => '<',
						'meta_query'     => array(
							'relation' => 'AND',
							array(
								'key'     => 'fy_event_date',
								'value'   => 'fy_event_date_end',
								'compare' => '<='
							),
							array(
								'key'     => 'fy_event_date_end',
								'value'   => $current_date,
								'compare' => '>='
							)
						),
						'orderby'        => 'meta_value',
						'order'          => 'ASC',
						'posts_per_page' => - 1
					) );

					if ( $query->have_posts() ) { ?>

                        <div class="fy-flex-column-25 fy-flex-column-tablet-50 fy-flex-column-phone-100">

                            <section class="fy-padding fy-page-content fy-content fy-sitemap-content">

                                <h3><?php esc_html_e( 'Events', 'linguini' ); ?></h3>

                                <ul>
									<?php while ( $query->have_posts() ) {
									    $query->the_post(); ?>

                                        <li>
                                            <div>
												<?php if ( function_exists( 'forqy_date_event' ) ) {
													forqy_date_event( array(
														'date_start' => forqy_meta( 'fy_event_date' ),
														'date_end'   => forqy_meta( 'fy_event_date_end' ),
													) );
												} ?>
                                            </div>
                                            <a href="<?php the_permalink(); ?>" rel="alternate" title="<?php the_title(); ?>">
												<?php the_title(); ?>
                                            </a>
                                        </li>

									<?php } ?>
                                </ul>
                            </section>

                        </div>

						<?php
                        wp_reset_postdata();
					}

					// Galleries
					$query = new WP_Query( array(
						'post_type'      => 'gallery',
						'post_status'    => 'publish',
						'posts_per_page' => - 1
					) );

					if ( $query->have_posts() ) { ?>

                        <div class="fy-flex-column-25 fy-flex-column-tablet-50 fy-flex-column-phone-100">

                            <section class="fy-padding fy-page-content fy-content fy-sitemap-content">

                                <h3><?php esc_html_e( 'Galleries', 'linguini' ); ?></h3>

                                <ul>
									<?php while ( $query->have_posts() ) {
									    $query->the_post(); ?>

                                        <li>
                                            <a href="<?php the_permalink(); ?>" rel="alternate" title="<?php the_title(); ?>">
												<?php the_title(); ?>
                                            </a>
                                        </li>

									<?php } ?>
                                </ul>
                            </section>

                        </div>

						<?php
                        wp_reset_postdata();
					} ?>

                </div>

            </main>

        </div>

    </div>

<?php
get_footer();
