<?php

/*

Template Name: Reservations

*/

// Main
$main_class = is_active_sidebar( 'reservation' ) ? 'fy-sidebar-active' : 'fy-sidebar-inactive';

get_header();
get_template_part( 'heading' );
?>

    <div class="fy-wrap">

        <div class="fy-centerer">
            <div class="fy-flex-container fy-flex-gutter-xxlarge">

                <main class="fy-main fy-main-reservation fy-flex-column-auto <?php echo esc_attr( $main_class ); ?>">

					<?php if ( have_posts() ) {
					    while ( have_posts() ) {
					        the_post();

					        get_template_part( 'templates/page/content' );

					    }
					}

					if ( shortcode_exists( 'forqy-form-reservation' ) ) {
					    echo do_shortcode( '[forqy-form-reservation]' );
					} ?>

                </main>

				<?php if ( is_active_sidebar( 'reservation' ) ) {
				    get_sidebar( 'reservation' );
				} ?>

            </div>

        </div>

    </div>

<?php
get_footer();
