<?php

/*

Template Name: Menu

*/

// Type
$type = 'menu';

// Taxonomy
$taxonomy = 'section';

// Main
$main_class = is_active_sidebar( $type ) ? 'fy-sidebar-active' : 'fy-sidebar-inactive';

get_header();
get_template_part( 'heading', 'menu' );
?>

    <div class="fy-wrap">

        <div class="fy-centerer">
            <div class="fy-flex-container fy-flex-gutter-xxlarge">

                <main class="fy-main fy-flex-column-auto <?php echo esc_attr( $main_class ); ?><?php if ( get_theme_mod( 'fy_menu_single' ) != 'enabled' ) { ?> js-images<?php } ?>"
                      itemscope itemtype="https://schema.org/FoodEstablishment">

					<?php
					if ( have_posts() ) {
						while ( have_posts() ) {
							the_post();

							get_template_part( 'templates/page/content' );

							wp_reset_postdata();
						}
					}

					// Counter
					$count = 1;

					/**
					 * Get Terms
					 */
					$terms = get_terms( array(
						'taxonomy'   => $taxonomy,
						'orderby'    => 'none',
						'order'      => 'ASC',
						'hide_empty' => 1,
						'parent'     => 0
					) );

					if ( $terms ) {
						foreach ( $terms as $term ) {
							if ( ! empty( $term ) || ! is_wp_error( $term ) ) {

								/**
								 * Terms Query
								 */
								$query = new WP_Query( array(
									'post_type'           => $type,
									'tax_query'           => array(
										array(
											'taxonomy'         => $taxonomy,
											'terms'            => $term->slug,
											'field'            => 'slug',
											'include_children' => 0
										)
									),
									'post_status'         => 'publish',
									'order'               => 'ASC',
									'orderby'             => 'date',
									'ignore_sticky_posts' => 1,
									'posts_per_page'      => - 1
								) );
								?>

                                <section class="fy-term-item fy-term-item-<?php echo esc_attr( $count ); ?> js-scroll-section">
                                    <div id="<?php echo esc_attr( $term->slug ); ?>" class="fy-anchor"></div>

                                    <header class="fy-term-header<?php if ( is_active_sidebar( $type ) ) { ?> fy-align-left<?php } ?>">
                                        <h2><?php echo esc_html( $term->name ); ?></h2>

										<?php if ( ! empty( $term->description ) ) { ?>
                                            <div class="fy-term-content">
												<?php echo wp_kses_post( $term->description ); ?>
                                            </div>
										<?php } ?>
                                    </header>

									<?php if ( $query->have_posts() ) { ?>
                                        <div class="fy-flex-container fy-flex-gutter-large">
											<?php while ( $query->have_posts() ) { ?>
												<?php $query->the_post(); ?>

                                                <div class="fy-post-column<?php if ( is_active_sidebar( $type ) ) { ?> fy-flex-column-100<?php } else { ?> fy-flex-column-50<?php } ?> fy-flex-column-tablet-100">
													<?php get_template_part( 'content', $type ); ?>
                                                </div>

											<?php } ?>
                                        </div>
									<?php }

									/**
									 * Get Children
									 */

									$children = get_terms( array(
										'taxonomy' => $taxonomy,
										'child_of' => $term->term_id,
										'order'    => 'ASC',
										'orderby'  => 'date',
									) );

									foreach ( $children as $child ) {

										/**
										 * Child Query
										 */
										$query_child = new WP_Query( array(
											'post_type'           => $type,
											'tax_query'           => array(
												array(
													'taxonomy'         => $taxonomy,
													'terms'            => $child->slug,
													'field'            => 'slug',
													'include_children' => 0
												)
											),
											'post_status'         => 'publish',
											'order'               => 'ASC',
											'orderby'             => 'date',
											'ignore_sticky_posts' => 1,
											'posts_per_page'      => - 1
										) );

										if ( $query_child->have_posts() ) { ?>
                                            <header class="fy-child-header">
                                                <h3><span><?php echo esc_html( $child->name ); ?></span></h3>

												<?php if ( ! empty( $child->description ) ) { ?>
                                                    <div class="fy-child-description">
														<?php echo wp_kses( $child->description, array(
															'a'      => array(
																'href'   => array(),
																'target' => array()
															),
															'br'     => array(),
															'em'     => array(),
															'strong' => array()
														) ); ?>
                                                    </div>
												<?php } ?>
                                            </header>

                                            <div class="fy-flex-container fy-flex-container-stretch fy-flex-gutter-large">
												<?php while ( $query_child->have_posts() ) {
													$query_child->the_post(); ?>

                                                    <div class="<?php if ( is_active_sidebar( $type ) ) { ?> fy-flex-column-100 <?php } else { ?> fy-flex-column-50<?php } ?> fy-flex-column-tablet-100">
														<?php get_template_part( 'content', $type ); ?>
                                                    </div>

												<?php } ?>
                                            </div>
										<?php }
									} ?>

                                </section>

								<?php
								$count ++;
							}
						}

						wp_reset_postdata();
					} else { ?>

                        <div class="fy-page-content fy-content fy-content-empty">
							<?php esc_html_e( 'No items were found.', 'linguini' ); ?>
                        </div>

					<?php } ?>

                </main>

				<?php if ( is_active_sidebar( $type ) ) {
					get_sidebar( $type );
				} ?>

            </div>

        </div>

    </div>

<?php
get_footer();
