<?php

/*

Template Name: Menu Sections

*/

// Type
$type = 'menu';

// Taxonomy
$taxonomy = 'section';

// Main
$main_class = is_active_sidebar( $type ) ? 'fy-sidebar-active' : 'fy-sidebar-inactive';

get_header();
get_template_part( 'heading' );
?>

    <div class="fy-wrap">

        <div class="fy-centerer">
            <div class="fy-flex-container fy-flex-gutter-xxlarge">

                <main class="fy-main fy-flex-column-auto <?php echo esc_attr( $main_class ); ?><?php if ( get_theme_mod( 'fy_menu_single' ) != 'enabled' ) { ?> js-images<?php } ?>"
                      itemscope itemtype="https://schema.org/FoodEstablishment">

					<?php if ( have_posts() ) {
						while ( have_posts() ) {
							the_post();

							get_template_part( 'templates/page/content' );

							wp_reset_postdata();
						}
					}

					if ( taxonomy_exists( $taxonomy ) ) {

						$count = 1;

						// Terms
						$terms = get_terms( array(
							'taxonomy'   => $taxonomy,
							'orderby'    => 'none',
							'order'      => 'ASC',
							'hide_empty' => 1,
							'parent'     => 0
						) );

						if ( $terms ) { ?>

                            <div class="fy-flex-container">
								<?php foreach ( $terms as $term ) { ?>
									<?php if ( ! empty( $term ) || ! is_wp_error( $term ) ) { ?>

										<?php
										$args  = array(
											'post_type'           => $type,
											'post_status'         => 'publish',
											'tax_query'           => array(
												array(
													'taxonomy' => $taxonomy,
													'field'    => 'slug',
													'terms'    => $term->slug,
												),
											),
											'order'               => 'ASC',
											'orderby'             => 'date',
											'ignore_sticky_posts' => 1,
											'paged'               => $paged,
											'posts_per_page'      => - 1
										);
										$query = new WP_Query( $args );

										$term_image = forqy_get_taxonomy_image_src( $term, 'fy-medium-fixed' );
										?>

                                        <div class="fy-flex-column-33 fy-flex-column-tablet-50 fy-flex-column-phone-100">

                                            <div class="fy-term-card fy-term-<?php echo esc_attr( $count ); ?><?php if ( $term_image['src'] ) { ?> has-image<?php } ?>">

                                                <header class="fy-term-header">
                                                    <h2>
                                                        <a href="<?php echo get_term_link( $term->slug, $taxonomy ); ?>">
															<?php if ( $term_image['src'] ) { ?>

                                                                <div title="<?php echo esc_attr( $term->name ); ?>"
                                                                     class="fy-term-image js-lazy-parent">

                                                                    <div class="fy-image js-lazy"
                                                                         data-src="<?php echo esc_url( $term_image['src'] ); ?>"></div>

																	<?php get_template_part( 'templates/element/loading' ); ?>
                                                                </div>

															<?php } ?>

                                                            <div class="fy-term-title">
                                                                <span><?php echo esc_html( $term->name ); ?></span>
                                                            </div>
                                                        </a>
                                                    </h2>
                                                </header>

                                            </div>

                                        </div>

										<?php $count ++; ?>
									<?php } ?>
								<?php } ?>
                            </div>

							<?php wp_reset_postdata(); ?>
						<?php } else { ?>

                            <div class="fy-page-content fy-content fy-content-empty">
								<?php esc_html_e( 'No items were found.', 'linguini' ); ?>
                            </div>

						<?php } ?>
					<?php } ?>

                </main>

				<?php if ( is_active_sidebar( $type ) ) { ?>
					<?php get_sidebar( $type ); ?>
				<?php } ?>

            </div>

        </div>

    </div>

<?php
get_footer();