<?php

/*

Template Name: Homepage

*/

global $sidebars_widgets;

// Count Widgets
$count = count( $sidebars_widgets['homepage-call-to-action'] );

get_header();
get_template_part( 'component', 'slideshow' );
?>

    <main class="fy-main fy-main-homepage">

		<?php if ( is_active_sidebar( 'homepage-call-to-action' ) ) { ?>
            <div class="fy-homepage-call-to-action fy-widgets-count-<?php echo esc_attr( $count ); ?>">
                <div id="cta" class="fy-anchor"></div>
                <div class="fy-gradient">
                    <div class="fy-centerer">
                        <div class="fy-flex-container fy-flex-container-stretch fy-flex-gutter-small">
							<?php dynamic_sidebar( 'homepage-call-to-action' ); ?>
                        </div>
                    </div>
                </div>
            </div>
		<?php }

		if ( is_active_sidebar( 'homepage' ) ) { ?>
            <div class="fy-homepage-widgets">
                <div class="fy-centerer">
                    <div class="fy-flex-container fy-flex-gutter-small">
						<?php dynamic_sidebar( 'homepage' ); ?>
                    </div>
                </div>
            </div>
		<?php }

		if ( have_posts() ) {
		    while ( have_posts() ) {
		        the_post();

				$content = get_the_content();

				if ( ! empty( $content ) ) { ?>
                    <div class="fy-homepage-content">
                        <div class="fy-centerer">
							<?php get_template_part( 'templates/page/content' ); ?>
                        </div>
                    </div>
				<?php }

				wp_reset_postdata();
		    }
		}

        if ( get_theme_mod( 'fy_homepage_about' ) != 'disabled' ) {
            get_template_part( 'component', 'about' );
        }

        if ( get_theme_mod( 'fy_homepage_posts' ) != 'disabled' ) {
            get_template_part( 'component', 'posts' );
        }

        if ( get_theme_mod( 'fy_homepage_events' ) != 'disabled' ) {
            get_template_part( 'component', 'events' );
        }
        ?>

    </main>

<?php
get_footer();
