<?php

/*

Template Name: Events

*/

// Type
$type = 'event';

// Taxonomy
$taxonomy = 'category-event';

// Main
$main_class = is_active_sidebar( $type ) ? 'fy-sidebar-active' : 'fy-sidebar-inactive';

get_header();
get_template_part( 'heading' );
?>

    <div class="fy-wrap">

        <div class="fy-centerer">
            <div class="fy-flex-container fy-flex-gutter-xxlarge">

                <main class="fy-main fy-main-event fy-flex-column-auto <?php echo esc_attr( $main_class ); ?>">

					<?php if ( have_posts() ) {
					    while ( have_posts() ) {
					        the_post();

					        get_template_part( 'templates/page/content' );

					        wp_reset_postdata();
					    }
					}

					// Current Date
					$current_date = date( 'Y/m/d', current_time( 'timestamp' ) );

					$paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;

					// Query
					$query = new WP_Query( array(
						'post_type'           => $type,
						'meta_key'            => 'fy_event_date',
						'meta_value'          => 'fy_event_date_end',
						'meta_compare'        => '<',
						'meta_query'          => array(
							'relation' => 'AND',
							array(
								'key'     => 'fy_event_date',
								'value'   => 'fy_event_date_end',
								'compare' => '<='
							),
							array(
								'key'     => 'fy_event_date_end',
								'value'   => $current_date,
								'compare' => '>='
							)
						),
						'order'               => 'ASC',
						'orderby'             => 'meta_value',
						'ignore_sticky_posts' => 1,
						'paged'               => $paged,
						'posts_per_page'      => get_option( 'posts_per_page' )
					) );

					if ( $query->have_posts() ) {
					    while ( $query->have_posts() ) {
					        $query->the_post();

					        get_template_part( 'content', $type );
					    }

					    if ( function_exists( 'linguini_pagination' ) ) {
							linguini_pagination( $query->max_num_pages, "", $paged );
						}

					    wp_reset_postdata();
					} else { ?>

                        <div class="fy-page-content fy-content fy-content-empty">
							<?php esc_html_e( 'No items were found.', 'linguini' ); ?>
                        </div>

					<?php } ?>

                </main>

				<?php if ( is_active_sidebar( $type ) ) {
				    get_sidebar( $type );
				} ?>

            </div>

        </div>

    </div>

<?php
get_footer();
